/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.model;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.model.DayOfWeek;
import com.floreantpos.model.PriceShift;
import com.floreantpos.model.dao.PriceShiftDAO;
import com.floreantpos.swing.CheckBoxList;
import com.floreantpos.swing.CheckBoxListModel;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.swing.IntegerTextField;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.dialog.OkCancelOptionDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import com.floreantpos.util.ShiftUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public class PriceShiftEntryDialog
extends OkCancelOptionDialog {
    private JComboBox cbStartHour;
    private JComboBox cbStartMin;
    private JComboBox cbStartAmPm;
    private JComboBox cbEndHour;
    private JComboBox cbEndAmPm;
    private JComboBox cbEndMin;
    private FixedLengthTextField tfPriceShiftName;
    private FixedLengthTextField tfPriceShiftDescription = new FixedLengthTextField();
    private JCheckBox chkAnyDay = new JCheckBox(Messages.getString("PriceShiftEntryDialog.0"));
    private CheckBoxList<DayOfWeek> chkDays;
    private Vector<Integer> hours;
    private Vector<Integer> mins;
    private PriceShift priceShift;
    private Date shiftStart;
    private Date shiftEnd;
    private JCheckBox chkActive = new JCheckBox(Messages.getString("ACTIVE"));
    private IntegerTextField tfPriority = new IntegerTextField();

    public PriceShiftEntryDialog() {
        this(new PriceShift());
    }

    public PriceShiftEntryDialog(PriceShift shift) {
        super((Window)POSUtil.getBackOfficeWindow(), shift.getId() == null ? Messages.getString("PriceShiftEntryDialog.2") : Messages.getString("PriceShiftEntryDialog.3"));
        this.initComponents();
        this.hours = new Vector();
        for (int i = 0; i <= 23; ++i) {
            this.hours.add(i);
        }
        this.mins = new Vector();
        int min = 0;
        for (int i = 0; i < 5; ++i) {
            this.mins.add(min);
            if (i == 3) {
                min += 14;
                continue;
            }
            min += 15;
        }
        this.cbStartHour.setModel(new DefaultComboBoxModel<Integer>(this.hours));
        this.cbEndHour.setModel(new DefaultComboBoxModel<Integer>(this.hours));
        this.cbStartMin.setModel(new DefaultComboBoxModel<Integer>(this.mins));
        this.cbEndMin.setModel(new DefaultComboBoxModel<Integer>(this.mins));
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                PriceShiftEntryDialog.this.onCancel();
            }
        });
        this.setPriceShift(shift);
    }

    private boolean calculatePriceShifts() {
        int startHour = (Integer)this.cbStartHour.getSelectedItem();
        int endHour = (Integer)this.cbEndHour.getSelectedItem();
        int startMin = (Integer)this.cbStartMin.getSelectedItem();
        int endMin = (Integer)this.cbEndMin.getSelectedItem();
        this.shiftStart = ShiftUtil.buildStartTime(startHour, startMin);
        this.shiftEnd = ShiftUtil.buildEndTime(this.shiftStart, endHour, endMin);
        if (!this.shiftEnd.after(this.shiftStart)) {
            POSMessageDialog.showError(this, POSConstants.SHIFT_END_TIME_MUST_BE_GREATER_THAN_SHIFT_START_TIME);
            return false;
        }
        return true;
    }

    private void onCancel() {
        this.setCanceled(true);
        this.dispose();
    }

    public Date getPriceShiftStart() {
        return this.shiftStart;
    }

    public Date getPriceShiftEnd() {
        return this.shiftEnd;
    }

    public void updateView() {
        if (this.priceShift.getId() == null) {
            this.chkActive.setSelected(true);
            return;
        }
        this.tfPriceShiftName.setText(this.priceShift.getName());
        this.tfPriceShiftDescription.setText(this.priceShift.getDescription());
        this.chkAnyDay.setSelected(this.priceShift.isAnyDay());
        this.chkActive.setSelected(this.priceShift.isEnable());
        this.tfPriority.setText(String.valueOf(this.priceShift.getPriority()));
        if (this.priceShift.isAnyDay()) {
            this.chkDays.setEnabled(false);
            this.chkDays.selectAll();
        } else {
            String days = this.priceShift.getDaysOfWeek();
            ArrayList<DayOfWeek> items = new ArrayList<DayOfWeek>();
            CheckBoxListModel model = (CheckBoxListModel)this.chkDays.getModel();
            if (StringUtils.isNotEmpty((String)days)) {
                for (int i = 0; i < model.getRowCount(); ++i) {
                    DayOfWeek item = (DayOfWeek)((Object)model.getValueAt(i, 1));
                    if (!days.contains(String.valueOf(item.getValue()))) continue;
                    items.add(item);
                }
            }
            this.chkDays.selectItems(items);
        }
        Date startTime = this.priceShift.getStartTime();
        Date endTime = this.priceShift.getEndTime();
        Calendar c = Calendar.getInstance();
        c.setTime(startTime);
        this.cbStartHour.setSelectedIndex(c.get(11));
        this.cbStartMin.setSelectedItem(c.get(12));
        c.setTime(endTime);
        this.cbEndHour.setSelectedIndex(c.get(11));
        this.cbEndMin.setSelectedItem(c.get(12));
    }

    public boolean updateModel() {
        String shiftName = this.tfPriceShiftName.getText();
        if (StringUtils.isBlank((String)shiftName)) {
            POSMessageDialog.showError(this, Messages.getString("PriceTableForm.28"));
            return false;
        }
        if (!this.calculatePriceShifts()) {
            return false;
        }
        if (this.priceShift == null) {
            this.priceShift = new PriceShift();
        }
        this.priceShift.setName(shiftName.trim());
        this.priceShift.setDescription(this.tfPriceShiftDescription.getText());
        this.priceShift.setPriority(this.tfPriority.getInteger());
        this.priceShift.setEnable(this.chkActive.isSelected());
        this.priceShift.setStartTime(this.shiftStart);
        this.priceShift.setEndTime(this.shiftEnd);
        if (this.chkAnyDay.isSelected()) {
            this.priceShift.setAnyDay(true);
        } else {
            String dayString = "";
            List<DayOfWeek> days = this.chkDays.getCheckedValues();
            Iterator<DayOfWeek> iterator = days.iterator();
            while (iterator.hasNext()) {
                DayOfWeek dayOfWeek = iterator.next();
                dayString = dayString + dayOfWeek.getValue();
                if (!iterator.hasNext()) continue;
                dayString = dayString + ",";
            }
            this.priceShift.setDaysOfWeek(dayString);
        }
        Calendar c = Calendar.getInstance();
        c.setTime(this.shiftStart);
        return true;
    }

    public PriceShift getPriceShift() {
        return this.priceShift;
    }

    public void setPriceShift(PriceShift shift) {
        this.priceShift = shift;
        this.updateView();
    }

    private void initComponents() {
        JPanel contentPane = this.getContentPanel();
        contentPane.setLayout(new BorderLayout());
        JPanel centerPanel = new JPanel((LayoutManager)new MigLayout("fillx", "[][grow]", ""));
        JLabel lblStartTime = new JLabel("From:");
        this.cbStartHour = new JComboBox();
        JLabel lblMin = new JLabel(POSConstants.MIN);
        this.cbStartMin = new JComboBox();
        this.cbStartAmPm = new JComboBox();
        DefaultComboBoxModel<String> defaultComboBoxModel1 = new DefaultComboBoxModel<String>();
        defaultComboBoxModel1.addElement(POSConstants.AM);
        defaultComboBoxModel1.addElement(POSConstants.PM);
        this.cbStartAmPm.setModel(defaultComboBoxModel1);
        JLabel lblEndTime = new JLabel("To:");
        this.cbEndHour = new JComboBox();
        JLabel lblEndMin = new JLabel(POSConstants.MIN);
        this.cbEndMin = new JComboBox();
        this.cbEndAmPm = new JComboBox();
        DefaultComboBoxModel<String> defaultComboBoxModel2 = new DefaultComboBoxModel<String>();
        defaultComboBoxModel2.addElement(POSConstants.AM);
        defaultComboBoxModel2.addElement(POSConstants.PM);
        this.cbEndAmPm.setModel(defaultComboBoxModel2);
        JLabel label7 = new JLabel();
        label7.setText(POSConstants.SHIFT_NAME + ":");
        this.tfPriceShiftName = new FixedLengthTextField();
        this.chkDays = new CheckBoxList<DayOfWeek>(DayOfWeek.values());
        this.tfPriceShiftName.setLength(30);
        this.tfPriceShiftDescription.setLength(255);
        centerPanel.add(new JLabel(Messages.getString("NAME")));
        centerPanel.add((Component)this.tfPriceShiftName, "grow,wrap");
        centerPanel.add(new JLabel(Messages.getString("PriceShiftEntryDialog.11")));
        centerPanel.add((Component)this.tfPriceShiftDescription, "grow,wrap");
        centerPanel.add(new JLabel(Messages.getString("PriceShiftEntryDialog.13")));
        centerPanel.add((Component)this.tfPriority, "grow,wrap");
        this.chkAnyDay.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PriceShiftEntryDialog.this.chkAnyDay.isSelected()) {
                    PriceShiftEntryDialog.this.chkDays.selectAll();
                }
                PriceShiftEntryDialog.this.chkDays.setEnabled(!PriceShiftEntryDialog.this.chkAnyDay.isSelected());
            }
        });
        this.cbStartHour.setMinimumSize(PosUIManager.getSize(60, 0));
        this.cbStartMin.setMinimumSize(PosUIManager.getSize(60, 0));
        this.cbEndHour.setMinimumSize(PosUIManager.getSize(60, 0));
        this.cbEndMin.setMinimumSize(PosUIManager.getSize(60, 0));
        centerPanel.add(lblStartTime);
        centerPanel.add((Component)this.cbStartHour, "split 4,h 25!");
        centerPanel.add(new JLabel(Messages.getString("PriceShiftEntryDialog.16")));
        centerPanel.add(this.cbStartMin);
        centerPanel.add((Component)lblMin, "wrap");
        centerPanel.add(lblEndTime);
        centerPanel.add((Component)this.cbEndHour, "split 4,h 25!");
        centerPanel.add(new JLabel(Messages.getString("PriceShiftEntryDialog.16")));
        centerPanel.add(this.cbEndMin);
        centerPanel.add(lblEndMin);
        centerPanel.add((Component)this.chkActive, "skip 1,gapleft 5,newline");
        centerPanel.add((Component)this.chkAnyDay, "newline,gapleft 5,skip 1,wrap");
        JScrollPane scrollPane = new JScrollPane(this.chkDays);
        scrollPane.setBorder(new TitledBorder(Messages.getString("PriceShiftEntryDialog.22")));
        centerPanel.add((Component)scrollPane, "skip 1,grow,wrap");
        contentPane.add(centerPanel);
        this.setSize(PosUIManager.getSize(500, 550));
    }

    @Override
    public void doOk() {
        try {
            if (!this.updateModel()) {
                return;
            }
            PriceShiftDAO dao = new PriceShiftDAO();
            if (this.priceShift.getId() == null && dao.exists(this.priceShift.getName())) {
                POSMessageDialog.showError(this, POSConstants.SHIFT_NAME_ALREADY_EXISTS);
                return;
            }
            dao.saveOrUpdate(this.priceShift);
            ShiftUtil.reInitialize();
            this.setCanceled(false);
            this.dispose();
        }
        catch (Exception e) {
            POSMessageDialog.showError(this, POSConstants.ERROR_SAVING_SHIFT_STATE, e);
        }
    }
}

