/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.model;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.model.Tax;
import com.floreantpos.model.dao.GenericDAO;
import com.floreantpos.model.dao.TaxDAO;
import com.floreantpos.model.util.IllegalModelStateException;
import com.floreantpos.swing.DoubleTextField;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JLabel;
import net.miginfocom.swing.MigLayout;

public class TaxForm
extends BeanEditor<Tax> {
    private FixedLengthTextField tfName = new FixedLengthTextField();
    private DoubleTextField tfRate = new DoubleTextField(10);

    public TaxForm() {
        this(new Tax());
    }

    public TaxForm(Tax unit) {
        this.createUI();
        this.setBean(unit);
    }

    private void createUI() {
        this.setLayout((LayoutManager)new MigLayout("fillx"));
        this.add(new JLabel(POSConstants.NAME + ":"));
        this.add((Component)this.tfName, "grow, wrap");
        this.add(new JLabel(POSConstants.RATE + ":"));
        this.tfRate.setHorizontalAlignment(4);
        this.add((Component)this.tfRate, "split 2,grow");
        this.add((Component)new JLabel("%"), "wrap");
    }

    @Override
    public boolean save() {
        try {
            if (!this.updateModel()) {
                return false;
            }
            Tax item = (Tax)this.getBean();
            TaxDAO.getInstance().saveOrUpdate(item);
            return true;
        }
        catch (PosException e) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e.getMessage());
            return false;
        }
        catch (IllegalModelStateException e) {
            POSMessageDialog.showError(this, e.getMessage());
            return false;
        }
    }

    @Override
    public void createNew() {
        this.setBean(new Tax());
        this.clearFields();
    }

    @Override
    public void setFieldsEnable(boolean enable) {
        this.tfName.setEnabled(enable);
        this.tfRate.setEnabled(enable);
    }

    @Override
    public void clearFields() {
        this.tfName.setText("");
        this.tfRate.setText("");
    }

    @Override
    protected void updateView() {
        Tax tax = (Tax)this.getBean();
        if (tax == null) {
            return;
        }
        this.tfName.setText(tax.getName());
        this.tfRate.setText(String.valueOf(tax.getRate()));
    }

    @Override
    protected boolean updateModel() throws IllegalModelStateException {
        Tax tax = (Tax)this.getBean();
        if (tax == null) {
            return false;
        }
        String name = this.tfName.getText();
        Double conversionRate = this.tfRate.getDoubleOrZero();
        GenericDAO.getInstance().checkIdOrNameExists(tax.getId(), name, Tax.class);
        tax.setName(name);
        tax.setRate(conversionRate);
        return true;
    }

    @Override
    public boolean delete() {
        try {
            Tax tax = (Tax)this.getBean();
            if (tax == null) {
                return false;
            }
            int option = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getBackOfficeWindow(), Messages.getString("TaxForm.9"), Messages.getString("CONFIRM"));
            if (option != 0) {
                return false;
            }
            TaxDAO.getInstance().delete(tax);
            this.clearFields();
            return true;
        }
        catch (Exception e) {
            POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), e.getMessage(), e);
            return false;
        }
    }

    @Override
    public String getDisplayText() {
        Tax tax = (Tax)this.getBean();
        if (tax.getId() == null) {
            return POSConstants.NEW_TAX_RATE;
        }
        return POSConstants.EDIT_TAX_RATE;
    }
}

