/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.ticket;

import com.floreantpos.model.Ticket;
import com.floreantpos.model.VoidItem;
import com.floreantpos.ui.ticket.VoidItemViewerTableModel;
import java.awt.Color;
import java.awt.Rectangle;
import java.util.List;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JTable;

public class VoidItemViewerTable
extends JTable {
    private VoidItemViewerTableModel model = new VoidItemViewerTableModel(this);
    private DefaultListSelectionModel selectionModel;

    public VoidItemViewerTable() {
        this((Ticket)null);
    }

    public VoidItemViewerTable(Ticket ticket) {
        this.setModel(this.model);
        this.selectionModel = new DefaultListSelectionModel();
        this.selectionModel.setSelectionMode(0);
        this.setGridColor(Color.LIGHT_GRAY);
        this.setSelectionModel(this.selectionModel);
        this.setAutoscrolls(true);
        this.setShowGrid(true);
        this.setBorder(null);
        this.setFocusable(false);
        this.setRowHeight(50);
        this.resizeTableColumns();
    }

    private void resizeTableColumns() {
        this.setAutoResizeMode(4);
    }

    public List<VoidItem> getVoidItems() {
        return this.model.getItems();
    }

    public void addVoidItem(VoidItem voidItem) {
        this.model.add(voidItem);
    }

    public void deleteSelectedItem() {
        int selectedRow = this.getSelectedRow();
        this.model.remove(selectedRow);
    }

    public void updateView() {
        int selectedRow = this.getSelectedRow();
        this.model.update();
        try {
            this.getSelectionModel().setSelectionInterval(selectedRow, selectedRow);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean isVoidItemNull() {
        List<VoidItem> itemList = this.getVoidItems();
        return itemList == null;
    }

    public void scrollUp() {
        int rowCount;
        if (this.isVoidItemNull()) {
            return;
        }
        int selectedRow = this.getSelectedRow();
        if (selectedRow > (rowCount = this.model.getItems().size()) - 1) {
            return;
        }
        if (--selectedRow < 0) {
            selectedRow = 0;
        }
        this.selectionModel.addSelectionInterval(selectedRow, selectedRow);
        Rectangle cellRect = this.getCellRect(selectedRow, 0, false);
        this.scrollRectToVisible(cellRect);
    }

    public void scrollDown() {
        if (this.isVoidItemNull()) {
            return;
        }
        int selectedRow = this.getSelectedRow();
        if (selectedRow >= this.model.getRowCount() - 1) {
            return;
        }
        this.selectionModel.addSelectionInterval(++selectedRow, selectedRow);
        Rectangle cellRect = this.getCellRect(selectedRow, 0, false);
        this.scrollRectToVisible(cellRect);
    }

    public VoidItem get(int index) {
        return this.model.get(index);
    }

    public VoidItem getSelected() {
        int index = this.getSelectedRow();
        return this.model.get(index);
    }

    public void delete(int index) {
        this.model.remove(index);
    }

    public void removeItem(VoidItem voidItem) {
        this.model.remove(voidItem);
    }

    public void updateVoidItem(VoidItem voidItem) {
        this.model.updateVoidItem(voidItem);
    }

    public boolean containsVoidItem(VoidItem voidItem) {
        return this.model.containsVoidItem(voidItem);
    }
}

