/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views;

import com.floreantpos.Messages;
import com.floreantpos.actions.CloseDialogAction;
import com.floreantpos.model.dao.GiftCardDAO;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.swing.PosButton;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public class GiftCardBatchNumberEntryDialog
extends POSDialog {
    private FixedLengthTextField txtBatchNumber;
    private boolean isActive;
    private boolean isActiveDate;
    private String batchNumber;

    public String getBatchNumber() {
        return this.batchNumber;
    }

    public boolean isActiveDate() {
        return this.isActiveDate;
    }

    @Override
    public boolean isActive() {
        return this.isActive;
    }

    public GiftCardBatchNumberEntryDialog() {
        super((Frame)POSUtil.getBackOfficeWindow(), "");
        this.init();
    }

    public GiftCardBatchNumberEntryDialog(JFrame parent) {
        this.init();
    }

    private void init() {
        TitlePanel titlePanel = new TitlePanel();
        titlePanel.setTitle(Messages.getString("GiftCardBatchNumberEntryDialog.2"));
        this.add((Component)titlePanel, "North");
        JPanel centerPanel = new JPanel((LayoutManager)new MigLayout("fillx,aligny center", "[]20px[]", ""));
        JLabel lblNumberOfCard = new JLabel(Messages.getString("BatchNumber"));
        this.txtBatchNumber = new FixedLengthTextField(20);
        this.txtBatchNumber.setLength(32);
        centerPanel.add((Component)lblNumberOfCard, "cell 0 0, alignx right");
        centerPanel.add((Component)this.txtBatchNumber, "cell 1 0");
        this.add((Component)centerPanel, "Center");
        JPanel buttonPanel = new JPanel((LayoutManager)new MigLayout("al center", "sg, fill", ""));
        PosButton btnGenerate = new PosButton(Messages.getString("DONE"));
        buttonPanel.add((Component)btnGenerate, "grow");
        btnGenerate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GiftCardBatchNumberEntryDialog.this.doGenerate();
            }
        });
        buttonPanel.add(new PosButton(new CloseDialogAction(this, Messages.getString("GiftCardBatchNumberEntryDialog.3"))));
        this.add((Component)buttonPanel, "South");
    }

    public void doGenerate() {
        String cardBatchNumber = this.txtBatchNumber.getText();
        if (StringUtils.isEmpty((String)cardBatchNumber)) {
            POSMessageDialog.showError(this, Messages.getString("GiftCardBatchNumberEntryDialog.13"));
            return;
        }
        boolean findActiveCardByBatchNumber = GiftCardDAO.getInstance().findActiveCardByBatchNumber(cardBatchNumber);
        this.isActive = findActiveCardByBatchNumber;
        this.batchNumber = cardBatchNumber;
        this.setCanceled(false);
        this.dispose();
    }
}

