/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views;

import com.floreantpos.IconFactory;
import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.bo.ui.CustomCellRenderer;
import com.floreantpos.bo.ui.explorer.ExplorerButtonPanel;
import com.floreantpos.model.MenuCategory;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.dao.MenuCategoryDAO;
import com.floreantpos.model.dao.MenuGroupDAO;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.swing.ComboBoxModel;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.model.MenuGroupForm;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.table.TableColumnModelExt;

public class MenuGroupSelectionView
extends JPanel {
    private JComboBox cbMenuCategory;
    private JXTable table;
    private BeanTableModel<MenuGroup> tableModel;
    private JTextField tfName;
    private MenuGroup parentMenuGroup;
    private PosButton btnNext;
    private PosButton btnPrev;
    private MenuCategory selectedCategory;
    private JLabel lblNumberOfItem = new JLabel();
    private JLabel lblName;
    private JButton btnSearch;
    private JPanel searchPanel;
    private Map<String, MenuGroup> addedMenuGroupMap = new HashMap<String, MenuGroup>();
    private JCheckBox chkShowSelected;
    private JCheckBox chkSelectAll;
    private JLabel lblMenuCategory;
    public static final int SINGLE_SELECTION = 0;
    public static final int MULTIPLE_SELECTION = 1;

    public MenuGroupSelectionView(List<MenuGroup> addedMenuGroups) {
        this.initComponents();
        this.tableModel.setCurrentRowIndex(0);
        this.cbMenuCategory.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                MenuGroupSelectionView.this.chkSelectAll.setEnabled(true);
                MenuGroupSelectionView.this.tableModel.setCurrentRowIndex(0);
                MenuGroupSelectionView.this.setSelectedMenuGroup(MenuGroupSelectionView.this.cbMenuCategory.getSelectedItem());
            }
        });
        this.setMenuGroups(addedMenuGroups);
        this.searchItem();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout(5, 5));
        this.tableModel = new BeanTableModel(MenuGroup.class);
        this.tableModel.addColumn("", "visible");
        this.tableModel.addColumn(POSConstants.NAME.toUpperCase(), "name");
        this.tableModel.setPageSize(10);
        this.table = new JXTable(this.tableModel);
        this.table.setSelectionMode(2);
        this.table.setDefaultRenderer(Object.class, (TableCellRenderer)new CustomCellRenderer());
        this.table.setRowHeight(PosUIManager.getSize(40));
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                if (me.getClickCount() == 2) {
                    MenuGroupSelectionView.this.editSelectedRow();
                } else {
                    MenuGroupSelectionView.this.selectItem();
                }
            }
        });
        JPanel contentPanel = new JPanel(new BorderLayout());
        contentPanel.setBorder(new EmptyBorder(10, 5, 10, 5));
        JScrollPane scroll = new JScrollPane((Component)this.table);
        scroll.setPreferredSize(PosUIManager.getSize(500, 250));
        contentPanel.add(scroll);
        contentPanel.add((Component)this.buildSearchForm(), "North");
        this.add(contentPanel);
        this.resizeColumnWidth((JTable)this.table);
        JPanel paginationButtonPanel = new JPanel((LayoutManager)new MigLayout("ins 5 0 0 0,fillx", "[left,grow][][][]", ""));
        paginationButtonPanel.add((Component)this.createButtonPanel(), "left,split 2");
        this.chkShowSelected = new JCheckBox(Messages.getString("MenuGroupSelectionView.5"));
        this.chkShowSelected.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuGroupSelectionView.this.updateView();
            }
        });
        paginationButtonPanel.add(this.chkShowSelected);
        paginationButtonPanel.add((Component)this.lblNumberOfItem, "split 3,center");
        this.btnPrev = new PosButton();
        this.btnPrev.setIcon(IconFactory.getIcon("/ui_icons/", "previous.png"));
        paginationButtonPanel.add((Component)this.btnPrev, "center");
        PosButton btnDot = new PosButton();
        btnDot.setBorder(null);
        btnDot.setOpaque(false);
        btnDot.setContentAreaFilled(false);
        btnDot.setIcon(IconFactory.getIcon("/ui_icons/", "dot.png"));
        this.btnNext = new PosButton();
        this.btnNext.setIcon(IconFactory.getIcon("/ui_icons/", "next.png"));
        paginationButtonPanel.add(this.btnNext);
        paginationButtonPanel.add((Component)new JSeparator(), "newline,span,grow");
        contentPanel.add((Component)paginationButtonPanel, "South");
        ActionListener action = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Object source = e.getSource();
                    if (source == MenuGroupSelectionView.this.btnPrev) {
                        MenuGroupSelectionView.this.scrollUp();
                    } else if (source == MenuGroupSelectionView.this.btnNext) {
                        MenuGroupSelectionView.this.scrollDown();
                    }
                }
                catch (Exception e2) {
                    POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), e2.getMessage(), e2);
                }
            }
        };
        this.btnPrev.addActionListener(action);
        this.btnNext.addActionListener(action);
        this.btnNext.setEnabled(false);
        this.btnPrev.setEnabled(false);
    }

    private void updateView() {
        if (this.chkShowSelected.isSelected()) {
            this.tableModel.setRows(new ArrayList<MenuGroup>(this.addedMenuGroupMap.values()));
            this.updateMenuGroupSelection();
            this.chkShowSelected.setText(String.format(Messages.getString("ShowSelected"), this.addedMenuGroupMap.values().size()));
            this.lblNumberOfItem.setText("");
            this.btnPrev.setEnabled(false);
            this.btnNext.setEnabled(false);
            this.cbMenuCategory.setEnabled(false);
            this.table.repaint();
        } else {
            if (this.cbMenuCategory.getSelectedItem() != null) {
                this.searchItem();
            }
            this.cbMenuCategory.setEnabled(true);
        }
    }

    private JPanel buildSearchForm() {
        this.searchPanel = new JPanel();
        this.searchPanel.setLayout((LayoutManager)new MigLayout("inset 0,fillx,hidemode 3", "", "[]10[]"));
        this.lblName = new JLabel(POSConstants.NAME + ":");
        this.tfName = new JTextField(15);
        this.btnSearch = new JButton(POSConstants.SEARCH_ITEM_BUTTON_TEXT);
        this.searchPanel.add((Component)this.lblName, "align label,split 5");
        this.searchPanel.add((Component)this.tfName, "growx");
        this.chkSelectAll = new JCheckBox(Messages.getString("MenuGroupSelectionView.18"));
        this.chkSelectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuGroupSelectionView.this.selectGroupItems();
            }
        });
        this.cbMenuCategory = new JComboBox();
        ArrayList<Object> groups = new ArrayList<Object>();
        groups.add(Messages.getString("MenuGroupSelectionView.19"));
        List<MenuCategory> menuCategoryList = MenuCategoryDAO.getInstance().findAll();
        groups.addAll(menuCategoryList);
        ComboBoxModel model = new ComboBoxModel(groups);
        this.cbMenuCategory.setModel(model);
        this.cbMenuCategory.setSelectedItem(Messages.getString("MenuGroupSelectionView.19"));
        this.cbMenuCategory.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                MenuGroupSelectionView.this.searchItem();
            }
        });
        this.searchPanel.add(this.btnSearch);
        this.lblMenuCategory = new JLabel(Messages.getString("MenuGroupSelectionView.21"));
        this.searchPanel.add((Component)this.lblMenuCategory, "split 2,right");
        this.searchPanel.add((Component)this.cbMenuCategory, "wrap");
        this.searchPanel.add((Component)this.chkSelectAll, "left");
        this.btnSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuGroupSelectionView.this.searchItem();
            }
        });
        this.tfName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuGroupSelectionView.this.searchItem();
            }
        });
        return this.searchPanel;
    }

    private void searchItem() {
        this.selectedCategory = this.cbMenuCategory.getSelectedItem() instanceof MenuCategory ? (MenuCategory)this.cbMenuCategory.getSelectedItem() : null;
        this.tableModel.setCurrentRowIndex(0);
        MenuGroupDAO.getInstance().loadMenuGroups(this.tableModel, this.tfName.getText(), this.selectedCategory, null);
        this.doSetVisibleCheckAll();
        this.updateButton();
        this.updateMenuGroupSelection();
        this.table.repaint();
        this.chkShowSelected.setSelected(false);
    }

    private void selectGroupItems() {
        Object selectedGroup = this.cbMenuCategory.getSelectedItem();
        if (selectedGroup instanceof MenuCategory) {
            List<MenuGroup> menuGroups = this.tableModel.getRows();
            if (menuGroups != null && menuGroups.size() > 0) {
                for (MenuGroup group : menuGroups) {
                    if (this.parentMenuGroup != null && this.parentMenuGroup.getId() != null && this.parentMenuGroup.getId().equals(group.getId())) continue;
                    group.setVisible(this.chkSelectAll.isSelected());
                    if (group.isVisible().booleanValue()) {
                        this.addedMenuGroupMap.put(group.getId(), group);
                        continue;
                    }
                    this.addedMenuGroupMap.remove(group.getId());
                }
            } else {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("MenuGroupSelectionView.25"));
                this.chkSelectAll.setSelected(false);
            }
        } else {
            List<MenuGroup> menuGroups = this.tableModel.getRows();
            if (menuGroups == null) {
                return;
            }
            for (MenuGroup group : menuGroups) {
                if (this.parentMenuGroup != null && this.parentMenuGroup.getId() != null && this.parentMenuGroup.getId().equals(group.getId())) continue;
                group.setVisible(this.chkSelectAll.isSelected());
                if (group.isVisible().booleanValue()) {
                    this.addedMenuGroupMap.put(group.getId(), group);
                } else {
                    this.addedMenuGroupMap.remove(group.getId());
                }
                this.chkShowSelected.setText(String.format(Messages.getString("ShowSelected"), this.addedMenuGroupMap.values().size()));
                this.table.repaint();
            }
        }
        this.table.repaint();
    }

    private void updateMenuGroupSelection() {
        List<MenuGroup> menuGroups = this.tableModel.getRows();
        if (menuGroups == null) {
            return;
        }
        Iterator<MenuGroup> iterator = menuGroups.iterator();
        while (iterator.hasNext()) {
            MenuGroup menuGroup;
            MenuGroup group = this.addedMenuGroupMap.get((menuGroup = iterator.next()).getId());
            menuGroup.setVisible(group != null);
        }
    }

    private void updateButton() {
        int totalNumber;
        int startNumber = this.tableModel.getCurrentRowIndex() + 1;
        int endNumber = this.tableModel.getNextRowIndex();
        if (endNumber > (totalNumber = this.tableModel.getNumRows())) {
            endNumber = totalNumber;
        }
        this.lblNumberOfItem.setText(String.format(Messages.getString("MenuGroupSelectionView.28"), startNumber, endNumber, totalNumber));
        this.btnPrev.setEnabled(this.tableModel.hasPrevious());
        this.btnNext.setEnabled(this.tableModel.hasNext());
        if (this.tableModel.getRowCount() > 0) {
            this.table.setRowSelectionInterval(0, 0);
        }
        this.chkShowSelected.setText(String.format(Messages.getString("ShowSelected"), this.addedMenuGroupMap.values().size()));
    }

    private TransparentPanel createButtonPanel() {
        ExplorerButtonPanel explorerButton = new ExplorerButtonPanel();
        JButton btnEdit = explorerButton.getEditButton();
        JButton btnAdd = explorerButton.getAddButton();
        btnAdd.setText(POSConstants.ADD);
        btnEdit.setText(POSConstants.EDIT);
        btnEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuGroupSelectionView.this.editSelectedRow();
            }
        });
        btnAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    MenuGroup menuGroup = new MenuGroup();
                    MenuGroupForm editor = new MenuGroupForm(menuGroup);
                    BeanEditorDialog dialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)editor);
                    dialog.open();
                    if (dialog.isCanceled()) {
                        return;
                    }
                    MenuGroup group = (MenuGroup)editor.getBean();
                    MenuGroupSelectionView.this.tableModel.addRow(group);
                    MenuGroupSelectionView.this.tableModel.setNumRows(MenuGroupSelectionView.this.tableModel.getNumRows() + 1);
                    MenuGroupSelectionView.this.updateButton();
                }
                catch (Throwable x) {
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
                }
            }
        });
        TransparentPanel panel = new TransparentPanel((LayoutManager)new MigLayout("center,ins 0", "sg,fill", ""));
        return panel;
    }

    public void resizeColumnWidth(JTable table) {
        TableColumnModel columnModel = table.getColumnModel();
        for (int column = 0; column < table.getColumnCount(); ++column) {
            columnModel.getColumn(column).setPreferredWidth((Integer)this.getColumnWidth().get(column));
        }
    }

    private List getColumnWidth() {
        ArrayList<Integer> columnWidth = new ArrayList<Integer>();
        columnWidth.add(70);
        columnWidth.add(250);
        columnWidth.add(70);
        return columnWidth;
    }

    private void editSelectedRow() {
        try {
            int index = this.table.getSelectedRow();
            if (index < 0) {
                return;
            }
            index = this.table.convertRowIndexToModel(index);
            MenuGroup menuGroup = this.tableModel.getRow(index);
            MenuGroupDAO.getInstance().initialize(menuGroup);
            this.tableModel.setRow(index, menuGroup);
            MenuGroupForm editor = new MenuGroupForm(menuGroup);
            BeanEditorDialog dialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)editor);
            dialog.open();
            if (dialog.isCanceled()) {
                return;
            }
            this.table.repaint();
        }
        catch (Throwable x) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
        }
    }

    public List<MenuGroup> getSelectedMenuGroupList() {
        return new ArrayList<MenuGroup>(this.addedMenuGroupMap.values());
    }

    public void setMenuGroups(List<MenuGroup> menuGroups) {
        if (menuGroups != null) {
            for (MenuGroup group : menuGroups) {
                this.addedMenuGroupMap.put(group.getId(), group);
                this.tableModel.addRow(group);
            }
        }
    }

    private void scrollDown() {
        this.tableModel.setCurrentRowIndex(this.tableModel.getNextRowIndex());
        MenuGroupDAO.getInstance().loadMenuGroups(this.tableModel, this.tfName.getText(), this.selectedCategory, null);
        this.doSetVisibleCheckAll();
        this.updateButton();
        this.updateMenuGroupSelection();
        this.table.repaint();
        this.chkShowSelected.setSelected(false);
    }

    private void scrollUp() {
        this.tableModel.setCurrentRowIndex(this.tableModel.getPreviousRowIndex());
        MenuGroupDAO.getInstance().loadMenuGroups(this.tableModel, this.tfName.getText(), this.selectedCategory, null);
        this.doSetVisibleCheckAll();
        this.updateButton();
        this.updateMenuGroupSelection();
        this.table.repaint();
        this.chkShowSelected.setSelected(false);
    }

    public void setSelectedMenuGroup(Object selectedItem) {
        this.selectedCategory = selectedItem instanceof MenuCategory ? (MenuCategory)selectedItem : null;
        this.searchItem();
    }

    private void selectItem() {
        if (this.table.getSelectedRow() < 0) {
            return;
        }
        int selectedRow = this.table.getSelectedRow();
        selectedRow = this.table.convertRowIndexToModel(selectedRow);
        MenuGroup item = this.tableModel.getRow(selectedRow);
        if (this.parentMenuGroup != null && this.parentMenuGroup.getId() != null && this.parentMenuGroup.getId().equals(item.getId())) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("MenuGroupSelectionView.34"));
            return;
        }
        item.setVisible(item.isVisible() == false);
        if (item.isVisible().booleanValue()) {
            this.addedMenuGroupMap.put(item.getId(), item);
        } else {
            this.addedMenuGroupMap.remove(item.getId());
        }
        this.chkShowSelected.setText(String.format(Messages.getString("ShowSelected"), this.addedMenuGroupMap.values().size()));
        this.table.repaint();
    }

    private void doSetVisibleCheckAll() {
        ArrayList<Boolean> checkVisibilities = new ArrayList<Boolean>();
        List<MenuGroup> menuItems = this.tableModel.getRows();
        for (MenuGroup menuItem : menuItems) {
            if (!this.addedMenuGroupMap.containsKey(menuItem.getId())) continue;
            checkVisibilities.add(menuItem.isVisible());
        }
        if (checkVisibilities.size() != 0 && !checkVisibilities.contains(false)) {
            this.chkSelectAll.setSelected(true);
        } else {
            this.chkSelectAll.setSelected(false);
        }
    }

    public BeanTableModel<MenuGroup> getModel() {
        return this.tableModel;
    }

    public int getSelectedRow() {
        int index = this.table.getSelectedRow();
        if (index < 0) {
            return -1;
        }
        return this.table.convertRowIndexToModel(index);
    }

    public void repaintTable() {
        this.table.repaint();
    }

    public void setSelectionMode(int selectionMode) {
        this.chkShowSelected.setVisible(selectionMode == 1);
        this.chkSelectAll.setVisible(selectionMode == 1);
        TableColumnModelExt columnModel = (TableColumnModelExt)this.table.getColumnModel();
        columnModel.getColumnExt(0).setVisible(selectionMode == 1);
        this.searchItem();
    }

    public void setSelectedCategory(MenuCategory menuCategory) {
        if (this.selectedCategory != null && this.selectedCategory.getId().equals(menuCategory.getId())) {
            return;
        }
        this.selectedCategory = menuCategory;
        this.cbMenuCategory.setSelectedItem(menuCategory);
        this.searchItem();
    }

    public void setEnableSearch(boolean enableSearch) {
        this.tfName.setVisible(enableSearch);
        this.lblName.setVisible(enableSearch);
        this.btnSearch.setVisible(enableSearch);
    }
}

