/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.actions.EmailSendAction;
import com.floreantpos.actions.TicketReorderAction;
import com.floreantpos.actions.TicketTransferAction;
import com.floreantpos.bo.actions.TicketPrintAction;
import com.floreantpos.main.Application;
import com.floreantpos.model.Store;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.UserPermission;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.report.ReceiptPrintService;
import com.floreantpos.swing.PosButton;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.ticket.returnui.ItemReturnDialog;
import com.floreantpos.ui.views.OrderInfoView;
import com.floreantpos.util.POSUtil;
import java.awt.Component;
import java.util.List;
import javax.swing.JPanel;

public class OrderInfoDialog
extends POSDialog {
    private OrderInfoView view;
    private boolean reorder = false;
    private PosButton btnReOrder;
    private PosButton btnTransferUser;
    private PosButton btnPrint;
    private PosButton btnPrintDriverCopy;
    private PosButton btnEmail;
    private JPanel buttonPanel;
    private PosButton btnClose;
    private PosButton btnReturn = new PosButton(Messages.getString("Return"));

    public OrderInfoDialog(OrderInfoView view) {
        this.view = view;
        this.setTitle(Messages.getString("OrderInfoDialog.0"));
        this.createUI();
        this.updateUI();
    }

    public void createUI() {
        this.add(this.view);
        this.buttonPanel = new JPanel();
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.btnReturn.addActionListener(e -> this.doReturnItems());
        this.buttonPanel.add(this.btnReturn);
        this.btnReOrder = new PosButton(Messages.getString("OrderInfoDialog.5"));
        this.btnReOrder.addActionListener(e -> this.performReorderTicket());
        this.btnEmail = new PosButton();
        this.btnEmail.setAction(new EmailSendAction(){

            @Override
            public Ticket getTicket() {
                return OrderInfoDialog.this.view.getTickets().get(0);
            }
        });
        this.buttonPanel.add(this.btnEmail);
        this.buttonPanel.add(this.btnReOrder);
        this.btnTransferUser = new PosButton();
        this.btnTransferUser.setText(Messages.getString("OrderInfoDialog.3"));
        this.btnTransferUser.addActionListener(e -> this.performToTransferUser());
        this.buttonPanel.add(this.btnTransferUser);
        this.btnPrint = new PosButton();
        this.btnPrint.addActionListener(new TicketPrintAction(this.view, null, this.view.getTickets()));
        this.btnPrint.setText(Messages.getString("OrderInfoDialog.1"));
        this.buttonPanel.add(this.btnPrint);
        this.btnPrintDriverCopy = new PosButton();
        this.btnPrintDriverCopy.addActionListener(e -> this.doPrintDriverCopy());
        this.btnPrintDriverCopy.setText(Messages.getString("OrderInfoDialog.2"));
        this.btnPrintDriverCopy.setVisible(false);
        this.buttonPanel.add(this.btnPrintDriverCopy);
        this.btnClose = new PosButton();
        this.btnClose.addActionListener(e -> this.dispose());
        this.btnClose.setText(Messages.getString("Close"));
        this.buttonPanel.add(this.btnClose);
    }

    private void updateUI() {
        try {
            Store store = DataProvider.get().getStore();
            boolean isHidePrintButton = POSUtil.getBoolean(store.getProperty("hide_print_button.in_order_info_view"));
            if (isHidePrintButton) {
                this.btnPrint.setVisible(Boolean.FALSE);
            } else {
                this.btnPrint.setVisible(Boolean.TRUE);
            }
        }
        catch (Exception e) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e.getMessage());
        }
    }

    private void doPrintDriverCopy() {
        try {
            if (ReceiptPrintService.hasNoReceiptPrinters()) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("NoPrinterIsConfigured"));
                return;
            }
            this.view.printCopy("Driver Copy");
        }
        catch (Exception e) {
            POSMessageDialog.showError(Application.getPosWindow(), e.getMessage());
        }
    }

    public void updateView() {
        this.btnTransferUser.setVisible(false);
        this.btnReOrder.setVisible(false);
        this.btnPrintDriverCopy.setVisible(true);
        this.btnPrint.setText(Messages.getString("OrderInfoDialog.7"));
    }

    public void setReorder(boolean reorder) {
        this.reorder = reorder;
    }

    public boolean isReorder() {
        return this.reorder;
    }

    public void showOnlyPrintButton() {
        this.btnTransferUser.setVisible(false);
        this.btnReOrder.setVisible(false);
        this.btnPrintDriverCopy.setVisible(false);
    }

    public OrderInfoView getOrderInfoView() {
        return this.view;
    }

    public JPanel getButtonPanel() {
        return this.buttonPanel;
    }

    private void performToTransferUser() {
        try {
            TicketTransferAction transferAction = new TicketTransferAction(this.view.getTickets().get(0), Application.getCurrentUser());
            transferAction.execute();
            if (!transferAction.isTransfered()) {
                return;
            }
            this.view.getReportPanel().removeAll();
            this.view.createReport();
            this.view.revalidate();
            this.view.repaint();
            this.setCanceled(false);
            this.dispose();
        }
        catch (Exception e1) {
            POSMessageDialog.showError(Messages.getString("MessageDialog.0"));
            PosLog.error(this.getClass(), e1);
        }
    }

    private void performReorderTicket() {
        try {
            TicketReorderAction reorderAction = new TicketReorderAction(this.view.getTickets().get(0), UserPermission.CREATE_TICKET);
            reorderAction.execute();
            if (!reorderAction.isReorder()) {
                return;
            }
            this.reorder = true;
            this.setCanceled(false);
            this.dispose();
        }
        catch (Exception e1) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e1.getMessage());
        }
    }

    private void doReturnItems() {
        List<Ticket> tickets = this.view.getTickets();
        if (tickets == null || tickets.isEmpty()) {
            throw new PosException(Messages.getString("OrderInfoDialog.8"));
        }
        this.dispose();
        ItemReturnDialog returnDialog = new ItemReturnDialog(tickets.get(0));
        returnDialog.open();
    }
}

