/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.config.TerminalConfig;
import com.floreantpos.main.Application;
import com.floreantpos.model.ComboItem;
import com.floreantpos.model.ComboTicketItem;
import com.floreantpos.model.Customer;
import com.floreantpos.model.IUnit;
import com.floreantpos.model.MemberType;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.swing.ComboBoxModel;
import com.floreantpos.swing.ListComboBoxModel;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.dialog.AutomatedWeightInputDialog;
import com.floreantpos.ui.dialog.ComboTicketItemSelectionDialog;
import com.floreantpos.ui.dialog.ItemQtySelectionDialog;
import com.floreantpos.ui.dialog.ItemSearchDialog;
import com.floreantpos.ui.dialog.NumberSelectionDialog2;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.dialog.TicketDiscountSelectionDialog;
import com.floreantpos.ui.dialog.TicketItemDiscountSelectionDialog;
import com.floreantpos.ui.ticket.TicketViewerTable;
import com.floreantpos.ui.views.order.modifier.ModifierSelectionDialog;
import com.floreantpos.ui.views.order.modifier.ModifierSelectionModel;
import com.floreantpos.ui.views.order.multipart.PizzaModifierSelectionDialog;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import net.miginfocom.swing.MigLayout;
import org.hibernate.Session;

public class PriceCheckView
extends POSDialog {
    private PosButton btnDiscount;
    private PosButton btnClear;
    private PosButton btnExit;
    private JTextField tfDiscount;
    private JTextField tfSubtotal;
    private JTextField tfTax;
    private JTextField tfTotal;
    private TicketViewerTable ticketViewerTable;
    private JTextField tfMenuItem;
    private PosButton btnSearch;
    private JComboBox<OrderType> cbOrderType;
    private JComboBox<MemberType> cbMemberType;
    private Ticket ticket;
    private Customer customer;

    public PriceCheckView() {
        super((Frame)POSUtil.getBackOfficeWindow(), "");
        this.init();
    }

    public PriceCheckView(JFrame parent) {
        this(parent, (boolean)Boolean.TRUE);
    }

    public PriceCheckView(JFrame parent, boolean isVissibleButton) {
        this.init();
        this.ticket = new Ticket();
        this.customer = new Customer();
        this.customer.setMemberType(MemberType.MEMBER);
        this.ticket.setCustomer(this.customer);
        this.ticketViewerTable.setTicket(this.ticket);
    }

    private void init() {
        JPanel mainContentPanel = new JPanel();
        mainContentPanel.setLayout(new BorderLayout());
        TitlePanel titlePanel = new TitlePanel();
        titlePanel.setTitle(Messages.getString("PRICE_CHECK_"));
        mainContentPanel.add((Component)titlePanel, "North");
        JPanel centerPanel = new JPanel((LayoutManager)new MigLayout("hidemode 3", "[]15[grow]5[]", ""));
        centerPanel.setBorder(new EmptyBorder(0, 10, 0, 10));
        this.cbOrderType = new JComboBox();
        this.cbOrderType.setMinimumSize(PosUIManager.getSize(150, 30));
        List<OrderType> orderTypes = DataProvider.get().getOrderTypes();
        this.cbOrderType.setModel(new ListComboBoxModel(orderTypes));
        centerPanel.add(new JLabel(Messages.getString("OrderType")));
        centerPanel.add(this.cbOrderType, "wrap");
        JLabel lblType = new JLabel(POSConstants.TYPE);
        this.cbMemberType = new JComboBox();
        ComboBoxModel memberTypeModel = new ComboBoxModel();
        memberTypeModel.addElement((Object)null);
        for (MemberType memberType : MemberType.values()) {
            memberTypeModel.addElement((Object)memberType);
        }
        this.cbMemberType.setModel(memberTypeModel);
        this.cbMemberType.setMinimumSize(PosUIManager.getSize(150, 30));
        this.cbMemberType.setSelectedItem((Object)MemberType.MEMBER);
        centerPanel.add(lblType);
        centerPanel.add(this.cbMemberType, "wrap");
        JLabel lblMenuItem = new JLabel(Messages.getString("PriceCheckView.1"));
        this.tfMenuItem = new JTextField();
        this.tfMenuItem.setMinimumSize(PosUIManager.getSize(0, 40));
        this.btnSearch = new PosButton(Messages.getString("Search"));
        this.tfMenuItem.addActionListener(e -> this.doSearchByScan());
        this.btnSearch.addActionListener(e -> this.doSearchByScan());
        this.cbMemberType.addItemListener(e -> this.doUpdateCustomer());
        this.cbOrderType.addItemListener(e -> this.doClearDiscount(e));
        centerPanel.add(lblMenuItem);
        centerPanel.add((Component)this.tfMenuItem, "grow");
        centerPanel.add((Component)this.btnSearch, "gaptop 0,wrap");
        centerPanel.add((Component)this.buildTablePannel(), "grow,wrap,span 4");
        mainContentPanel.add((Component)centerPanel, "Center");
        this.add((Component)mainContentPanel, "Center");
        TransparentPanel southPanel = new TransparentPanel();
        southPanel.setLayout(new BorderLayout());
        JSeparator jSeparator1 = new JSeparator();
        southPanel.add((Component)jSeparator1, "North");
        southPanel.add(this.buildButtonPannel());
        this.add((Component)southPanel, "South");
    }

    private void doClearDiscount(ItemEvent e) {
        if (e.getStateChange() != 1) {
            return;
        }
        if (this.ticket == null || this.ticket.getTicketItems().isEmpty()) {
            return;
        }
        OrderType orderType = (OrderType)this.cbOrderType.getSelectedItem();
        if (orderType == null) {
            return;
        }
        this.ticket.setOrderType(orderType);
        ArrayList<MenuItem> menuItemList = new ArrayList<MenuItem>();
        for (TicketItem ticketItem : this.ticket.getTicketItems()) {
            if (ticketItem == null) continue;
            menuItemList.add(ticketItem.getMenuItem());
        }
        this.ticket.getTicketItems().clear();
        this.ticketViewerTable.getModel().removeAll();
        for (MenuItem menuItem : menuItemList) {
            if (menuItem == null) continue;
            this.itemSelected(menuItem);
        }
        this.ticketViewerTable.updateView();
        this.updateView();
    }

    private void doUpdateCustomer() {
        MemberType memberType = (MemberType)((Object)this.cbMemberType.getSelectedItem());
        this.customer.setMemberType(memberType);
        this.ticket.setCustomer(this.customer);
        this.updateView();
    }

    private void doSearchByScan() {
        String searchString = this.tfMenuItem.getText();
        if (searchString.equals("")) {
            POSMessageDialog.showMessage(Messages.getString("PriceCheckView.2"));
            return;
        }
        OrderType orderType = (OrderType)this.cbOrderType.getSelectedItem();
        if (orderType == null) {
            POSMessageDialog.showMessage(Messages.getString("PriceCheckView.0"));
            return;
        }
        this.ticket.setOrderType(orderType);
        MenuItem menuItem = MenuItemDAO.getInstance().getMenuItemByIdOrBarcode(searchString);
        if (menuItem != null) {
            this.itemSelected(menuItem);
        }
        this.tfMenuItem.setText("");
    }

    private void doSearch() {
        OrderType orderType = (OrderType)this.cbOrderType.getSelectedItem();
        if (orderType == null) {
            POSMessageDialog.showMessage(Messages.getString("PriceCheckView.0"));
            return;
        }
        this.ticket.setOrderType(orderType);
        ItemSearchDialog itemSearchDialog = new ItemSearchDialog(Application.getPosWindow());
        itemSearchDialog.setTitle(Messages.getString("TicketView.7"));
        itemSearchDialog.updateFilterPanel(orderType);
        itemSearchDialog.pack();
        itemSearchDialog.openFullScreen();
        if (itemSearchDialog.isCanceled()) {
            return;
        }
        this.tfMenuItem.requestFocus();
        if (itemSearchDialog.getMenuItem() == null) {
            POSMessageDialog.showError(Application.getPosWindow(), Messages.getString("TicketView.8"));
            return;
        }
        MenuItem menuItem = itemSearchDialog.getMenuItem();
        if (menuItem != null) {
            this.itemSelected(menuItem);
        }
    }

    private JPanel buildButtonPannel() {
        JPanel buttonPannel = new JPanel();
        buttonPannel.setBorder(new EmptyBorder(0, 10, 0, 10));
        this.btnDiscount = new PosButton(POSConstants.DISCOUNT);
        this.btnClear = new PosButton(POSConstants.CLEAR);
        this.btnExit = new PosButton(Messages.getString("EXIT_"));
        buttonPannel.add(this.btnDiscount);
        buttonPannel.add(this.btnClear);
        buttonPannel.add(this.btnExit);
        this.btnDiscount.addActionListener(e -> this.doAddDiscount());
        this.btnClear.addActionListener(e -> this.doClear());
        this.btnExit.addActionListener(e -> this.doExit());
        return buttonPannel;
    }

    private void doAddDiscount() {
        OrderType orderType = (OrderType)this.cbOrderType.getSelectedItem();
        if (orderType == null) {
            POSMessageDialog.showMessage(Messages.getString("PriceCheckView.0"));
            return;
        }
        this.ticket.setOrderType(orderType);
        if (this.ticket == null || this.ticket.getTicketItems().isEmpty()) {
            POSMessageDialog.showMessage(Messages.getString("PriceCheckView.3"));
            return;
        }
        this.doApplyCoupon(0);
    }

    public void doApplyCoupon(int couponType) {
        try {
            if (this.ticket == null) {
                return;
            }
            if (!this.ticket.isDiscountable()) {
                String message = POSConstants.TICKET_IS_EMPTY_;
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), message);
                return;
            }
            if (couponType == 1) {
                TicketDiscountSelectionDialog dialog = new TicketDiscountSelectionDialog(this.ticket);
                dialog.openFullScreen();
            } else {
                TicketItemDiscountSelectionDialog dialog = new TicketItemDiscountSelectionDialog(this.ticket);
                dialog.openFullScreen();
            }
            this.ticketViewerTable.updateView();
            this.updateView();
        }
        catch (Exception e) {
            POSMessageDialog.showError(Application.getPosWindow(), POSConstants.ERROR_MESSAGE, e);
        }
    }

    private void doClear() {
        this.ticketViewerTable.getModel().removeAll();
        this.tfSubtotal.setText("");
        this.tfDiscount.setText("");
        this.tfTax.setText("");
        this.tfTotal.setText("");
    }

    private void doExit() {
        this.setCanceled(true);
        this.dispose();
    }

    private JPanel buildTablePannel() {
        JScrollPane scrollPane = new JScrollPane();
        JLabel lblSubtotal = new JLabel(POSConstants.SUBTOTAL + ":");
        JLabel lblTotal = new JLabel(POSConstants.TOTAL + ":");
        JLabel lblDiscount = new JLabel(POSConstants.DISCOUNT + ":");
        JLabel lblTax = new JLabel(POSConstants.TAX + ":");
        this.tfSubtotal = new JTextField();
        this.tfSubtotal.setHorizontalAlignment(11);
        this.tfSubtotal.setColumns(10);
        this.tfTax = new JTextField();
        this.tfTax.setHorizontalAlignment(11);
        this.tfTax.setColumns(10);
        this.tfDiscount = new JTextField();
        this.tfDiscount.setHorizontalAlignment(11);
        this.tfDiscount.setColumns(10);
        this.tfTotal = new JTextField();
        this.tfTotal.setHorizontalAlignment(11);
        this.tfTotal.setColumns(10);
        this.ticketViewerTable = new TicketViewerTable();
        scrollPane.setHorizontalScrollBarPolicy(31);
        scrollPane.setVerticalScrollBarPolicy(20);
        scrollPane.setViewportView(this.ticketViewerTable);
        TransparentPanel ticketTotalPanel = new TransparentPanel((LayoutManager)new MigLayout("wrap 2,right,inset 5 5 5 0"));
        lblSubtotal.setHorizontalAlignment(4);
        ticketTotalPanel.add(lblSubtotal);
        this.tfSubtotal.setEditable(false);
        ticketTotalPanel.add(this.tfSubtotal);
        lblDiscount.setHorizontalAlignment(4);
        ticketTotalPanel.add(lblDiscount);
        this.tfDiscount.setEditable(false);
        ticketTotalPanel.add(this.tfDiscount);
        lblTax.setHorizontalAlignment(4);
        ticketTotalPanel.add(lblTax);
        this.tfTax.setEditable(false);
        ticketTotalPanel.add(this.tfTax);
        lblTotal.setHorizontalAlignment(4);
        ticketTotalPanel.add(lblTotal);
        this.tfTotal.setEditable(false);
        ticketTotalPanel.add(this.tfTotal);
        JPanel tablePanel = new JPanel((LayoutManager)new MigLayout("fill,ins 0", "[]", "[grow][]"));
        tablePanel.add((Component)scrollPane, "grow,wrap");
        tablePanel.add((Component)ticketTotalPanel, "right");
        return tablePanel;
    }

    public void updateView() {
        if (this.ticket == null || this.ticket.getTicketItems() == null || this.ticket.getTicketItems().size() <= 0) {
            this.doClear();
            return;
        }
        this.ticket.calculatePrice();
        this.tfSubtotal.setText(NumberUtil.formatNumber(this.ticket.getSubtotalAmount()));
        this.tfDiscount.setText(NumberUtil.formatNumber(this.ticket.getDiscountAmount()));
        this.tfTax.setText(NumberUtil.formatNumber(this.ticket.getTaxAmount()));
        this.tfTotal.setText(NumberUtil.formatNumber(this.ticket.getTotalAmountWithTips()));
    }

    public void itemSelected(MenuItem originalMenuItem) {
        try (Session session = MenuItemDAO.getInstance().createNewSession();){
            MenuItem menuItem = MenuItemDAO.getInstance().get(originalMenuItem.getId(), session);
            if (!this.hasAvailableStock(menuItem, 1.0)) {
                return;
            }
            if (menuItem.isAuto86Enabled() && menuItem.get86Countdown() <= 0 && !menuItem.isFractionalUnit().booleanValue()) {
                originalMenuItem.setEnable(false);
                menuItem.setEnable(false);
                MenuItemDAO.getInstance().updateUsingTransaction(menuItem, session);
                POSMessageDialog.showError(Messages.getString("OrderController.11"));
                return;
            }
            if (menuItem.isVariant().booleanValue()) {
                MenuItem parentMenuItem = MenuItemDAO.getInstance().get(menuItem.getParentMenuItemId(), session);
                menuItem.setParentMenuItem(parentMenuItem);
            }
            if (menuItem.isHasVariant().booleanValue() && menuItem.getVariants() != null && menuItem.getVariants().size() > 0) {
                return;
            }
            double itemQuantity = 1.0;
            IUnit destinationUnit = null;
            if (menuItem.isFractionalUnit().booleanValue() || menuItem.isAllowUnitSelection()) {
                if (TerminalConfig.getScaleActivationValue().equals("cas10")) {
                    itemQuantity = AutomatedWeightInputDialog.takeDoubleInput(menuItem.getName(), 1.0);
                } else {
                    ItemQtySelectionDialog qtyDialog = ItemQtySelectionDialog.getQtyAndUnit(menuItem, Messages.getString("OrderController.2"), 1.0);
                    qtyDialog.pack();
                    qtyDialog.open();
                    itemQuantity = qtyDialog.isCanceled() ? -1.0 : qtyDialog.getValue();
                    destinationUnit = qtyDialog.getSelectedUnit();
                }
                if (itemQuantity <= -1.0) {
                    return;
                }
                if (itemQuantity == 0.0) {
                    POSMessageDialog.showError(Messages.getString("OrderController.3"));
                    return;
                }
            }
            double itemPrice = 0.0;
            if (menuItem.isEditablePrice().booleanValue()) {
                itemPrice = NumberSelectionDialog2.takeDoubleInput(Messages.getString("OrderController.5"), menuItem.getPrice());
                if (itemPrice <= -1.0) {
                    return;
                }
                menuItem.setPrice(itemPrice);
            }
            TicketItem ticketItem = menuItem.convertToTicketItem(this.ticket, itemQuantity, destinationUnit);
            double voidQuantity = 0.0;
            if (menuItem.isAuto86Enabled() && !menuItem.isFractionalUnit().booleanValue()) {
                int countdown86 = 0;
                countdown86 = menuItem.get86Countdown() - (int)Math.ceil(itemQuantity);
                menuItem.set86Countdown(Math.max(0, countdown86));
                menuItem.setEnable(countdown86 > 0);
                MenuItemDAO.getInstance().updateUsingTransaction(menuItem, session);
                originalMenuItem.setEnable(menuItem.isEnable());
            }
            if (menuItem.isVariant().booleanValue()) {
                menuItem = menuItem.getParentMenuItem();
            }
            if (menuItem.isComboItem().booleanValue()) {
                if (voidQuantity > 1.0) {
                    ticketItem.setQuantity(voidQuantity);
                }
                if (!this.addComboItemsToTicketItem(menuItem, ticketItem)) {
                    return;
                }
            }
            ticketItem.setTicket(this.ticket);
            if (menuItem.isPizzaType().booleanValue()) {
                PizzaModifierSelectionDialog dialog = new PizzaModifierSelectionDialog(this.ticket, ticketItem, menuItem, false);
                dialog.setResizable(false);
                if (TerminalConfig.isKioskMode()) {
                    dialog.openUndecoratedFullScreen();
                } else {
                    dialog.openFullScreen();
                }
                if (dialog.isCanceled()) {
                    return;
                }
                List pizzaModifierList = dialog.getPizzzItemList();
                for (TicketItem ticketItemPizza : pizzaModifierList) {
                    this.addTicketItem(ticketItemPizza);
                }
            } else if (menuItem.hasMandatoryModifiers()) {
                ModifierSelectionModel modifierSelectionModel = new ModifierSelectionModel(this.ticket, ticketItem, menuItem);
                ModifierSelectionDialog dialog = new ModifierSelectionDialog(modifierSelectionModel);
                dialog.open();
                if (!dialog.isCanceled()) {
                    this.addTicketItem(ticketItem);
                }
            } else {
                this.addTicketItem(ticketItem);
            }
        }
        catch (Exception e) {
            POSMessageDialog.showError(Application.getPosWindow(), e.getMessage(), e);
        }
    }

    private boolean hasAvailableStock(MenuItem menuItem, double selectedQty) {
        List<TicketItem> ticketItems;
        if (menuItem == null || !menuItem.isDisableWhenStockAmountIsZero().booleanValue() || menuItem.isHasVariant().booleanValue()) {
            return true;
        }
        double qty = 0.0;
        if (this.ticket != null && (ticketItems = this.ticket.getTicketItems()) != null) {
            for (TicketItem item : ticketItems) {
                if (!item.getMenuItemId().equals(menuItem.getId())) continue;
                qty += item.getQuantity() - item.getInventoryAdjustQty();
            }
        }
        qty += selectedQty;
        return !(menuItem.getAvailableUnit() < qty) || POSMessageDialog.showYesNoQuestionDialog(Application.getPosWindow(), Messages.getString("OrderController.6"), Messages.getString("CONFIRM"), Messages.getString("OrderController.8"), Messages.getString("OrderController.9")) == 0;
    }

    private boolean addComboItemsToTicketItem(MenuItem menuItem, TicketItem ticketItemObj) {
        ComboTicketItem ticketItem = (ComboTicketItem)ticketItemObj;
        if (menuItem.getComboItems() != null && !menuItem.getComboItems().isEmpty()) {
            for (ComboItem item : menuItem.getComboItems()) {
                ModifierSelectionDialog dialog;
                MenuItemDAO menuItemDAO;
                MenuItem comboMenuItem;
                if (item.getQuantity() == 0.0 || item.getItemId() == null || (comboMenuItem = (menuItemDAO = MenuItemDAO.getInstance()).get(item.getItemId())) == null) continue;
                menuItemDAO.initialize(comboMenuItem);
                if (comboMenuItem.isVariant().booleanValue()) {
                    menuItemDAO.initialize(comboMenuItem.getParentMenuItem());
                }
                TicketItem comboTicketItem = comboMenuItem.convertToTicketItem(this.ticket, item.getQuantity());
                comboTicketItem.setMenuItem(comboMenuItem);
                if (comboMenuItem.hasMandatoryModifiers()) {
                    dialog = new ModifierSelectionDialog(new ModifierSelectionModel(this.ticket, comboTicketItem, comboMenuItem));
                    dialog.open();
                    if (dialog.isCanceled()) {
                        return false;
                    }
                } else if (menuItem.isPizzaType().booleanValue()) {
                    dialog = new PizzaModifierSelectionDialog(this.ticket, comboTicketItem, comboMenuItem, false);
                    dialog.openFullScreen();
                    if (dialog.isCanceled()) {
                        return false;
                    }
                }
                comboTicketItem.setMenuItemId(comboMenuItem.getId());
                comboTicketItem.setName(comboMenuItem.getName());
                comboTicketItem.setQuantity(ticketItem.getQuantity() * item.getQuantity());
                comboTicketItem.setParentTicketItem(ticketItem);
                comboTicketItem.setTicket(null);
                comboTicketItem.setGroupId(null);
                ticketItem.addTocomboItems(comboTicketItem);
            }
        }
        if (menuItem.getComboGroups() != null && !menuItem.getComboGroups().isEmpty()) {
            ComboTicketItemSelectionDialog dialog = new ComboTicketItemSelectionDialog(menuItem, ticketItem);
            dialog.setTitle(Messages.getString("OrderController.13"));
            dialog.setSize(PosUIManager.getSize(1024, 700));
            dialog.open();
            if (dialog.isCanceled()) {
                return false;
            }
            if (menuItem.isModifiablePriceForComboItem()) {
                ticketItem.doCalculateComboItemPrice();
            }
        }
        return true;
    }

    public void addTicketItem(TicketItem ticketItem) {
        this.ticketViewerTable.addTicketItem(ticketItem);
        this.updateView();
    }
}

