/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views;

import com.floreantpos.IconFactory;
import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.model.ITicketItem;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.swing.POSToggleButton;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.ticket.TicketViewerTable;
import com.floreantpos.util.NumberUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public class TicketTransferView
extends TransparentPanel
implements ActionListener {
    private PosButton btnScrollDown;
    private PosButton btnScrollUp;
    private PosButton btnTransferOneByOne;
    private PosButton btnTransferAll;
    private JScrollPane scrollPane;
    private JTextField tfDiscount;
    private JTextField tfSubtotal;
    private JTextField tfTax;
    private JTextField tfTotal;
    private JLabel lblMemberName;
    private TicketViewerTable ticketViewerTable;
    private int viewNumber = 1;
    protected int splitNumber;
    private List<Integer> selectedTicketNumbers;
    private List<Ticket> tickets;
    private Ticket ticket;
    private TicketTransferView otherTicketView;
    private ButtonGroup btnGroup;
    private ArrayList<POSToggleButton> addedButtonList;
    private final String TICKET_PROP = "ticket";
    private POSToggleButton currentSelectedButton;
    private ORIENTATION orientation;

    public TicketTransferView(List<Ticket> tickets, ORIENTATION orientation) {
        this.tickets = tickets;
        this.orientation = orientation;
        this.initComponents();
        this.setOpaque(true);
    }

    private void initComponents() {
        this.setLayout(new BorderLayout(5, 5));
        this.setBorder(BorderFactory.createTitledBorder(null, "*", 2, 0));
        this.add((Component)this.createTopPanel(), "North");
        this.add((Component)this.createTicketTablePanel(), "Center");
        this.add((Component)this.createRightButtonPanel(), "East");
        this.add((Component)this.createTicketTotalPanel(), "South");
    }

    private JPanel createTopPanel() {
        JPanel topPanel = new JPanel((LayoutManager)new MigLayout());
        JPanel buttonPanel = new JPanel((LayoutManager)new MigLayout());
        JPanel customerPanel = new JPanel((LayoutManager)new MigLayout());
        this.btnGroup = new ButtonGroup();
        this.addedButtonList = new ArrayList();
        for (Ticket ticket : this.tickets) {
            POSToggleButton btnTicket = new POSToggleButton(Messages.getString("TicketTransferView.2") + ticket.getTokenNo());
            btnTicket.putClientProperty("ticket", ticket);
            btnTicket.addActionListener(this);
            this.addedButtonList.add(btnTicket);
            this.btnGroup.add(btnTicket);
            buttonPanel.add(btnTicket);
        }
        customerPanel.add(new JLabel(Messages.getString("TicketTransferView.0")));
        this.lblMemberName = new JLabel();
        customerPanel.add(this.lblMemberName);
        topPanel.add((Component)buttonPanel, "wrap");
        topPanel.add(customerPanel);
        return topPanel;
    }

    private JPanel createTicketTablePanel() {
        TransparentPanel ticketTableViewPanel = new TransparentPanel(new BorderLayout());
        ticketTableViewPanel.setBorder(new EmptyBorder(0, 5, 0, 0));
        this.scrollPane = new JScrollPane();
        this.ticketViewerTable = new TicketViewerTable();
        this.scrollPane.setHorizontalScrollBarPolicy(31);
        this.scrollPane.setVerticalScrollBarPolicy(21);
        this.scrollPane.setViewportView(this.ticketViewerTable);
        ticketTableViewPanel.add((Component)this.scrollPane, "Center");
        return ticketTableViewPanel;
    }

    private JPanel createTicketTotalPanel() {
        int rightGap = PosUIManager.getSize(60) + 10;
        TransparentPanel ticketTotalPanel = new TransparentPanel((LayoutManager)new MigLayout("wrap 2,right,inset 5 5 5 " + rightGap + " "));
        JLabel lblSubtotal = new JLabel(POSConstants.SUBTOTAL + ":");
        JLabel lblTotal = new JLabel(POSConstants.TOTAL + ":");
        JLabel lblDiscount = new JLabel(POSConstants.DISCOUNT + ":");
        JLabel lblTax = new JLabel(POSConstants.TAX + ":");
        lblSubtotal.setHorizontalAlignment(4);
        lblTotal.setHorizontalAlignment(4);
        lblDiscount.setHorizontalAlignment(4);
        lblTax.setHorizontalAlignment(4);
        this.tfSubtotal = new JTextField();
        this.tfSubtotal.setHorizontalAlignment(11);
        this.tfSubtotal.setColumns(10);
        this.tfTax = new JTextField();
        this.tfTax.setHorizontalAlignment(11);
        this.tfTax.setColumns(10);
        this.tfDiscount = new JTextField();
        this.tfDiscount.setHorizontalAlignment(11);
        this.tfDiscount.setColumns(10);
        this.tfTotal = new JTextField();
        this.tfTotal.setHorizontalAlignment(11);
        this.tfTotal.setColumns(10);
        this.tfSubtotal.setEditable(false);
        this.tfTotal.setEditable(false);
        this.tfDiscount.setEditable(false);
        this.tfTax.setEditable(false);
        ticketTotalPanel.add(lblSubtotal);
        ticketTotalPanel.add(this.tfSubtotal);
        ticketTotalPanel.add(lblDiscount);
        ticketTotalPanel.add(this.tfDiscount);
        ticketTotalPanel.add(lblTax);
        ticketTotalPanel.add(this.tfTax);
        ticketTotalPanel.add(lblTotal);
        ticketTotalPanel.add(this.tfTotal);
        return ticketTotalPanel;
    }

    private JPanel createRightButtonPanel() {
        TransparentPanel rightButtonPanel = new TransparentPanel((LayoutManager)new MigLayout("wrap 1,fill,hidemode 3,inset 1"));
        this.btnScrollUp = new PosButton();
        this.btnScrollUp.setIcon(IconFactory.getIcon("/ui_icons/", "up.png"));
        this.btnScrollUp.setPreferredSize(PosUIManager.getSize(60, 50));
        this.btnScrollUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TicketTransferView.this.doScrollUp(evt);
            }
        });
        rightButtonPanel.add((Component)this.btnScrollUp, "grow");
        this.btnScrollDown = new PosButton();
        this.btnScrollDown.setIcon(IconFactory.getIcon("/ui_icons/", "down.png"));
        this.btnScrollDown.setPreferredSize(PosUIManager.getSize(60, 50));
        this.btnScrollDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TicketTransferView.this.doScrollDown(evt);
            }
        });
        rightButtonPanel.add((Component)this.btnScrollDown, "grow");
        this.btnTransferOneByOne = new PosButton();
        this.btnTransferOneByOne.setPreferredSize(PosUIManager.getSize(60, 50));
        this.btnTransferOneByOne.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TicketTransferView.this.btnTransferToTicket1ActionPerformed();
            }
        });
        rightButtonPanel.add((Component)this.btnTransferOneByOne, "grow");
        this.btnTransferAll = new PosButton(">>>");
        this.btnTransferAll.setFont(new Font("Tahoma", 1, 18));
        this.btnTransferAll.setPreferredSize(PosUIManager.getSize(60, 50));
        this.btnTransferAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TicketTransferView.this.doTransferAll();
            }
        });
        rightButtonPanel.add((Component)this.btnTransferAll, "grow");
        if (this.orientation.equals((Object)ORIENTATION.LEFT)) {
            this.btnTransferOneByOne.setIcon(IconFactory.getIcon("next.png"));
            this.btnTransferAll.setText(">>>");
        } else {
            this.btnTransferOneByOne.setIcon(IconFactory.getIcon("previous.png"));
            this.btnTransferAll.setText("<<<");
        }
        return rightButtonPanel;
    }

    private void btnTransferToTicket1ActionPerformed() {
        try {
            int selectedRow = this.ticketViewerTable.getSelectedRow();
            ITicketItem object = this.ticketViewerTable.get(selectedRow);
            if (object instanceof TicketItem) {
                TicketItem ticketItem = (TicketItem)object;
                double ticketItemQuantity = ticketItem.getQuantity();
                this.transferTicketItem(ticketItem, ticketItemQuantity);
            }
        }
        catch (Exception e) {
            POSMessageDialog.showError(this, POSConstants.ERROR_MESSAGE, e);
        }
    }

    private void doTransferAll() {
        try {
            List<TicketItem> ticketItems = this.ticketViewerTable.getTicketItems();
            for (TicketItem ticketItem : ticketItems) {
                this.transferTicketItem(ticketItem, ticketItem.getQuantity());
            }
        }
        catch (Exception e) {
            POSMessageDialog.showError(this, POSConstants.ERROR_MESSAGE, e);
        }
    }

    public void transferTicketItem(TicketItem ticketItem, Double quantity) {
        TicketItem newTicketItem = ticketItem.cloneAsNew(true);
        double ticketItemQuantity = NumberUtil.roundToTwoDigit(ticketItem.getQuantity());
        if (Double.isInfinite(quantity)) {
            return;
        }
        if (quantity % 1.0 != 0.0) {
            newTicketItem.setFractionalUnit(true);
        }
        quantity = NumberUtil.roundToTwoDigit(quantity);
        this.otherTicketView.addTicketItem(newTicketItem);
        this.otherTicketView.updateView();
        if (ticketItemQuantity > quantity) {
            double itemQuantity = ticketItem.getQuantity();
            ticketItem.setQuantity(itemQuantity - quantity);
            if (ticketItem.getQuantity() % 1.0 != 0.0) {
                ticketItem.setFractionalUnit(true);
            }
        } else {
            this.ticketViewerTable.delete(ticketItem.getTableRowNum());
        }
        this.ticket.getTicketItems().remove(ticketItem);
        this.updateView();
    }

    public void addTicketItem(TicketItem ticketItem) {
        this.getTicketViewerTable().addTicketItem(ticketItem);
    }

    public List<Integer> getViewNumbers() {
        return this.selectedTicketNumbers;
    }

    private void doScrollDown(ActionEvent evt) {
        this.ticketViewerTable.scrollDown();
    }

    private void doScrollUp(ActionEvent evt) {
        this.ticketViewerTable.scrollUp();
    }

    public void updateModel() {
        this.ticket.calculatePrice();
    }

    public void updateView() {
        if (this.ticket == null || this.ticket.getTicketItems() == null || this.ticket.getTicketItems().size() <= 0) {
            this.tfSubtotal.setText("");
            this.tfDiscount.setText("");
            this.tfTax.setText("");
            this.tfTotal.setText("");
            return;
        }
        this.ticket.calculatePrice();
        this.tfSubtotal.setText(NumberUtil.formatNumber(this.ticket.getSubtotalAmount()));
        this.tfDiscount.setText(NumberUtil.formatNumber(this.ticket.getDiscountAmount()));
        this.tfTax.setText(NumberUtil.formatNumber(this.ticket.getTaxAmount()));
        this.tfTotal.setText(NumberUtil.formatNumber(this.ticket.getTotalAmountWithTips()));
        this.updateCustomerInfo();
    }

    private void updateCustomerInfo() {
        String firstName = this.ticket.getProperty("CUSTOMER_NAME");
        String lastName = this.ticket.getProperty("CUSTOMER_LAST_NAME");
        StringBuilder fullName = new StringBuilder();
        if (StringUtils.isNotBlank((String)firstName)) {
            fullName.append(firstName);
        }
        if (StringUtils.isNotBlank((String)lastName)) {
            fullName.append(" ").append(lastName);
        }
        this.lblMemberName.setText(fullName.toString());
    }

    public Ticket getTicket() {
        return this.ticket;
    }

    public TicketTransferView getOtherTicketView() {
        return this.otherTicketView;
    }

    public void setOtherTicketView(TicketTransferView ticketView) {
        this.otherTicketView = ticketView;
    }

    public int getViewNumber() {
        return this.viewNumber;
    }

    private TicketViewerTable getTicketViewerTable() {
        return this.ticketViewerTable;
    }

    public void setSelectTicketButton(int index) {
        this.currentSelectedButton = this.addedButtonList.get(index);
        this.currentSelectedButton.setSelected(true);
        this.ticket = (Ticket)this.currentSelectedButton.getClientProperty("ticket");
        this.ticketViewerTable.setTicket(this.ticket);
        this.updateView();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            POSToggleButton btnTgl = (POSToggleButton)e.getSource();
            if (btnTgl.isSelected()) {
                Ticket ticket = (Ticket)btnTgl.getClientProperty("ticket");
                if (this.otherTicketView.getTicket() != null && this.otherTicketView.getTicket().equals(ticket)) {
                    btnTgl.setSelected(false);
                    this.currentSelectedButton.setSelected(true);
                    return;
                }
                this.currentSelectedButton = (POSToggleButton)e.getSource();
                this.setCurrentTicket(ticket);
            }
        }
        catch (Exception e2) {
            POSMessageDialog.showError(this, POSConstants.ERROR_MESSAGE, e2);
        }
    }

    public void setCurrentTicket(Ticket ticket) {
        this.ticket = ticket;
        this.ticketViewerTable.setTicket(ticket);
        this.updateView();
    }

    public List<Ticket> getTickets() {
        ArrayList<Ticket> tickets = new ArrayList<Ticket>();
        for (POSToggleButton posToggleButton : this.addedButtonList) {
            tickets.add((Ticket)posToggleButton.getClientProperty("ticket"));
        }
        return tickets;
    }

    public static enum ORIENTATION {
        LEFT,
        RIGHT;

    }
}

