/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views.order;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.model.SubOrderType;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.swing.POSToggleButton;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.QwertyKeyPad;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public class ForHereToGoSelectionDialog
extends POSDialog {
    private String selectedOrderType;
    private PosButton btnForHere;
    private POSToggleButton btnToGo;
    private FixedLengthTextField tfPickupTime;

    public ForHereToGoSelectionDialog() throws HeadlessException {
        this.initializeComponent();
    }

    private void initializeComponent() {
        this.setTitle(Messages.getString("OrderTypeSelectionDialog.0"));
        this.setResizable(false);
        this.setLayout(new BorderLayout(5, 5));
        JPanel orderTypePanel = new JPanel(new GridLayout(1, 0, 10, 10));
        orderTypePanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.btnForHere = new PosButton(SubOrderType.FOR_HERE.getDisplayString());
        this.btnForHere.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ForHereToGoSelectionDialog.this.selectedOrderType = SubOrderType.FOR_HERE.getName();
                ForHereToGoSelectionDialog.this.setCanceled(false);
                ForHereToGoSelectionDialog.this.dispose();
            }
        });
        orderTypePanel.add(this.btnForHere);
        this.btnToGo = new POSToggleButton(SubOrderType.TO_GO.getDisplayString());
        this.btnToGo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ForHereToGoSelectionDialog.this.selectedOrderType = SubOrderType.TO_GO.getName();
                ForHereToGoSelectionDialog.this.setCanceled(false);
            }
        });
        orderTypePanel.add(this.btnToGo);
        PosButton btnOk = new PosButton(Messages.getString("ForHereToGoSelectionDialog.0"));
        PosButton btnCancel = new PosButton(POSConstants.CANCEL_BUTTON_TEXT);
        btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ForHereToGoSelectionDialog.this.setCanceled(true);
                ForHereToGoSelectionDialog.this.dispose();
            }
        });
        JPanel timePanel = new JPanel();
        JLabel lblPickupTime = new JLabel(Messages.getString("ForHereToGoSelectionDialog.1"));
        this.tfPickupTime = new FixedLengthTextField(20, 20);
        timePanel.add(lblPickupTime);
        timePanel.add(this.tfPickupTime);
        btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (StringUtils.isEmpty((String)ForHereToGoSelectionDialog.this.selectedOrderType)) {
                    POSMessageDialog.showError(Messages.getString("ForHereToGoSelectionDialog.2"));
                    return;
                }
                ForHereToGoSelectionDialog.this.dispose();
            }
        });
        JPanel actionPanel = new JPanel((LayoutManager)new MigLayout("fill,hidemode 3", "", "[]15[]"));
        QwertyKeyPad qwertyKeyPad = new QwertyKeyPad();
        JPanel qwertyKeyPadPanel = new JPanel();
        qwertyKeyPadPanel.add((Component)((Object)qwertyKeyPad));
        actionPanel.add((Component)timePanel, "right,span 2,wrap");
        actionPanel.add((Component)((Object)qwertyKeyPad), "growx, gaptop 5, span 2,wrap");
        actionPanel.add((Component)btnOk, "growx,split 2");
        actionPanel.add((Component)btnCancel, "growx");
        this.add(orderTypePanel);
        this.add((Component)actionPanel, "South");
        this.setSize(PosUIManager.getSize(800, 500));
    }

    public String getSelectedOrderType() {
        return this.selectedOrderType;
    }

    public String getPickupTime() {
        return this.tfPickupTime.getText();
    }
}

