/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views.order;

import com.floreantpos.POSConstants;
import com.floreantpos.model.MenuCategory;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.dao.MenuGroupDAO;
import com.floreantpos.swing.HorizontalSimpleScrollPane;
import com.floreantpos.swing.HorizontalTouchScrollPanel;
import com.floreantpos.swing.MessageDialog;
import com.floreantpos.swing.POSToggleButton;
import com.floreantpos.swing.PaginatedListModel;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.views.order.SelectionView;
import com.floreantpos.ui.views.order.actions.GroupSelectionListener;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class GroupView
extends SelectionView {
    private Vector<GroupSelectionListener> listenerList = new Vector();
    private MenuCategory menuCategory;
    public static final String VIEW_NAME = "GROUP_VIEW";
    private ButtonGroup buttonGroup;

    public GroupView() {
        super(POSConstants.GROUPS, new GridLayout(1, 0, 5, 5), PosUIManager.getSize(100), PosUIManager.getSize(50));
        this.dataModel = new PaginatedListModel(4);
        this.remove(this.actionButtonPanel);
        this.btnPrev.setText("<<");
        this.btnNext.setText(">>");
        this.add((Component)this.btnPrev, "West");
        this.add((Component)this.btnNext, "East");
    }

    public MenuCategory getMenuCategory() {
        return this.menuCategory;
    }

    public void setMenuCategory(MenuCategory menuCategory) {
        this.menuCategory = menuCategory;
        this.reset();
        if (menuCategory == null) {
            this.fireGroupSelected(null);
            return;
        }
        try {
            this.dataModel.setCurrentRowIndex(0);
            MenuGroupDAO.getInstance().loadGroupsForGroupView(this.getOrderType(), menuCategory, this.dataModel);
            this.setDataModel(this.dataModel);
            if (this.dataModel.getSize() > 0) {
                MenuGroup menuGroup = (MenuGroup)this.dataModel.getElementAt(0);
                GroupButton groupButton = (GroupButton)this.getFirstItemButton();
                if (groupButton != null) {
                    groupButton.setSelected(true);
                    this.fireGroupSelected(menuGroup);
                }
            } else {
                this.fireGroupSelected(null);
            }
        }
        catch (Exception e) {
            MessageDialog.showError(e);
        }
    }

    @Override
    protected void renderItems() {
        this.buttonGroup = new ButtonGroup();
        super.renderItems();
    }

    @Override
    protected int getFitableButtonCount() {
        Dimension size = this.selectionButtonsPanel.getSize();
        Dimension itemButtonSize = this.getButtonSize();
        int horizontalButtonCount = this.getButtonCount(size.width, itemButtonSize.width);
        return horizontalButtonCount;
    }

    public void addGroupSelectionListener(GroupSelectionListener listener) {
        this.listenerList.add(listener);
    }

    public void removeGroupSelectionListener(GroupSelectionListener listener) {
        this.listenerList.remove(listener);
    }

    private void fireGroupSelected(MenuGroup foodGroup) {
        for (GroupSelectionListener listener : this.listenerList) {
            listener.groupSelected(foodGroup);
        }
    }

    @Override
    protected AbstractButton createItemButton(Object item) {
        MenuGroup menuGroup = (MenuGroup)item;
        GroupButton button = new GroupButton(menuGroup);
        this.buttonGroup.add(button);
        return button;
    }

    @Override
    protected void scrollDown() {
        this.dataModel.setCurrentRowIndex(this.dataModel.getNextRowIndex());
        MenuGroupDAO.getInstance().loadGroupsForGroupView(this.getOrderType(), this.menuCategory, this.dataModel);
        this.setDataModel(this.dataModel);
    }

    @Override
    protected void scrollUp() {
        this.dataModel.setCurrentRowIndex(this.dataModel.getPreviousRowIndex());
        MenuGroupDAO.getInstance().loadGroupsForGroupView(this.getOrderType(), this.menuCategory, this.dataModel);
        this.setDataModel(this.dataModel);
    }

    @Override
    protected JPanel createButtonPanel() {
        return new HorizontalTouchScrollPanel();
    }

    @Override
    protected JScrollPane createScrollContainer() {
        return new HorizontalSimpleScrollPane();
    }

    private class GroupButton
    extends POSToggleButton
    implements ActionListener {
        MenuGroup menuGroup;

        GroupButton(MenuGroup foodGroup) {
            this.menuGroup = foodGroup;
            this.setText("<html><body><center>" + foodGroup.getDisplayName() + "</center></body></html>");
            if (this.menuGroup.getButtonColorCode() != null) {
                this.setBackground(this.menuGroup.getButtonColor());
            }
            if (this.menuGroup.getTextColorCode() != null) {
                this.setForeground(this.menuGroup.getTextColor());
            }
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GroupView.this.fireGroupSelected(this.menuGroup);
        }
    }
}

