/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views.order;

import com.floreantpos.IconFactory;
import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.actions.ForHereToGoAction;
import com.floreantpos.actions.MemberPreferenceAction;
import com.floreantpos.actions.SeatSelectionAction;
import com.floreantpos.actions.SettleTicketAction;
import com.floreantpos.actions.TableSelectionAction;
import com.floreantpos.actions.VoidTicketAction;
import com.floreantpos.bo.actions.TicketNoteEntryAction;
import com.floreantpos.config.TerminalConfig;
import com.floreantpos.customer.CustomerSelectorDialog;
import com.floreantpos.customer.CustomerSelectorFactory;
import com.floreantpos.customer.clubmember.MemberHistoryDialog;
import com.floreantpos.extension.ExtensionManager;
import com.floreantpos.extension.OrderServiceExtension;
import com.floreantpos.extension.OrderServiceFactory;
import com.floreantpos.main.Application;
import com.floreantpos.model.Course;
import com.floreantpos.model.CreditBookType;
import com.floreantpos.model.Customer;
import com.floreantpos.model.ITicketItem;
import com.floreantpos.model.ImageResource;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.PosPrinters;
import com.floreantpos.model.SalesArea;
import com.floreantpos.model.ShopSeat;
import com.floreantpos.model.SubOrderType;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemSeat;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.ActionHistoryDAO;
import com.floreantpos.model.dao.CreditBookTypeDAO;
import com.floreantpos.model.dao.CustomerDAO;
import com.floreantpos.model.dao.ImageResourceDAO;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.model.util.ColorPref;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.swing.ColoredCircleRenderer;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.RefreshableView;
import com.floreantpos.ui.dialog.MiscTicketItemDialog;
import com.floreantpos.ui.dialog.NumberSelectionDialog2;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.dialog.PasswordEntryDialog;
import com.floreantpos.ui.dialog.ReorderDialog;
import com.floreantpos.ui.dialog.SalesAreaSelectionDialog;
import com.floreantpos.ui.forms.MemberUnUsedMinSpendInfoDialog;
import com.floreantpos.ui.order.CourseOrganizeDialog;
import com.floreantpos.ui.order.SeatOrganizeDialog;
import com.floreantpos.ui.views.order.CategoryView;
import com.floreantpos.ui.views.order.GroupView;
import com.floreantpos.ui.views.order.MenuItemView;
import com.floreantpos.ui.views.order.OrderController;
import com.floreantpos.ui.views.order.RootView;
import com.floreantpos.ui.views.order.TicketView;
import com.floreantpos.ui.views.order.ViewPanel;
import com.floreantpos.ui.views.order.actions.DataChangeListener;
import com.floreantpos.ui.views.order.actions.OrderListener;
import com.floreantpos.ui.views.order.actions.TicketEditListener;
import com.floreantpos.ui.views.payment.PaymentListener;
import com.floreantpos.ui.views.payment.PaymentView;
import com.floreantpos.ui.views.payment.SettleTicketProcessor;
import com.floreantpos.ui.views.payment.creditbook.CreditBookTypesSelectionDialog;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.DrawerUtil;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import com.foretees.salesforce.sync.SFException;
import com.foretees.salesforce.sync.SFUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.json.JsonArray;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;
import org.hibernate.StaleStateException;

public class OrderView
extends ViewPanel
implements PaymentListener,
TicketEditListener,
RefreshableView,
DataChangeListener,
OrderListener {
    private HashMap<String, JComponent> views = new HashMap();
    private SettleTicketProcessor ticketProcessor = new SettleTicketProcessor(Application.getCurrentUser(), this);
    public static final String VIEW_NAME = "ORDER_VIEW";
    private static OrderView instance;
    private Ticket currentTicket;
    private CategoryView categoryView = new CategoryView();
    private GroupView groupView = new GroupView();
    private MenuItemView itemView = new MenuItemView();
    private TicketView ticketView = new TicketView();
    private TransparentPanel midContainer = new TransparentPanel(new BorderLayout(5, 5));
    private JPanel ticketViewContainer = new JPanel(new BorderLayout());
    private JPanel ticketSummaryView = this.createTicketSummeryPanel();
    private JPanel memberPanel = this.createMemberPanel();
    private OrderController orderController = new OrderController(this);
    private JPanel actionButtonPanel = new JPanel((LayoutManager)new MigLayout("fill, ins 2, hidemode 3", "fill", "fill"));
    private PosButton btnForHereToGo = new PosButton(POSConstants.FOR_HERE_TO_GO_BUTTON_TEXT);
    private PosButton btnHold = new PosButton(POSConstants.HOLD_BUTTON_TEXT);
    private PosButton btnDone = new PosButton(POSConstants.SAVE_BUTTON_TEXT);
    private PosButton btnSend = new PosButton(POSConstants.SEND_TO_KITCHEN);
    private PosButton btnCancel = new PosButton(POSConstants.CANCEL_BUTTON_TEXT);
    private PosButton btnGuestNo = new PosButton(POSConstants.GUEST_NO_BUTTON_TEXT);
    private PosButton btnSeatNo = new PosButton(Messages.getString("OrderView.3"));
    private PosButton btnMisc = new PosButton(POSConstants.MISC_BUTTON_TEXT);
    private PosButton btnOrderType = new PosButton(POSConstants.ORDER_TYPE_BUTTON_TEXT);
    private PosButton btnTableNumber = new PosButton(POSConstants.TABLE_NO_BUTTON_TEXT);
    private PosButton btnReorder = new PosButton(Messages.getString("OrderView.24"));
    private PosButton btnOrganizeCourse = new PosButton("<html><center>" + POSConstants.ORGANIZE_COURSE + "</center></html>");
    private PosButton btnOrganizeSeats = new PosButton("<html><center>" + Messages.getString("OrderView.45") + "</center></html>");
    private PosButton btnNote = new PosButton(Messages.getString("OrderView.36"));
    private PosButton btnCustomerInRetail = new PosButton(POSConstants.CUSTOMER_SELECTION_BUTTON_TEXT);
    private PosButton btnDeliveryInfo = new PosButton(Messages.getString("OrderView.28"));
    private PosButton btnSalesArea = new PosButton(Messages.getString("OrderView.29"));
    private SeatSelectionAction seatAction = new SeatSelectionAction();
    private PosButton btnDiscount = new PosButton(Messages.getString("TicketView.43"));
    private boolean _86Mode;
    private boolean returnMode;
    private JTextField tfSubtotal;
    private JTextField tfDiscount;
    private JTextField tfDeliveryCharge;
    private JTextField tfServiceCharge;
    private JTextField tfTax;
    private JTextField tfGratuity;
    private JTextField tfTotal;
    private PaymentView paymentView;
    private PosButton btnCustomer;
    private JLabel lblImage;
    private ColoredCircleRenderer coloredCircleRenderer;

    private OrderView() {
        this.initComponents();
        this.ticketView.addOrderListener(this);
        this.ticketView.getTicketViewerTable().addTicketUpdateListener(this);
        this.ticketView.getTicketViewerTable().addTicketUpdateListener(this.itemView);
        this.orderController.addTicketUpdateListener(this);
        this.ticketProcessor.addPaymentListener(this);
    }

    public void addView(String viewName, JComponent view) {
        JComponent oldView = this.views.get(viewName);
        if (oldView != null) {
            return;
        }
        this.midContainer.add((Component)view, viewName);
    }

    private void initComponents() {
        this.setOpaque(false);
        this.setLayout(new BorderLayout(2, 1));
        JPanel ticketViewInnerCon = new JPanel(new BorderLayout());
        ticketViewInnerCon.add(this.ticketView);
        ticketViewInnerCon.add((Component)this.ticketSummaryView, "South");
        this.ticketViewContainer.add(ticketViewInnerCon);
        this.midContainer.setOpaque(false);
        this.midContainer.setBorder(null);
        this.midContainer.add((Component)this.groupView, "North");
        this.midContainer.add(this.itemView);
        this.addActionButtonPanel();
        this.btnOrderType.setVisible(false);
        this.showView("VIEW_EMPTY");
    }

    private void handleTicketItemSelection() {
        ITicketItem selectedItem = this.ticketView.getTicketViewerTable().getSelected();
        if (selectedItem == null) {
            this.btnDiscount.setEnabled(false);
        } else {
            this.btnDiscount.setEnabled(selectedItem.canAddDiscount());
        }
    }

    private void addActionButtonPanel() {
        this.ticketView.getTicketViewerTable().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    OrderView.this.handleTicketItemSelection();
                }
            }
        });
        this.btnSalesArea.addActionListener(e -> this.doAddSalesArea());
        this.btnDone.addActionListener(e -> this.doFinish());
        this.btnCancel.addActionListener(e -> this.doCancel());
        this.btnSend.addActionListener(e -> this.doSendTicketToKitchen());
        this.btnReorder.addActionListener(e -> this.doReorder());
        this.btnOrganizeCourse.addActionListener(e -> this.doOrganizeTicketItemsByCourse());
        this.btnOrganizeSeats.addActionListener(e -> this.doOrganizeSeats());
        this.btnOrderType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
            }
        });
        this.btnCustomerInRetail.addActionListener(e -> this.doAddEditCustomer(true));
        this.btnNote.addActionListener(new TicketNoteEntryAction(this));
        this.btnMisc.addActionListener(evt -> this.doInsertMisc(evt));
        this.btnGuestNo.addActionListener(e -> this.btnCustomerNumberActionPerformed());
        this.seatAction.setSource(this.btnSeatNo);
        this.btnSeatNo.setAction(this.seatAction);
        this.btnTableNumber.addActionListener(new TableSelectionAction(this));
        this.btnForHereToGo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new ForHereToGoAction(OrderView.this.currentTicket).execute();
                OrderView.this.updateView();
            }
        });
        this.btnHold.addActionListener(e -> this.doHoldOrder());
        this.btnDiscount.addActionListener(e -> this.addDiscount());
        this.btnDeliveryInfo.addActionListener(e -> this.doShowDeliveryDialog());
        this.actionButtonPanel.add(this.btnOrderType);
        this.actionButtonPanel.add(this.btnCustomerInRetail);
        this.actionButtonPanel.add(this.btnNote);
        this.actionButtonPanel.add(this.btnDeliveryInfo);
        this.actionButtonPanel.add(this.btnTableNumber);
        this.actionButtonPanel.add(this.btnGuestNo);
        this.actionButtonPanel.add(this.btnOrganizeSeats);
        this.actionButtonPanel.add(this.btnSalesArea);
        this.actionButtonPanel.add(this.btnOrganizeCourse);
        this.actionButtonPanel.add(this.btnForHereToGo);
        this.actionButtonPanel.add(this.btnHold);
        this.actionButtonPanel.add(this.btnSend);
        this.actionButtonPanel.add(this.btnReorder);
        this.actionButtonPanel.add(this.btnCancel);
        this.actionButtonPanel.add(this.btnDone);
        this.btnDeliveryInfo.setVisible(false);
        this.btnCustomerInRetail.setVisible(false);
    }

    protected boolean doCheckForHereToGoOrderType() {
        SubOrderType subOrderType;
        OrderType orderType;
        OrderType orderType2 = orderType = this.currentTicket == null ? null : this.currentTicket.getOrderType();
        if (orderType != null && orderType.isHasForHereAndToGo().booleanValue() && (subOrderType = this.currentTicket.getSubOrderType()) == null) {
            ForHereToGoAction forHereToGoAction = new ForHereToGoAction(this.currentTicket);
            forHereToGoAction.execute();
            return forHereToGoAction.isPerformed();
        }
        return true;
    }

    private void doOrganizeTicketItemsByCourse() {
        if (DataProvider.get().getCourses().isEmpty()) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("OrderView.33"));
            return;
        }
        CourseOrganizeDialog dialog = new CourseOrganizeDialog(this.currentTicket);
        dialog.openFullScreen();
        if (dialog.isCanceled()) {
            return;
        }
        this.ticketView.getTicketViewerTable().updateView();
    }

    private void doOrganizeSeats() {
        Ticket ticket = this.ticketView.getTicket();
        Ticket cloneTicket = Ticket.clone(ticket);
        SeatOrganizeDialog dialog = new SeatOrganizeDialog(cloneTicket);
        dialog.openFullScreen();
        if (dialog.isCanceled()) {
            return;
        }
        HashMap<TicketItemSeat, ArrayList<TicketItem>> ticketItemsMap = new HashMap<TicketItemSeat, ArrayList<TicketItem>>();
        HashMap<String, TicketItem> seatItemsMap = new HashMap<String, TicketItem>();
        ArrayList<TicketItem> sharedItems = new ArrayList<TicketItem>();
        ArrayList<TicketItem> returnItemList = new ArrayList<TicketItem>();
        for (TicketItem ticketItem : cloneTicket.getTicketItems()) {
            if (!ticketItem.isTreatAsSeat().booleanValue()) {
                if (ticketItem.isReturned() || ticketItem.isVoided().booleanValue()) {
                    returnItemList.add(ticketItem);
                    continue;
                }
                if (ticketItem.getSeat() != null) {
                    ArrayList<TicketItem> list = (ArrayList<TicketItem>)ticketItemsMap.get(ticketItem.getSeat());
                    if (list == null) {
                        list = new ArrayList<TicketItem>();
                        ticketItemsMap.put(ticketItem.getSeat(), list);
                    }
                    list.add(ticketItem);
                    continue;
                }
                sharedItems.add(ticketItem);
                continue;
            }
            if (!ticketItem.isTreatAsSeat().booleanValue() || ticketItem.getSeat() == null) continue;
            seatItemsMap.put(ticketItem.getSeat().getSeatId(), ticketItem);
        }
        ArrayList<TicketItem> items = new ArrayList<TicketItem>();
        items.addAll(sharedItems);
        Set keySet = ticketItemsMap.keySet();
        ArrayList seatList = new ArrayList(keySet);
        Collections.sort(seatList, (o1, o2) -> o1.getSeatNumber().compareTo(o2.getSeatNumber()));
        for (TicketItemSeat ticketItemSeat : seatList) {
            TicketItem seatItem = (TicketItem)seatItemsMap.get(ticketItemSeat.getSeatId());
            List itemList = (List)ticketItemsMap.get(ticketItemSeat);
            Collections.sort(itemList, new Comparator<TicketItem>(){

                @Override
                public int compare(TicketItem o1, TicketItem o2) {
                    Course course1 = DataProvider.get().getCourse(o1.getCourseId());
                    Course course2 = DataProvider.get().getCourse(o2.getCourseId());
                    if (course1 == null || course2 == null) {
                        return 0;
                    }
                    return course1.getSortOrder().compareTo(course2.getSortOrder());
                }
            });
            if (seatItem == null) {
                seatItem = new TicketItem();
                seatItem.setName(ticketItemSeat.getShopSeat().getSeatNumberWithTableName(cloneTicket));
                seatItem.setShouldPrintToKitchen(true);
                seatItem.setTreatAsSeat(true);
                seatItem.setTicket(cloneTicket);
            }
            if (ticketItemSeat.getMember() == null) {
                ticketItemSeat.setMember(cloneTicket.getCustomer());
            }
            seatItem.setSeat(ticketItemSeat);
            seatItem.setSeatNumber(ticketItemSeat.getSeatNumber());
            items.add(seatItem);
            items.addAll(itemList);
        }
        if (dialog.isAddToOrder()) {
            ShopSeat seat = dialog.getSeat();
            TicketItem seatItem = new TicketItem();
            if (seat == null) {
                seatItem.setName(Messages.getString("SeatSelectionAction.3"));
                seatItem.setSeat(null);
            } else {
                seatItem.setName(seat.getSeatNumberWithTableName(cloneTicket));
                TicketItemSeat ticketItemSeat = seat.convertTicketItemSeat();
                ticketItemSeat.setMember(seat.getMember() != null ? seat.getMember() : cloneTicket.getCustomer());
                seatItem.setSeat(ticketItemSeat);
                seatItem.setSeatNumber(ticketItemSeat.getSeatNumber());
            }
            seatItem.setShouldPrintToKitchen(true);
            seatItem.setTreatAsSeat(true);
            seatItem.setTicket(cloneTicket);
            items.add(seatItem);
        }
        items.addAll(returnItemList);
        cloneTicket.setTicketItems(items);
        this.currentTicket = cloneTicket;
        this.ticketView.setTicket(this.currentTicket);
    }

    private JPanel createTicketSummeryPanel() {
        JLabel lblSubtotal = new JLabel();
        lblSubtotal.setHorizontalAlignment(4);
        lblSubtotal.setText(POSConstants.SUBTOTAL + ": " + CurrencyUtil.getCurrencySymbol());
        this.tfSubtotal = new JTextField(10);
        this.tfSubtotal.setHorizontalAlignment(11);
        this.tfSubtotal.setEditable(false);
        JLabel lblDiscount = new JLabel();
        lblDiscount.setHorizontalAlignment(4);
        lblDiscount.setText(Messages.getString("TicketView.9") + " " + CurrencyUtil.getCurrencySymbol());
        this.tfDiscount = new JTextField(10);
        this.tfDiscount.setHorizontalAlignment(11);
        this.tfDiscount.setEditable(false);
        JLabel lblDeliveryCharge = new JLabel();
        lblDeliveryCharge.setHorizontalAlignment(4);
        lblDeliveryCharge.setText(Messages.getString("OrderView.34") + " " + CurrencyUtil.getCurrencySymbol());
        this.tfDeliveryCharge = new JTextField(10);
        this.tfDeliveryCharge.setHorizontalAlignment(11);
        this.tfDeliveryCharge.setEditable(false);
        JLabel lblServiceCharge = new JLabel();
        lblServiceCharge.setHorizontalAlignment(4);
        lblServiceCharge.setText(Messages.getString("OrderView.35") + " " + CurrencyUtil.getCurrencySymbol());
        this.tfServiceCharge = new JTextField(10);
        this.tfServiceCharge.setHorizontalAlignment(11);
        this.tfServiceCharge.setEditable(false);
        JLabel lblTax = new JLabel();
        lblTax.setHorizontalAlignment(4);
        lblTax.setText(POSConstants.TAX + ": " + CurrencyUtil.getCurrencySymbol());
        this.tfTax = new JTextField(10);
        this.tfTax.setEditable(false);
        this.tfTax.setHorizontalAlignment(11);
        JLabel lblGratuity = new JLabel();
        lblGratuity.setHorizontalAlignment(4);
        lblGratuity.setText(Messages.getString("SettleTicketDialog.5") + ": " + CurrencyUtil.getCurrencySymbol());
        this.tfGratuity = new JTextField(10);
        this.tfGratuity.setEditable(false);
        this.tfGratuity.setHorizontalAlignment(11);
        JLabel lblTotal = new JLabel();
        lblTotal.setFont(lblTotal.getFont().deriveFont(1, PosUIManager.getFontSize(18)));
        lblTotal.setHorizontalAlignment(4);
        lblTotal.setText(POSConstants.TOTAL + ": " + CurrencyUtil.getCurrencySymbol());
        this.tfTotal = new JTextField(10);
        this.tfTotal.setFont(this.tfTotal.getFont().deriveFont(1, PosUIManager.getFontSize(18)));
        this.tfTotal.setHorizontalAlignment(11);
        this.tfTotal.setEditable(false);
        TransparentPanel ticketAmountPanel = new TransparentPanel((LayoutManager)new MigLayout("hidemode 3,ins 2 2 3 2,alignx trailing,fill", "[grow]2[]", ""));
        ticketAmountPanel.add((Component)lblSubtotal, "growx,aligny center");
        ticketAmountPanel.add((Component)this.tfSubtotal, "growx,aligny center");
        ticketAmountPanel.add((Component)lblDiscount, "newline,growx,aligny center");
        ticketAmountPanel.add((Component)this.tfDiscount, "growx,aligny center");
        ticketAmountPanel.add((Component)lblServiceCharge, "newline,growx,aligny center");
        ticketAmountPanel.add((Component)this.tfServiceCharge, "growx,aligny center");
        ticketAmountPanel.add((Component)lblTax, "newline,growx,aligny center");
        ticketAmountPanel.add((Component)this.tfTax, "growx,aligny center");
        ticketAmountPanel.add((Component)lblGratuity, "newline,growx,aligny center");
        ticketAmountPanel.add((Component)this.tfGratuity, "growx,aligny center");
        ticketAmountPanel.add((Component)lblTotal, "newline,growx,aligny center");
        ticketAmountPanel.add((Component)this.tfTotal, "growx,aligny center");
        return ticketAmountPanel;
    }

    public void updateTicketSummeryView() {
        Ticket ticket = this.ticketView.getTicket();
        if (ticket == null) {
            this.tfSubtotal.setText("");
            this.tfDiscount.setText("");
            this.tfDeliveryCharge.setText("");
            this.tfServiceCharge.setText("");
            this.tfTax.setText("");
            this.tfTotal.setText("");
            this.tfGratuity.setText("");
            return;
        }
        this.tfSubtotal.setText(NumberUtil.formatNumber(ticket.getSubtotalAmount()));
        this.tfDiscount.setText(NumberUtil.formatNumber(ticket.getDiscountAmount()));
        this.tfDeliveryCharge.setText(NumberUtil.formatNumber(ticket.getDeliveryCharge()));
        this.tfServiceCharge.setText(NumberUtil.formatNumber(ticket.getServiceCharge()));
        if (Application.getInstance().isPriceIncludesTax()) {
            this.tfTax.setText(Messages.getString("TicketView.35"));
        } else {
            this.tfTax.setText(NumberUtil.formatNumber(ticket.getTaxAmount()));
        }
        if (ticket.getGratuity() != null) {
            this.tfGratuity.setText(NumberUtil.formatNumber(ticket.getGratuity().getAmount()));
        } else {
            this.tfGratuity.setText("0.00");
        }
        this.tfTotal.setText(NumberUtil.formatNumber(ticket.getTotalAmountWithTips()));
    }

    protected void doShowDeliveryDialog() {
        try {
            Customer customer = CustomerDAO.getInstance().findById(this.currentTicket.getCustomerId());
            OrderServiceFactory.getOrderService().showDeliveryInfo(this.currentTicket, this.currentTicket.getOrderType(), customer);
        }
        catch (StaleStateException x) {
            POSMessageDialog.showMessageDialogWithReloadButton(POSUtil.getFocusedWindow(), this);
        }
        catch (PosException x) {
            POSMessageDialog.showError(x.getMessage());
        }
        catch (Exception x) {
            POSMessageDialog.showError(Application.getPosWindow(), POSConstants.ERROR_MESSAGE, x);
        }
    }

    protected void doAddSalesArea() {
        try {
            SalesAreaSelectionDialog dialog = new SalesAreaSelectionDialog();
            dialog.open();
            if (dialog.isCanceled()) {
                return;
            }
            SalesArea selectedSalesArea = dialog.getSelectedSalesArea();
            this.setFocusable(true);
            this.currentTicket.setSalesArea(selectedSalesArea);
            this.currentTicket.setSalesAreaId(selectedSalesArea.getId());
            this.btnSalesArea.setText("<html><center>Sales area<br/>" + selectedSalesArea.getName() + "</center></html>");
            ActionHistoryDAO.addSalesAreaAddedActionHistory(this.currentTicket, selectedSalesArea);
        }
        catch (StaleStateException x) {
            POSMessageDialog.showMessageDialogWithReloadButton(POSUtil.getFocusedWindow(), this);
        }
        catch (PosException x) {
            POSMessageDialog.showError(x.getMessage());
        }
        catch (Exception x) {
            POSMessageDialog.showError(Application.getPosWindow(), POSConstants.ERROR_MESSAGE, x);
        }
    }

    protected void btnCustomerNumberActionPerformed() {
        try {
            Ticket thisTicket = this.currentTicket;
            int guestNumber = thisTicket.getNumberOfGuests();
            NumberSelectionDialog2 dialog = new NumberSelectionDialog2(5);
            dialog.setTitle(POSConstants.NUMBER_OF_GUESTS);
            dialog.setValue(guestNumber);
            dialog.pack();
            dialog.open();
            if (dialog.isCanceled()) {
                return;
            }
            guestNumber = (int)dialog.getValue();
            if (guestNumber == 0) {
                POSMessageDialog.showError(Application.getPosWindow(), POSConstants.GUEST_NUMBER_CANNOT_BE_0);
                return;
            }
            thisTicket.setNumberOfGuests(guestNumber);
            this.updateView();
        }
        catch (StaleStateException x) {
            POSMessageDialog.showMessageDialogWithReloadButton(POSUtil.getFocusedWindow(), this);
        }
        catch (PosException x) {
            POSMessageDialog.showError(x.getMessage());
        }
        catch (Exception x) {
            POSMessageDialog.showError(Application.getPosWindow(), POSConstants.ERROR_MESSAGE, x);
        }
    }

    protected void doInsertMisc(ActionEvent evt) {
        try {
            MiscTicketItemDialog dialog = new MiscTicketItemDialog();
            dialog.setOrderType(this.currentTicket.getOrderType());
            dialog.pack();
            dialog.open();
            if (!dialog.isCanceled()) {
                TicketItem ticketItem = dialog.getTicketItem();
                ticketItem.setTicket(this.currentTicket);
                ticketItem.calculatePrice();
                this.ticketView.addTicketItem(ticketItem);
            }
        }
        catch (StaleStateException x) {
            POSMessageDialog.showMessageDialogWithReloadButton(POSUtil.getFocusedWindow(), this);
        }
        catch (PosException x) {
            POSMessageDialog.showError(x.getMessage());
        }
        catch (Exception x) {
            POSMessageDialog.showError(Application.getPosWindow(), POSConstants.ERROR_MESSAGE, x);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doAddEditCustomer(boolean isRetailOrder) {
        try {
            DataProvider.get().setTicketToBeCreated(this.currentTicket);
            if (this.currentTicket.isPaid().booleanValue()) {
                POSMessageDialog.showMessage(Application.getPosWindow(), Messages.getString("CustomerSelectionAction.0"));
                return;
            }
            CustomerSelectorDialog dialog = CustomerSelectorFactory.createCustomerSelectorDialog(this.currentTicket.getOrderType());
            dialog.setCreateNewTicket(false);
            if (this.currentTicket != null) {
                dialog.setTicket(this.currentTicket);
            }
            dialog.openUndecoratedFullScreen();
            if (!dialog.isCanceled()) {
                Customer selectedCustomer = dialog.getSelectedCustomer();
                this.currentTicket.setCustomer(selectedCustomer);
                String labelCustomer = this.doGenarateCustomerLabel(selectedCustomer);
                if (isRetailOrder) {
                    if (selectedCustomer != null) {
                        this.btnCustomerInRetail.setText(labelCustomer);
                    } else {
                        this.btnCustomerInRetail.setText(POSConstants.CUSTOMER_SELECTION_BUTTON_TEXT);
                    }
                } else {
                    if (selectedCustomer != null) {
                        this.btnCustomer.setText(labelCustomer);
                    } else {
                        this.btnCustomer.setText(POSConstants.CUSTOMER_SELECTION_BUTTON_TEXT);
                    }
                    this.setMemberPicture(selectedCustomer);
                }
                this.ticketView.updateView();
            }
        }
        catch (StaleStateException x) {
            POSMessageDialog.showMessageDialogWithReloadButton(POSUtil.getFocusedWindow(), this);
        }
        catch (PosException x) {
            POSMessageDialog.showError(x.getMessage());
        }
        catch (Exception x) {
            POSMessageDialog.showError(Application.getPosWindow(), POSConstants.ERROR_MESSAGE, x);
        }
        finally {
            DataProvider.get().setTicketToBeCreated(null);
        }
    }

    private String doGenarateCustomerLabel(Customer selectedCustomer) {
        String labelCustomer = "";
        if (selectedCustomer != null) {
            labelCustomer = "<html><center>" + selectedCustomer.getName();
            if (selectedCustomer.getMemberShipType() != null) {
                labelCustomer = labelCustomer + "<br/>" + selectedCustomer.getMemberShipType();
            }
            labelCustomer = labelCustomer + "</center></html>";
        }
        return labelCustomer;
    }

    private void setMemberPicture(Customer member) {
        this.lblImage.setIcon(IconFactory.getIcon("/images/", "generic-profile-pic-v2.png"));
        if (member != null && member.getImageId() != null) {
            ImageResource imageResource = ImageResourceDAO.getInstance().findById(member.getImageId());
            if (imageResource != null) {
                this.lblImage.setIcon(imageResource.getScaledImage(170, 170));
            } else {
                this.lblImage.setIcon(IconFactory.getIcon("/images/", "generic-profile-pic-v2.png"));
            }
        }
    }

    protected void addDiscount() {
        try {
            ITicketItem selectedObject = this.ticketView.getTicketViewerTable().getSelected();
            if (!(selectedObject instanceof TicketItem)) {
                POSMessageDialog.showError(Application.getPosWindow(), Messages.getString("TicketView.20"));
                return;
            }
        }
        catch (StaleStateException x) {
            POSMessageDialog.showMessageDialogWithReloadButton(POSUtil.getFocusedWindow(), this);
        }
        catch (PosException x) {
            POSMessageDialog.showError(x.getMessage());
        }
        catch (Exception x) {
            POSMessageDialog.showError(Application.getPosWindow(), POSConstants.ERROR_MESSAGE, x);
        }
    }

    public void updateView() {
        Terminal terminal = Application.getInstance().getTerminal();
        if (this.currentTicket != null) {
            OrderType orderType = this.currentTicket.getOrderType();
            this.btnForHereToGo.setVisible(orderType.isHasForHereAndToGo());
            if (orderType.isPrepaid().booleanValue()) {
                this.btnDone.setVisible(false);
            } else {
                this.btnDone.setVisible(true);
            }
            if (!orderType.isShouldPrintToKitchen().booleanValue()) {
                this.btnSend.setEnabled(false);
            } else {
                this.btnSend.setEnabled(true);
            }
            if (!orderType.isAllowSeatBasedOrder().booleanValue()) {
                this.btnSeatNo.setVisible(false);
            } else {
                this.btnSeatNo.setVisible(true);
            }
            if (orderType.isShowTableSelection().booleanValue() || orderType.isPropertyValueTrue("tableSelection.freeTextInput")) {
                this.btnGuestNo.setVisible(true);
                this.btnTableNumber.setVisible(true);
                if (orderType.isShowTableSelection().booleanValue()) {
                    this.btnTableNumber.setText("<html><center>" + Messages.getString("OrderView.23") + ": " + this.currentTicket.getTableNameOrNumberDisplay() + "</center><html/>");
                } else if (orderType.isPropertyValueTrue("tableSelection.freeTextInput")) {
                    this.btnTableNumber.setText("<html><center>" + Messages.getString("OrderView.23") + ": " + this.currentTicket.getFreeTextTableNameOrNumberDisplay() + "</center><html/>");
                }
                this.btnGuestNo.setText(Messages.getString("OrderView.27") + ": " + String.valueOf(this.currentTicket.getNumberOfGuests()));
            } else {
                this.btnGuestNo.setVisible(false);
                this.btnTableNumber.setVisible(false);
            }
            if (orderType.isEnableReorder().booleanValue()) {
                this.btnReorder.setVisible(true);
            } else {
                this.btnReorder.setVisible(false);
            }
            this.btnOrganizeCourse.setVisible(orderType.isEnableCourse());
            this.btnOrganizeSeats.setVisible(orderType.isShowTableSelection());
            OrderServiceExtension orderService = (OrderServiceExtension)ExtensionManager.getPlugin(OrderServiceExtension.class);
            if (orderService != null && orderType.isDelivery().booleanValue() && orderType.isRequiredCustomerData().booleanValue()) {
                this.btnDeliveryInfo.setVisible(true);
            }
            this.ticketView.updateView();
            if (orderType.isRetailOrder().booleanValue()) {
                this.updateTicketSummeryView();
                this.paymentView.setTicket(this.currentTicket);
                this.setHideButtonForRetailView();
                this.btnCustomerInRetail.setVisible(true);
            } else {
                this.btnCustomerInRetail.setVisible(false);
            }
            if (this.currentTicket.getId() == null) {
                if (orderType.getSalesArea() != null) {
                    this.currentTicket.setSalesArea(orderType.getSalesArea());
                } else if (DataProvider.get().getCurrentTerminal().getSalesArea() != null) {
                    this.currentTicket.setSalesArea(DataProvider.get().getCurrentTerminal().getSalesArea());
                }
            }
            if (this.currentTicket.getSalesArea() != null) {
                String salesAreaString = this.currentTicket.getSalesArea().toString();
                this.btnSalesArea.setText("<html><center>" + Messages.getString("OrderView.61") + "<br>" + salesAreaString + "</center><html/>");
            } else if (this.currentTicket.getId() != null) {
                this.btnSalesArea.setText(Messages.getString("OrderView.64"));
            } else {
                SalesArea salesArea = terminal.getSalesArea();
                if (salesArea != null) {
                    String salesAreaString = salesArea.toString();
                    this.btnSalesArea.setText("<html><center>" + Messages.getString("OrderView.30") + "<br>" + salesAreaString + "</center><html/>");
                } else {
                    this.btnSalesArea.setText(Messages.getString("OrderView.69"));
                }
                if (terminal.isFixedSalesArea().booleanValue()) {
                    this.btnSalesArea.setEnabled(false);
                } else {
                    this.btnSalesArea.setEnabled(true);
                }
            }
            Customer customer = this.currentTicket.getCustomer();
            if (customer != null) {
                String customerLabel = this.doGenarateCustomerLabel(customer);
                this.btnCustomerInRetail.setText(customerLabel);
                this.btnCustomer.setText(customerLabel);
            } else {
                this.btnCustomerInRetail.setText(POSConstants.CUSTOMER_SELECTION_BUTTON_TEXT);
                this.btnCustomer.setText(POSConstants.CUSTOMER_SELECTION_BUTTON_TEXT);
            }
            if (customer != null) {
                this.coloredCircleRenderer.setColorPref(customer.getColorPrefs());
            }
            this.setMemberPicture(customer);
        }
    }

    public void showView(String viewName) {
    }

    public CategoryView getCategoryView() {
        return this.categoryView;
    }

    public void setCategoryView(CategoryView categoryView) {
        this.categoryView = categoryView;
    }

    public GroupView getGroupView() {
        return this.groupView;
    }

    public void setGroupView(GroupView groupView) {
        this.groupView = groupView;
    }

    public MenuItemView getItemView() {
        return this.itemView;
    }

    public void setItemView(MenuItemView itemView) {
        this.itemView = itemView;
    }

    public TicketView getTicketView() {
        return this.ticketView;
    }

    public void setTicketView(TicketView ticketView) {
        this.ticketView = ticketView;
    }

    public OrderController getOrderController() {
        return this.orderController;
    }

    public Ticket getCurrentTicket() {
        return this.currentTicket;
    }

    private void changeViewForOrderType(OrderType orderType) {
        if (orderType.isRetailOrder().booleanValue()) {
            this.showRetailView();
        } else {
            this.showDefaultView();
        }
        this.revalidate();
        this.repaint();
    }

    private void setHideButtonForRetailView() {
        this.btnDone.setVisible(false);
        this.btnCancel.setVisible(false);
        this.btnDeliveryInfo.setVisible(false);
        this.btnDiscount.setVisible(false);
        this.btnGuestNo.setVisible(false);
        this.btnOrderType.setVisible(false);
        this.btnReorder.setVisible(false);
        this.btnSalesArea.setVisible(false);
        this.btnSeatNo.setVisible(false);
        this.btnTableNumber.setVisible(false);
        this.btnSend.setVisible(false);
        this.btnHold.setVisible(false);
    }

    private void setVisibleButtonForOrderView() {
        this.btnDone.setVisible(true);
        this.btnCancel.setVisible(true);
        this.btnDiscount.setVisible(true);
        this.btnGuestNo.setVisible(true);
        this.btnHold.setVisible(true);
        this.btnMisc.setVisible(true);
        this.btnSalesArea.setVisible(true);
        this.btnSeatNo.setVisible(true);
        this.btnSend.setVisible(true);
        this.btnTableNumber.setVisible(true);
        this.btnForHereToGo.setVisible(true);
    }

    private void showRetailView() {
        this.removeAll();
        if (this.paymentView == null) {
            this.paymentView = new PaymentView(this.ticketProcessor);
        }
        this.ticketView.showSettleButton(false);
        this.ticketSummaryView.setVisible(true);
        this.memberPanel.setVisible(false);
        this.ticketViewContainer.add((Component)this.actionButtonPanel, "South");
        this.add((Component)this.ticketViewContainer, "Center");
        this.add((Component)this.paymentView, "East");
    }

    private void showDefaultView() {
        this.removeAll();
        this.setVisibleButtonForOrderView();
        this.ticketSummaryView.setVisible(false);
        this.ticketView.showSettleButton(true);
        this.memberPanel.setVisible(true);
        this.midContainer.add((Component)this.actionButtonPanel, "South");
        this.ticketViewContainer.add((Component)this.memberPanel, "South");
        this.add((Component)this.categoryView, "East");
        this.add((Component)this.ticketViewContainer, "West");
        this.add((Component)this.midContainer, "Center");
    }

    private JPanel createMemberPanel() {
        JPanel memberPanel = new JPanel((LayoutManager)new MigLayout("fill, ins 0", "[200][]", ""));
        memberPanel.setBorder(BorderFactory.createCompoundBorder(new EmptyBorder(0, 0, 0, 0), BorderFactory.createTitledBorder(null, Messages.getString("OrderView.31"), 2, 2)));
        memberPanel.setPreferredSize(PosUIManager.getSize(0, 200));
        this.coloredCircleRenderer = new ColoredCircleRenderer();
        this.lblImage = new JLabel(){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                Graphics2D g2 = (Graphics2D)g;
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                ColorPref colorPref = OrderView.this.coloredCircleRenderer.getColorPref();
                if (colorPref == null) {
                    return;
                }
                int x = 6;
                int y = 5;
                int gap = 16;
                if (colorPref.isBlueFlag()) {
                    g.setColor(new Color(2453759));
                    g.fillOval(x, y, 10, 10);
                    x += gap;
                }
                if (colorPref.isGreenFlag()) {
                    g.setColor(new Color(3787607));
                    g.fillOval(x, y, 10, 10);
                    x += gap;
                }
                if (colorPref.isOrangeFlag()) {
                    g.setColor(new Color(16348726));
                    g.fillOval(x, y, 10, 10);
                    x += gap;
                }
                if (colorPref.isPurpleFlag()) {
                    g.setColor(new Color(9306366));
                    g.fillOval(x, y, 10, 10);
                    x += gap;
                }
                if (colorPref.isRedFlag()) {
                    g.setColor(new Color(16259598));
                    g.fillOval(x, y, 10, 10);
                    x += gap;
                }
                if (colorPref.isYellowFlag()) {
                    g.setColor(new Color(16102683));
                    g.fillOval(x, y, 10, 10);
                    x += gap;
                }
            }
        };
        this.lblImage.setHorizontalAlignment(0);
        this.lblImage.setIcon(IconFactory.getIcon("/images/", "generic-profile-pic-v2.png", PosUIManager.getSize(160, 178)));
        this.lblImage.setBorder(BorderFactory.createTitledBorder(null, "", 1, 1));
        this.btnCustomer = new PosButton(Messages.getString("OrderView.79"));
        this.btnCustomer.setBackground(Color.WHITE);
        this.btnCustomer.setPreferredSize(PosUIManager.getSize(0, 60));
        PosButton btnCreditBook = new PosButton(Messages.getString("OrderView.80"));
        PosButton btnPreference = new PosButton(Messages.getString("OrderView.81"));
        PosButton btnHistory = new PosButton(Messages.getString("OrderView.82"));
        PosButton btnMinSpend = new PosButton(Messages.getString("OrderView.83"));
        this.btnCustomer.addActionListener(e -> this.doAddEditCustomer(false));
        btnCreditBook.addActionListener(e -> this.doShowCreditBooks());
        btnPreference.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (OrderView.this.currentTicket.getCustomer() == null) {
                    POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("OrderView.84"));
                    return;
                }
                MemberPreferenceAction preferenceAction = new MemberPreferenceAction(OrderView.this.currentTicket.getCustomer());
                preferenceAction.execute();
            }
        });
        btnHistory.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    DataProvider.get().setTicketToBeCreated(OrderView.this.currentTicket);
                    if (OrderView.this.currentTicket.getCustomer() == null) {
                        POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("OrderView.84"));
                        return;
                    }
                    MemberHistoryDialog dialog = new MemberHistoryDialog(OrderView.this.currentTicket.getCustomer().getId());
                    dialog.open();
                }
                finally {
                    DataProvider.get().setTicketToBeCreated(null);
                }
            }
        });
        btnMinSpend.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OrderView.this.doShowMinSpend();
            }
        });
        memberPanel.add((Component)this.lblImage, "grow");
        JPanel btnpanel = new JPanel((LayoutManager)new MigLayout("fill,ins 1 1 1 1"));
        btnpanel.add((Component)this.btnCustomer, "grow,wrap");
        btnpanel.add((Component)btnCreditBook, "grow,wrap");
        btnpanel.add((Component)btnPreference, "split 2,grow");
        btnpanel.add((Component)btnHistory, "grow,wrap");
        btnpanel.add((Component)btnMinSpend, "grow");
        memberPanel.add((Component)btnpanel, "grow");
        return memberPanel;
    }

    protected void doShowMinSpend() {
        try {
            Customer member = this.currentTicket.getCustomer();
            if (member == null) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("OrderView.94"));
                return;
            }
            JsonArray memberMinSpend = SFUtil.getMemberMinSpend(member.getId());
            if (memberMinSpend == null || memberMinSpend.isEmpty()) {
                POSMessageDialog.showMessage(this, Messages.getString("OrderView.40"));
                return;
            }
            MemberUnUsedMinSpendInfoDialog dialog = new MemberUnUsedMinSpendInfoDialog(memberMinSpend);
            dialog.open();
        }
        catch (SFException x) {
            POSMessageDialog.showError(this, x.getMessage());
        }
        catch (StaleStateException x) {
            POSMessageDialog.showMessageDialogWithReloadButton(POSUtil.getFocusedWindow(), this);
        }
        catch (PosException x) {
            POSMessageDialog.showError(x.getMessage());
        }
        catch (Exception x) {
            POSMessageDialog.showError(Application.getPosWindow(), POSConstants.ERROR_MESSAGE, x);
        }
    }

    public void setCurrentTicket(Ticket newTicket) {
        if (this.currentTicket != null && newTicket != null) {
            OrderType currentOrderType = this.currentTicket.getOrderType();
            OrderType newOrderType = newTicket.getOrderType();
            if (newOrderType == null) {
                throw new PosException(Messages.getString("OrderView.56"));
            }
            if (currentOrderType != null && !currentOrderType.equals(newOrderType)) {
                this.currentTicket = newTicket;
                this.changeViewForOrderType(newOrderType);
            }
        } else if (this.currentTicket == null && newTicket != null) {
            OrderType newOrderType = newTicket.getOrderType();
            if (newOrderType == null) {
                throw new PosException(Messages.getString("OrderView.56"));
            }
            this.changeViewForOrderType(newOrderType);
        }
        this.currentTicket = newTicket;
        this.ticketView.setTicket(newTicket);
        if (this.paymentView != null) {
            this.paymentView.setTicket(newTicket);
        }
        this.updateView();
        this.resetView();
        this.orderController.fireTicketEditingStart(newTicket);
    }

    public static synchronized OrderView getInstance() {
        if (instance == null) {
            instance = new OrderView();
        }
        return instance;
    }

    public void resetView() {
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.initializeCategoryView();
            this.ticketView.setVisible(true);
        } else {
            this.ticketView.setVisible(false);
            if (TerminalConfig.isActiveCustomerDisplay()) {
                DrawerUtil.setCustomerDisplayMessage(TerminalConfig.getCustomerDisplayPort(), Messages.getString("OrderView.95"));
            }
        }
        this.setReturnMode(false);
    }

    @Override
    public String getViewName() {
        return VIEW_NAME;
    }

    private void initializeCategoryView() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    OrderView.this.categoryView.initialize();
                }
                catch (Throwable t) {
                    POSMessageDialog.showError(Application.getPosWindow(), POSConstants.ERROR_MESSAGE, t);
                }
            }
        });
    }

    public void doHoldOrder() {
        this.doHoldOrder(true);
    }

    public void doHoldOrder(boolean gotoDefaultView) {
        try {
            if (this.currentTicket.getOrderType().isShowTableSelection().booleanValue() && this.currentTicket.getOrderType().isRequiredCustomerData().booleanValue()) {
                String password = PasswordEntryDialog.show(Application.getPosWindow(), Messages.getString("OrderView.9"));
                if (StringUtils.isEmpty((String)password)) {
                    return;
                }
                User user2 = UserDAO.getInstance().findUserBySecretKey(password);
                if (user2 == null) {
                    POSMessageDialog.showError(Application.getPosWindow(), Messages.getString("OrderView.10"));
                    return;
                }
            }
            if (this.ticketView.getTicket().getTicketItems() == null || this.ticketView.getTicket().getTicketItems().size() == 0) {
                POSMessageDialog.showError(POSConstants.TICKET_IS_EMPTY_);
                return;
            }
            this.ticketView.doHoldOrder(gotoDefaultView);
            this.ticketView.setAllowToLogOut(true);
            ActionHistoryDAO.saveHistory(this.currentTicket, "Hold order", this.currentTicket.getId() == null ? "" : String.format(Messages.getString("OrderView.37"), this.currentTicket.getId()));
            this.orderController.fireTicketEditingFinish(this.currentTicket);
        }
        catch (StaleStateException x) {
            POSMessageDialog.showMessageDialogWithReloadButton(POSUtil.getFocusedWindow(), this);
        }
        catch (PosException x) {
            POSMessageDialog.showError(x.getMessage());
        }
        catch (Exception x) {
            POSMessageDialog.showError(Application.getPosWindow(), POSConstants.ERROR_MESSAGE, x);
        }
    }

    private void doReorder() {
        try {
            Ticket ticket = this.ticketView.getTicket();
            Ticket cloneTicket = Ticket.clone(ticket);
            List<TicketItem> ticketItems = cloneTicket.getTicketItems();
            if (ticketItems == null || ticketItems.size() == 0) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("OrderView.99"));
                return;
            }
            Iterator<TicketItem> iterator = ticketItems.iterator();
            while (iterator.hasNext()) {
                TicketItem ticketItem = iterator.next();
                if (ticketItem.isPrintedToKitchen().booleanValue()) continue;
                iterator.remove();
            }
            if (cloneTicket.getTicketItems().size() == 0) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("OrderView.99"));
                return;
            }
            ReorderDialog dialog = new ReorderDialog(cloneTicket);
            dialog.setTitle(Messages.getString("OrderView.101"));
            dialog.setDefaultCloseOperation(2);
            dialog.setResizable(false);
            dialog.openFullScreen();
            if (!dialog.isCanceled()) {
                List<TicketItem> ticketItemList = dialog.getTicketItems();
                if (ticketItemList == null) {
                    return;
                }
                for (TicketItem ticketItem : ticketItemList) {
                    this.ticketView.addTicketItem(ticketItem);
                }
                OrderController.saveOrder(this.ticketView.getTicket());
                this.ticketView.sendTicketToKitchen();
                this.ticketView.getTicketViewerTable().repaint();
                POSMessageDialog.showMessage(Messages.getString("OrderView.8"));
            }
        }
        catch (StaleStateException x) {
            POSMessageDialog.showMessageDialogWithReloadButton(POSUtil.getFocusedWindow(), this);
        }
        catch (PosException x) {
            POSMessageDialog.showError(x.getMessage());
        }
        catch (Exception x) {
            POSMessageDialog.showError(Application.getPosWindow(), POSConstants.ERROR_MESSAGE, x);
        }
    }

    private void doSendTicketToKitchen() {
        try {
            if (!this.doCheckForHereToGoOrderType()) {
                return;
            }
            PosPrinters printers = DataProvider.get().getPrinters();
            if (printers.getKitchenPrinters().size() == 0 && printers.getStickerPrinters().size() == 0 && !printers.isPrintToKds()) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("OrderView.102"));
                return;
            }
            this.ticketView.sendTicketToKitchenByOption(this);
            this.ticketView.updateTicketTitle();
            this.ticketView.getTicketViewerTable().updateView();
        }
        catch (StaleStateException x) {
            POSMessageDialog.showMessageDialogWithReloadButton(POSUtil.getFocusedWindow(), this);
        }
        catch (PosException x) {
            POSMessageDialog.showError(x.getMessage());
        }
        catch (Exception x) {
            POSMessageDialog.showError(Application.getPosWindow(), POSConstants.ERROR_MESSAGE, x);
        }
        finally {
            this.currentTicket.setShouldUpdateStock(false);
        }
    }

    public Object getSelectedSeatNumber() {
        Ticket currentTicket = this.getCurrentTicket();
        if (currentTicket.getOrderType() != null && currentTicket.getOrderType().isAllowSeatBasedOrder().booleanValue()) {
            return this.seatAction.getSelectedSeatNumber();
        }
        return null;
    }

    public boolean updateSeat(TicketItem ticketItem) {
        return this.seatAction.updateSeatNumber(ticketItem);
    }

    public boolean is_86Mode() {
        return this._86Mode;
    }

    public void set_86Mode(boolean _86Mode) {
        this._86Mode = _86Mode;
    }

    @Override
    public void paymentDone() {
        this.ticketView.doFinishOrder();
        this.updateView();
    }

    @Override
    public void paymentCanceled() {
        if (this.currentTicket == null) {
            return;
        }
        if (StringUtils.isNotEmpty((String)this.currentTicket.getId()) && this.currentTicket.getDueAmount() > 0.0) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("OrderView.103"));
            return;
        }
        this.currentTicket.getTicketItems().clear();
        this.ticketView.doCancelOrder();
        this.updateView();
    }

    @Override
    public void paymentDataChanged() {
        this.updateView();
    }

    public PaymentView getPaymentView() {
        return this.paymentView;
    }

    public SettleTicketProcessor getTicketProcessor() {
        return this.ticketProcessor;
    }

    @Override
    public void itemAdded(Ticket ticket, ITicketItem item) {
        if (ticket.getOrderType().isRetailOrder().booleanValue()) {
            this.updateView();
            this.paymentView.updateView();
        }
    }

    @Override
    public void itemRemoved(ITicketItem item) {
        if (this.currentTicket.getOrderType().isRetailOrder().booleanValue()) {
            this.updateView();
            this.paymentView.updateView();
        }
    }

    public boolean isReturnMode() {
        return this.returnMode;
    }

    public void setReturnMode(boolean returnMode) {
        this.returnMode = returnMode;
    }

    @Override
    public void refresh() {
        if (this.currentTicket != null && this.currentTicket.getId() != null) {
            Ticket ticket = TicketDAO.getInstance().loadFullTicket(this.currentTicket.getId());
            this.setCurrentTicket(ticket);
        } else {
            this.setCurrentTicket(this.currentTicket);
        }
    }

    private void doShowCreditBooks() {
        try {
            Customer customer = this.currentTicket.getCustomer();
            if (customer == null) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("OrderView.105"));
                return;
            }
            List<CreditBookType> creditBookTypes = CreditBookTypeDAO.getInstance().getSFCreditBookTypesForMember(customer.getId(), this.currentTicket.getOrderType());
            if (creditBookTypes == null || creditBookTypes.isEmpty()) {
                throw new PosException(Messages.getString("CreditBookPaymentPlugin.1"));
            }
            CreditBookTypesSelectionDialog dialog = new CreditBookTypesSelectionDialog(customer, creditBookTypes);
            dialog.setTitle(Application.getTitle());
            dialog.setSize(1000, 600);
            dialog.open();
        }
        catch (Exception e) {
            POSMessageDialog.showError(this, e.getMessage(), e);
        }
    }

    @Override
    public void dataAdded(Object object) {
    }

    @Override
    public void dataChanged(Object object) {
    }

    @Override
    public void dataRemoved(Object object) {
    }

    @Override
    public Object getSelectedData() {
        return this.getCurrentTicket();
    }

    @Override
    public void dataSetUpdated() {
    }

    @Override
    public void dataChangeCanceled(Object object) {
    }

    private void doCancel() {
        try {
            this.currentTicket.getEvents().clear();
            this.lblImage.setIcon(IconFactory.getIcon("/images/", "generic-profile-pic-v2.png"));
            if (this.ticketView.isCancelable()) {
                this.ticketView.doCancelOrder();
                this.orderController.fireTicketEditingFinish(this.currentTicket);
                return;
            }
            int result = POSMessageDialog.showYesNoQuestionDialog(null, Messages.getString("OrderView.4"), Messages.getString("OrderView.7"));
            if (result != 0) {
                return;
            }
            VoidTicketAction action = new VoidTicketAction(this.currentTicket);
            action.execute();
            if (this.currentTicket.isVoided().booleanValue()) {
                this.ticketView.doCancelOrder();
                this.ticketView.setAllowToLogOut(true);
            }
            this.orderController.fireTicketEditingFinish(this.currentTicket);
        }
        catch (Exception e) {
            POSMessageDialog.showError(this, e.getMessage());
        }
    }

    private void doFinish() {
        try {
            if (!this.doCheckForHereToGoOrderType()) {
                return;
            }
            this.currentTicket.setShouldUpdateStock(true);
            this.ticketView.doFinishOrder();
            this.orderController.fireTicketEditingFinish(this.currentTicket);
        }
        catch (StaleStateException x) {
            POSMessageDialog.showMessageDialogWithReloadButton(POSUtil.getFocusedWindow(), OrderView.getInstance());
        }
        catch (PosException x) {
            POSMessageDialog.showError(x.getMessage());
        }
        catch (Exception x) {
            POSMessageDialog.showError(Application.getPosWindow(), POSConstants.ERROR_MESSAGE, x);
        }
        finally {
            this.currentTicket.setShouldUpdateStock(false);
        }
    }

    @Override
    public void payOrderSelected(Ticket ticket) {
        this.doPayNow();
    }

    private void doPayNow() {
        try {
            this.currentTicket.validateTicketBeforeSave();
            OrderController.saveOrder(this.currentTicket);
            if (new SettleTicketAction(this.currentTicket).performSettle()) {
                RootView.getInstance().showDefaultView();
            }
        }
        catch (PosException e) {
            POSMessageDialog.showError(e.getMessage());
        }
        catch (StaleStateException x) {
            POSMessageDialog.showMessageDialogWithReloadButton(this, this);
        }
        catch (Exception e) {
            POSMessageDialog.showError(POSConstants.ERROR_MESSAGE, e);
        }
    }
}

