/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views.order;

import com.floreantpos.Messages;
import com.floreantpos.PosLog;
import com.floreantpos.actions.ShowCustomerSelectionHomeViewAction;
import com.floreantpos.bo.ui.BackOfficeWindow;
import com.floreantpos.config.TerminalConfig;
import com.floreantpos.extension.ExtensionManager;
import com.floreantpos.extension.OrderServiceExtension;
import com.floreantpos.extension.OrderServiceFactory;
import com.floreantpos.main.Application;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.User;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.HeaderPanel;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.kitchendisplay.KitchenDisplayView;
import com.floreantpos.ui.views.IView;
import com.floreantpos.ui.views.LoginView;
import com.floreantpos.ui.views.SwitchboardView;
import com.floreantpos.ui.views.TableLayoutView;
import com.floreantpos.ui.views.order.OrderView;
import com.floreantpos.ui.views.payment.SettleTicketDialog;
import com.floreantpos.util.POSUtil;
import com.floreantpos.util.TicketAlreadyExistsException;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class RootView
extends TransparentPanel {
    private CardLayout cards = new CardLayout();
    private HeaderPanel headerPanel = new HeaderPanel();
    private JPanel contentPanel = new JPanel(this.cards);
    private LoginView loginScreen;
    private SettleTicketDialog paymentView;
    private String currentViewName;
    private IView homeView;
    private Map<String, IView> views = new HashMap<String, IView>();
    private static RootView instance;

    private RootView() {
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(1, 0, 0, 0));
        this.add(this.contentPanel);
    }

    public void initDefaultViews() {
        this.headerPanel.setVisible(false);
        this.add((Component)this.headerPanel, "North");
        this.loginScreen = LoginView.getInstance();
        this.addView(this.loginScreen);
    }

    public void addView(IView iView) {
        this.views.put(iView.getViewName(), iView);
        this.contentPanel.add(iView.getViewName(), iView.getViewComponent());
    }

    public void showView(String viewName) {
        if ("LOGIN_VIEW".equals(viewName)) {
            this.headerPanel.setVisible(false);
        } else {
            this.headerPanel.setVisible(true);
        }
        this.currentViewName = viewName;
        this.cards.show(this.contentPanel, viewName);
        if (this.homeView != null) {
            this.headerPanel.updateHomeView(!this.homeView.getViewName().equals(this.currentViewName));
        }
        this.headerPanel.updateSwitchBoardView(!this.currentViewName.equals(SwitchboardView.VIEW_NAME));
    }

    public void showView(IView view) {
        if (!this.views.containsKey(view.getViewName())) {
            this.addView(view);
        }
        this.currentViewName = view.getViewName();
        this.showView(this.currentViewName);
    }

    public boolean hasView(String viewName) {
        return this.views.containsKey(viewName);
    }

    public boolean hasView(IView view) {
        return this.views.containsKey(view.getViewName());
    }

    public OrderView getOrderView() {
        return (OrderView)this.views.get("ORDER_VIEW");
    }

    public LoginView getLoginScreen() {
        return this.loginScreen;
    }

    public static synchronized RootView getInstance() {
        if (instance == null) {
            instance = new RootView();
        }
        return instance;
    }

    public SettleTicketDialog getPaymentView() {
        return this.paymentView;
    }

    public HeaderPanel getHeaderPanel() {
        return this.headerPanel;
    }

    public String getCurrentViewName() {
        return this.currentViewName;
    }

    public IView getCurrentView() {
        return this.views.get(this.currentViewName);
    }

    public void showDefaultView() {
        String defaultViewName = TerminalConfig.getDefaultView();
        if (defaultViewName == null) {
            defaultViewName = "";
        }
        if (defaultViewName.equals("KD")) {
            if (!this.hasView((IView)KitchenDisplayView.getInstance())) {
                this.addView((IView)KitchenDisplayView.getInstance());
            }
            this.setAndShowHomeScreen((IView)KitchenDisplayView.getInstance());
            RootView.getInstance().getHeaderPanel().setVisible(false);
        } else if (defaultViewName.equals(SwitchboardView.VIEW_NAME)) {
            this.setAndShowHomeScreen(SwitchboardView.getInstance());
        } else {
            OrderType orderType = DataProvider.get().getOrderType(defaultViewName);
            if (orderType == null) {
                IView iView = this.views.get(defaultViewName);
                if (iView == null) {
                    this.setAndShowHomeScreen(SwitchboardView.getInstance());
                } else {
                    this.setAndShowHomeScreen(iView);
                }
                return;
            }
            if (orderType.isRetailOrder().booleanValue()) {
                try {
                    this.homeView = OrderView.getInstance();
                    if (!this.hasView(this.homeView)) {
                        this.addView(this.homeView);
                    }
                    OrderServiceFactory.getOrderService().createNewTicket(orderType, null, null);
                    return;
                }
                catch (TicketAlreadyExistsException e1) {
                    PosLog.error(RootView.class, e1);
                }
            }
            if (orderType.isShowTableSelection().booleanValue() || orderType.isBarTab().booleanValue()) {
                TableLayoutView tableMapView = TableLayoutView.getInstance(orderType);
                this.setAndShowHomeScreen(tableMapView);
            } else if (orderType.isRequiredCustomerData().booleanValue() || orderType.isDelivery().booleanValue()) {
                OrderServiceExtension orderServicePlugin = (OrderServiceExtension)ExtensionManager.getPlugin(OrderServiceExtension.class);
                if (orderServicePlugin != null) {
                    if (orderType.isDelivery().booleanValue()) {
                        this.setAndShowHomeScreen(orderServicePlugin.getDeliveryDispatchView(orderType));
                    } else {
                        this.showCustomerSelectionView(orderType);
                    }
                } else {
                    this.showCustomerSelectionView(orderType);
                }
            } else {
                try {
                    this.homeView = OrderView.getInstance();
                    OrderServiceFactory.getOrderService().createNewTicket(orderType, null, null);
                }
                catch (TicketAlreadyExistsException e1) {
                    POSMessageDialog.showError(this, Messages.getString("RootView.1"), e1);
                }
            }
        }
    }

    private void showCustomerSelectionView(OrderType orderType) {
        try {
            new ShowCustomerSelectionHomeViewAction(this, orderType).execute();
        }
        catch (Exception e) {
            POSMessageDialog.showError(e.getMessage(), e);
        }
    }

    public IView getHomeView() {
        return this.homeView;
    }

    public void setAndShowHomeScreen(IView homeScreen) {
        this.homeView = homeScreen;
        this.showHomeScreen();
    }

    public void showHomeScreen() {
        IView view = this.getHomeView();
        this.showView(view);
        view.refresh();
    }

    public void showBackOffice() {
        BackOfficeWindow window = POSUtil.getBackOfficeWindow();
        if (window == null) {
            window = new BackOfficeWindow(Application.getCurrentUser());
        }
        window.setVisible(true);
        window.toFront();
    }

    public void showBackOffice(User user) {
        BackOfficeWindow window = POSUtil.getBackOfficeWindow();
        if (window == null) {
            window = new BackOfficeWindow(user);
        }
        window.setVisible(true);
        window.toFront();
    }
}

