/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views.order;

import com.floreantpos.IconFactory;
import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.actions.ReturnTicketItemAction;
import com.floreantpos.actions.VoidTicketItemAction;
import com.floreantpos.config.TerminalConfig;
import com.floreantpos.main.Application;
import com.floreantpos.model.ITicketItem;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.ModifiableTicketItem;
import com.floreantpos.model.Store;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemCookingInstruction;
import com.floreantpos.model.TicketItemDiscount;
import com.floreantpos.model.TicketItemModifier;
import com.floreantpos.model.TicketItemSeat;
import com.floreantpos.model.dao.ActionHistoryDAO;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.report.ReceiptPrintService;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosScrollPane;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.RefreshableView;
import com.floreantpos.ui.dialog.ComboTicketItemSelectionDialog;
import com.floreantpos.ui.dialog.GlobalInputDialog;
import com.floreantpos.ui.dialog.ItemSearchDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.ticket.TicketViewerTable;
import com.floreantpos.ui.views.CookingInstructionSelectionDialog;
import com.floreantpos.ui.views.order.OrderController;
import com.floreantpos.ui.views.order.OrderView;
import com.floreantpos.ui.views.order.RootView;
import com.floreantpos.ui.views.order.actions.DataChangeListener;
import com.floreantpos.ui.views.order.actions.OrderListener;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.DrawerUtil;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import com.floreantpos.versioning.VersionInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public class TicketView
extends JPanel {
    private final Vector<OrderListener> orderListeners = new Vector();
    private Ticket ticket;
    private final PosButton btnTenIncrease = new PosButton(IconFactory.getIcon("/ui_icons/", "page-up.png"));
    private final PosButton btnTenDecrease = new PosButton(IconFactory.getIcon("/ui_icons/", "page-down.png"));
    private final PosButton btnDelete = new PosButton();
    private final PosButton btnEdit = new PosButton(IconFactory.getIcon("/ui_icons/", "edit.png"));
    private final PosButton btnEditItemQuantity = new PosButton(IconFactory.getIcon("/ui_icons/", "add-multiple.png"));
    private PosButton btnScrollDown;
    private final PosButton btnScrollUp = new PosButton();
    private TransparentPanel ticketItemActionPanel;
    private JScrollPane ticketScrollPane;
    private PosButton btnTotal;
    private TicketViewerTable ticketViewerTable;
    private ItemSearchDialog itemSearchDialog = new ItemSearchDialog(Application.getPosWindow());
    private JPanel itemSearchPanel;
    private JTextField txtSearchItem;
    private final PosButton btnCookingInstruction = new PosButton(IconFactory.getIcon("/ui_icons/", "cooking-instruction.png"));
    private final TitledBorder titledBorder = new TitledBorder("");
    private final Border border = new CompoundBorder(this.titledBorder, new EmptyBorder(2, 2, 2, 2));
    private boolean cancelable;
    private boolean allowToLogOut;
    public static final String VIEW_NAME = "TICKET_VIEW";

    public TicketView() {
        this.initComponents();
    }

    private void initComponents() {
        this.titledBorder.setTitleJustification(2);
        this.setBorder(this.border);
        this.setLayout(new BorderLayout(5, 5));
        this.itemSearchPanel = new JPanel();
        this.ticketItemActionPanel = new TransparentPanel();
        this.btnScrollDown = new PosButton();
        this.ticketViewerTable = new TicketViewerTable();
        this.ticketScrollPane = new PosScrollPane(this.ticketViewerTable);
        this.ticketScrollPane.setHorizontalScrollBarPolicy(31);
        this.ticketScrollPane.setVerticalScrollBarPolicy(21);
        this.ticketScrollPane.setPreferredSize(PosUIManager.getSize(180, 200));
        this.btnEdit.setEnabled(false);
        this.btnCookingInstruction.setEnabled(false);
        this.createPayButton();
        this.createTicketItemControlPanel();
        this.createItemSearchPanel();
        JPanel centerPanel = new JPanel(new BorderLayout(5, 5));
        centerPanel.add(this.ticketScrollPane);
        this.add((Component)this.itemSearchPanel, "North");
        this.add(centerPanel);
        this.add((Component)this.ticketItemActionPanel, "East");
        this.ticketViewerTable.getRenderer().setInTicketScreen(true);
        this.ticketViewerTable.getSelectionModel().addListSelectionListener(new TicketItemSelectionListener());
        this.setPreferredSize(PosUIManager.getSize(320, 463));
    }

    private void createItemSearchPanel() {
        this.itemSearchPanel.setLayout(new BorderLayout(5, 5));
        PosButton btnSearch = new PosButton(IconFactory.getIcon("/ui_icons/", "search.png"));
        btnSearch.setPreferredSize(PosUIManager.getSize(50, 40));
        this.txtSearchItem = new JTextField();
        this.txtSearchItem.requestFocusInWindow();
        this.txtSearchItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String searchString = TicketView.this.txtSearchItem.getText();
                if (searchString.equals("")) {
                    POSMessageDialog.showMessage(Messages.getString("TicketView.5"));
                    return;
                }
                MenuItem menuItem = MenuItemDAO.getInstance().getMenuItemByBarcodeOrSKU(searchString);
                if (menuItem != null) {
                    OrderView.getInstance().getOrderController().itemSelected(menuItem);
                }
                TicketView.this.txtSearchItem.setText("");
            }
        });
        btnSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TicketView.this.itemSearchDialog.setTitle(Messages.getString("TicketView.7"));
                TicketView.this.itemSearchDialog.updateFilterPanel(TicketView.this.ticket.getOrderType());
                TicketView.this.itemSearchDialog.pack();
                TicketView.this.itemSearchDialog.openFullScreen();
                if (TicketView.this.itemSearchDialog.isCanceled()) {
                    return;
                }
                TicketView.this.txtSearchItem.requestFocus();
                if (TicketView.this.itemSearchDialog.getMenuItem() == null) {
                    POSMessageDialog.showError(Application.getPosWindow(), Messages.getString("TicketView.8"));
                    return;
                }
                OrderView.getInstance().getOrderController().itemSelected(TicketView.this.itemSearchDialog.getMenuItem());
            }
        });
        this.itemSearchPanel.add(this.txtSearchItem);
        this.itemSearchPanel.add((Component)btnSearch, "East");
    }

    private void createPayButton() {
        this.btnTotal = new PosButton(POSConstants.TOTAL.toUpperCase());
        this.btnTotal.setFont(this.btnTotal.getFont().deriveFont(1));
        this.btnTotal.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TicketView.this.firePayOrderSelected();
            }
        });
        this.add((Component)this.btnTotal, "South");
    }

    private void createTicketItemControlPanel() {
        this.ticketItemActionPanel.setLayout((LayoutManager)new MigLayout("fill, hidemode 3, ins 0 0 0 0", "sg, fill", ""));
        this.btnScrollUp.setIcon(IconFactory.getIcon("/ui_icons/", "up.png"));
        this.btnScrollUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TicketView.this.doScrollUp();
            }
        });
        this.btnTenIncrease.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TicketView.this.scrollPageUp();
            }
        });
        this.btnScrollDown.setIcon(IconFactory.getIcon("/ui_icons/", "down.png"));
        this.btnScrollDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TicketView.this.doScrollDown();
            }
        });
        this.btnTenDecrease.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TicketView.this.scrollPageDown();
            }
        });
        this.btnDelete.setText("");
        this.btnDelete.setIcon(IconFactory.getIcon("/ui_icons/", "delete.png"));
        this.btnDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TicketView.this.doDeleteSelection();
            }
        });
        this.btnEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TicketView.this.doEditSelection();
            }
        });
        this.btnEditItemQuantity.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TicketView.this.doEditItemQuantity();
            }
        });
        this.btnCookingInstruction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TicketView.this.doAddCookingInstruction();
            }
        });
        this.ticketItemActionPanel.add((Component)this.btnTenIncrease, "grow, wrap");
        this.ticketItemActionPanel.add((Component)this.btnScrollUp, "grow, wrap");
        this.ticketItemActionPanel.add((Component)this.btnEditItemQuantity, "grow, wrap");
        this.ticketItemActionPanel.add((Component)this.btnDelete, "grow, wrap");
        this.ticketItemActionPanel.add((Component)this.btnEdit, "grow, wrap");
        this.ticketItemActionPanel.add((Component)this.btnCookingInstruction, "grow, wrap");
        this.ticketItemActionPanel.add((Component)this.btnScrollDown, "grow, wrap");
        this.ticketItemActionPanel.add((Component)this.btnTenDecrease, "grow");
        this.ticketItemActionPanel.setPreferredSize(PosUIManager.getSize(50, 0));
    }

    private void doEditItemQuantity() {
        ITicketItem object = this.ticketViewerTable.getSelected();
        if (object == null) {
            return;
        }
        if (!(object instanceof TicketItem) || ((TicketItem)object).isTreatAsSeat().booleanValue()) {
            return;
        }
        TicketItem ticketItem = (TicketItem)object;
        OrderView.getInstance().getOrderController().doEditTicketItemQuantity(ticketItem);
        this.updateView();
        int selectedRow = this.ticketViewerTable.getSelectedRow();
        this.ticketViewerTable.getModel().fireTableRowsUpdated(selectedRow, selectedRow);
        this.ticketViewerTable.fireTicketItemUpdated(this.getTicket(), ticketItem);
    }

    public synchronized void doFinishOrder() {
        this.saveTicketIfNeeded();
        this.sendTicketToKitchen();
        this.closeView(false, true);
    }

    @Deprecated
    public synchronized void sendTicketToKitchenByOption(RefreshableView refreshableView) {
        boolean isKitchenPrintable = this.ticket.isKitchenPrintable();
        if (!isKitchenPrintable) {
            throw new PosException(Messages.getString("TicketView.333"));
        }
        OrderController.saveOrder(this.ticket);
        if (this.ticket.getOrderType().isShouldPrintToKitchen().booleanValue()) {
            if (this.ticket.needsKitchenPrint()) {
                ReceiptPrintService.printToKitchen(this.ticket, true);
                POSMessageDialog.showMessage(Messages.getString("TicketView.32"));
                ActionHistoryDAO.saveHistory(this.ticket, "Sent to kitchen", "");
            } else {
                POSMessageDialog.showMessage(Messages.getString("TicketView.333"));
            }
        }
        this.setAllowToLogOut(false);
    }

    public synchronized void sendTicketToKitchen() {
        if (this.ticket.getOrderType().isShouldPrintToKitchen().booleanValue() && this.ticket.needsKitchenPrint()) {
            ReceiptPrintService.printToKitchen(this.ticket);
            this.setCancelable(false);
            this.setAllowToLogOut(false);
        }
    }

    public void doHoldOrder() {
        this.doHoldOrder(true);
    }

    public synchronized void doHoldOrder(boolean gotoDefaultView) {
        this.updateModel();
        OrderController.saveOrder(this.ticket);
        this.closeView(false, gotoDefaultView);
    }

    public void saveTicketIfNeeded() {
        this.updateModel();
        OrderController.saveOrder(this.ticket);
    }

    private void closeView(boolean orderCanceled, boolean gotoHomeView) {
        DataChangeListener listener = RootView.getInstance().getHomeView().getDataChangeListener();
        if (listener != null) {
            if (orderCanceled) {
                listener.dataChangeCanceled(this.ticket);
            } else {
                listener.dataChanged(this.ticket);
            }
        }
        if (gotoHomeView) {
            RootView.getInstance().showDefaultView();
        }
    }

    public void doCancelOrder() {
        this.doCancelOrder(true);
    }

    public void doCancelOrder(boolean gotoHomeView) {
        this.closeView(true, gotoHomeView);
    }

    private synchronized void updateModel() {
        if (this.ticket.getTicketItems() == null || this.ticket.getTicketItems().size() == 0) {
            throw new PosException(POSConstants.TICKET_IS_EMPTY_);
        }
        this.ticket.calculatePrice();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void doDeleteSelection() {
        Ticket ticket;
        TicketItem ticketItem;
        block10: {
            boolean inventoryAdjusted;
            ITicketItem selected;
            block12: {
                block11: {
                    selected = this.ticketViewerTable.getSelected();
                    if (selected == null) {
                        return;
                    }
                    if (!(selected instanceof TicketItem)) {
                        this.ticketViewerTable.deleteSelectedItem();
                        this.updateView();
                        return;
                    }
                    ticketItem = (TicketItem)selected;
                    inventoryAdjusted = ticketItem.getInventoryAdjustQty() > 0.0;
                    ticket = ticketItem.getTicket();
                    if (ticketItem.isInventoryAdjusted() && ticket.getPaidAmount() > 0.0) {
                        POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("TicketView.0"));
                        return;
                    }
                    if (!ticketItem.isTreatAsSeat().booleanValue()) break block11;
                    this.doDeleteSeat(ticketItem);
                    break block10;
                }
                if (!selected.isPrintedToKitchen().booleanValue() && !inventoryAdjusted) break block12;
                if (ticketItem.isVoided().booleanValue()) {
                    if (!ticketItem.isCloudSynced().booleanValue()) {
                        this.doPerformDeleteAndUpdateView(ticketItem);
                        break block10;
                    } else {
                        if (!ticketItem.isDeletableVoidItem()) {
                            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("TicketView.2"));
                            return;
                        }
                        this.doPerformDeleteAndUpdateView(ticketItem);
                    }
                    break block10;
                } else {
                    this.doPerformVoid(ticketItem);
                }
                break block10;
            }
            if (ticketItem.getVoidedItemId() != null) {
                if (!selected.isPrintedToKitchen().booleanValue() && !inventoryAdjusted) {
                    this.ticketViewerTable.deleteSelectedItem();
                    this.updateSurchargeAmount(ticketItem);
                    this.updateView();
                    return;
                }
                this.doPerformUndoVoid(ticketItem);
                return;
            }
            this.ticketViewerTable.deleteSelectedItem();
            this.updateView();
        }
        OrderView.getInstance().getOrderController().fireTicketItemUpdated(ticket, ticketItem);
    }

    private void updateSurchargeAmount(TicketItem ticketItem) {
        List<TicketItem> ticketItems = this.ticket.getTicketItems();
        Iterator<TicketItem> iterator = ticketItems.iterator();
        while (iterator.hasNext()) {
            String refundItemIds;
            TicketItem ticketItem2 = iterator.next();
            if (!ticketItem2.getMenuItemName().equals("CC Surcharge") || StringUtils.isNotBlank((String)ticketItem2.getTransactionUUId()) || !(refundItemIds = ticketItem2.getRefundItemIds()).contains("'" + ticketItem.getVoidedItemId() + "'")) continue;
            double surchargeAmount = ticketItem2.getUnitPrice() - this.calculateSurchargeReturnAmount(Math.abs(ticketItem.getTotalAmount()));
            if (NumberUtil.isZero(surchargeAmount)) {
                iterator.remove();
                this.ticketViewerTable.removeObject(ticketItem2);
                continue;
            }
            ticketItem2.setUnitPrice(surchargeAmount);
            ticketItem2.setSubtotalAmount(surchargeAmount);
            ticketItem2.setTotalAmount(surchargeAmount);
            this.ticket.setTotalSurchargeAmount(this.ticket.getTotalSurchargeAmount() + surchargeAmount);
        }
        this.ticket.calculatePrice();
    }

    private double calculateSurchargeReturnAmount(double tenderAmount) {
        if (this.ticket == null) {
            return 0.0;
        }
        Store store = DataProvider.get().getStore();
        if (this.ticket.getOrderType().isApplyCreditCardSurcharge() && store.isEnableCreditCardSurcharge()) {
            Double percentagesAmountByCardType = store.getPercentagesAmountByCardType(this.ticket.getCreditCardType());
            double surchargeAmount = NumberUtil.round(tenderAmount * (percentagesAmountByCardType / 100.0));
            return surchargeAmount;
        }
        return 0.0;
    }

    private void doPerformDeleteAndUpdateView(TicketItem ticketItem) {
        if (ticketItem.getVoidedItemId() != null) {
            this.doPerformUndoVoid(ticketItem);
            return;
        }
        if (ticketItem.getId() == null) {
            this.ticketViewerTable.deleteSelectedItem();
            this.updateView();
            return;
        }
        if (POSMessageDialog.showYesNoQuestionDialog(Application.getPosWindow(), POSConstants.CONFIRM_DELETE, POSConstants.CONFIRM) != 0) {
            return;
        }
        this.ticketViewerTable.deleteSelectedItem();
        this.updateView();
    }

    private void doPerformVoid(TicketItem ticketItem) {
        if (ticketItem.isPaid()) {
            ReturnTicketItemAction returnmAction = new ReturnTicketItemAction(this, this.ticket, ticketItem);
            returnmAction.actionPerformed(null);
            if (returnmAction.isDataChanged()) {
                this.ticketViewerTable.updateView();
                this.updateView();
            }
        } else {
            VoidTicketItemAction action = new VoidTicketItemAction(this.ticket, ticketItem);
            action.actionPerformed(null);
            if (action.isDataChanged()) {
                this.ticketViewerTable.updateView();
                this.updateView();
            }
        }
    }

    private void update86Countdown(TicketItem ticketItem, Double quantity) {
        MenuItem menuItem = ticketItem.getMenuItem();
        if (menuItem == null) {
            return;
        }
        MenuItemDAO.getInstance().refresh(menuItem);
        if (menuItem.isAuto86Enabled() && !menuItem.isFractionalUnit().booleanValue()) {
            int countdown86 = menuItem.get86Countdown() + quantity.intValue();
            menuItem.set86Countdown(Math.max(0, countdown86));
            menuItem.setEnable(countdown86 > 0);
            MenuItemDAO.getInstance().update(menuItem);
            this.ticketViewerTable.fireTicketItemUpdated(this.getTicket(), ticketItem);
        }
    }

    private void doPerformUndoVoid(TicketItem ticketItem) {
        if (POSMessageDialog.showYesNoQuestionDialog(Application.getPosWindow(), POSConstants.CONFIRM_DELETE, POSConstants.CONFIRM) != 0) {
            return;
        }
        TicketItem undoTicketItem = this.ticket.undoVoidItem(ticketItem);
        if (ticketItem != undoTicketItem) {
            this.ticketViewerTable.deleteSelectedItem();
            this.ticketViewerTable.getModel().fireTableRowsUpdated(undoTicketItem.getTableRowNum(), undoTicketItem.getTableRowNum());
        } else {
            int selectedRow = this.ticketViewerTable.getSelectedRow();
            this.ticketViewerTable.getModel().fireTableRowsUpdated(selectedRow, selectedRow);
            this.update86Countdown(ticketItem, -ticketItem.getQuantity().doubleValue());
        }
        this.updateView();
    }

    private void doDeleteSeat(TicketItem ticketItem) {
        TicketItem nextTicketItem;
        if (ticketItem.isSaved() && POSMessageDialog.showYesNoQuestionDialog(Application.getPosWindow(), POSConstants.CONFIRM_DELETE, POSConstants.CONFIRM) != 0) {
            return;
        }
        TicketItemSeat prevSeat = null;
        Integer prevSeatNumber = 0;
        List<TicketItem> ticketItems = this.getTicket().getTicketItems();
        int idx = ticketItems.indexOf(ticketItem);
        if (idx > 0) {
            TicketItem prevTicketItem = ticketItems.get(idx - 1);
            prevSeat = prevTicketItem.getSeat();
            prevSeatNumber = prevTicketItem.getSeatNumber();
        }
        for (int i = idx + 1; i < ticketItems.size() && !(nextTicketItem = ticketItems.get(i)).isTreatAsSeat().booleanValue(); ++i) {
            nextTicketItem.setSeat(prevSeat);
            nextTicketItem.setSeatNumber(prevSeatNumber);
        }
        this.ticketViewerTable.deleteSelectedItem();
        this.updateView();
    }

    private void doEditSelection() {
        ITicketItem object = this.ticketViewerTable.getSelected();
        if (object == null) {
            return;
        }
        if (object instanceof TicketItem) {
            TicketItem ticketItem = (TicketItem)object;
            if (ticketItem.isOpenItem() && !ticketItem.isItemReturned().booleanValue()) {
                this.doUpdateDescription(ticketItem);
            }
            if (ticketItem.isTreatAsSeat().booleanValue()) {
                if (!OrderView.getInstance().updateSeat(ticketItem)) {
                    return;
                }
            } else if (ticketItem.isComboItem().booleanValue()) {
                MenuItem menuItem = ticketItem.getMenuItem();
                ComboTicketItemSelectionDialog dialog = new ComboTicketItemSelectionDialog(menuItem, ticketItem);
                dialog.setTitle(Messages.getString("TicketView.47"));
                dialog.setSize(PosUIManager.getSize(1024, 700));
                dialog.open();
                if (dialog.isCanceled()) {
                    return;
                }
                if (menuItem.isModifiablePriceForComboItem()) {
                    ticketItem.doCalculateComboItemPrice();
                }
            } else if (ticketItem instanceof ModifiableTicketItem) {
                OrderController.openModifierDialog(object);
            }
            OrderView.getInstance().getOrderController().fireTicketItemUpdated(this.ticket, ticketItem);
        } else {
            OrderController.openModifierDialog(object);
        }
        this.ticketViewerTable.rowTobeSelectedOnResize = -1;
        this.updateView();
    }

    private void doScrollDown() {
        this.ticketViewerTable.scrollDown();
    }

    private void doScrollUp() {
        this.ticketViewerTable.scrollUp();
    }

    private void scrollPageUp() {
        this.ticketViewerTable.scrollUpTen();
    }

    private void scrollPageDown() {
        this.ticketViewerTable.scrollDownTen();
    }

    public Ticket getTicket() {
        return this.ticket;
    }

    public void setTicket(Ticket _ticket) {
        this.ticket = _ticket;
        this.ticketViewerTable.setTicket(_ticket);
        this.updateView();
        this.setCancelable(true);
        this.setAllowToLogOut(true);
    }

    public void addTicketItem(TicketItem ticketItem) {
        this.ticketViewerTable.addTicketItem(ticketItem);
        this.updateView();
    }

    public void removeModifier(TicketItem parent, TicketItemModifier modifier) {
        modifier.setItemQuantity(0.0);
        this.ticketViewerTable.removeModifier(parent, modifier);
    }

    public void selectRow(int rowIndex) {
        this.ticketViewerTable.selectRow(rowIndex);
    }

    public void updateView() {
        if (this.ticket == null) {
            this.btnTotal.setText(POSConstants.TOTAL.toUpperCase() + " " + CurrencyUtil.getCurrencySymbol() + "0.00");
            this.titledBorder.setTitle("[" + Messages.getString("NewTicket") + "]");
            return;
        }
        this.ticket.calculatePrice();
        if (this.ticket.getDueAmount() < 0.0) {
            String dueAmountString = NumberUtil.formatNumber(this.ticket.getDueAmount(), true);
            String textToDisplay = Messages.getString("TicketView.48") + CurrencyUtil.getCurrencySymbol() + dueAmountString.replaceFirst("-", "");
            this.btnTotal.setText(textToDisplay);
        } else {
            String dueAmountString = NumberUtil.formatNumber(this.ticket.getDueAmount(), true);
            this.btnTotal.setText(Messages.getString("TicketView.51") + CurrencyUtil.getCurrencySymbol() + dueAmountString);
        }
        this.updateTicketTitle();
        this.showCustomerDisplayInfo(this.ticketViewerTable.getSelected());
    }

    public void updateTicketTitle() {
        String ticketType = this.ticket.getOrderType().toString();
        if (this.ticket.getId() == null) {
            this.titledBorder.setTitle(ticketType + " [New Ticket]");
        } else {
            StringBuilder titleBuilder = new StringBuilder();
            String ticketName = Messages.getString("TicketView.37");
            titleBuilder.append(ticketType);
            titleBuilder.append(" [ " + ticketName + " " + this.ticket.getId() + " ]");
            this.titledBorder.setTitle(titleBuilder.toString());
        }
        this.repaint();
    }

    public void addOrderListener(OrderListener listenre) {
        this.orderListeners.add(listenre);
    }

    public void removeOrderListener(OrderListener listenre) {
        this.orderListeners.remove(listenre);
    }

    public void firePayOrderSelected() {
        for (OrderListener listener : this.orderListeners) {
            listener.payOrderSelected(this.getTicket());
        }
    }

    public void setControlsVisible(boolean visible) {
        this.btnDelete.setEnabled(visible);
    }

    public TicketViewerTable getTicketViewerTable() {
        return this.ticketViewerTable;
    }

    public void setEnableActionButtons(boolean enable) {
        this.btnCookingInstruction.setEnabled(enable);
        this.btnEditItemQuantity.setEnabled(enable);
        this.btnEdit.setEnabled(enable);
        this.btnDelete.setEnabled(enable);
    }

    private String getDisplayMessage(ITicketItem item, String totalPrice) {
        String total;
        String line2;
        double itemPrice;
        String itemName = item.getNameDisplay();
        itemName = itemName.length() > 10 ? item.getNameDisplay().substring(0, 10) : item.getNameDisplay();
        String line = String.format("%-10s %9s", itemName, NumberUtil.formatNumber(itemPrice = item.getSubtotalAmount() == null ? 0.0 : item.getSubtotalAmount(), true));
        if (line.length() > 20) {
            line = line.substring(0, 20);
        }
        if ((line2 = String.format("%-8s %11s", total = Messages.getString("TicketView.29") + CurrencyUtil.getCurrencySymbol(), totalPrice)).length() > 20) {
            line2 = line2.substring(0, 20);
        }
        return line + line2;
    }

    public boolean isCancelable() {
        return this.cancelable;
    }

    public void setCancelable(boolean cancelable) {
        this.cancelable = cancelable;
    }

    public boolean isAllowToLogOut() {
        return this.allowToLogOut;
    }

    public void setAllowToLogOut(boolean allowToLogOut) {
        this.allowToLogOut = allowToLogOut;
    }

    public boolean isStockAvailable(MenuItem menuItem, TicketItem selectedTicketItem, double selectedItemQuantity) {
        if (!menuItem.isDisableWhenStockAmountIsZero().booleanValue()) {
            return true;
        }
        List<TicketItem> ticketItems = this.ticketViewerTable.getTicketItems();
        if (menuItem.isFractionalUnit().booleanValue()) {
            if (ticketItems == null || ticketItems.isEmpty()) {
                return !(menuItem.getAvailableUnit() < selectedTicketItem.getQuantity());
            }
            double totalItemQuantity = 0.0;
            for (TicketItem tItem : ticketItems) {
                if (!menuItem.getName().equals(tItem.getName())) continue;
                totalItemQuantity += tItem.getQuantity().doubleValue();
                if (!(menuItem.getAvailableUnit() < totalItemQuantity)) continue;
                return false;
            }
            if (selectedItemQuantity != -1.0) {
                totalItemQuantity -= selectedTicketItem.getQuantity().doubleValue();
                totalItemQuantity += selectedItemQuantity;
            } else {
                totalItemQuantity += selectedTicketItem.getQuantity().doubleValue();
            }
            return !(menuItem.getAvailableUnit() < totalItemQuantity);
        }
        if (ticketItems == null || ticketItems.isEmpty()) {
            return !(menuItem.getAvailableUnit() < selectedTicketItem.getQuantity());
        }
        int totalItemCount = 0;
        for (TicketItem tItem : ticketItems) {
            if (!tItem.getName().equals(menuItem.getName())) continue;
            totalItemCount = (int)((double)totalItemCount + tItem.getQuantity());
            if (!(menuItem.getAvailableUnit() <= (double)totalItemCount)) continue;
            return false;
        }
        return true;
    }

    protected void doAddCookingInstruction() {
        try {
            ITicketItem object = this.ticketViewerTable.getSelected();
            if (!(object instanceof TicketItem)) {
                POSMessageDialog.showError(Application.getPosWindow(), Messages.getString("TicketView.20"));
                return;
            }
            TicketItem ticketItem = (TicketItem)object;
            if (ticketItem.isPrintedToKitchen().booleanValue()) {
                POSMessageDialog.showError(Application.getPosWindow(), Messages.getString("TicketView.21"));
                return;
            }
            CookingInstructionSelectionDialog dialog = new CookingInstructionSelectionDialog();
            dialog.setSize(PosUIManager.getSize(850, 600));
            dialog.setLocationRelativeTo(Application.getPosWindow());
            dialog.setVisible(true);
            if (dialog.isCanceled()) {
                return;
            }
            List<TicketItemCookingInstruction> instructions = dialog.getTicketItemCookingInstructions();
            ticketItem.addCookingInstructions(instructions);
            this.ticketViewerTable.updateView();
        }
        catch (Exception e) {
            PosLog.error(this.getClass(), e);
            POSMessageDialog.showError(e.getMessage());
        }
    }

    public void showSettleButton(boolean show) {
        this.btnTotal.setVisible(show);
        this.btnEdit.setVisible(show);
        this.btnCookingInstruction.setVisible(show);
    }

    private void showCustomerDisplayInfo(Object selected) {
        if (TerminalConfig.isActiveCustomerDisplay()) {
            TicketItem ticketItem = null;
            if (selected instanceof TicketItemModifier) {
                ticketItem = ((TicketItemModifier)selected).getTicketItem();
            } else if (selected instanceof TicketItem) {
                ticketItem = (TicketItem)selected;
            }
            if (ticketItem != null) {
                String sendMessageToCustomerDisplay = this.getDisplayMessage(ticketItem, NumberUtil.formatNumber(this.ticket.getTotalAmountWithTips(), true));
                DrawerUtil.setItemDisplay(TerminalConfig.getCustomerDisplayPort(), sendMessageToCustomerDisplay);
            }
        }
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            if (this.txtSearchItem.getParent() == null) {
                this.itemSearchPanel.add(this.txtSearchItem);
            }
            this.txtSearchItem.requestFocus();
        } else {
            this.itemSearchPanel.remove(this.txtSearchItem);
        }
    }

    private void doUpdateDescription(TicketItem ticketItem) {
        GlobalInputDialog dialog = new GlobalInputDialog();
        dialog.setInputLength(40);
        dialog.setCaption(Messages.getString("TicketView.3"));
        dialog.setInput(ticketItem.getName());
        dialog.setTitle(VersionInfo.getAppName());
        dialog.open();
        if (dialog.isCanceled()) {
            return;
        }
        ticketItem.setName(dialog.getInput());
    }

    private class TicketItemSelectionListener
    implements ListSelectionListener {
        private TicketItemSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            ITicketItem selected = TicketView.this.ticketViewerTable.getSelected();
            if (selected == null) {
                TicketView.this.setEnableActionButtons(false);
            }
            if (!(selected instanceof ITicketItem)) {
                return;
            }
            TicketView.this.setEnableActionButtons(true);
            ITicketItem iTicketItem = selected;
            if (selected instanceof TicketItem) {
                TicketItem ticketItem = (TicketItem)selected;
                if (ticketItem.isVoided().booleanValue()) {
                    TicketView.this.setEnableActionButtons(false);
                    TicketView.this.setControlsVisible(StringUtils.isBlank((String)ticketItem.getProperty("voidId")) || !ticketItem.isInventoryAdjusted());
                } else if (!(ticketItem instanceof ModifiableTicketItem || ticketItem.isComboItem().booleanValue() || ticketItem.isTreatAsSeat().booleanValue())) {
                    TicketView.this.btnEdit.setEnabled(false);
                }
                if (ticketItem.isTreatAsSeat().booleanValue()) {
                    TicketView.this.btnCookingInstruction.setEnabled(false);
                    TicketView.this.btnEditItemQuantity.setEnabled(false);
                }
                if (ticketItem.getMenuItemName().equals("CC Surcharge")) {
                    TicketView.this.btnDelete.setEnabled(false);
                }
                if (ticketItem.isOpenItem() && !ticketItem.isVoided().booleanValue() && !ticketItem.isReturned()) {
                    TicketView.this.btnEdit.setEnabled(true);
                }
            }
            if (iTicketItem.isPrintedToKitchen().booleanValue() || iTicketItem instanceof TicketItemCookingInstruction || iTicketItem instanceof TicketItemDiscount) {
                TicketView.this.btnCookingInstruction.setEnabled(false);
                TicketView.this.btnEditItemQuantity.setEnabled(false);
                TicketView.this.btnEdit.setEnabled(false);
                if (selected instanceof TicketItemModifier || selected instanceof TicketItemDiscount) {
                    TicketView.this.btnDelete.setEnabled(false);
                }
                if (iTicketItem instanceof TicketItem && ((TicketItem)iTicketItem).isTreatAsSeat().booleanValue()) {
                    TicketView.this.btnEdit.setEnabled(true);
                }
            } else if (selected instanceof TicketItemModifier) {
                TicketView.this.btnEdit.setEnabled(true);
                TicketView.this.btnDelete.setEnabled(false);
                TicketView.this.btnCookingInstruction.setEnabled(false);
                TicketView.this.btnEditItemQuantity.setEnabled(false);
            }
            if (TicketView.this.ticket.isSourceOnline()) {
                TicketView.this.setEnableActionButtons(false);
            }
            TicketView.this.showCustomerDisplayInfo(selected);
        }
    }
}

