/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views.payment;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.config.CardConfig;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.Store;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.ui.views.payment.CardProcessor;
import com.floreantpos.util.POSUtil;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import net.authorize.DeviceType;
import net.authorize.Environment;
import net.authorize.MarketType;
import net.authorize.Merchant;
import net.authorize.ResponseReasonCode;
import net.authorize.TransactionType;
import net.authorize.aim.Transaction;
import net.authorize.aim.cardpresent.Result;
import net.authorize.api.contract.v1.CreateTransactionRequest;
import net.authorize.api.contract.v1.CreateTransactionResponse;
import net.authorize.api.contract.v1.CreditCardType;
import net.authorize.api.contract.v1.MerchantAuthenticationType;
import net.authorize.api.contract.v1.MessageTypeEnum;
import net.authorize.api.contract.v1.MessagesType;
import net.authorize.api.contract.v1.PaymentType;
import net.authorize.api.contract.v1.TransactionRequestType;
import net.authorize.api.contract.v1.TransactionResponse;
import net.authorize.api.contract.v1.TransactionTypeEnum;
import net.authorize.api.controller.CreateTransactionController;
import net.authorize.api.controller.base.ApiOperationBase;
import net.authorize.data.creditcard.CardType;
import net.authorize.data.creditcard.CreditCard;
import org.apache.commons.lang.StringUtils;
import us.fatehi.magnetictrack.BankCardMagneticTrack;

public class AuthorizeDotNetProcessor
implements CardProcessor {
    private static final String AUTHORIZE_NET_TRANS_KEY = "authorize.net.trans.key";
    private static final String AUTHORIZE_NET_LOGIN_ID = "authorize.net.login.id";

    @Override
    public void preAuth(PosTransaction transaction) throws Exception {
        Merchant merchant = this.createMerchant(transaction);
        CreditCard creditCard = this.createCard(transaction);
        Transaction authCaptureTransaction = merchant.createAIMTransaction(TransactionType.AUTH_ONLY, new BigDecimal(transaction.calculateAuthorizeAmount()));
        authCaptureTransaction.setCreditCard(creditCard);
        Result result = (Result)merchant.postTransaction((net.authorize.Transaction)authCaptureTransaction);
        if (!result.isApproved()) {
            if (result.isDeclined()) {
                throw new PosException(Messages.getString("AuthorizeDotNetProcessor.2") + ((ResponseReasonCode)result.getResponseReasonCodes().get(0)).getReasonText());
            }
            throw new PosException(Messages.getString("AuthorizeDotNetProcessor.3") + ((ResponseReasonCode)result.getResponseReasonCodes().get(0)).getReasonText());
        }
        transaction.setCardTransactionId(result.getTransId());
        transaction.setCardAuthCode(result.getAuthCode());
        transaction.setAuthorizable(true);
        this.populateCardInformation(transaction, (Result<Transaction>)result);
    }

    @Override
    public void chargeAmount(PosTransaction transaction) throws Exception {
        Merchant merchant = this.createMerchant(transaction);
        CreditCard creditCard = this.createCard(transaction);
        Transaction authCaptureTransaction = merchant.createAIMTransaction(TransactionType.AUTH_CAPTURE, new BigDecimal(transaction.getAmount()));
        authCaptureTransaction.setCreditCard(creditCard);
        Result result = (Result)merchant.postTransaction((net.authorize.Transaction)authCaptureTransaction);
        if (!result.isApproved()) {
            if (result.isDeclined()) {
                throw new PosException(Messages.getString("AuthorizeDotNetProcessor.2") + ((ResponseReasonCode)result.getResponseReasonCodes().get(0)).getReasonText());
            }
            throw new PosException(Messages.getString("AuthorizeDotNetProcessor.3") + ((ResponseReasonCode)result.getResponseReasonCodes().get(0)).getReasonText());
        }
        transaction.setCaptured(false);
        transaction.setAuthorizable(false);
        transaction.setCardTransactionId(result.getTransId());
        transaction.setCardAuthCode(result.getAuthCode());
        this.populateCardInformation(transaction, (Result<Transaction>)result);
    }

    @Override
    public void captureAuthAmount(PosTransaction transaction) throws Exception {
        Merchant merchant = this.createMerchant(transaction);
        Transaction authCaptureTransaction = merchant.createAIMTransaction(TransactionType.PRIOR_AUTH_CAPTURE, new BigDecimal(transaction.getAmount()));
        authCaptureTransaction.setTransactionId(transaction.getCardTransactionId());
        Result result = (Result)merchant.postTransaction((net.authorize.Transaction)authCaptureTransaction);
        if (!result.isApproved()) {
            if (result.isDeclined()) {
                throw new PosException(Messages.getString("AuthorizeDotNetProcessor.6") + ((ResponseReasonCode)result.getResponseReasonCodes().get(0)).getReasonText());
            }
            throw new PosException(Messages.getString("AuthorizeDotNetProcessor.7") + ((ResponseReasonCode)result.getResponseReasonCodes().get(0)).getReasonText());
        }
        transaction.setCardTransactionId(result.getTransId());
        transaction.setCardAuthCode(result.getAuthCode());
        transaction.setCaptured(true);
        this.populateCardInformation(transaction, (Result<Transaction>)result);
    }

    public void captureNewAmount(PosTransaction transaction) throws Exception {
        Merchant merchant = this.createMerchant(transaction);
        CreditCard creditCard = this.createCard(transaction);
        Transaction authCaptureTransaction = merchant.createAIMTransaction(TransactionType.AUTH_CAPTURE, new BigDecimal(transaction.getAmount()));
        authCaptureTransaction.setCreditCard(creditCard);
        Result result = (Result)merchant.postTransaction((net.authorize.Transaction)authCaptureTransaction);
        if (!result.isApproved()) {
            if (result.isDeclined()) {
                throw new Exception(Messages.getString("AuthorizeDotNetProcessor.8") + ((ResponseReasonCode)result.getResponseReasonCodes().get(0)).getReasonText());
            }
            throw new Exception(Messages.getString("AuthorizeDotNetProcessor.9") + ((ResponseReasonCode)result.getResponseReasonCodes().get(0)).getReasonText());
        }
        transaction.setCardTransactionId(result.getTransId());
        transaction.setCardAuthCode(result.getAuthCode());
        transaction.setCaptured(true);
        this.populateCardInformation(transaction, (Result<Transaction>)result);
    }

    public void voidAmount(PosTransaction transaction) throws Exception {
        Merchant merchant = this.createMerchant(transaction);
        Transaction authCaptureTransaction = merchant.createAIMTransaction(TransactionType.VOID, new BigDecimal(transaction.getAmount()));
        authCaptureTransaction.setTransactionId(transaction.getCardTransactionId());
        Result result = (Result)merchant.postTransaction((net.authorize.Transaction)authCaptureTransaction);
        if (!result.isApproved()) {
            if (result.isDeclined()) {
                throw new Exception(Messages.getString("AuthorizeDotNetProcessor.10") + ((ResponseReasonCode)result.getResponseReasonCodes().get(0)).getReasonText());
            }
            throw new Exception(Messages.getString("AuthorizeDotNetProcessor.11") + ((ResponseReasonCode)result.getResponseReasonCodes().get(0)).getReasonText());
        }
        transaction.setCardTransactionId(result.getTransId());
        transaction.setCardAuthCode(result.getAuthCode());
        transaction.setVoided(true);
        this.populateCardInformation(transaction, (Result<Transaction>)result);
    }

    private CreditCard createCard(PosTransaction transaction) {
        CreditCard creditCard = CreditCard.createCreditCard();
        String cardType = transaction.getCardType();
        creditCard.setCardType(CardType.findByValue((String)cardType));
        if (StringUtils.isNotEmpty((String)transaction.getCardTrack())) {
            return this.createCard(transaction.getCardTrack(), cardType);
        }
        String cardNumber = transaction.getCardNumber();
        String cardExpMonth = transaction.getCardExpMonth();
        String cardExpYear = transaction.getCardExpYear();
        this.validateCreditCardInfo(cardNumber, cardExpMonth, cardExpYear);
        return this.createCard(cardNumber, cardExpMonth, cardExpYear, cardType);
    }

    private void validateCreditCardInfo(String cardNumber, String cardExpMonth, String cardExpYear) {
        List<String> inputList = Arrays.asList(cardNumber, cardExpMonth, cardExpYear);
        for (String input : inputList) {
            if (!StringUtils.isEmpty((String)input)) continue;
            throw new PosException(Messages.getString("AuthorizeDotNetProcessor.16"));
        }
    }

    private CreditCard createCard(String cardTrack, String cardType) {
        CreditCard creditCard = CreditCard.createCreditCard();
        creditCard.setCardType(CardType.findByValue((String)cardType));
        String[] tracks = cardTrack.split(";");
        creditCard.setTrack1(tracks[0]);
        if (tracks.length > 1) {
            creditCard.setTrack2(";" + tracks[1]);
        }
        return creditCard;
    }

    private CreditCard createCard(String cardNumber, String expMonth, String expYear, String cardType) {
        CreditCard creditCard = CreditCard.createCreditCard();
        creditCard.setCardType(CardType.findByValue((String)cardType));
        creditCard.setExpirationYear(expYear);
        creditCard.setExpirationMonth(expMonth);
        creditCard.setCreditCardNumber(cardNumber);
        return creditCard;
    }

    private Merchant createMerchant(PosTransaction transaction) throws Exception {
        String apiLoginID = transaction.getProperty(AUTHORIZE_NET_LOGIN_ID, CardConfig.getMerchantAccount());
        String transactionKey = transaction.getProperty(AUTHORIZE_NET_TRANS_KEY, CardConfig.getMerchantPass());
        Environment environment = this.createEnvironment();
        if (POSUtil.getBoolean(transaction.getProperty("online_transaction"))) {
            Store store = DataProvider.get().getStore();
            apiLoginID = store.getProperty("online_order.auth_net.apiLoginId");
            transactionKey = store.getProperty("online_order.auth_net.merchantId");
            environment = this.createEnvironmentFromStore(store);
        }
        Merchant merchant = Merchant.createMerchant((Environment)environment, (String)apiLoginID, (String)transactionKey);
        merchant.setDeviceType(DeviceType.VIRTUAL_TERMINAL);
        merchant.setMarketType(MarketType.RETAIL);
        transaction.addProperty(AUTHORIZE_NET_LOGIN_ID, apiLoginID);
        transaction.addProperty(AUTHORIZE_NET_TRANS_KEY, transactionKey);
        ApiOperationBase.setEnvironment((Environment)environment);
        MerchantAuthenticationType merchantAuthenticationType = new MerchantAuthenticationType();
        merchantAuthenticationType.setName(apiLoginID);
        merchantAuthenticationType.setTransactionKey(transactionKey);
        ApiOperationBase.setMerchantAuthentication((MerchantAuthenticationType)merchantAuthenticationType);
        return merchant;
    }

    private Environment createEnvironmentFromStore(Store store) {
        boolean isSandboxMode = POSUtil.getBoolean(store.getProperty("online_order.auth_net.sandbox_mode"));
        Environment environment = Environment.PRODUCTION;
        if (isSandboxMode) {
            environment = Environment.SANDBOX;
        }
        return environment;
    }

    private Environment createEnvironment() {
        Environment environment = Environment.PRODUCTION;
        if (CardConfig.isSandboxMode()) {
            environment = Environment.SANDBOX;
        }
        return environment;
    }

    public static void main(String[] args) throws Exception {
        BankCardMagneticTrack track = BankCardMagneticTrack.from((String)"%B4111111111111111^SHAH/RIAR^1803101000000000020000831000000?;4111111111111111=1803101000020000831?");
    }

    @Override
    public void voidTransaction(PosTransaction transaction) throws Exception {
        Merchant merchant = this.createMerchant(transaction);
        Transaction voidTransaction = merchant.createAIMTransaction(TransactionType.VOID, new BigDecimal(transaction.getAmount()));
        voidTransaction.setTransactionId(transaction.getCardTransactionId());
        Result result = (Result)merchant.postTransaction((net.authorize.Transaction)voidTransaction);
        if (!result.isApproved()) {
            if (result.isDeclined()) {
                throw new Exception(Messages.getString("AuthorizeDotNetProcessor.10") + ((ResponseReasonCode)result.getResponseReasonCodes().get(0)).getReasonText());
            }
            throw new Exception(Messages.getString("AuthorizeDotNetProcessor.11") + ((ResponseReasonCode)result.getResponseReasonCodes().get(0)).getReasonText());
        }
        transaction.setCardTransactionId(result.getTransId());
        transaction.setCardAuthCode(result.getAuthCode());
        transaction.setVoided(true);
        this.populateCardInformation(transaction, (Result<Transaction>)result);
    }

    @Override
    public String getCardInformationForReceipt(PosTransaction transaction) {
        return null;
    }

    private void populateCardInformation(PosTransaction transaction, Result<Transaction> result) {
        CreditCard card;
        if (result.getTarget() != null && (card = ((Transaction)result.getTarget()).getCreditCard()) != null) {
            transaction.setCardType(card.getCardType().name());
            transaction.setCardNumber(card.getCreditCardNumber());
            if (StringUtils.isNotEmpty((String)card.getTrack1())) {
                String rawTrackData = "%" + card.getTrack1() + "?;" + card.getTrack2() + "?";
                BankCardMagneticTrack track = BankCardMagneticTrack.from((String)rawTrackData);
                transaction.setCardHolderName(track.getTrack1().getName().toString());
                transaction.setCardExpYear(card.getExpirationYear());
                transaction.setCardExpMonth(card.getExpirationMonth());
            }
        }
    }

    @Override
    public void cancelTransaction() {
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void refundTransaction(PosTransaction transaction, double refundAmount) throws Exception {
        this.createMerchant(transaction);
        PaymentType paymentType = new PaymentType();
        CreditCardType creditCard = new CreditCardType();
        creditCard.setCardNumber(transaction.getCardNumber().replaceAll("X", ""));
        creditCard.setExpirationDate("XXXX");
        paymentType.setCreditCard(creditCard);
        TransactionRequestType txnRequest = new TransactionRequestType();
        txnRequest.setTransactionType(TransactionTypeEnum.REFUND_TRANSACTION.value());
        txnRequest.setRefTransId(transaction.getCardTransactionId());
        txnRequest.setAmount(new BigDecimal(String.valueOf(refundAmount)));
        txnRequest.setPayment(paymentType);
        CreateTransactionRequest apiRequest = new CreateTransactionRequest();
        apiRequest.setTransactionRequest(txnRequest);
        CreateTransactionController controller = new CreateTransactionController(apiRequest);
        controller.execute();
        CreateTransactionResponse response = (CreateTransactionResponse)controller.getApiResponse();
        if (response == null) throw new Exception(Messages.getString("AuthorizeDotNetProcessor.11") + Messages.getString("AuthorizeDotNetProcessor.38"));
        String errMsg = "";
        if (response.getMessages().getResultCode() == MessageTypeEnum.OK) {
            TransactionResponse result = response.getTransactionResponse();
            if (result.getMessages() != null) {
                transaction.setRefunded(true);
                PosLog.info(this.getClass(), "Successfully created transaction with Transaction ID: " + result.getTransId());
                PosLog.info(this.getClass(), "Response Code: " + result.getResponseCode());
                PosLog.info(this.getClass(), "Message Code: " + ((TransactionResponse.Messages.Message)result.getMessages().getMessage().get(0)).getCode());
                PosLog.info(this.getClass(), "Description: " + ((TransactionResponse.Messages.Message)result.getMessages().getMessage().get(0)).getDescription());
                PosLog.info(this.getClass(), "Auth Code: " + result.getAuthCode());
                return;
            }
            PosLog.info(this.getClass(), "Failed Transaction.");
            if (response.getTransactionResponse().getErrors() == null) return;
            PosLog.info(this.getClass(), "Error Code: " + ((TransactionResponse.Errors.Error)response.getTransactionResponse().getErrors().getError().get(0)).getErrorCode());
            errMsg = ((TransactionResponse.Errors.Error)response.getTransactionResponse().getErrors().getError().get(0)).getErrorText();
            PosLog.info(this.getClass(), "Error message: " + errMsg);
            throw new Exception(Messages.getString("AuthorizeDotNetProcessor.11") + errMsg);
        }
        PosLog.info(this.getClass(), "Failed Transaction.");
        if (response.getTransactionResponse() != null && response.getTransactionResponse().getErrors() != null) {
            errMsg = ((TransactionResponse.Errors.Error)response.getTransactionResponse().getErrors().getError().get(0)).getErrorText();
            PosLog.info(this.getClass(), "Error Code: " + ((TransactionResponse.Errors.Error)response.getTransactionResponse().getErrors().getError().get(0)).getErrorCode());
            PosLog.info(this.getClass(), "Error message: " + errMsg);
            throw new Exception(Messages.getString("AuthorizeDotNetProcessor.11") + errMsg);
        }
        errMsg = ((MessagesType.Message)response.getMessages().getMessage().get(0)).getText();
        PosLog.info(this.getClass(), "Error Code: " + ((MessagesType.Message)response.getMessages().getMessage().get(0)).getCode());
        PosLog.info(this.getClass(), "Error message: " + errMsg);
        throw new Exception(Messages.getString("AuthorizeDotNetProcessor.11") + errMsg);
    }
}

