/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views.payment;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.config.GiftCardConfig;
import com.floreantpos.extension.GiftCardPaymentPlugin;
import com.floreantpos.model.CardReader;
import com.floreantpos.model.GiftCard;
import com.floreantpos.model.PaymentType;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.GiftCardManagementView;
import com.floreantpos.ui.views.payment.CardInputListener;
import com.floreantpos.ui.views.payment.CardInputProcessor;
import com.floreantpos.ui.views.payment.GiftCardProcessor;
import com.floreantpos.ui.views.payment.ManualCardEntryDialog;
import com.floreantpos.ui.views.payment.SettleTicketProcessor;
import com.floreantpos.ui.views.payment.SwipeCardDialog;
import com.floreantpos.util.POSUtil;
import java.awt.Window;
import org.hibernate.StaleStateException;

public class GiftCardInputListener
implements CardInputListener {
    private SettleTicketProcessor settleTicketProcessor;

    public GiftCardInputListener(SettleTicketProcessor settleTicketProcessor) {
        this.settleTicketProcessor = settleTicketProcessor;
    }

    @Override
    public void cardInputted(CardInputProcessor inputter, PaymentType selectedPaymentType, String cardType) {
        Window focusedWindow = POSUtil.getFocusedWindow();
        try {
            switch (selectedPaymentType) {
                case GIFT_CERTIFICATE: {
                    this.giftCardInputted(inputter, selectedPaymentType, cardType);
                    break;
                }
            }
        }
        catch (StaleStateException x) {
            POSMessageDialog.showMessageDialogWithReloadButton(focusedWindow, this.settleTicketProcessor.getRefreshableView());
        }
        catch (PosException e) {
            POSMessageDialog.showError(focusedWindow, e.getMessage());
        }
        catch (Exception e) {
            POSMessageDialog.showError(focusedWindow, Messages.getString("SettleTicketProcessor.1"), e);
        }
    }

    private void giftCardInputted(CardInputProcessor inputter, PaymentType selectedPaymentType, String cardType) throws Exception {
        PosTransaction transaction = selectedPaymentType.createTransaction();
        transaction.setTicket(this.settleTicketProcessor.getTicket());
        GiftCardPaymentPlugin giftCardPaymentGateway = GiftCardConfig.getPaymentGateway();
        if (giftCardPaymentGateway == null) {
            throw new PosException(Messages.getString("SettleTicketProcessor.3"));
        }
        GiftCardProcessor giftCardProcessor = giftCardPaymentGateway.getProcessor();
        if (inputter instanceof SwipeCardDialog) {
            SwipeCardDialog swipeGiftCardDialog = (SwipeCardDialog)inputter;
            String cardNo = swipeGiftCardDialog.getCardString();
            giftCardProcessor.validateCardNo(cardNo);
            transaction.setCardType(cardType);
            transaction.setGiftCertNumber(cardNo);
            transaction.setCaptured(false);
            transaction.setCardMerchantGateway(giftCardPaymentGateway.getProductName());
            transaction.setCardReader(CardReader.SWIPE.name());
            this.settleTicketProcessor.setTransactionAmounts(transaction);
            giftCardProcessor.chargeAmount(transaction);
            this.settleTicketProcessor.settleTicket(transaction);
        } else if (inputter instanceof ManualCardEntryDialog) {
            ManualCardEntryDialog mDialog = (ManualCardEntryDialog)inputter;
            giftCardProcessor.validateCardNo(mDialog.getCardNo());
            transaction.setCaptured(false);
            transaction.setCardMerchantGateway(giftCardPaymentGateway.getProductName());
            transaction.setCardReader(CardReader.MANUAL.name());
            transaction.setCardHolderName(mDialog.getCardHolderName());
            transaction.setGiftCertNumber(mDialog.getCardNo());
            transaction.setCardExpMonth(mDialog.getExpMonth());
            transaction.setCardExpYear(mDialog.getExpYear());
            this.settleTicketProcessor.setTransactionAmounts(transaction);
            giftCardProcessor.chargeAmount(transaction);
            this.settleTicketProcessor.settleTicket(transaction);
        } else if (inputter instanceof GiftCardManagementView) {
            GiftCardManagementView mDialog = (GiftCardManagementView)inputter;
            GiftCard selectedGiftCard = mDialog.getSelectedGiftCard();
            giftCardProcessor.validateCardNo(selectedGiftCard.getCardNumber());
            transaction.setCaptured(false);
            transaction.setCardMerchantGateway(giftCardPaymentGateway.getProductName());
            transaction.setCardReader(CardReader.MANUAL.name());
            transaction.setCardHolderName(selectedGiftCard.getOwnerName());
            transaction.setGiftCertNumber(selectedGiftCard.getCardNumber());
            this.settleTicketProcessor.setTransactionAmounts(transaction);
            giftCardProcessor.chargeAmount(transaction);
            this.settleTicketProcessor.settleTicket(transaction);
        }
    }
}

