/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views.payment;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.config.CardConfig;
import com.floreantpos.model.PaymentType;
import com.floreantpos.model.ext.CardTypeEnum;
import com.floreantpos.swing.FixedLengthDocument;
import com.floreantpos.swing.POSTextField;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.QwertyKeyPad;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.payment.AuthorizationCodeDialog;
import com.floreantpos.ui.views.payment.CardInputListener;
import com.floreantpos.ui.views.payment.CardInputProcessor;
import com.floreantpos.ui.views.payment.SwipeCardDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public class ManualCardEntryDialog
extends POSDialog
implements CardInputProcessor {
    private CardInputListener cardInputListener;
    private POSTextField tfCardNo;
    private POSTextField tfExpMonth;
    private POSTextField tfExpYear;
    private POSTextField tfCardHolderName;
    private POSTextField tfCardCVV;
    private PaymentType paymentType;

    public ManualCardEntryDialog(CardInputListener cardInputListener, PaymentType paymentType) {
        this.cardInputListener = cardInputListener;
        this.paymentType = paymentType;
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.setTitle("Card informations");
        this.createUI();
    }

    private void createUI() {
        this.setPreferredSize(new Dimension(PosUIManager.getSize(900), PosUIManager.getSize(600)));
        JPanel panel = new JPanel();
        panel.setLayout((LayoutManager)new MigLayout("fill", "[][grow]", "[][][][][][][][grow]"));
        JLabel lblCardHolderName = new JLabel(Messages.getString("CARD_HOLDER_NAME"));
        panel.add((Component)lblCardHolderName, "cell 0 1,alignx trailing");
        this.tfCardHolderName = new POSTextField();
        this.tfCardHolderName.setColumns(20);
        panel.add((Component)this.tfCardHolderName, "cell 1 1");
        JLabel lblCardNumber = new JLabel(Messages.getString("CardNumber"));
        panel.add((Component)lblCardNumber, "cell 0 2,alignx trailing");
        this.tfCardNo = new POSTextField();
        this.tfCardNo.setColumns(20);
        this.tfCardNo.setDocument(new FixedLengthDocument(16));
        panel.add((Component)this.tfCardNo, "cell 1 2");
        JLabel lblExpieryMonth = new JLabel(Messages.getString("ManualCardEntryDialog.6"));
        panel.add((Component)lblExpieryMonth, "cell 0 3,alignx trailing");
        this.tfExpMonth = new POSTextField();
        this.tfExpMonth.setColumns(4);
        this.tfExpMonth.setDocument(new FixedLengthDocument(2));
        panel.add((Component)this.tfExpMonth, "cell 1 3");
        JLabel lblExpieryYear = new JLabel(Messages.getString("ManualCardEntryDialog.9"));
        panel.add((Component)lblExpieryYear, "cell 0 4,alignx trailing");
        this.tfExpYear = new POSTextField();
        this.tfExpYear.setColumns(4);
        this.tfExpYear.setDocument(new FixedLengthDocument(4));
        panel.add((Component)this.tfExpYear, "cell 1 4");
        JLabel lblCardCVV = new JLabel(Messages.getString("ManualCardEntryDialog.0"));
        panel.add((Component)lblCardCVV, "cell 0 5,alignx trailing");
        this.tfCardCVV = new POSTextField();
        this.tfCardCVV.setColumns(4);
        this.tfCardCVV.setDocument(new FixedLengthDocument(9));
        panel.add((Component)this.tfCardCVV, "cell 1 5");
        QwertyKeyPad qwertyKeyPad = new QwertyKeyPad();
        JPanel centerPanel = new JPanel(new BorderLayout());
        centerPanel.setBorder(BorderFactory.createEmptyBorder(5, 3, 5, 5));
        centerPanel.add((Component)panel, "North");
        centerPanel.add((Component)((Object)qwertyKeyPad), "Center");
        this.getContentPane().add((Component)centerPanel, "Center");
        JPanel panel_1 = new JPanel();
        this.getContentPane().add((Component)panel_1, "South");
        panel_1.setLayout(new BorderLayout(0, 0));
        JPanel panel_2 = new JPanel((LayoutManager)new MigLayout("al center"));
        panel_1.add(panel_2);
        PosButton btnSwipeCard = new PosButton();
        panel_2.add((Component)btnSwipeCard, "grow");
        btnSwipeCard.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ManualCardEntryDialog.this.openSwipeCardDialog();
            }
        });
        btnSwipeCard.setText(Messages.getString("ManualCardEntryDialog.13"));
        PosButton btnSubmit = new PosButton();
        panel_2.add((Component)btnSubmit, "grow");
        btnSubmit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ManualCardEntryDialog.this.submitCard();
            }
        });
        btnSubmit.setText(Messages.getString("ManualCardEntryDialog.15"));
        PosButton btnCancel = new PosButton();
        panel_2.add((Component)btnCancel, "grow");
        btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ManualCardEntryDialog.this.setCanceled(true);
                ManualCardEntryDialog.this.dispose();
            }
        });
        btnCancel.setText(Messages.getString("CANCEL"));
        JSeparator separator = new JSeparator();
        panel_1.add((Component)separator, "North");
        TitlePanel titlePanel = new TitlePanel();
        titlePanel.setTitle(Messages.getString("ManualCardEntryDialog.17"));
        this.getContentPane().add((Component)titlePanel, "North");
        if (!CardConfig.isSwipeCardSupported()) {
            btnSwipeCard.setEnabled(false);
        }
    }

    protected void openAuthorizationCodeEntryDialog() {
        this.setCanceled(true);
        this.dispose();
        AuthorizationCodeDialog dialog = new AuthorizationCodeDialog(this.cardInputListener, this.paymentType);
        dialog.pack();
        dialog.open();
    }

    protected void submitCard() {
        try {
            String cardHolderName = this.getCardHolderName();
            String cardNo = this.getCardNo();
            String expMonth = this.getExpMonth();
            String expYear = this.getExpYear();
            if (StringUtils.isBlank((String)cardHolderName)) {
                throw new PosException("Please enter card holder name");
            }
            if (StringUtils.isBlank((String)cardNo)) {
                throw new PosException("Please enter card number");
            }
            if (StringUtils.isBlank((String)expMonth)) {
                throw new PosException("Please enter expiry month");
            }
            if (StringUtils.isBlank((String)expYear)) {
                throw new PosException("Please enter expiry year");
            }
            this.setCanceled(false);
            this.dispose();
            CardTypeEnum detectedCardType = CardTypeEnum.detect(cardNo);
            String cardTypeNameString = "";
            if (detectedCardType != null) {
                cardTypeNameString = detectedCardType.name();
                PosLog.debug(this.getClass(), cardTypeNameString);
            }
            this.cardInputListener.cardInputted(this, this.paymentType, cardTypeNameString);
        }
        catch (PosException e) {
            POSMessageDialog.showError(e.getMessage());
        }
    }

    private void openSwipeCardDialog() {
        this.setCanceled(true);
        this.dispose();
        SwipeCardDialog swipeCardDialog = new SwipeCardDialog(this.cardInputListener, this.paymentType, (boolean)Boolean.FALSE, Boolean.FALSE);
        swipeCardDialog.pack();
        swipeCardDialog.open();
    }

    public String getCardHolderName() {
        return this.tfCardHolderName.getText();
    }

    public String getCardNo() {
        return this.tfCardNo.getText();
    }

    public String getExpMonth() {
        return this.tfExpMonth.getText();
    }

    public String getExpYear() {
        return this.tfExpYear.getText();
    }

    public String getCardCVV() {
        return this.tfCardCVV.getText();
    }
}

