/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views.payment;

import com.floreantpos.Messages;
import com.floreantpos.config.AppProperties;
import com.floreantpos.main.Application;
import com.floreantpos.model.PaymentType;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.ReversalTransaction;
import com.floreantpos.model.StoreSession;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.PosTransactionDAO;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.swing.ListTableModel;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosScrollPane;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.PosTableRenderer;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import net.miginfocom.swing.MigLayout;

public class SessionBasedTransactionBrowser
extends POSDialog {
    private JTable table;
    private TransactionListTableModel tableModel;

    public SessionBasedTransactionBrowser() {
        this.setTitle(AppProperties.getAppName());
        this.init();
        this.initData();
    }

    private void initData() {
        StoreSession storeSession = DataProvider.get().getStoreSession();
        List<PosTransaction> transactionList = PosTransactionDAO.getInstance().getStoreSessionTransactions(storeSession);
        this.tableModel.setRows(transactionList);
    }

    private void init() {
        this.setLayout(new BorderLayout(5, 5));
        TitlePanel titlePanel = new TitlePanel();
        titlePanel.setTitle(Messages.getString("SessionBasedTransactionBrowser.0"));
        this.add((Component)titlePanel, "North");
        this.table = new JTable();
        this.tableModel = new TransactionListTableModel();
        this.table.setModel(this.tableModel);
        this.table.setRowHeight(PosUIManager.getSize(40));
        this.table.setAutoResizeMode(3);
        this.table.setDefaultRenderer(Object.class, new PosTableRenderer());
        this.table.setGridColor(Color.LIGHT_GRAY);
        PosScrollPane scrollPane = new PosScrollPane(this.table, 20, 31);
        JScrollBar scrollBar = scrollPane.getVerticalScrollBar();
        scrollBar.setPreferredSize(PosUIManager.getSize(30, 60));
        JPanel centerPanel = new JPanel((LayoutManager)new MigLayout("fill"));
        TitledBorder border = BorderFactory.createTitledBorder(null, Messages.getString("SessionBasedTransactionBrowser.2"), 2, 0);
        centerPanel.setBorder(border);
        centerPanel.add((Component)scrollPane, "grow");
        this.add((Component)centerPanel, "Center");
        JPanel buttonPanel = new JPanel((LayoutManager)new MigLayout("center"));
        PosButton btnReverse = new PosButton(Messages.getString("DELETE"));
        btnReverse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SessionBasedTransactionBrowser.this.doRevertTransaction();
            }
        });
        PosButton btnClose = new PosButton(Messages.getString("SessionBasedTransactionBrowser.6"));
        btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SessionBasedTransactionBrowser.this.dispose();
            }
        });
        buttonPanel.add(btnReverse);
        buttonPanel.add(btnClose);
        this.add((Component)buttonPanel, "South");
    }

    private void doRevertTransaction() {
        int index = this.table.getSelectedRow();
        if (index < 0) {
            return;
        }
        int option = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), Messages.getString("SessionBasedTransactionBrowser.7"), Messages.getString("SessionBasedTransactionBrowser.8"));
        if (option != 0) {
            return;
        }
        index = this.table.convertRowIndexToModel(index);
        PosTransaction transaction = (PosTransaction)this.tableModel.getRowData(index);
        Ticket ticket = transaction.getTicket();
        TicketDAO.getInstance().loadFullTicket(ticket);
        double dueAmount = ticket.getDueAmount();
        double transactionAmount = transaction.getAmount();
        ticket.setDueAmount(dueAmount + transactionAmount);
        ticket.setPaidAmount(0.0);
        ticket.setPaid(false);
        ticket.setClosed(false);
        ticket.setClosingDate(null);
        ticket.getTransactions().remove(transaction);
        ReversalTransaction reversalTransaction = new ReversalTransaction();
        reversalTransaction.setPaymentType(PaymentType.CASH);
        reversalTransaction.setTicket(ticket);
        reversalTransaction.setCaptured(true);
        reversalTransaction.setAmount(transactionAmount);
        reversalTransaction.setTransactionTime(new Date());
        reversalTransaction.setTerminal(Application.getInstance().getTerminal());
        reversalTransaction.setUser(ticket.getOwner());
        reversalTransaction.setNote(Messages.getString("SessionBasedTransactionBrowser.9") + (Object)((Object)transaction.getPaymentType()));
        PosTransactionDAO.getInstance().saveReversalTransaction(ticket, transaction, reversalTransaction);
        this.tableModel.deleteItem(transaction);
        this.tableModel.fireTableDataChanged();
        this.table.repaint();
        this.table.revalidate();
    }

    private class TransactionListTableModel
    extends ListTableModel<PosTransaction> {
        public TransactionListTableModel() {
            super(new String[]{Messages.getString("SessionBasedTransactionBrowser.10"), Messages.getString("SessionBasedTransactionBrowser.11"), Messages.getString("SessionBasedTransactionBrowser.12"), Messages.getString("SessionBasedTransactionBrowser.13"), Messages.getString("SessionBasedTransactionBrowser.14"), Messages.getString("SessionBasedTransactionBrowser.15"), Messages.getString("SessionBasedTransactionBrowser.16"), Messages.getString("SessionBasedTransactionBrowser.17")});
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            PosTransaction transaction = (PosTransaction)this.rows.get(rowIndex);
            Ticket ticket = transaction.getTicket();
            switch (columnIndex) {
                case 0: {
                    return transaction.getId();
                }
                case 1: {
                    return ticket.getId();
                }
                case 2: {
                    User owner = ticket.getOwner();
                    if (owner == null) {
                        return null;
                    }
                    return owner.getFirstName();
                }
                case 3: {
                    return transaction.getTransactionTime();
                }
                case 4: {
                    return transaction.getPaymentType().getDisplayString();
                }
                case 5: {
                    return transaction.getTipsAmount();
                }
                case 6: {
                    return transaction.getAmount() - transaction.getTipsAmount();
                }
                case 7: {
                    return transaction.getAmount();
                }
            }
            return null;
        }
    }
}

