/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.util;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Random;
import org.apache.commons.lang.StringUtils;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.id.IdentifierGenerator;

public class GlobalIdGenerator
implements IdentifierGenerator {
    public Serializable generate(SessionImplementor session, Object object) throws HibernateException {
        Class<?> clazz = object.getClass();
        Object generatedId = null;
        try {
            Object id;
            Method method = clazz.getMethod("getId", null);
            if (method != null && (id = method.invoke(object, (Object[])null)) != null) {
                generatedId = (Serializable)id;
            }
        }
        catch (Exception method) {
            // empty catch block
        }
        if (generatedId == null) {
            generatedId = this.generate();
        }
        try {
            String barcode;
            Method methodGetBarcode = clazz.getMethod("getBarcode", null);
            if (methodGetBarcode != null && StringUtils.isEmpty((String)(barcode = (String)methodGetBarcode.invoke(object, (Object[])null)))) {
                barcode = generatedId.toString();
                Method methodSetBarcode = clazz.getMethod("setBarcode", String.class);
                methodSetBarcode.invoke(object, barcode);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return generatedId;
    }

    public String generate() {
        return GlobalIdGenerator.generateGlobalId();
    }

    public static String generateGlobalId() {
        long currentTimeMillis = System.currentTimeMillis();
        Random random = new Random();
        for (int i = 0; i < 3; ++i) {
            currentTimeMillis += (long)random.nextInt();
        }
        String idString = String.valueOf(currentTimeMillis);
        int length = idString.length();
        if (length == 16) {
            return idString;
        }
        if (length > 16) {
            return idString.substring(0, 16);
        }
        for (int i = 0; i < 16 - length; ++i) {
            char c = (char)(random.nextInt(26) + 97);
            idString = c + idString;
        }
        return idString;
    }
}

