/*
 * Decompiled with CFR 0.152.
 */
package com.foretees.salesforce.sync;

import com.floreantpos.model.Store;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.JsonUtil;
import com.floreantpos.util.POSUtil;
import com.foretees.salesforce.sync.MemberSyncable;
import com.foretees.salesforce.sync.SFDateUtil;
import com.foretees.salesforce.sync.SFUtil;
import com.foretees.salesforce.sync.SalesForceSyncable;
import com.foretees.salesforce.sync.SyncView;
import java.util.Date;
import java.util.Iterator;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonValue;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Session;
import org.hibernate.Transaction;

public class EmployeeSyncable
implements SalesForceSyncable {
    private SyncView syncView;
    private int count;

    @Override
    public void doSync() throws Exception {
        if (this.syncView == null) {
            return;
        }
        Date syncDate = new Date();
        JsonArray usersArray = SFUtil.getUsers();
        if (usersArray == null) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "No data to sync.");
            this.syncView.setCanceled(true);
            this.syncView.dispose();
            return;
        }
        int maxSize = usersArray.size();
        this.syncView.setProgressMaximum(maxSize);
        this.count = 0;
        this.saveUsers(usersArray, syncDate);
    }

    public void saveUsers(JsonArray readArray, Date syncDate) throws Exception {
        Session session = null;
        Transaction transaction = null;
        try {
            session = UserDAO.getInstance().createNewSession();
            transaction = session.beginTransaction();
            Iterator iterator = readArray.iterator();
            while (iterator.hasNext()) {
                this.syncView.checkCancelStatus();
                JsonObject employeeObject = (JsonObject)iterator.next();
                String id = JsonUtil.getStringValue((JsonValue)employeeObject.get((Object)"Id"));
                String firstName = JsonUtil.getStringValue((JsonValue)employeeObject.get((Object)"firstName"));
                String lastName = JsonUtil.getStringValue((JsonValue)employeeObject.get((Object)"lastName"));
                String status = JsonUtil.getStringValue((JsonValue)employeeObject.get((Object)"status"));
                User user = UserDAO.getInstance().get(id);
                boolean newItem = false;
                if (user == null) {
                    user = new User();
                    user.setId(id);
                    newItem = true;
                    user.setRoot(true);
                }
                user.setFirstName(firstName);
                user.setLastName(lastName);
                user.setDeleted(false);
                boolean active = false;
                if (StringUtils.isNotEmpty((String)status)) {
                    active = status.equals("Active");
                }
                user.setActive(active);
                if (newItem) {
                    UserDAO.getInstance().save(user, session);
                } else {
                    UserDAO.getInstance().update(user, session);
                }
                MemberSyncable.extractAndSaveMember(employeeObject);
                this.syncView.setProgressValue(++this.count);
            }
            transaction.commit();
            this.doUpdateSyncTime(syncDate);
        }
        catch (Exception e) {
            transaction.rollback();
            throw e;
        }
        finally {
            if (session != null && session.isOpen()) {
                session.close();
            }
        }
    }

    private void doUpdateSyncTime(Date syncDate) {
        try {
            DataProvider.get().refreshStore();
            Store store = DataProvider.get().getStore();
            store.addProperty("salesforce.employeeSyncTime", SFDateUtil.formatDateAsSFFormat(syncDate));
            StoreDAO.getInstance().saveOrUpdate(store);
            DataProvider.get().refreshStore();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public SyncView getSyncView() {
        return this.syncView;
    }

    public void setSyncView(SyncView syncView) {
        this.syncView = syncView;
    }
}

