/*
 * Decompiled with CFR 0.152.
 */
package com.foretees.salesforce.sync;

import com.floreantpos.PosLog;
import com.floreantpos.model.FinancialAccount;
import com.floreantpos.model.InventoryUnit;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.Store;
import com.floreantpos.model.Tax;
import com.floreantpos.model.TaxGroup;
import com.floreantpos.model.dao.FinancialAccountDAO;
import com.floreantpos.model.dao.InventoryUnitDAO;
import com.floreantpos.model.dao.MenuGroupDAO;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.dao.TaxDAO;
import com.floreantpos.model.dao.TaxGroupDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.JsonUtil;
import com.floreantpos.util.POSUtil;
import com.foretees.salesforce.sync.SFAuth;
import com.foretees.salesforce.sync.SFDateUtil;
import com.foretees.salesforce.sync.SFUtil;
import com.foretees.salesforce.sync.SalesForceSyncable;
import com.foretees.salesforce.sync.SyncView;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonValue;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Session;
import org.hibernate.Transaction;

public class ItemSyncable
implements SalesForceSyncable {
    private SyncView syncView;
    private int count;

    @Override
    public void doSync() throws Exception {
        if (this.syncView == null) {
            return;
        }
        if (!SFAuth.login()) {
            this.syncView.setCanceled(true);
            this.syncView.dispose();
            return;
        }
        String lastSyncTime = this.getSFItemSyncTime();
        PosLog.debug(this.getClass(), "last sync time: " + lastSyncTime);
        Date syncedTime = new Date();
        JsonArray menuItemsArray = SFUtil.getMenuItems(lastSyncTime);
        JsonArray taxArray = SFUtil.getTaxGroups();
        JsonArray financialAccountJsonArray = SFUtil.getFinancialAccounts();
        if (menuItemsArray == null) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "No data to sync.");
            this.syncView.setCanceled(true);
            this.syncView.dispose();
            return;
        }
        int maxSize = menuItemsArray.size() + (taxArray != null ? taxArray.size() : 0) + (financialAccountJsonArray != null ? financialAccountJsonArray.size() : 0);
        this.syncView.setProgressMaximum(maxSize);
        this.count = 0;
        this.saveMenuItems(menuItemsArray, syncedTime);
        if (taxArray == null) {
            this.syncView.setCanceled(false);
            return;
        }
        this.saveTaxes(taxArray);
        if (financialAccountJsonArray == null) {
            this.syncView.setCanceled(false);
            return;
        }
        this.saveOrUpdateFinancialAccount(financialAccountJsonArray);
    }

    private void saveOrUpdateFinancialAccount(JsonArray financialAccountJsonArray) {
        Iterator iterator = financialAccountJsonArray.iterator();
        while (iterator.hasNext()) {
            this.syncView.checkCancelStatus();
            Date synetime = StoreDAO.getServerTimestamp();
            JsonObject itemObject = (JsonObject)iterator.next();
            String id = JsonUtil.getStringValue((JsonValue)itemObject.get((Object)"financialAccountSFId"));
            String name = JsonUtil.getStringValue((JsonValue)itemObject.get((Object)"financialAccountName"));
            FinancialAccountDAO instance = FinancialAccountDAO.getInstance();
            FinancialAccount financialAccount = instance.get(id);
            if (financialAccount == null) {
                financialAccount = new FinancialAccount();
                financialAccount.setId(id);
                financialAccount.setName(name);
                financialAccount.setLastSyncTime(synetime);
                instance.save(financialAccount);
            } else {
                financialAccount.setName(name);
                financialAccount.setLastSyncTime(synetime);
                instance.update(financialAccount);
            }
            this.syncView.setProgressValue(++this.count);
        }
    }

    private void saveTaxes(JsonArray taxArray) {
        Iterator iterator = taxArray.iterator();
        while (iterator.hasNext()) {
            this.syncView.checkCancelStatus();
            JsonObject itemObject = (JsonObject)iterator.next();
            String name = JsonUtil.getStringValue((JsonValue)itemObject.get((Object)"Name"));
            String type = JsonUtil.getStringValue((JsonValue)itemObject.get((Object)"Type"));
            String subType = JsonUtil.getStringValue((JsonValue)itemObject.get((Object)"SubType"));
            String scName = JsonUtil.getStringValue((JsonValue)itemObject.get((Object)"SCName"));
            String billingRecordType = JsonUtil.getStringValue((JsonValue)itemObject.get((Object)"billingRecordType"));
            boolean taxOnServiceCharge = itemObject.getBoolean("TaxOnSErviceCharge");
            boolean serviceChargeApplicable = itemObject.getBoolean("SCApplicable");
            double serviceCharge = JsonUtil.getDoubleValue((JsonValue)itemObject.get((Object)"SC"));
            JsonObject taxesObj = itemObject.getJsonObject("Taxes");
            ArrayList<Tax> newTaxes = new ArrayList<Tax>();
            for (Object entry : taxesObj.entrySet()) {
                String taxNameUnformatted = (String)entry.getKey();
                double taxRate = 0.0;
                try {
                    String value = entry.getValue().toString().replaceAll("^\"|\"$", "");
                    taxRate = Double.parseDouble(value);
                }
                catch (NumberFormatException value) {
                    // empty catch block
                }
                String taxName = ItemSyncable.formatName(taxNameUnformatted);
                Tax tax = TaxDAO.getInstance().get(taxNameUnformatted);
                if (tax == null) {
                    tax = TaxDAO.getInstance().get(taxName);
                }
                if (tax == null) {
                    tax = new Tax();
                    tax.setId(taxNameUnformatted);
                    tax.setName(taxName);
                    tax.setSfName(taxNameUnformatted);
                    tax.setRate(taxRate);
                    tax.setEnable(true);
                    TaxDAO.getInstance().save(tax);
                } else {
                    tax.setRate(taxRate);
                    tax.setName(taxName);
                    tax.setSfName(taxNameUnformatted);
                    TaxDAO.getInstance().update(tax);
                }
                newTaxes.add(tax);
            }
            TaxGroup taxGroup = TaxGroupDAO.getInstance().get(name);
            if (taxGroup == null) {
                Object entry;
                taxGroup = new TaxGroup();
                taxGroup.setId(name);
                taxGroup.setName(name);
                taxGroup.setServiceChargeName(scName);
                TaxGroupDAO.getInstance().save(taxGroup);
                entry = newTaxes.iterator();
                while (entry.hasNext()) {
                    Tax tax = (Tax)entry.next();
                    taxGroup.addTotaxes(tax);
                }
            } else {
                List<Tax> taxes = taxGroup.getTaxes();
                for (Tax tax : newTaxes) {
                    if (taxes.contains(tax)) continue;
                    taxes.add(tax);
                }
                Iterator<Tax> iterator2 = taxes.iterator();
                while (iterator2.hasNext()) {
                    Tax tax = iterator2.next();
                    if (newTaxes.contains(tax)) continue;
                    iterator2.remove();
                }
            }
            taxGroup.setType(type);
            taxGroup.setSubType(subType);
            taxGroup.setBillingRecordType(billingRecordType);
            taxGroup.setTaxOnServiceCharge(taxOnServiceCharge);
            taxGroup.setServiceCharge(serviceCharge);
            taxGroup.setServiceChargeName(scName);
            taxGroup.setServiceChargeApplicable(serviceChargeApplicable);
            TaxGroupDAO.getInstance().saveOrUpdate(taxGroup);
            this.syncView.setProgressValue(++this.count);
        }
    }

    public void saveMenuItems(JsonArray readArray, Date syncedTime) throws Exception {
        Transaction transaction = null;
        try (Session session = null;){
            session = MenuItemDAO.getInstance().createNewSession();
            transaction = session.beginTransaction();
            Iterator iterator = readArray.iterator();
            while (iterator.hasNext()) {
                this.syncView.checkCancelStatus();
                JsonObject itemObject = (JsonObject)iterator.next();
                String id = JsonUtil.getStringValue((JsonValue)itemObject.get((Object)"Id"));
                String name = JsonUtil.getStringValue((JsonValue)itemObject.get((Object)"recordName"));
                double price = JsonUtil.getDoubleValue((JsonValue)itemObject.get((Object)"price"));
                double retailPrice = JsonUtil.getDoubleValue((JsonValue)itemObject.get((Object)"retailPrice"));
                String typeStr = JsonUtil.getStringValue((JsonValue)itemObject.get((Object)"type"));
                String subTypeStr = JsonUtil.getStringValue((JsonValue)itemObject.get((Object)"subType"));
                String itemCodeStr = JsonUtil.getStringValue((JsonValue)itemObject.get((Object)"itemCode"));
                String lastUpdateDate = JsonUtil.getStringValue((JsonValue)itemObject.get((Object)"lastModifiedDate"));
                String barcode = JsonUtil.getStringValue((JsonValue)itemObject.get((Object)"barCode"));
                String description = JsonUtil.getStringValue((JsonValue)itemObject.get((Object)"description"));
                String unitName = JsonUtil.getStringValue((JsonValue)itemObject.get((Object)"unitOfMeasure"));
                String group = JsonUtil.getStringValue((JsonValue)itemObject.get((Object)"posGroup"));
                boolean isInventoryItem = JsonUtil.getBoolean(itemObject, "isInventoryItem");
                boolean isActive = JsonUtil.getBoolean(itemObject, "isActive");
                MenuItem menuItem = MenuItemDAO.getInstance().get(id, session);
                boolean newItem = false;
                if (menuItem == null) {
                    menuItem = new MenuItem();
                    menuItem.setId(id);
                    menuItem.setShouldPrintToKitchen(false);
                    newItem = true;
                }
                menuItem.setName(name);
                menuItem.setPrice(price);
                menuItem.setRetailPrice(retailPrice);
                menuItem.setCmsItemCode(itemCodeStr);
                menuItem.setCmsTypeName(typeStr);
                menuItem.setCmsSubTypeName(subTypeStr);
                menuItem.setBarcode(barcode);
                menuItem.setDescription(description);
                menuItem.setInventoryItem(isInventoryItem);
                menuItem.setVisible(isActive);
                if (unitName != null) {
                    InventoryUnit inventoryUnit = InventoryUnitDAO.getInstance().findByName(unitName);
                    if (inventoryUnit == null) {
                        inventoryUnit = new InventoryUnit();
                        inventoryUnit.setName(unitName);
                        inventoryUnit.setCode(String.valueOf(unitName.charAt(0)).toLowerCase());
                        InventoryUnitDAO.getInstance().save(inventoryUnit);
                    }
                    menuItem.setUnit(inventoryUnit);
                }
                if (group != null) {
                    MenuGroup menuGroup = MenuGroupDAO.getInstance().findMenuGroupByName(group);
                    if (menuGroup == null) {
                        menuGroup = new MenuGroup();
                        menuGroup.setName(group);
                        menuGroup.setVisible(true);
                        MenuGroupDAO.getInstance().save(menuGroup);
                    }
                    menuItem.setMenuGroup(menuGroup);
                }
                Date lastUpdate = StringUtils.isNotEmpty((String)lastUpdateDate) ? SFDateUtil.parseBySFDate(lastUpdateDate) : null;
                menuItem.setLastUpdateDate(lastUpdate);
                if (newItem) {
                    MenuItemDAO.getInstance().save(menuItem, session);
                } else {
                    MenuItemDAO.getInstance().update(menuItem, session);
                }
                this.syncView.setProgressValue(this.count++);
            }
            transaction.commit();
            this.doUpdateSyncTime(syncedTime);
        }
    }

    private void doUpdateSyncTime(Date syncedTime) {
        try {
            DataProvider.get().refreshStore();
            Store store = DataProvider.get().getStore();
            String currentTimeInGmt = SFDateUtil.formatDateAsSFFormat(syncedTime);
            store.addProperty("salesforce.itemSyncTime", currentTimeInGmt);
            StoreDAO.getInstance().saveOrUpdate(store);
            DataProvider.get().refreshStore();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static String formatName(String name) {
        name = name.replaceAll("_c", "");
        name = name.replaceAll("_Percentage", "");
        name = name.replaceAll("_", " ");
        return name.trim();
    }

    public SyncView getSyncView() {
        return this.syncView;
    }

    public void setSyncView(SyncView syncView) {
        this.syncView = syncView;
    }

    private String getSFItemSyncTime() {
        Store store = DataProvider.get().getStore();
        return store.getProperty("salesforce.itemSyncTime");
    }
}

