/*
 * Decompiled with CFR 0.152.
 */
package com.foretees.salesforce.sync;

import com.floreantpos.main.Application;
import com.floreantpos.model.Store;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.swing.POSTextField;
import com.floreantpos.ui.dialog.OkCancelOptionDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.AESencrp;
import com.floreantpos.util.POSUtil;
import java.awt.Component;
import java.awt.HeadlessException;
import java.awt.LayoutManager;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public class LoginDialog
extends OkCancelOptionDialog {
    private JTextField tfUserName;
    private JPasswordField tfPassword;
    private JPasswordField tfSecurityToken;
    private POSTextField tfLoginUrl;
    private POSTextField tfClientId;
    private JPasswordField tfClientSecret;
    private Store store;

    public LoginDialog() throws HeadlessException {
        super(POSUtil.getFocusedWindow());
        this.setTitle("Salesforce login failure");
        this.setCaption("Please enter salesforce credential");
        this.initComponents();
        this.initData();
    }

    private void initComponents() {
        JPanel panel = new JPanel((LayoutManager)new MigLayout());
        this.tfUserName = new JTextField(30);
        this.tfPassword = new JPasswordField(30);
        JLabel lblSecurityToken = new JLabel("Security token");
        this.tfSecurityToken = new JPasswordField(30);
        JLabel lblLoginUrl = new JLabel("Login url");
        this.tfLoginUrl = new POSTextField(30);
        JLabel lblClientId = new JLabel("Client id");
        this.tfClientId = new POSTextField(30);
        JLabel lblClientSecret = new JLabel("Client secret");
        this.tfClientSecret = new JPasswordField(30);
        panel.add(new JLabel("User name:"));
        panel.add((Component)this.tfUserName, "wrap");
        panel.add(new JLabel("Password:"));
        panel.add((Component)this.tfPassword, "wrap");
        panel.add((Component)lblSecurityToken, "");
        panel.add((Component)this.tfSecurityToken, "wrap");
        panel.add((Component)lblLoginUrl, "");
        panel.add((Component)this.tfLoginUrl, "wrap");
        panel.add((Component)lblClientId, "");
        panel.add((Component)this.tfClientId, "wrap");
        panel.add((Component)lblClientSecret, "");
        panel.add((Component)this.tfClientSecret, "wrap");
        this.getContentPanel().add(panel);
    }

    private void initData() {
        try {
            Application.getInstance().refreshStore();
            this.store = Application.getInstance().getStore();
            this.tfUserName.setText(this.store.getProperty("salesforce.username"));
            String password = this.store.getProperty("salesforce.password");
            String securityToken = this.store.getProperty("salesforce.securityToken");
            this.tfLoginUrl.setText(this.store.getProperty("salesforce.loginurl"));
            this.tfClientId.setText(this.store.getProperty("salesforce.clientId"));
            String clientSecret = this.store.getProperty("salesforce.clientSecret");
            if (StringUtils.isNotEmpty((String)password)) {
                password = AESencrp.decrypt((String)password);
                this.tfPassword.setText(password);
            }
            if (StringUtils.isNotEmpty((String)securityToken)) {
                securityToken = AESencrp.decrypt((String)securityToken);
                this.tfSecurityToken.setText(securityToken);
            }
            if (StringUtils.isNotEmpty((String)clientSecret)) {
                clientSecret = AESencrp.decrypt((String)clientSecret);
                this.tfClientSecret.setText(clientSecret);
            }
        }
        catch (Exception e) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e.getMessage(), e);
        }
    }

    @Override
    public void doOk() {
        try {
            String username = this.tfUserName.getText();
            String password = new String(this.tfPassword.getPassword());
            String securityToken = new String(this.tfSecurityToken.getPassword());
            String loginUrl = this.tfLoginUrl.getText();
            String clientId = this.tfClientId.getText();
            String clientSecret = new String(this.tfClientSecret.getPassword());
            if (StringUtils.isEmpty((String)username)) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "Please enter username.");
                return;
            }
            if (StringUtils.isEmpty((String)password)) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "Please enter password.");
                return;
            }
            if (StringUtils.isEmpty((String)securityToken)) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "Please enter security token.");
                return;
            }
            if (StringUtils.isEmpty((String)loginUrl)) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "Please enter login url.");
                return;
            }
            if (StringUtils.isEmpty((String)clientId)) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "Please enter client id.");
                return;
            }
            if (StringUtils.isEmpty((String)clientSecret)) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "Please enter client secret.");
                return;
            }
            this.store.addProperty("salesforce.username", username);
            this.store.addProperty("salesforce.loginurl", loginUrl);
            this.store.addProperty("salesforce.clientId", clientId);
            if (StringUtils.isNotEmpty((String)password)) {
                String encryptedPassword = AESencrp.encrypt((String)password);
                this.store.addProperty("salesforce.password", encryptedPassword);
            }
            if (StringUtils.isNotEmpty((String)securityToken)) {
                String encryptedSecurityToken = AESencrp.encrypt((String)securityToken);
                this.store.addProperty("salesforce.securityToken", encryptedSecurityToken);
            }
            if (StringUtils.isNotEmpty((String)clientSecret)) {
                String encryptedClientSecret = AESencrp.encrypt((String)clientSecret);
                this.store.addProperty("salesforce.clientSecret", encryptedClientSecret);
            }
            StoreDAO.getInstance().saveOrUpdate(this.store);
        }
        catch (Exception e) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e.getMessage(), e);
        }
        this.setCanceled(false);
        this.dispose();
    }
}

