/*
 * Decompiled with CFR 0.152.
 */
package com.foretees.salesforce.sync;

import com.floreantpos.PosLog;
import com.floreantpos.config.AppConfig;
import com.floreantpos.model.Discount;
import com.floreantpos.model.Store;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.util.DataProvider;
import com.foretees.salesforce.sync.SFAuth;
import com.foretees.salesforce.sync.SFConnectionException;
import com.foretees.salesforce.sync.SFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashSet;
import java.util.List;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonReader;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public class SFUtil {
    private static final String SERVICE_QUERY_URL = "/services/data/v20.0/query/?q=";
    private static final String SERVICE_GET_CHARGE_ITEM = "getChargeItems";
    private static final String SERVICE_GET_EMPLOYEES = "getEmployees";
    private static final String SERVICE_GET_TAX_AND_SERVICE_AMOUNTS = "getTaxAndServiceAmounts";
    private static final String SERVICE_FINANCIAL_ACCOUNTS = "getPromotionFinancialAccounts";
    private static final String SERVICE_GET_SYNCABLE_MEMBERS = "getSyncableMembers";
    private static final String SERVICE_GET_SYNCABLE_MEMBER_CREDIT_BOOKS = "getMembersCreditBooks&member=";
    private static final String SERVICE_GET_CREDIT_BOOKS = "getCreditBooks";
    private static final String SERVICE_GET_CREDIT_BOOK_TYPES = "getCreditBookTypes";
    private static final String SERVICE_GET_GUESTS = "getGuests";
    private static final String SERVICE_GET_MEMBER_PREFERENCES = "getMemberPref&memberId=";
    private static final String SERVICE_UPDATE_TICKETS = "updateTicket";
    private static final String SERVICE_UPDATE_ITEMS = "updateChargeItems";
    private static final String SERVICE_MEMBER_PAYMENT = "memberPayment";
    private static final String SERVICE_MEMBER_REFUND = "memberRefund";
    public static final HashSet<String> ACTIVE_STATUSES = new HashSet<String>(Arrays.asList("Active", "Reinstated"));
    public static final HashSet<String> OVERRIDEABLE_STATUSES = new HashSet<String>(Arrays.asList("Suspended"));
    private static final String SERVICE_GET_SALES_AREAS = "getSalesArea";
    private static final String SERVICE_GET_MIN_SPEND = "getMemberMinimums&member_id=";
    private static Log logger = LogFactory.getLog(SFUtil.class);
    private static final String SERVICE_UPDATE_INVENTORY_COUNT = "updateInventoryCount";
    private static final String mEMBER_SELECTION_QUERY = "SELECT Id,Customer_Id__c, FirstName, LastName, Name, Status__c, Realtime_Account_Balance__c, Photo_Attachment_Id__c, Appetizers_Preference__c, Billing_Statement_Preference__c, Cocktail_Preference__c, Dessert_Preference__c, Entree_Preference__c,Golf_Ball_Preference__c FROM Contact";

    public static String getNowFormatted() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        Calendar cal = Calendar.getInstance();
        return dateFormat.format(cal.getTime());
    }

    public static Boolean isActiveCustomer(String custId, Integer numRetries) throws SFConnectionException, SFException {
        Boolean isActive = false;
        Integer statusCode = null;
        Integer n = numRetries;
        Integer n2 = numRetries = Integer.valueOf(numRetries - 1);
        try {
            HttpClient httpclient = SFAuth.createHttpClint();
            String url = SFAuth.getInstanceUrl() + "/services/apexrest/club62/C62RESTServices?function=getIsActiveCustomer&custId=" + URLEncoder.encode(custId, "UTF-8");
            HttpGet httpGet = new HttpGet(url);
            httpGet.setHeader("Authorization", "OAuth " + SFAuth.getAccessToken());
            HttpResponse response = httpclient.execute((HttpUriRequest)httpGet);
            statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                String sfdcError = EntityUtils.toString((HttpEntity)response.getEntity());
                System.out.println("SFDC error:" + statusCode + " : " + sfdcError);
                throw new SFException(sfdcError, statusCode);
            }
            String getResult = null;
            getResult = EntityUtils.toString((HttpEntity)response.getEntity());
            if ((getResult = getResult.replaceAll("\"", "")) != null && getResult.equalsIgnoreCase("true")) {
                isActive = true;
            }
            httpGet.releaseConnection();
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)(SFUtil.getNowFormatted() + "SFDC Error"), (Throwable)e);
            if (numRetries >= 0) {
                SFAuth.login();
                return SFUtil.isActiveCustomer(custId, numRetries);
            }
            throw new SFException(e.getMessage(), statusCode);
        }
        return isActive;
    }

    public static JSONArray getMembers(String str, String searchField, Integer numRetries) throws SFConnectionException, SFException {
        Integer n = numRetries;
        Integer n2 = numRetries = Integer.valueOf(numRetries - 1);
        JSONArray results = null;
        Integer statusCode = null;
        try {
            HttpClient httpclient = SFAuth.createHttpClint();
            URI url = new URIBuilder().setScheme("https").setHost(SFAuth.getInstanceUrlWithoutProtocol() + "/services/data/v31.0").setPath("/query").setParameter("q", "SELECT Id,Customer_Id__c, FirstName, LastName, Name, Status__c, Realtime_Account_Balance__c, Photo_Attachment_Id__c, Appetizers_Preference__c, Billing_Statement_Preference__c, Cocktail_Preference__c, Dessert_Preference__c, Entree_Preference__c,Golf_Ball_Preference__c FROM Contact WHERE Name like '%" + str + "%'").build();
            HttpGet httpGet = new HttpGet(url);
            httpGet.setHeader("Authorization", "OAuth " + SFAuth.getAccessToken());
            HttpResponse response = httpclient.execute((HttpUriRequest)httpGet);
            statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                System.out.println("SFDC error:" + statusCode);
                String sfdcError = EntityUtils.toString((HttpEntity)response.getEntity());
                throw new SFException(sfdcError, statusCode);
            }
            String getResult = null;
            getResult = EntityUtils.toString((HttpEntity)response.getEntity());
            JSONObject jsonResult = new JSONObject(getResult);
            int totalSize = jsonResult.getInt("totalSize");
            System.out.println("Total records: " + totalSize);
            results = jsonResult.getJSONArray("records");
            httpGet.releaseConnection();
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)(SFUtil.getNowFormatted() + "SFDC Error"), (Throwable)e);
        }
        return results;
    }

    public static JSONArray getMembersById(String id, Integer numRetries) throws SFConnectionException, SFException {
        Integer n = numRetries;
        Integer n2 = numRetries = Integer.valueOf(numRetries - 1);
        JSONArray results = null;
        Integer statusCode = null;
        try {
            HttpClient httpclient = SFAuth.createHttpClint();
            URI url = new URIBuilder().setScheme("https").setHost(SFAuth.getInstanceUrlWithoutProtocol() + "/services/data/v31.0").setPath("/query").setParameter("q", "SELECT Id,Customer_Id__c,FirstName,LastName,Name,Status__c,Realtime_Account_Balance__c FROM Contact WHERE Id = '" + id + "'").build();
            HttpGet httpGet = new HttpGet(url);
            httpGet.setHeader("Authorization", "OAuth " + SFAuth.getAccessToken());
            HttpResponse response = httpclient.execute((HttpUriRequest)httpGet);
            statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                System.out.println("SFDC error:" + statusCode);
                String sfdcError = EntityUtils.toString((HttpEntity)response.getEntity());
                throw new SFException(sfdcError, statusCode);
            }
            String getResult = null;
            getResult = EntityUtils.toString((HttpEntity)response.getEntity());
            int index = getResult.indexOf("[");
            if (index >= 0) {
                getResult = getResult.substring(index);
                getResult = getResult.substring(0, getResult.lastIndexOf("}"));
            }
            getResult = getResult.replace("\\\"", "\"");
            results = new JSONArray(getResult);
            httpGet.releaseConnection();
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)(SFUtil.getNowFormatted() + "SFDC Error"), (Throwable)e);
            if (numRetries >= 0) {
                SFAuth.login();
                return SFUtil.getMembersById(id, numRetries);
            }
            throw new SFException(e.getMessage(), statusCode);
        }
        return results;
    }

    public static JSONArray getMemberTransaction(String field, String value) throws SFConnectionException, SFException {
        Integer statusCode = null;
        JSONArray results = new JSONArray();
        try {
            HttpClient httpclient = SFAuth.createHttpClint();
            URI uri = new URIBuilder().setScheme("https").setHost(SFAuth.getInstanceUrlWithoutProtocol() + "/services/data/v31.0").setPath("/query").setParameter("q", "SELECT Id, CreatedById, CreatedDate, IsDeleted, LastModifiedById, LastModifiedDate, Name, OwnerId, RecordTypeId, SystemModstamp, Adjustment_Reason__c, Amount_Adjusted__c, Amount_Discounted__c, Amount_Due__c, Amount_Paid__c, Amount_Refunded__c, Amount__c, Batch_Or_Inactive_Member_Transaction__c, Bill_To_Related_Customer__c, Chit_Processing__c, Comment__c, Cover_Count__c, Customer_Status_Flag__c, Customer__c, Date__c, Days_Old__c, Description__c, Discount_Reason__c, Do_Not_Apply_Discount__c, Do_Not_Map__c, Drink_Amount__c, Event_Charges__c, Facility__c, Financial_Account_Name__c, Folio__c, Food_Amount__c, Generic_Transaction__c, Gratuity_Amount__c, Hide_From_Member__c, Hotel_Tax__c, Insert_Index__c, Instructor__c, Internal_Notes__c, Is_Amount_Late_Fee__c, Late_Fee_Does_Not_Apply__c, Liability__c, Manual_Event_Transaction__c, Manual_Registration_Transaction__c, Manually_Created_Charge__c, Occupancy_Tax__c, Overridden_Hotel_Tax__c, Overridden_Occupancy_Tax__c, Overridden_Sales_Tax__c, Overridden_Unit_Tax__c, POS_Order_Id__c, Parent_Charge__c, Pass_Direct_Bill__c, Pass__c, Payment_Method_Id__c, Payment__c, Person__c, Posted_Date_Time__c, Posted__c, Price_Per_Unit__c, Quantity__c, Receivable__c, Revenue_Split_1_Amount__c, Revenue_Split_2_Amount__c, Sales_Tax__c, Separate_Charge__c, Server_Name__c, Status__c, SubType__c, Tax_Amount__c, Tax_Manual_Adjust_Flag__c, Total_Amount__c, Type__c, Unit_Tax__c, Who_is_Paying__c FROM Transaction__c WHERE Customer__c = " + value).build();
            HttpGet httpGet = new HttpGet(uri);
            httpGet.setHeader("Authorization", "OAuth " + SFAuth.getAccessToken());
            HttpResponse response = httpclient.execute((HttpUriRequest)httpGet);
            statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                System.out.println("SFDC error:" + statusCode);
                String sfdcError = EntityUtils.toString((HttpEntity)response.getEntity());
                throw new SFException(sfdcError, statusCode);
            }
            String getResult = null;
            getResult = EntityUtils.toString((HttpEntity)response.getEntity());
            JSONObject jObj = new JSONObject(getResult);
            if (jObj.getInt("totalSize") > 0) {
                results = jObj.getJSONArray("records");
            }
            httpGet.releaseConnection();
            return results;
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)(SFUtil.getNowFormatted() + "SFDC Error"), (Throwable)e);
            return null;
        }
    }

    public static JSONArray getMemberBalance(String field, String value) throws SFConnectionException, SFException {
        Integer statusCode = null;
        JSONArray results = new JSONArray();
        try {
            HttpClient httpclient = SFAuth.createHttpClint();
            URI uri = new URIBuilder().setScheme("https").setHost(SFAuth.getInstanceUrlWithoutProtocol() + "/services/data/v31.0").setPath("/query").setParameter("q", "SELECT Amount_Paid__c, Amount_Remaining__c, Amount__c FROM Receivable__c WHERE Customer__c = " + value).build();
            HttpGet httpGet = new HttpGet(uri);
            httpGet.setHeader("Authorization", "OAuth " + SFAuth.getAccessToken());
            HttpResponse response = httpclient.execute((HttpUriRequest)httpGet);
            statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                System.out.println("SFDC error:" + statusCode);
                String sfdcError = EntityUtils.toString((HttpEntity)response.getEntity());
                throw new SFException(sfdcError, statusCode);
            }
            String getResult = null;
            getResult = EntityUtils.toString((HttpEntity)response.getEntity());
            JSONObject jObj = new JSONObject(getResult);
            if (jObj.getInt("totalSize") > 0) {
                results = jObj.getJSONArray("records");
            }
            httpGet.releaseConnection();
            return results;
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)(SFUtil.getNowFormatted() + "SFDC Error"), (Throwable)e);
            return null;
        }
    }

    public static JSONArray getHouseHoldMember(String accountId, Integer numRetries) throws SFConnectionException, SFException {
        Integer n = numRetries;
        Integer n2 = numRetries = Integer.valueOf(numRetries - 1);
        Integer statusCode = null;
        JSONArray results = null;
        try {
            HttpClient httpclient = SFAuth.createHttpClint();
            URI uri = new URIBuilder().setScheme("https").setHost(SFAuth.getInstanceUrlWithoutProtocol() + "/services/data/v31.0").setPath("/query").setParameter("q", "SELECT Id, AccountId, CreatedById, FirstName, MailingAddress,LastName,Status__c, Name, OwnerId, Accounting_Notes__c, Company_Name__c, Customer_Id__c FROM Contact WHERE AccountId = '" + accountId + "' LIMIT 1").build();
            HttpGet httpGet = new HttpGet(uri);
            httpGet.setHeader("Authorization", "OAuth " + SFAuth.getAccessToken());
            HttpResponse response = httpclient.execute((HttpUriRequest)httpGet);
            statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                System.out.println("SFDC error:" + statusCode);
                String sfdcError = EntityUtils.toString((HttpEntity)response.getEntity());
                throw new SFException(sfdcError, statusCode);
            }
            String getResult = EntityUtils.toString((HttpEntity)response.getEntity());
            System.out.println(getResult);
            JSONObject jObj = new JSONObject(getResult);
            if (jObj.getInt("totalSize") > 0) {
                results = jObj.getJSONArray("records");
            }
            httpGet.releaseConnection();
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)(SFUtil.getNowFormatted() + "SFDC Error"), (Throwable)e);
            if (numRetries >= 0) {
                SFAuth.login();
                return SFUtil.getHouseHoldMember(accountId, numRetries);
            }
            throw new SFException(e.getMessage(), statusCode);
        }
        return results;
    }

    public static JSONArray getHouseHoldMemberByAccountName(String accountName, Integer numRetries) throws SFConnectionException, SFException {
        Integer n = numRetries;
        Integer n2 = numRetries = Integer.valueOf(numRetries - 1);
        Integer statusCode = null;
        JSONArray results = null;
        try {
            HttpClient httpclient = SFAuth.createHttpClint();
            URI uri = new URIBuilder().setScheme("https").setHost(SFAuth.getInstanceUrlWithoutProtocol() + "/services/data/v31.0").setPath("/query").setParameter("q", "SELECT Id, AccountId, CreatedById, FirstName, MailingAddress, Name, OwnerId, Account_Number__c, Accounting_Notes__c, Company_Name__c, Customer_Id__c FROM Contact WHERE Name = '" + accountName + "' LIMIT 1").build();
            HttpGet httpGet = new HttpGet(uri);
            httpGet.setHeader("Authorization", "OAuth " + SFAuth.getAccessToken());
            HttpResponse response = httpclient.execute((HttpUriRequest)httpGet);
            statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                System.out.println("SFDC error:" + statusCode);
                String sfdcError = EntityUtils.toString((HttpEntity)response.getEntity());
                throw new SFException(sfdcError, statusCode);
            }
            String getResult = EntityUtils.toString((HttpEntity)response.getEntity());
            JSONObject jObj = new JSONObject(getResult);
            if (jObj.getInt("totalSize") > 0) {
                results = jObj.getJSONArray("records");
            }
            httpGet.releaseConnection();
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)(SFUtil.getNowFormatted() + "SFDC Error"), (Throwable)e);
            if (numRetries >= 0) {
                SFAuth.login();
                return SFUtil.getHouseHoldMember(accountName, numRetries);
            }
            throw new SFException(e.getMessage(), statusCode);
        }
        return results;
    }

    public static JSONObject getMemberById(String memberId, Integer numRetries) throws SFConnectionException, SFException {
        Integer n = numRetries;
        Integer n2 = numRetries = Integer.valueOf(numRetries - 1);
        Integer statusCode = null;
        JSONArray results = null;
        try {
            HttpClient httpclient = SFAuth.createHttpClint();
            URI uri = new URIBuilder().setScheme("https").setHost(SFAuth.getInstanceUrlWithoutProtocol() + "/services/data/v31.0").setPath("/query").setParameter("q", "SELECT Id,AccountId, OwnerId, Name FROM Contact WHERE Id = '" + memberId + "' LIMIT 1").build();
            HttpGet httpGet = new HttpGet(uri);
            httpGet.setHeader("Authorization", "OAuth " + SFAuth.getAccessToken());
            HttpResponse response = httpclient.execute((HttpUriRequest)httpGet);
            statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                System.out.println("SFDC error:" + statusCode);
                String sfdcError = EntityUtils.toString((HttpEntity)response.getEntity());
                throw new SFException(sfdcError, statusCode);
            }
            String getResult = EntityUtils.toString((HttpEntity)response.getEntity());
            JSONObject jObj = new JSONObject(getResult);
            if (jObj.getInt("totalSize") > 0) {
                results = jObj.getJSONArray("records");
            }
            httpGet.releaseConnection();
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)(SFUtil.getNowFormatted() + "SFDC Error"), (Throwable)e);
            if (numRetries >= 0) {
                SFAuth.login();
                return SFUtil.getMemberById(memberId, numRetries);
            }
            throw new SFException(e.getMessage(), statusCode);
        }
        return (JSONObject)results.get(0);
    }

    public static JSONArray getHouseHoldMember() throws SFConnectionException, SFException {
        Integer statusCode = null;
        JSONArray results = new JSONArray();
        try {
            HttpClient httpclient = SFAuth.createHttpClint();
            URI uri = new URIBuilder().setScheme("https").setHost(SFAuth.getInstanceUrlWithoutProtocol() + "/services/data/v31.0").setPath("/query").setParameter("q", "SELECT Id, Name  FROM Account ").build();
            HttpGet httpGet = new HttpGet(uri);
            httpGet.setHeader("Authorization", "OAuth " + SFAuth.getAccessToken());
            HttpResponse response = httpclient.execute((HttpUriRequest)httpGet);
            statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                System.out.println("SFDC error:" + statusCode);
                String sfdcError = EntityUtils.toString((HttpEntity)response.getEntity());
                throw new SFException(sfdcError, statusCode);
            }
            String getResult = null;
            getResult = EntityUtils.toString((HttpEntity)response.getEntity());
            JSONObject jObj = new JSONObject(getResult);
            if (jObj.getInt("totalSize") > 0) {
                results = jObj.getJSONArray("records");
            }
            httpGet.releaseConnection();
            return results;
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)(SFUtil.getNowFormatted() + "SFDC Error"), (Throwable)e);
            return null;
        }
    }

    public static JSONArray getAllMembers() throws SFConnectionException, SFException {
        Integer statusCode = null;
        JSONArray results = new JSONArray();
        try {
            HttpClient httpclient = SFAuth.createHttpClint();
            URI uri = new URIBuilder().setScheme("https").setHost(SFAuth.getInstanceUrlWithoutProtocol() + "/services/data/v31.0").setPath("/query").setParameter("q", "SELECT Id, AccountId, CreatedById, FirstName, MailingAddress, Name  FROM Contact").build();
            HttpGet httpGet = new HttpGet(uri);
            httpGet.setHeader("Authorization", "OAuth " + SFAuth.getAccessToken());
            HttpResponse response = httpclient.execute((HttpUriRequest)httpGet);
            statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                System.out.println("SFDC error:" + statusCode);
                String sfdcError = EntityUtils.toString((HttpEntity)response.getEntity());
                throw new SFException(sfdcError, statusCode);
            }
            String getResult = null;
            getResult = EntityUtils.toString((HttpEntity)response.getEntity());
            JSONObject jObj = new JSONObject(getResult);
            if (jObj.getInt("totalSize") > 0) {
                results = jObj.getJSONArray("records");
            }
            httpGet.releaseConnection();
            return results;
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)(SFUtil.getNowFormatted() + "SFDC Error"), (Throwable)e);
            return null;
        }
    }

    public static JSONArray getMembersWithOwnerId() throws SFConnectionException, SFException {
        Integer statusCode = null;
        JSONArray results = new JSONArray();
        try {
            HttpClient httpclient = SFAuth.createHttpClint();
            URI uri = new URIBuilder().setScheme("https").setHost(SFAuth.getInstanceUrlWithoutProtocol() + "/services/data/v31.0").setPath("/query").setParameter("q", "SELECT FirstName,OwnerId FROM Contact WHERE AccountId = '001o000000gEC1BAAW' LIMIT 1").build();
            HttpGet httpGet = new HttpGet(uri);
            httpGet.setHeader("Authorization", "OAuth " + SFAuth.getAccessToken());
            HttpResponse response = httpclient.execute((HttpUriRequest)httpGet);
            statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                System.out.println("SFDC error:" + statusCode);
                String sfdcError = EntityUtils.toString((HttpEntity)response.getEntity());
                throw new SFException(sfdcError, statusCode);
            }
            String getResult = null;
            getResult = EntityUtils.toString((HttpEntity)response.getEntity());
            JSONObject jObj = new JSONObject(getResult);
            if (jObj.getInt("totalSize") > 0) {
                results = jObj.getJSONArray("records");
            }
            httpGet.releaseConnection();
            return results;
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)(SFUtil.getNowFormatted() + "SFDC Error"), (Throwable)e);
            return null;
        }
    }

    private static HttpResponse callSfService(String serviceName) throws Exception {
        HttpGet httpGet = null;
        try {
            if (!SFAuth.login()) {
                return null;
            }
            HttpClient httpclient = SFAuth.createHttpClint();
            URI uri = new URIBuilder().setScheme("https").setHost(SFAuth.getInstanceUrlWithoutProtocol() + SFUtil.getServiceUrl() + serviceName).build();
            httpGet = new HttpGet(uri);
            httpGet.setHeader("Authorization", "OAuth " + SFAuth.getAccessToken());
            System.out.println(uri);
            return httpclient.execute((HttpUriRequest)httpGet);
        }
        catch (Exception e) {
            PosLog.error(SFUtil.class, e.getMessage());
            if (httpGet != null) {
                httpGet.releaseConnection();
            }
            return null;
        }
    }

    public static HttpResponse postSfService(String postData, POST_SERVICE_TYPE serviceType) throws Exception {
        HttpPost httpPost = null;
        try {
            SFAuth.login();
            HttpClient httpclient = SFAuth.createHttpClint();
            String serviceName = POST_SERVICE_TYPE.get(serviceType.getValue());
            PosLog.debug(SFUtil.class, "calling service: " + serviceName);
            URI uri = new URIBuilder().setScheme("https").setHost(SFAuth.getInstanceUrlWithoutProtocol() + SFUtil.getServiceUrl() + serviceName).build();
            httpPost = new HttpPost(uri);
            StringEntity postingString = new StringEntity(postData);
            httpPost.addHeader("Content-type", "application/json");
            httpPost.addHeader("Authorization", "OAuth " + SFAuth.getAccessToken());
            httpPost.setEntity((HttpEntity)postingString);
            return httpclient.execute((HttpUriRequest)httpPost);
        }
        catch (Exception e) {
            PosLog.error(SFUtil.class, e.getMessage());
            if (httpPost != null) {
                httpPost.releaseConnection();
            }
            return null;
        }
    }

    public static HttpResponse postSfService(String postData, String serviceName) throws Exception {
        HttpPost httpPost = null;
        try {
            SFAuth.login();
            HttpClient httpclient = SFAuth.createHttpClint();
            PosLog.debug(SFUtil.class, "calling service: " + serviceName);
            URI uri = new URIBuilder().setScheme("https").setHost(SFAuth.getInstanceUrlWithoutProtocol() + SFUtil.getServiceUrl() + serviceName).build();
            httpPost = new HttpPost(uri);
            StringEntity postingString = new StringEntity(postData);
            httpPost.addHeader("Content-type", "application/json");
            httpPost.addHeader("Authorization", "OAuth " + SFAuth.getAccessToken());
            httpPost.setEntity((HttpEntity)postingString);
            return httpclient.execute((HttpUriRequest)httpPost);
        }
        catch (Exception e) {
            PosLog.error(SFUtil.class, e.getMessage());
            if (httpPost != null) {
                httpPost.releaseConnection();
            }
            return null;
        }
    }

    public static void postFJLAmountSfService() throws Exception {
        HttpPost httpPost = null;
        try {
            SFAuth.login();
            HttpClient httpclient = SFAuth.createHttpClint();
            PosLog.debug(SFUtil.class, "calling service: updateFJLAmount");
            URI uri = new URIBuilder().setScheme("https").setHost(SFAuth.getInstanceUrlWithoutProtocol() + "/services/apexrest/RESTServices?function=updateFJLAmount").build();
            httpPost = new HttpPost(uri);
            StringEntity postingString = new StringEntity(new JSONObject().toString());
            httpPost.addHeader("Content-type", "application/json");
            httpPost.addHeader("Authorization", "OAuth " + SFAuth.getAccessToken());
            httpPost.setEntity((HttpEntity)postingString);
            httpclient.execute((HttpUriRequest)httpPost);
        }
        catch (Exception e) {
            PosLog.error(SFUtil.class, e.getMessage());
        }
        if (httpPost != null) {
            httpPost.releaseConnection();
        }
    }

    private static HttpResponse callSfServiceQuery(String serviceName) {
        HttpGet httpGet = null;
        try {
            HttpClient httpclient = SFAuth.createHttpClint();
            URI uri = new URIBuilder().setScheme("https").setHost(SFAuth.getInstanceUrlWithoutProtocol() + SERVICE_QUERY_URL + serviceName).build();
            httpGet = new HttpGet(uri);
            httpGet.setHeader("Authorization", "OAuth " + SFAuth.getAccessToken());
            return httpclient.execute((HttpUriRequest)httpGet);
        }
        catch (Exception e) {
            PosLog.error(SFUtil.class, e.getMessage());
            httpGet.releaseConnection();
            return null;
        }
    }

    public static JsonArray getMenuItems(String lastUpdateTime) throws Exception {
        String serviceURL;
        HttpResponse response;
        Integer statusCode = null;
        if (lastUpdateTime != null) {
            lastUpdateTime = URLEncoder.encode(lastUpdateTime, "utf-8");
        }
        if ((response = SFUtil.callSfService(serviceURL = lastUpdateTime != null ? "getChargeItems&last_update_date=" + lastUpdateTime : SERVICE_GET_CHARGE_ITEM)) == null) {
            return null;
        }
        statusCode = response.getStatusLine().getStatusCode();
        if (statusCode != 200) {
            String sfdcError = EntityUtils.toString((HttpEntity)response.getEntity());
            throw new SFException(sfdcError, statusCode);
        }
        return SFUtil.getJsonArray(response);
    }

    public static JsonArray getErrorItems(String uniqueId) throws Exception {
        Integer statusCode = null;
        String serviceURL = "getPOSExceptions&uniqueid=" + uniqueId;
        HttpResponse response = SFUtil.callSfService(serviceURL);
        if (response == null) {
            return null;
        }
        statusCode = response.getStatusLine().getStatusCode();
        if (statusCode != 200) {
            String sfdcError = EntityUtils.toString((HttpEntity)response.getEntity());
            throw new SFException(sfdcError, statusCode);
        }
        return SFUtil.getJsonArray(response);
    }

    public static JsonArray getUsers() throws Exception {
        Integer statusCode = null;
        HttpResponse response = SFUtil.callSfService(SERVICE_GET_EMPLOYEES);
        if (response == null) {
            return null;
        }
        statusCode = response.getStatusLine().getStatusCode();
        if (statusCode != 200) {
            String sfdcError = EntityUtils.toString((HttpEntity)response.getEntity());
            throw new SFException(sfdcError, statusCode);
        }
        return SFUtil.getJsonArray(response);
    }

    private static JsonArray getJsonArray(HttpResponse response) throws IOException {
        String getResult = EntityUtils.toString((HttpEntity)response.getEntity());
        PosLog.debug(SFUtil.class, getResult);
        if (StringUtils.isEmpty((String)getResult)) {
            getResult = "[]";
        }
        JsonReader reader = Json.createReader((Reader)new StringReader(getResult));
        JsonArray readArray = reader.readArray();
        return readArray;
    }

    public static JsonArray getTaxGroups() throws Exception {
        Integer statusCode = null;
        HttpResponse response = SFUtil.callSfService(SERVICE_GET_TAX_AND_SERVICE_AMOUNTS);
        if (response == null) {
            return null;
        }
        statusCode = response.getStatusLine().getStatusCode();
        if (statusCode != 200) {
            String sfdcError = EntityUtils.toString((HttpEntity)response.getEntity());
            throw new SFException(sfdcError, statusCode);
        }
        return SFUtil.getJsonArray(response);
    }

    public static JsonArray getFinancialAccounts() throws Exception {
        Integer statusCode = null;
        HttpResponse response = SFUtil.callSfService(SERVICE_FINANCIAL_ACCOUNTS);
        if (response == null) {
            return null;
        }
        statusCode = response.getStatusLine().getStatusCode();
        if (statusCode != 200) {
            String sfdcError = EntityUtils.toString((HttpEntity)response.getEntity());
            throw new SFException(sfdcError, statusCode);
        }
        return SFUtil.getJsonArray(response);
    }

    public static JsonArray getCreditBooks() throws Exception {
        Integer statusCode = null;
        HttpResponse response = SFUtil.callSfService(SERVICE_GET_CREDIT_BOOKS);
        if (response == null) {
            return null;
        }
        statusCode = response.getStatusLine().getStatusCode();
        if (statusCode != 200) {
            String sfdcError = EntityUtils.toString((HttpEntity)response.getEntity());
            throw new SFException(sfdcError, statusCode);
        }
        return SFUtil.getJsonArray(response);
    }

    public static JsonArray getCreditBookTypes() throws Exception {
        Integer statusCode = null;
        HttpResponse response = SFUtil.callSfService(SERVICE_GET_CREDIT_BOOK_TYPES);
        if (response == null) {
            return null;
        }
        statusCode = response.getStatusLine().getStatusCode();
        if (statusCode != 200) {
            String sfdcError = EntityUtils.toString((HttpEntity)response.getEntity());
            throw new SFException(sfdcError, statusCode);
        }
        return SFUtil.getJsonArray(response);
    }

    public static JsonArray getMembers(String lastUpdateTime) throws Exception {
        String serviceName;
        HttpResponse response;
        Integer statusCode = null;
        if (StringUtils.isNotEmpty((String)lastUpdateTime)) {
            lastUpdateTime = URLEncoder.encode(lastUpdateTime, "utf-8");
        }
        if ((response = SFUtil.callSfService(serviceName = StringUtils.isNotEmpty((String)lastUpdateTime) ? "getSyncableMembers&last_update_date=" + lastUpdateTime : SERVICE_GET_SYNCABLE_MEMBERS)) == null) {
            return null;
        }
        statusCode = response.getStatusLine().getStatusCode();
        if (statusCode != 200) {
            String sfdcError = EntityUtils.toString((HttpEntity)response.getEntity());
            throw new SFException(sfdcError, statusCode);
        }
        return SFUtil.getJsonArray(response);
    }

    public static JsonArray getMemberCreditBooks(String memberId) throws Exception {
        Integer statusCode = null;
        String serviceName = SERVICE_GET_SYNCABLE_MEMBER_CREDIT_BOOKS + memberId;
        HttpResponse response = SFUtil.callSfService(serviceName);
        if (response == null) {
            return null;
        }
        statusCode = response.getStatusLine().getStatusCode();
        if (statusCode != 200) {
            String sfdcError = EntityUtils.toString((HttpEntity)response.getEntity());
            throw new SFException(sfdcError, statusCode);
        }
        return SFUtil.getJsonArray(response);
    }

    public static JsonArray getGuests() throws Exception {
        Integer statusCode = null;
        HttpResponse response = SFUtil.callSfService(SERVICE_GET_GUESTS);
        if (response == null) {
            return null;
        }
        statusCode = response.getStatusLine().getStatusCode();
        if (statusCode != 200) {
            String sfdcError = EntityUtils.toString((HttpEntity)response.getEntity());
            throw new SFException(sfdcError, statusCode);
        }
        return SFUtil.getJsonArray(response);
    }

    public static JsonArray getSalesAreas() throws Exception {
        Integer statusCode = null;
        HttpResponse response = SFUtil.callSfService(SERVICE_GET_SALES_AREAS);
        if (response == null) {
            return null;
        }
        statusCode = response.getStatusLine().getStatusCode();
        if (statusCode != 200) {
            String sfdcError = EntityUtils.toString((HttpEntity)response.getEntity());
            throw new SFException(sfdcError, statusCode);
        }
        return SFUtil.getJsonArray(response);
    }

    public static JsonArray getMembersGuestsEmployees() throws Exception {
        Integer statusCode = null;
        HttpResponse response = SFUtil.callSfService(SERVICE_GET_SYNCABLE_MEMBERS);
        if (response == null) {
            return null;
        }
        statusCode = response.getStatusLine().getStatusCode();
        if (statusCode != 200) {
            String sfdcError = EntityUtils.toString((HttpEntity)response.getEntity());
            throw new SFException(sfdcError, statusCode);
        }
        return SFUtil.getJsonArray(response);
    }

    public static JsonArray getMemberPreferences(String memberId) throws Exception {
        Integer statusCode = null;
        HttpResponse response = SFUtil.callSfService(SERVICE_GET_MEMBER_PREFERENCES + memberId);
        if (response == null) {
            return null;
        }
        statusCode = response.getStatusLine().getStatusCode();
        if (statusCode != 200) {
            String sfdcError = EntityUtils.toString((HttpEntity)response.getEntity());
            JSONArray jsonArray = new JSONArray(sfdcError);
            JSONObject jsonObject = jsonArray.getJSONObject(0);
            String message = (String)jsonObject.get("message");
            throw new SFException(message, statusCode);
        }
        return SFUtil.getJsonArray(response);
    }

    private static String formatJson(String jsonResult) {
        jsonResult = jsonResult.replaceAll("\\\\", "");
        jsonResult = StringUtils.substring((String)jsonResult, (int)1, (int)(jsonResult.length() - 1));
        return jsonResult;
    }

    public static JSONObject getFullMember(String memId, Integer numRetries) throws SFConnectionException, SFException {
        Integer n = numRetries;
        Integer n2 = numRetries = Integer.valueOf(numRetries - 1);
        Integer statusCode = null;
        JSONObject result = null;
        try {
            HttpClient httpclient = SFAuth.createHttpClint();
            String url = SFAuth.getInstanceUrl() + "/services/apexrest/club62/C62RESTServices?function=getFullMember&memId=" + URLEncoder.encode(memId, "UTF-8");
            HttpGet httpGet = new HttpGet(url);
            httpGet.setHeader("Authorization", "OAuth " + SFAuth.getAccessToken());
            HttpResponse response = httpclient.execute((HttpUriRequest)httpGet);
            statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                System.out.println("SFDC error:" + statusCode);
                String sfdcError = EntityUtils.toString((HttpEntity)response.getEntity());
                throw new SFException(sfdcError, statusCode);
            }
            String getResult = null;
            getResult = EntityUtils.toString((HttpEntity)response.getEntity());
            getResult = getResult.substring(1, getResult.length() - 1);
            getResult = getResult.replace("\\\"", "\"");
            getResult = getResult.replace("\\\"", "\"");
            result = new JSONArray(getResult).getJSONObject(0);
            httpGet.releaseConnection();
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)(SFUtil.getNowFormatted() + "SFDC Error"), (Throwable)e);
            if (numRetries >= 0) {
                SFAuth.login();
                return SFUtil.getFullMember(memId, numRetries);
            }
            throw new SFException(e.getMessage(), statusCode);
        }
        return result;
    }

    public static List<JSONObject> getMemberReservations(String memId, Integer numRetries) throws SFConnectionException, SFException {
        Integer n = numRetries;
        Integer n2 = numRetries = Integer.valueOf(numRetries - 1);
        Integer statusCode = null;
        ArrayList<JSONObject> result = null;
        try {
            HttpClient httpclient = SFAuth.createHttpClint();
            String url = SFAuth.getInstanceUrl() + "/services/apexrest/club62/C62RESTServices?function=getMemberReservations&memId=" + URLEncoder.encode(memId, "UTF-8");
            HttpGet httpGet = new HttpGet(url);
            httpGet.setHeader("Authorization", "OAuth " + SFAuth.getAccessToken());
            HttpResponse response = httpclient.execute((HttpUriRequest)httpGet);
            statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                System.out.println("SFDC error:" + statusCode);
                String sfdcError = EntityUtils.toString((HttpEntity)response.getEntity());
                throw new SFException(sfdcError, statusCode);
            }
            String getResult = null;
            getResult = EntityUtils.toString((HttpEntity)response.getEntity());
            getResult = getResult.substring(1, getResult.length() - 1);
            getResult = getResult.replace("\\\"", "\"");
            result = new ArrayList<JSONObject>();
            JSONArray jarr = new JSONArray(getResult);
            Integer i = 0;
            while (i < jarr.length()) {
                JSONObject jobj = jarr.getJSONObject(i.intValue());
                result.add(jobj);
                Integer n3 = i;
                Integer n4 = i = Integer.valueOf(i + 1);
            }
            httpGet.releaseConnection();
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)(SFUtil.getNowFormatted() + "SFDC Error"), (Throwable)e);
            if (numRetries >= 0) {
                SFAuth.login();
                return SFUtil.getMemberReservations(memId, numRetries);
            }
            throw new SFException(e.getMessage(), statusCode);
        }
        return result;
    }

    public static List<JSONObject> getMemberLessons(String memId, Integer numRetries) throws SFConnectionException, SFException {
        Integer n = numRetries;
        Integer n2 = numRetries = Integer.valueOf(numRetries - 1);
        Integer statusCode = null;
        ArrayList<JSONObject> result = null;
        try {
            HttpClient httpclient = SFAuth.createHttpClint();
            String url = SFAuth.getInstanceUrl() + "/services/apexrest/club62/C62RESTServices?function=getMemberLessons&memId=" + URLEncoder.encode(memId, "UTF-8");
            HttpGet httpGet = new HttpGet(url);
            httpGet.setHeader("Authorization", "OAuth " + SFAuth.getAccessToken());
            HttpResponse response = httpclient.execute((HttpUriRequest)httpGet);
            statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                System.out.println("SFDC error:" + statusCode);
                String sfdcError = EntityUtils.toString((HttpEntity)response.getEntity());
                throw new SFException(sfdcError, statusCode);
            }
            String getResult = null;
            getResult = EntityUtils.toString((HttpEntity)response.getEntity());
            getResult = getResult.substring(1, getResult.length() - 1);
            getResult = getResult.replace("\\\"", "\"");
            result = new ArrayList<JSONObject>();
            JSONArray jarr = new JSONArray(getResult);
            Integer i = 0;
            while (i < jarr.length()) {
                JSONObject jobj = jarr.getJSONObject(i.intValue());
                result.add(jobj);
                Integer n3 = i;
                Integer n4 = i = Integer.valueOf(i + 1);
            }
            httpGet.releaseConnection();
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)(SFUtil.getNowFormatted() + "SFDC Error"), (Throwable)e);
            if (numRetries >= 0) {
                SFAuth.login();
                return SFUtil.getMemberLessons(memId, numRetries);
            }
            throw new SFException(e.getMessage(), statusCode);
        }
        return result;
    }

    public static List<JSONObject> getMemberClasses(String memId, Integer numRetries) throws SFConnectionException, SFException {
        Integer n = numRetries;
        Integer n2 = numRetries = Integer.valueOf(numRetries - 1);
        Integer statusCode = null;
        ArrayList<JSONObject> result = null;
        try {
            HttpClient httpclient = SFAuth.createHttpClint();
            String url = SFAuth.getInstanceUrl() + "/services/apexrest/club62/C62RESTServices?function=getMemberClasses&memId=" + URLEncoder.encode(memId, "UTF-8");
            HttpGet httpGet = new HttpGet(url);
            httpGet.setHeader("Authorization", "OAuth " + SFAuth.getAccessToken());
            HttpResponse response = httpclient.execute((HttpUriRequest)httpGet);
            statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                System.out.println("SFDC error:" + statusCode);
                String sfdcError = EntityUtils.toString((HttpEntity)response.getEntity());
                throw new SFException(sfdcError, statusCode);
            }
            String getResult = null;
            getResult = EntityUtils.toString((HttpEntity)response.getEntity());
            getResult = getResult.substring(1, getResult.length() - 1);
            getResult = getResult.replace("\\\"", "\"");
            result = new ArrayList<JSONObject>();
            JSONArray jarr = new JSONArray(getResult);
            Integer i = 0;
            while (i < jarr.length()) {
                JSONObject jobj = jarr.getJSONObject(i.intValue());
                result.add(jobj);
                Integer n3 = i;
                Integer n4 = i = Integer.valueOf(i + 1);
            }
            httpGet.releaseConnection();
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)(SFUtil.getNowFormatted() + "SFDC Error"), (Throwable)e);
            if (numRetries >= 0) {
                SFAuth.login();
                return SFUtil.getMemberClasses(memId, numRetries);
            }
            throw new SFException(e.getMessage(), statusCode);
        }
        return result;
    }

    public static List<JSONObject> getMemberSubscriptions(String memId, Integer numRetries) throws SFConnectionException, SFException {
        Integer n = numRetries;
        Integer n2 = numRetries = Integer.valueOf(numRetries - 1);
        Integer statusCode = null;
        ArrayList<JSONObject> result = null;
        try {
            HttpClient httpclient = SFAuth.createHttpClint();
            String url = SFAuth.getInstanceUrl() + "/services/apexrest/club62/C62RESTServices?function=getMemberSubscriptions&memId=" + URLEncoder.encode(memId, "UTF-8");
            HttpGet httpGet = new HttpGet(url);
            httpGet.setHeader("Authorization", "OAuth " + SFAuth.getAccessToken());
            HttpResponse response = httpclient.execute((HttpUriRequest)httpGet);
            statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                System.out.println("SFDC error:" + statusCode);
                String sfdcError = EntityUtils.toString((HttpEntity)response.getEntity());
                throw new SFException(sfdcError, statusCode);
            }
            String getResult = null;
            getResult = EntityUtils.toString((HttpEntity)response.getEntity());
            getResult = getResult.substring(1, getResult.length() - 1);
            getResult = getResult.replace("\\\"", "\"");
            result = new ArrayList<JSONObject>();
            JSONArray jarr = new JSONArray(getResult);
            Integer i = 0;
            while (i < jarr.length()) {
                JSONObject jobj = jarr.getJSONObject(i.intValue());
                result.add(jobj);
                Integer n3 = i;
                Integer n4 = i = Integer.valueOf(i + 1);
            }
            httpGet.releaseConnection();
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)(SFUtil.getNowFormatted() + "SFDC Error"), (Throwable)e);
            if (numRetries >= 0) {
                SFAuth.login();
                return SFUtil.getMemberSubscriptions(memId, numRetries);
            }
            throw new SFException(e.getMessage(), statusCode);
        }
        return result;
    }

    public static List<JSONObject> getMemberStorages(String memId, Integer numRetries) throws SFConnectionException, SFException {
        Integer n = numRetries;
        Integer n2 = numRetries = Integer.valueOf(numRetries - 1);
        Integer statusCode = null;
        ArrayList<JSONObject> result = null;
        try {
            HttpClient httpclient = SFAuth.createHttpClint();
            String url = SFAuth.getInstanceUrl() + "/services/apexrest/club62/C62RESTServices?function=getMemberStorages&memId=" + URLEncoder.encode(memId, "UTF-8");
            HttpGet httpGet = new HttpGet(url);
            httpGet.setHeader("Authorization", "OAuth " + SFAuth.getAccessToken());
            HttpResponse response = httpclient.execute((HttpUriRequest)httpGet);
            statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                System.out.println("SFDC error:" + statusCode);
                String sfdcError = EntityUtils.toString((HttpEntity)response.getEntity());
                throw new SFException(sfdcError, statusCode);
            }
            String getResult = null;
            getResult = EntityUtils.toString((HttpEntity)response.getEntity());
            getResult = getResult.substring(1, getResult.length() - 1);
            getResult = getResult.replace("\\\"", "\"");
            result = new ArrayList<JSONObject>();
            JSONArray jarr = new JSONArray(getResult);
            Integer i = 0;
            while (i < jarr.length()) {
                JSONObject jobj = jarr.getJSONObject(i.intValue());
                result.add(jobj);
                Integer n3 = i;
                Integer n4 = i = Integer.valueOf(i + 1);
            }
            httpGet.releaseConnection();
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)(SFUtil.getNowFormatted() + "SFDC Error"), (Throwable)e);
            if (numRetries >= 0) {
                SFAuth.login();
                return SFUtil.getMemberStorages(memId, numRetries);
            }
            throw new SFException(e.getMessage(), statusCode);
        }
        return result;
    }

    public static Double getPassAmount(String passId, Integer numRetries) throws SFConnectionException, SFException {
        Integer n = numRetries;
        Integer n2 = numRetries = Integer.valueOf(numRetries - 1);
        Integer statusCode = null;
        Double dblReturn = null;
        try {
            JSONArray ja;
            JSONObject memberRecord;
            HttpClient httpclient = SFAuth.createHttpClint();
            URI uri = new URIBuilder().setScheme("https").setHost(SFAuth.getInstanceUrlWithoutProtocol() + "/services/data/v31.0").setPath("/query").setParameter("q", "SELECT Id,Amount_Left__c FROM Pass__c WHERE Name = '" + passId + "' LIMIT 1").build();
            HttpGet httpGet = new HttpGet(uri);
            httpGet.setHeader("Authorization", "OAuth " + SFAuth.getAccessToken());
            HttpResponse response = httpclient.execute((HttpUriRequest)httpGet);
            statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                System.out.println("SFDC error:" + statusCode);
                String sfdcError = EntityUtils.toString((HttpEntity)response.getEntity());
                throw new SFException(sfdcError, statusCode);
            }
            String getResult = null;
            getResult = EntityUtils.toString((HttpEntity)response.getEntity());
            JSONObject jObj = new JSONObject(getResult);
            if (jObj.getInt("totalSize") > 0 && (memberRecord = (JSONObject)(ja = jObj.getJSONArray("records")).get(0)).has("Amount_Left__c") && !memberRecord.isNull("Amount_Left__c")) {
                dblReturn = memberRecord.getDouble("Amount_Left__c");
            }
            httpGet.releaseConnection();
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)(SFUtil.getNowFormatted() + "SFDC Error"), (Throwable)e);
            if (numRetries >= 0) {
                SFAuth.login();
                return SFUtil.getPassAmount(passId, numRetries);
            }
            throw new SFException(e.getMessage(), statusCode);
        }
        return dblReturn;
    }

    public static List<Discount> getActiveDiscounts(String fromId, String fromType, Integer numRetries) throws SFConnectionException, SFException {
        Integer n = numRetries;
        Integer n2 = numRetries = Integer.valueOf(numRetries - 1);
        Object statusCode = null;
        ArrayList<Discount> results = new ArrayList<Discount>();
        return results;
    }

    public static List<JSONObject> getPacks(String memId, Integer numRetries) throws SFConnectionException, SFException {
        Integer n = numRetries;
        Integer n2 = numRetries = Integer.valueOf(numRetries - 1);
        Integer statusCode = null;
        ArrayList<JSONObject> results = new ArrayList<JSONObject>();
        try {
            HttpClient httpclient = SFAuth.createHttpClint();
            String url = SFAuth.getInstanceUrl() + "/services/apexrest/club62/C62RESTServices?function=getPacks&memId=" + URLEncoder.encode(memId, "UTF-8");
            HttpGet httpGet = new HttpGet(url);
            httpGet.setHeader("Authorization", "OAuth " + SFAuth.getAccessToken());
            HttpResponse response = httpclient.execute((HttpUriRequest)httpGet);
            statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                System.out.println("SFDC error:" + statusCode);
                String sfdcError = EntityUtils.toString((HttpEntity)response.getEntity());
                throw new SFException(sfdcError, statusCode);
            }
            String getResult = null;
            getResult = EntityUtils.toString((HttpEntity)response.getEntity());
            getResult = getResult.substring(1, getResult.length() - 1);
            getResult = getResult.replace("\\\"", "\"");
            JSONArray jarr = new JSONArray(getResult);
            Integer i = 0;
            while (i < jarr.length()) {
                JSONObject jobj = jarr.getJSONObject(i.intValue());
                results.add(jobj);
                Integer n3 = i;
                Integer n4 = i = Integer.valueOf(i + 1);
            }
            httpGet.releaseConnection();
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)(SFUtil.getNowFormatted() + "SFDC Error"), (Throwable)e);
            if (numRetries >= 0) {
                SFAuth.login();
                return SFUtil.getPacks(memId, numRetries);
            }
            throw new SFException(e.getMessage(), statusCode);
        }
        return results;
    }

    public static void postRefund(Ticket ticket, Integer numRetries) throws SFConnectionException, SFException {
        Integer n = numRetries;
        Integer n2 = numRetries = Integer.valueOf(numRetries - 1);
        Integer statusCode = null;
        try {
            HttpClient httpclient = SFAuth.createHttpClint();
            String url = SFAuth.getInstanceUrl() + "/services/apexrest/club62/C62RESTServices?function=postRefund&ticketId=" + URLEncoder.encode(String.valueOf(ticket.getId()), "UTF-8");
            HttpPost httpPost = new HttpPost(url);
            httpPost.setHeader("Authorization", "OAuth " + SFAuth.getAccessToken());
            HttpResponse response = httpclient.execute((HttpUriRequest)httpPost);
            statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                System.out.println("SFDC error:" + statusCode);
                String sfdcError = EntityUtils.toString((HttpEntity)response.getEntity());
                throw new SFException(sfdcError, statusCode);
            }
            String getResult = null;
            getResult = EntityUtils.toString((HttpEntity)response.getEntity());
            if ((getResult = getResult.replaceAll("\"", "")) != null && !getResult.equals("")) {
                throw new Exception(getResult);
            }
            httpPost.releaseConnection();
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)(SFUtil.getNowFormatted() + "SFDC Error"), (Throwable)e);
            if (numRetries >= 0) {
                SFAuth.login();
                SFUtil.postRefund(ticket, numRetries);
            }
            throw new SFException(e.getMessage(), statusCode);
        }
    }

    public static void deleteTransaction(Ticket ticket, Integer numRetries) throws Exception {
        Integer n = numRetries;
        Integer n2 = numRetries = Integer.valueOf(numRetries - 1);
        Integer statusCode = null;
        try {
            HttpClient httpclient = SFAuth.createHttpClint();
            String url = SFAuth.getInstanceUrl() + "/services/apexrest/club62/C62RESTServices?function=voidTransaction&ticketId=" + URLEncoder.encode(String.valueOf(ticket.getId()), "UTF-8");
            HttpPost httpPost = new HttpPost(url);
            httpPost.setHeader("Authorization", "OAuth " + SFAuth.getAccessToken());
            HttpResponse response = httpclient.execute((HttpUriRequest)httpPost);
            statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                System.out.println("SFDC error:" + statusCode);
                String sfdcError = EntityUtils.toString((HttpEntity)response.getEntity());
                throw new SFException(sfdcError, statusCode);
            }
            String getResult = null;
            getResult = EntityUtils.toString((HttpEntity)response.getEntity());
            if ((getResult = getResult.replaceAll("\"", "")) != null && !getResult.equals("")) {
                throw new Exception(getResult);
            }
            httpPost.releaseConnection();
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)(SFUtil.getNowFormatted() + "SFDC Error"), (Throwable)e);
            if (numRetries >= 0) {
                SFAuth.login();
                SFUtil.deleteTransaction(ticket, numRetries);
            }
            throw new SFException(e.getMessage(), statusCode);
        }
    }

    public static String getTime(Ticket ticket) {
        String time = "";
        return time;
    }

    public static void postTicketPDF(Ticket ticket, double paidAmount, String recordId, Integer numRetries) throws SFConnectionException, SFException {
        Integer n = numRetries;
        Integer n2 = numRetries = Integer.valueOf(numRetries - 1);
        Object statusCode = null;
    }

    public static void postRedemptionPDF(Ticket ticket, String recordId, Integer numRetries) throws SFConnectionException, SFException {
    }

    public static String[] getDiscountReasons() throws SFConnectionException, SFException {
        return SFUtil.getPicklistValues("Promotion__c", "Reason__c", true, 1);
    }

    public static String[] getTransactionTypes() throws SFConnectionException, SFException {
        return SFUtil.getPicklistValues("Transaction__c", "Type__c", true, 1);
    }

    private static String[] getPicklistValues(String objAPIName, String fieldAPIName, Boolean hasNull, Integer numRetries) throws SFConnectionException, SFException {
        Integer n = numRetries;
        Integer n2 = numRetries = Integer.valueOf(numRetries - 1);
        Integer statusCode = null;
        ArrayList<String> lstReturn = null;
        try {
            HttpClient httpclient = SFAuth.createHttpClint();
            URI uri = new URIBuilder().setScheme("https").setHost(SFAuth.getInstanceUrlWithoutProtocol() + "/services/data/v31.0").setPath("/sobjects/" + objAPIName + "/describe").build();
            HttpGet httpGet = new HttpGet(uri);
            httpGet.setHeader("Authorization", "OAuth " + SFAuth.getAccessToken());
            HttpResponse response = httpclient.execute((HttpUriRequest)httpGet);
            statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                System.out.println("SFDC error:" + statusCode);
                String sfdcError = EntityUtils.toString((HttpEntity)response.getEntity());
                throw new SFException(sfdcError, statusCode);
            }
            String getResult = null;
            getResult = EntityUtils.toString((HttpEntity)response.getEntity());
            JSONObject jObj = new JSONObject(getResult);
            if (jObj.has("fields")) {
                JSONArray fields = jObj.getJSONArray("fields");
                for (int i = 0; i < fields.length(); ++i) {
                    JSONObject field = fields.getJSONObject(i);
                    if (!field.has("name") || !field.getString("name").equals(fieldAPIName) || !field.has("picklistValues")) continue;
                    JSONArray picklistValues = field.getJSONArray("picklistValues");
                    lstReturn = new ArrayList<String>();
                    if (hasNull.booleanValue()) {
                        lstReturn.add(null);
                    }
                    for (int j = 0; j < picklistValues.length(); ++j) {
                        JSONObject picklistEntry = picklistValues.getJSONObject(j);
                        lstReturn.add(picklistEntry.getString("value"));
                    }
                }
            }
            httpGet.releaseConnection();
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)(SFUtil.getNowFormatted() + "SFDC Error"), (Throwable)e);
            if (numRetries >= 0) {
                SFAuth.login();
                SFUtil.getPicklistValues(objAPIName, fieldAPIName, hasNull, numRetries);
            }
            throw new SFException(e.getMessage(), statusCode);
        }
        String[] strReturn = null;
        if (lstReturn != null) {
            strReturn = new String[lstReturn.size()];
            Integer i = 0;
            while (i < lstReturn.size()) {
                strReturn[i.intValue()] = (String)lstReturn.get(i);
                Integer n3 = i;
                Integer n4 = i = Integer.valueOf(i + 1);
            }
        }
        return strReturn;
    }

    public static byte[] getPhoto(String id) throws SFConnectionException, SFException {
        Integer statusCode = null;
        try {
            HttpClient httpclient = SFAuth.createHttpClint();
            String url = "https://" + SFAuth.getInstanceUrlWithoutProtocol() + "/services/data/v31.0/sobjects/Attachment/" + id + "/body";
            HttpGet httpGet = new HttpGet(url);
            httpGet.addHeader("Authorization", "Bearer " + SFAuth.getAccessToken());
            HttpResponse response = httpclient.execute((HttpUriRequest)httpGet);
            statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                System.out.println("SFDC error:" + statusCode);
                String sfdcError = EntityUtils.toString((HttpEntity)response.getEntity());
                return null;
            }
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                InputStream instream = entity.getContent();
                return IOUtils.toByteArray((InputStream)instream);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private static String getSfPackageName() {
        Store store = DataProvider.get().getStore();
        String property = store.getProperty("salesforce.org.name");
        if (StringUtils.isEmpty((String)property)) {
            property = (String)AppConfig.getConfig().getProperty("sf.packageName");
        }
        if (StringUtils.isNotEmpty((String)property)) {
            return property + "/";
        }
        return "";
    }

    public static JsonArray getMemberMinSpend(String memberId) throws Exception {
        Integer statusCode = null;
        HttpResponse response = SFUtil.callSfService(SERVICE_GET_MIN_SPEND + memberId);
        if (response == null) {
            return null;
        }
        statusCode = response.getStatusLine().getStatusCode();
        if (statusCode != 200) {
            String sfdcError = EntityUtils.toString((HttpEntity)response.getEntity());
            JSONArray jsonArray = new JSONArray(sfdcError);
            JSONObject jsonObject = jsonArray.getJSONObject(0);
            String message = (String)jsonObject.get("message");
            throw new SFException(message, statusCode);
        }
        return SFUtil.getJsonArray(response);
    }

    private static String getServiceUrl() {
        return "/services/apexrest/" + SFUtil.getSfPackageName() + "RESTServices?function=";
    }

    public static enum POST_SERVICE_TYPE {
        ITEM(1),
        TRANSACTION(2),
        REFUND(3),
        UPDATE_ITEM(4),
        TICKET(5),
        UPDATE_INVENTORY_COUNT(6);

        private final int value;

        private POST_SERVICE_TYPE(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static String get(int value) {
            switch (value) {
                case 1: {
                    return SFUtil.SERVICE_UPDATE_TICKETS;
                }
                case 2: {
                    return SFUtil.SERVICE_MEMBER_PAYMENT;
                }
                case 3: {
                    return SFUtil.SERVICE_MEMBER_REFUND;
                }
                case 4: {
                    return SFUtil.SERVICE_UPDATE_ITEMS;
                }
                case 5: {
                    return SFUtil.SERVICE_UPDATE_TICKETS;
                }
                case 6: {
                    return SFUtil.SERVICE_UPDATE_INVENTORY_COUNT;
                }
            }
            return null;
        }
    }
}

