/*
 * Decompiled with CFR 0.152.
 */
package com.foretees.salesforce.sync;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.config.AppConfig;
import com.floreantpos.config.ui.YellowDogConfigurationView;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.MenuModifier;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketDiscount;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemDiscount;
import com.floreantpos.model.TicketItemModifier;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.model.dao.TicketItemDAO;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import com.foretees.salesforce.sync.SFJsonInfoDisplayDialog;
import com.foretees.salesforce.sync.SalesForceSyncable;
import com.foretees.salesforce.sync.SyncCanceledException;
import com.foretees.salesforce.sync.SyncView;
import com.foretees.yellowDog.YellowDogUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public class YellowDogSyncable
implements SalesForceSyncable {
    private SyncView syncView;
    private List<TicketItem> ticketItems;
    private boolean isCanceled = false;
    private int uploadSize = 20;

    public YellowDogSyncable(List<TicketItem> activeTicketItems) {
        this(activeTicketItems, false);
    }

    public YellowDogSyncable(List<TicketItem> jsonArray, boolean isUploadSeperately) {
        this.ticketItems = jsonArray;
    }

    public SyncView getSyncView() {
        return this.syncView;
    }

    public void setSyncView(SyncView syncView) {
        this.syncView = syncView;
    }

    @Override
    public void doSync() throws Exception {
        if (this.syncView == null) {
            return;
        }
        if (this.ticketItems == null || this.ticketItems.isEmpty()) {
            throw new PosException(Messages.getString("PaymentSyncable.2"));
        }
        int itemsToUpload = this.ticketItems.size();
        this.syncView.setSyncMessage(Messages.getString("PaymentSyncable.3") + itemsToUpload);
        this.syncView.setProgressMaximum(itemsToUpload);
        this.doUploadItems();
        if (this.isCanceled) {
            return;
        }
        this.ticketItems.clear();
        if (this.syncView != null) {
            this.syncView.dispose();
        }
    }

    private void doUploadItems() {
        JSONArray array = new JSONArray();
        int i = 0;
        for (TicketItem ticketItem : this.ticketItems) {
            Ticket ticketToEdit = TicketDAO.getInstance().loadFullTicket(ticketItem.getTicket().getId());
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("thirdPartyId", (Object)ticketToEdit.getId());
            jsonObject.put("transactionNumber", (Object)ticketToEdit.getId());
            jsonObject.put("checkClosed", (Object)ticketToEdit.getClosingDate());
            jsonObject.put("employeeName", (Object)ticketToEdit.getOwner().getFullName());
            Set<PosTransaction> transactions = ticketToEdit.getTransactions();
            String pay = "";
            Iterator<PosTransaction> iterator = transactions.iterator();
            while (iterator.hasNext()) {
                PosTransaction posTransaction = iterator.next();
                pay = pay + posTransaction.getPaymentType().getDisplayString();
                if (!iterator.hasNext()) continue;
                pay = pay + ",";
            }
            jsonObject.put("tender", (Object)pay);
            jsonObject.put("registerNumber", (Object)ticketToEdit.getTerminal().getId());
            jsonObject.put("registerName", (Object)ticketToEdit.getTerminal().getName());
            JSONObject jsonObjectStore = new JSONObject();
            jsonObjectStore.put("id", (Object)ticketItem.getYellowDogStoreId());
            jsonObject.put("store", (Object)jsonObjectStore);
            JSONObject lineObject = new JSONObject();
            lineObject.put("thirdPartyLineId", (Object)ticketItem.getId());
            lineObject.put("quantity", (Object)ticketItem.getQuantity());
            lineObject.put("itemRetail", (Object)ticketItem.getTotalAmount());
            lineObject.put("lineNumber", ++i);
            lineObject.put("itemDiscount", -1.0 * ticketItem.getAdjustedDiscount());
            String discountNames = this.createDiscountName(ticketItem, ticketToEdit);
            lineObject.put("discountDescription", (Object)discountNames);
            MenuItem menuItem = ticketItem.getMenuItem();
            if (menuItem != null) {
                if (menuItem.isVariant().booleanValue()) {
                    lineObject.put("itemNumber", (Object)menuItem.getParentMenuItemId());
                } else {
                    lineObject.put("itemNumber", (Object)ticketItem.getMenuItemId());
                }
                lineObject.put("itemDescription", (Object)ticketItem.getName());
                if (ticketItem.isMemberInventoryEnable()) {
                    lineObject.put("baseRetail", 0);
                } else {
                    lineObject.put("baseRetail", (Object)menuItem.getPrice());
                }
            } else {
                lineObject.put("itemNumber", (Object)ticketItem.getMenuItemId());
            }
            JSONArray jsonArray = new JSONArray();
            jsonArray.put((Object)lineObject);
            if (ticketItem.isHasModifiers().booleanValue()) {
                List<TicketItemModifier> ticketItemModifiers = ticketItem.getTicketItemModifiers();
                for (TicketItemModifier ticketItemModifier : ticketItemModifiers) {
                    jsonArray.put((Object)this.createModifierJSON(ticketItemModifier, i, ticketItem, discountNames));
                }
            }
            jsonObject.put("lines", (Object)jsonArray);
            array.put((Object)jsonObject);
        }
        try {
            boolean isDebugMode = AppConfig.getBoolean("salesforce.debug.enabled", false);
            String doCustomizeJsonString = array.toString();
            if (isDebugMode) {
                doCustomizeJsonString = this.doCustomizeJsonString(array.toString(5));
            }
            PosLog.debug(YellowDogConfigurationView.class, doCustomizeJsonString);
            YellowDogUtil.postTransactions(doCustomizeJsonString);
            this.updateYellowDogTicketSyncStatus(doCustomizeJsonString);
        }
        catch (SyncCanceledException isDebugMode) {
        }
        catch (Exception e) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e.getMessage());
        }
    }

    private JSONObject createModifierJSON(TicketItemModifier ticketItemModifier, int i, TicketItem ticketItem, String discountNames) {
        JSONObject lineObject = new JSONObject();
        lineObject.put("thirdPartyLineId", (Object)ticketItemModifier.getId());
        MenuModifier menuModifier = ticketItemModifier.getMenuModifier();
        if (menuModifier != null) {
            lineObject.put("itemNumber", (Object)menuModifier.getId());
        }
        lineObject.put("itemDescription", (Object)ticketItemModifier.getName());
        lineObject.put("itemRetail", (Object)ticketItemModifier.getTotalAmount());
        lineObject.put("baseRetail", (Object)ticketItemModifier.getUnitPrice());
        lineObject.put("itemDiscount", -1.0 * ticketItemModifier.getAdjustedDiscount());
        lineObject.put("quantity", (Object)ticketItemModifier.getItemQuantity());
        lineObject.put("lineNumber", i);
        lineObject.put("modifier", (Object)ticketItem.getId());
        lineObject.put("discountDescription", (Object)discountNames);
        return lineObject;
    }

    private void updateYellowDogTicketSyncStatus(String doCustomizeJsonString) {
        if (StringUtils.isNotBlank((String)doCustomizeJsonString)) {
            ArrayList<TicketItem> newYDticketItems = new ArrayList<TicketItem>();
            JSONArray mainArray = new JSONArray(doCustomizeJsonString);
            for (int i = 0; i < mainArray.length(); ++i) {
                JSONObject explrObject = mainArray.getJSONObject(i);
                JSONArray jsonLinesArray = explrObject.getJSONArray("lines");
                for (int j = 0; j < jsonLinesArray.length(); ++j) {
                    JSONObject explrTicketItemObject = jsonLinesArray.getJSONObject(j);
                    String ticketItemId = explrTicketItemObject.getString("thirdPartyLineId");
                    for (TicketItem ticketItem : this.ticketItems) {
                        if (!ticketItem.getId().equals(ticketItemId)) continue;
                        newYDticketItems.add(ticketItem);
                    }
                }
            }
            TicketItemDAO.getInstance().updateYellowDogSyncItem(newYDticketItems, Boolean.TRUE);
        }
    }

    private String createDiscountName(TicketItem ticketItem, Ticket ticketToEdit) {
        List<TicketItemDiscount> itemDiscounts;
        String discountName = "";
        List<TicketDiscount> ticketDiscounts = ticketToEdit.getDiscounts();
        if (ticketDiscounts != null && !ticketDiscounts.isEmpty()) {
            Iterator<TicketDiscount> iterator = ticketDiscounts.iterator();
            while (iterator.hasNext()) {
                TicketDiscount ticketDiscount = iterator.next();
                discountName = discountName + ticketDiscount.getName();
                if (!iterator.hasNext()) continue;
                discountName = discountName + ", ";
            }
        }
        if ((itemDiscounts = ticketItem.getDiscounts()) != null && !itemDiscounts.isEmpty()) {
            if (StringUtils.isNotBlank((String)discountName)) {
                discountName = discountName + ", ";
            }
            Iterator<TicketItemDiscount> iterator = itemDiscounts.iterator();
            while (iterator.hasNext()) {
                TicketItemDiscount ticketItemDiscount = iterator.next();
                discountName = discountName + ticketItemDiscount.getName();
                if (!iterator.hasNext()) continue;
                discountName = discountName + ", ";
            }
        }
        return discountName;
    }

    private String doCustomizeJsonString(String jsonString) {
        SFJsonInfoDisplayDialog dialog = new SFJsonInfoDisplayDialog(jsonString);
        dialog.open();
        if (dialog.isCanceled()) {
            this.syncView.setCanceled(true);
            throw new SyncCanceledException(Messages.getString("YellowDogSyncable.0"));
        }
        return dialog.getUpdateJsonString();
    }

    private boolean isSyncable(TicketItem ticketItem) {
        return !StringUtils.isEmpty((String)ticketItem.getMenuItemId()) && ticketItem.isCloudSynced() == false;
    }
}

