/*
 * Decompiled with CFR 0.152.
 */
package com.foretees.yellowDog;

import com.floreantpos.Messages;
import com.floreantpos.PosLog;
import com.floreantpos.model.Store;
import com.floreantpos.model.YellowDogStore;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.foretees.salesforce.sync.SFException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONTokener;

public class YellowDogUtil {
    private static final String SERVICE_GET_STORES = "stores";
    private static final String SERVICE_TRANSACTIONS = "transactions";

    public static final HttpClient createHttpClint() throws Exception {
        CloseableHttpClient httpclient = HttpClientBuilder.create().build();
        return httpclient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getYellowDogAuthToken() throws Exception {
        HttpPost post = null;
        try {
            HttpClient httpclient = YellowDogUtil.createHttpClint();
            post = new HttpPost(YellowDogUtil.getStore().getYellowDogsTokenUrl());
            StringEntity postingString = new StringEntity(YellowDogUtil.createYellowDogAuthTokenGson().toString());
            post.setEntity((HttpEntity)postingString);
            post.setHeader("Content-type", "application/json");
            HttpResponse response = httpclient.execute((HttpUriRequest)post);
            String getResult = null;
            getResult = EntityUtils.toString((HttpEntity)response.getEntity());
            JSONObject jsonObject = (JSONObject)new JSONTokener(getResult).nextValue();
            JSONObject json0 = jsonObject.getJSONObject("result");
            String string = json0.getString("accessToken");
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
            PosLog.error(YellowDogUtil.class, e.getMessage());
        }
        finally {
            post.releaseConnection();
        }
        return null;
    }

    private static Store getStore() {
        return DataProvider.get().getStore();
    }

    public static JSONObject createYellowDogAuthTokenGson() {
        JSONObject ticketItemObj = new JSONObject();
        Store store = YellowDogUtil.getStore();
        ticketItemObj.put("userName", (Object)store.getYellowDogUserName());
        ticketItemObj.put("password", (Object)store.getClientPassword());
        ticketItemObj.put("clientId", (Object)store.getClientId());
        return ticketItemObj;
    }

    public static List<YellowDogStore> getYellowDogStore() {
        ArrayList<YellowDogStore> dogStores = new ArrayList<YellowDogStore>();
        try {
            Integer statusCode = null;
            HttpClient httpclient = YellowDogUtil.createHttpClint();
            Store store = YellowDogUtil.getStore();
            String url = store.getYellowDogsFetchUrl() + "/" + SERVICE_GET_STORES;
            HttpGet httpGet = new HttpGet(url);
            httpGet.setHeader("Authorization", "Bearer " + YellowDogUtil.getYellowDogAuthToken());
            httpGet.setHeader("userName", store.getYellowDogUserName());
            httpGet.setHeader("client_id", store.getClientPassword());
            httpGet.setHeader("password", store.getClientId());
            HttpResponse response = httpclient.execute((HttpUriRequest)httpGet);
            statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                String sfdcError = EntityUtils.toString((HttpEntity)response.getEntity());
                PosLog.debug(YellowDogUtil.class, "Error:" + statusCode + " : " + sfdcError);
                throw new SFException(sfdcError, statusCode);
            }
            String getResult = null;
            getResult = EntityUtils.toString((HttpEntity)response.getEntity());
            JSONArray results = new JSONArray(getResult);
            if (results != null) {
                for (int i = 0; i < results.length(); ++i) {
                    JSONObject obj = (JSONObject)results.get(i);
                    YellowDogStore yellowDogStore = YellowDogUtil.convertToYellowDogStore(obj);
                    dogStores.add(yellowDogStore);
                }
            }
            httpGet.releaseConnection();
        }
        catch (Exception e) {
            e.printStackTrace();
            PosLog.error(YellowDogUtil.class, e.getMessage());
        }
        return dogStores;
    }

    public static YellowDogStore convertToYellowDogStore(JSONObject obj) {
        YellowDogStore yellowDogStore = new YellowDogStore();
        yellowDogStore.setId(obj.getString(YellowDogStore.PROP_ID));
        yellowDogStore.setCode(obj.getString(YellowDogStore.PROP_CODE));
        yellowDogStore.setName(obj.getString(YellowDogStore.PROP_NAME));
        yellowDogStore.setNoOnHand(obj.getBoolean(YellowDogStore.PROP_NO_ON_HAND));
        String revenueCenter = obj.get(YellowDogStore.PROP_REVENUE_CENTER).toString();
        if (StringUtils.isBlank((String)revenueCenter) || revenueCenter.equals("null")) {
            revenueCenter = "";
        }
        yellowDogStore.setRevenueCenter(revenueCenter);
        String notes = obj.get(YellowDogStore.PROP_NOTES).toString();
        if (StringUtils.isBlank((String)notes) || notes.equals("null")) {
            notes = "";
        }
        yellowDogStore.setNotes("" + notes);
        return yellowDogStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void postTransactions(String jsonString) throws Exception {
        HttpPost post = null;
        try {
            HttpClient httpclient = YellowDogUtil.createHttpClint();
            Store store = YellowDogUtil.getStore();
            post = new HttpPost(store.getYellowDogsFetchUrl() + "/" + SERVICE_TRANSACTIONS);
            StringEntity postingString = new StringEntity(jsonString);
            post.setEntity((HttpEntity)postingString);
            post.setHeader("Content-type", "application/json");
            post.setHeader("Authorization", "Bearer " + YellowDogUtil.getYellowDogAuthToken());
            HttpResponse response = httpclient.execute((HttpUriRequest)post);
            int statusCode = response.getStatusLine().getStatusCode();
            POSMessageDialog.showMessage(Messages.getString("YellowDogUtil.2"));
        }
        finally {
            post.releaseConnection();
        }
    }
}

