/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.orocust.ui.dialog;

import com.floreantpos.POSConstants;
import com.floreantpos.main.Application;
import com.floreantpos.model.ITicketItem;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.model.ext.KitchenStatus;
import com.floreantpos.swing.ListTableModel;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TimerWatch;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.kitchendisplay.KitchenTicketStatusSelector;
import com.floreantpos.ui.ticket.TicketItemRowCreator;
import com.orocube.orocust.OroCustMessages;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import net.miginfocom.swing.MigLayout;

public class KitchenStatusDialog
extends POSDialog {
    Ticket ticket;
    JLabel ticketId = new JLabel();
    protected final HashMap<String, ITicketItem> tableRows = new LinkedHashMap<String, ITicketItem>();
    KitchenTicketItemTableModel tableModel;
    JTable table;
    KitchenTicketStatusSelector statusSelector;
    private TimerWatch timerWatch;
    private JScrollPane scrollPane;
    private JPanel headerPanel;
    private JLabel ticketInfo;
    private JLabel tableInfo;
    private JLabel serverInfo;
    private JPanel contentPanel;

    public KitchenStatusDialog(Ticket ticket) {
        this.setLayout(new BorderLayout());
        this.ticket = ticket;
        this.contentPanel = new JPanel();
        this.contentPanel.setLayout(new BorderLayout(1, 1));
        this.contentPanel.setBorder(new EmptyBorder(5, 10, 10, 10));
        TitlePanel titlePane = new TitlePanel();
        titlePane.setTitle(OroCustMessages.getString("KitchenStatusDialog.0"));
        this.add((Component)titlePane, "North");
        this.setTitle(OroCustMessages.getString("KitchenStatusDialog.1"));
        this.createHeader(ticket);
        this.createTable(ticket);
        this.updateTable();
        this.createButtonPanel();
        this.statusSelector = new KitchenTicketStatusSelector((Frame)SwingUtilities.getWindowAncestor(this));
        this.statusSelector.pack();
        this.timerWatch.start();
        this.contentPanel.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorRemoved(AncestorEvent event) {
                KitchenStatusDialog.this.timerWatch.stop();
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
            }

            @Override
            public void ancestorAdded(AncestorEvent event) {
            }
        });
        this.add((Component)this.contentPanel, "Center");
    }

    public void stopTimer() {
        this.timerWatch.stop();
    }

    private void updateTable() {
        this.ticket = TicketDAO.getInstance().loadFullTicket(this.ticket.getId());
        TicketItemRowCreator.calculateTicketRows(this.ticket, this.tableRows, true, true, false);
        ArrayList<ITicketItem> list = new ArrayList<ITicketItem>();
        for (ITicketItem ticketItem : this.tableRows.values()) {
            list.add(ticketItem);
        }
        this.tableModel.setItems(list);
    }

    private void createHeader(Ticket ticket) {
        this.ticketInfo = new JLabel(OroCustMessages.getString("KitchenStatusDialog.2") + ticket.getId());
        Terminal terminal = Application.getInstance().getTerminal();
        this.tableInfo = new JLabel();
        if (!terminal.isShowTableNumber()) {
            this.tableInfo.setText(OroCustMessages.getString("KitchenStatusDialog.3") + ticket.getTableNames());
        } else if (ticket.getTableNumbers() != null && ticket.getTableNumbers().size() > 0) {
            String tableNumbers = ticket.getTableNumbers().toString();
            tableNumbers = tableNumbers.replace("[", "").replace("]", "");
            this.tableInfo.setText(OroCustMessages.getString("KitchenStatusDialog.3") + tableNumbers);
        }
        this.serverInfo = new JLabel();
        if (ticket.getOwner() != null) {
            this.serverInfo.setText(OroCustMessages.getString("KitchenStatusDialog.5") + ticket.getOwner());
        }
        Font font = new Font("Verdana", 1, 13);
        this.ticketInfo.setFont(font);
        this.tableInfo.setFont(font);
        this.serverInfo.setFont(font);
        this.timerWatch = new TimerWatch(ticket.getCreateDate());
        this.timerWatch.setPreferredSize(new Dimension(100, 30));
        this.headerPanel = new JPanel((LayoutManager)new MigLayout("fill", "sg, fill", ""));
        this.headerPanel.setBorder(BorderFactory.createLineBorder(Color.gray));
        this.headerPanel.add((Component)this.ticketInfo, "split 2");
        this.headerPanel.add((Component)this.timerWatch, "right,wrap, span");
        this.headerPanel.add((Component)this.tableInfo, "split 2, grow");
        this.headerPanel.add((Component)this.serverInfo, "right,span");
        this.contentPanel.add((Component)this.headerPanel, "North");
    }

    private void createTable(Ticket ticket) {
        this.table = new JTable();
        this.tableModel = new KitchenTicketItemTableModel();
        this.table.setModel(this.tableModel);
        this.table.setRowSelectionAllowed(false);
        this.table.setCellSelectionEnabled(false);
        this.table.setRowHeight(50);
        this.table.setDefaultRenderer(Object.class, new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component rendererComponent = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                ITicketItem object = (ITicketItem)KitchenStatusDialog.this.tableModel.getRowData(row);
                TicketItem ticketItem = null;
                if (!(object instanceof TicketItem)) {
                    return rendererComponent;
                }
                ticketItem = (TicketItem)object;
                if (ticketItem != null) {
                    if (ticketItem.isShouldPrintToKitchen().booleanValue() && ticketItem.isPrintedToKitchen().booleanValue()) {
                        rendererComponent.setBackground(Color.yellow);
                    } else if (ticketItem.isBeverage().booleanValue() || ticketItem.getKitchenStatusValue() == KitchenStatus.BUMP) {
                        rendererComponent.setBackground(Color.green);
                    } else if (ticketItem.getKitchenStatusValue() == KitchenStatus.VOID) {
                        rendererComponent.setBackground(new Color(128, 0, 128));
                    } else {
                        rendererComponent.setBackground(Color.white);
                    }
                }
                KitchenStatusDialog.this.updateHeaderView();
                return rendererComponent;
            }
        });
        this.resizeTableColumns();
        this.scrollPane = new JScrollPane(this.table);
        this.contentPanel.add(this.scrollPane);
    }

    private void updateHeaderView() {
        this.headerPanel.setBackground(this.timerWatch.backColor);
        this.ticketInfo.setForeground(this.timerWatch.textColor);
        this.tableInfo.setForeground(this.timerWatch.textColor);
        this.serverInfo.setForeground(this.timerWatch.textColor);
    }

    private void createButtonPanel() {
        JPanel buttonPanel = new JPanel(new GridLayout(1, 0, 5, 5));
        PosButton btnDone = new PosButton(POSConstants.BUMP);
        btnDone.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KitchenStatusDialog.this.doChangeStatus("Ready");
            }
        });
        btnDone.setPreferredSize(PosUIManager.getSize(100, 40));
        PosButton btnCancel = new PosButton(POSConstants.OK);
        btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KitchenStatusDialog.this.setCanceled(true);
                KitchenStatusDialog.this.dispose();
            }
        });
        btnCancel.setPreferredSize(PosUIManager.getSize(100, 40));
        buttonPanel.add(btnCancel);
        this.contentPanel.add((Component)buttonPanel, "South");
    }

    private void resizeTableColumns() {
        this.table.setAutoResizeMode(4);
        this.setColumnWidth(1, PosUIManager.getSize(60));
        this.setColumnWidth(2, PosUIManager.getSize(100));
    }

    private void setColumnWidth(int columnNumber, int width) {
        TableColumn column = this.table.getColumnModel().getColumn(columnNumber);
        column.setPreferredWidth(width);
        column.setMaxWidth(width);
        column.setMinWidth(width);
    }

    public Ticket getTicket() {
        return this.ticket;
    }

    public void setTicket(Ticket ticket) {
        this.ticket = ticket;
    }

    private void doChangeStatus(String status) {
        try {
            this.stopTimer();
            for (TicketItem ticketItem : this.ticket.getTicketItems()) {
                ticketItem.setKitchenStatus(status);
            }
            this.ticket.setStatus(status);
            TicketDAO.getInstance().saveOrUpdate(this.ticket);
            this.updateTable();
            this.tableModel.fireTableDataChanged();
            this.revalidate();
            this.repaint();
        }
        catch (Exception e) {
            POSMessageDialog.showError(this, e.getMessage(), e);
        }
    }

    class KitchenTicketItemTableModel
    extends ListTableModel<ITicketItem> {
        KitchenTicketItemTableModel() {
            super(new String[]{OroCustMessages.getString("KitchenTicketView.13"), OroCustMessages.getString("KitchenTicketView.14"), OroCustMessages.getString("KitchenStatusDialog.4")});
        }

        KitchenTicketItemTableModel(List<ITicketItem> list) {
            super(new String[]{OroCustMessages.getString("KitchenTicketView.13"), OroCustMessages.getString("KitchenTicketView.14"), OroCustMessages.getString("KitchenStatusDialog.4")}, list);
        }

        public void setItems(List list) {
            this.setRows(list);
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 2;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            ITicketItem ticketItem = (ITicketItem)this.getRowData(rowIndex);
            if (ticketItem instanceof TicketItem) {
                ticketItem = (TicketItem)ticketItem;
            }
            switch (columnIndex) {
                case 0: {
                    return ticketItem.getNameDisplay();
                }
                case 1: {
                    return ticketItem.getItemQuantityDisplay();
                }
                case 2: {
                    TicketItem item;
                    KitchenStatus kitchenStatusValue = ticketItem.getKitchenStatusValue();
                    if (kitchenStatusValue == null) {
                        return "";
                    }
                    if (ticketItem instanceof TicketItem && !(item = (TicketItem)ticketItem).isShouldPrintToKitchen().booleanValue()) {
                        return "";
                    }
                    return kitchenStatusValue.getValue();
                }
            }
            return ticketItem;
        }
    }
}

