/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.orocust.ui.dialog;

import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.actions.SettleTicketAction;
import com.floreantpos.extension.ExtensionManager;
import com.floreantpos.extension.OrderServiceExtension;
import com.floreantpos.main.Application;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.OrderInfoDialog;
import com.floreantpos.ui.views.OrderInfoView;
import com.floreantpos.ui.views.SwitchboardView;
import com.floreantpos.ui.views.order.DefaultOrderServiceExtension;
import com.floreantpos.ui.views.order.OrderController;
import com.floreantpos.ui.views.order.OrderView;
import com.floreantpos.ui.views.order.RootView;
import com.floreantpos.util.POSUtil;
import com.orocube.orocust.OroCustMessages;
import com.orocube.orocust.ui.view.CustomerListView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.logging.LogFactory;

public class TicketActivitySelectionDialog
extends POSDialog
implements ActionListener {
    private PosButton btnEditTicket = new PosButton(POSConstants.EDIT_TICKET_BUTTON_TEXT);
    private PosButton btnOrderInfo = new PosButton(POSConstants.ORDER_INFO_BUTTON_TEXT);
    private PosButton btnSettleTicket = new PosButton(POSConstants.SETTLE_TICKET_BUTTON_TEXT);
    private PosButton btnCloseOrder = new PosButton(POSConstants.CLOSE_ORDER_BUTTON_TEXT);
    private PosButton btnAssignDriver = new PosButton(POSConstants.ASSIGN_DRIVER_BUTTON_TEXT);
    private JPanel centerPanel;
    private Ticket ticket;
    private CustomerListView parent;

    public TicketActivitySelectionDialog(Ticket ticket, CustomerListView parent) {
        this.setLayout(new BorderLayout(5, 5));
        this.setTitle(OroCustMessages.getString("TicketActivitySelectionDialog.0"));
        this.setResizable(false);
        this.ticket = ticket;
        this.parent = parent;
        TitlePanel titlePanel = new TitlePanel();
        titlePanel.setTitle(OroCustMessages.getString("TicketActivitySelectionDialog.1") + ticket.getId().toString());
        this.centerPanel = new JPanel(new BorderLayout(5, 5));
        this.centerPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        JPanel actionButtonPanel = new JPanel((LayoutManager)new MigLayout("fill,inset 0", "sg,fill", ""));
        int width = PosUIManager.getSize(150);
        int height = PosUIManager.getSize(130);
        actionButtonPanel.add((Component)this.btnOrderInfo, "grow,w " + width + "!,h " + height + "!");
        actionButtonPanel.add((Component)this.btnEditTicket, "grow,w " + width + "!,h " + height + "!");
        actionButtonPanel.add((Component)this.btnSettleTicket, "grow,w " + width + "!,h " + height + "!");
        actionButtonPanel.add((Component)this.btnCloseOrder, "grow,w " + width + "!,h " + height + "!");
        actionButtonPanel.add((Component)this.btnAssignDriver, "grow,w " + width + "!,h " + height + "!");
        this.btnEditTicket.addActionListener(this);
        this.btnOrderInfo.addActionListener(this);
        this.btnSettleTicket.addActionListener(this);
        this.btnCloseOrder.addActionListener(this);
        this.btnAssignDriver.addActionListener(this);
        PosButton cancelButton = new PosButton(POSConstants.CANCEL.toUpperCase());
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TicketActivitySelectionDialog.this.setCanceled(true);
                TicketActivitySelectionDialog.this.dispose();
            }
        });
        actionButtonPanel.add((Component)cancelButton, "grow,w " + width + "!,h " + height + "!");
        this.centerPanel.add((Component)actionButtonPanel, "Center");
        this.add(this.centerPanel);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        boolean closeParent = false;
        if (source == this.btnEditTicket) {
            if (this.doEditTicket()) {
                closeParent = true;
            }
        } else if (source == this.btnOrderInfo) {
            this.doShowOrderInfo();
        } else if (source == this.btnSettleTicket) {
            this.doSettleTicket();
        } else if (source == this.btnCloseOrder) {
            this.doCloseOrder();
        } else if (source == this.btnAssignDriver) {
            this.doAssignDriver();
        }
        this.closeDialog(closeParent);
    }

    protected void doCloseOrder() {
        this.ticket = TicketDAO.getInstance().loadFullTicket(this.ticket.getId());
        int due = (int)POSUtil.getDouble(this.ticket.getDueAmount());
        if (due != 0) {
            POSMessageDialog.showError(this, OroCustMessages.getString("SwitchboardView.5"));
            return;
        }
        int option = JOptionPane.showOptionDialog(Application.getPosWindow(), OroCustMessages.getString("SwitchboardView.6") + this.ticket.getId() + OroCustMessages.getString("SwitchboardView.7"), POSConstants.CONFIRM, 2, 1, null, null, null);
        if (option != 0) {
            return;
        }
        OrderController.closeOrder(this.ticket);
    }

    protected void doAssignDriver() {
        try {
            int option;
            if (!this.ticket.getOrderType().isDelivery().booleanValue()) {
                POSMessageDialog.showError(this, OroCustMessages.getString("SwitchboardView.8"));
                return;
            }
            User assignedDriver = this.ticket.getAssignedDriver();
            if (assignedDriver != null && (option = JOptionPane.showOptionDialog(Application.getPosWindow(), OroCustMessages.getString("SwitchboardView.9"), POSConstants.CONFIRM, 0, 3, null, null, null)) != 0) {
                return;
            }
            OrderServiceExtension orderServiceExtension = (OrderServiceExtension)ExtensionManager.getPlugin(OrderServiceExtension.class);
            if (orderServiceExtension == null) {
                this.btnAssignDriver.setEnabled(false);
                orderServiceExtension = new DefaultOrderServiceExtension();
            }
            orderServiceExtension.assignDriver(this.ticket.getId());
        }
        catch (Exception e) {
            e.printStackTrace();
            POSMessageDialog.showError(this, e.getMessage());
            LogFactory.getLog(SwitchboardView.class).error((Object)e);
        }
    }

    private boolean doEditTicket() {
        try {
            if (!this.editTicket(this.ticket)) {
                return false;
            }
        }
        catch (PosException e) {
            POSMessageDialog.showError(this, e.getMessage());
            return false;
        }
        catch (Exception e) {
            POSMessageDialog.showError(this, e.getMessage(), e);
        }
        return true;
    }

    private boolean editTicket(Ticket ticket) {
        if (ticket.isPaid().booleanValue()) {
            POSMessageDialog.showMessage(this, "");
            return false;
        }
        Ticket ticketToEdit = TicketDAO.getInstance().loadFullTicket(ticket.getId());
        OrderView.getInstance().setCurrentTicket(ticketToEdit);
        RootView.getInstance().showView("ORDER_VIEW");
        return true;
    }

    private void doSettleTicket() {
        try {
            if (!POSUtil.checkDrawerAssignment()) {
                return;
            }
            new SettleTicketAction(this.ticket).actionPerformed(null);
        }
        catch (PosException e) {
            POSMessageDialog.showError(this, e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            POSMessageDialog.showError(this, POSConstants.ERROR_MESSAGE, e);
        }
    }

    private void doShowOrderInfo() {
        try {
            ArrayList<Ticket> ticketsToShow = new ArrayList<Ticket>();
            ticketsToShow.add(TicketDAO.getInstance().loadFullTicket(this.ticket.getId()));
            OrderInfoView view = new OrderInfoView(ticketsToShow);
            OrderInfoDialog dialog = new OrderInfoDialog(view);
            dialog.setSize(400, 600);
            dialog.setDefaultCloseOperation(2);
            dialog.setLocationRelativeTo(Application.getPosWindow());
            dialog.setVisible(true);
            if (dialog.isReorder()) {
                this.closeDialog(true);
            }
        }
        catch (Exception e) {
            POSMessageDialog.showError(this, POSConstants.ERROR_MESSAGE, e);
        }
    }

    private void closeDialog(boolean parentClose) {
        if (parentClose) {
            this.parent.closeDialog(parentClose);
        }
        this.setCanceled(true);
        this.dispose();
    }
}

