/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.orocust.ui.view;

import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.model.Customer;
import com.floreantpos.model.CustomerGroup;
import com.floreantpos.model.dao.CustomerDAO;
import com.floreantpos.model.dao.CustomerGroupDAO;
import com.floreantpos.model.util.IllegalModelStateException;
import com.floreantpos.swing.ListTableModel;
import com.floreantpos.swing.PaginatedListModel;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import com.orocube.orocust.OroCustMessages;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import jiconfont.IconCode;
import jiconfont.icons.GoogleMaterialDesignIcons;
import jiconfont.swing.IconFontSwing;
import net.miginfocom.swing.MigLayout;

public class CustomerGroupDetailForm
extends BeanEditor<CustomerGroup>
implements ActionListener {
    private JTable customerListItemTable;
    private CustomerListExplorerTableModel customerListTableModel;
    private boolean viewMode;
    private JLabel lblNumberOfItem = new JLabel();
    private PosButton btnNext;
    private PosButton btnPrev;
    protected PaginatedListModel dataModel = new PaginatedListModel();
    private boolean edit = false;

    public CustomerGroupDetailForm(CustomerGroup customerGroup) {
        this.initComponents();
        this.customerListTableModel = new CustomerListExplorerTableModel();
        this.customerListItemTable.setModel(this.customerListTableModel);
        this.setBean(customerGroup);
    }

    private void initComponents() {
        this.setLayout((LayoutManager)new MigLayout("fill", "[][grow]", ""));
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.customerListItemTable = new JTable();
        this.customerListItemTable.setRowHeight(PosUIManager.getSize(30));
        this.add((Component)new JScrollPane(this.customerListItemTable), "newline,split 2,span,grow");
        this.addButtonPanel();
    }

    private void scrollDown() {
        CustomerGroup customerGroup = (CustomerGroup)this.getBean();
        if (this.edit) {
            CustomerGroupDAO.getInstance().saveOrUpdate(customerGroup);
            this.edit = false;
        }
        this.dataModel.setCurrentRowIndex(this.dataModel.getNextRowIndex());
        this.updateData();
    }

    private void updateButton() {
        int totalNumber;
        int startNumber = this.dataModel.getCurrentRowIndex() + 1;
        int endNumber = this.dataModel.getNextRowIndex();
        if (endNumber > (totalNumber = this.dataModel.getNumRows())) {
            endNumber = totalNumber;
        }
        this.lblNumberOfItem.setText(String.format(OroCustMessages.getString("CustomerGroupDetailForm.4"), startNumber, endNumber, totalNumber));
        this.btnPrev.setEnabled(this.dataModel.hasPrevious());
        this.btnNext.setEnabled(this.dataModel.hasNext());
    }

    private void updateData() {
        CustomerGroup customerGroup = (CustomerGroup)this.getBean();
        CustomerDAO.getInstance().loadCustomers(customerGroup, this.dataModel);
        this.customerListTableModel.setItems(this.dataModel.getDataList());
        this.updateButton();
        this.customerListItemTable.revalidate();
        this.customerListItemTable.repaint();
    }

    private void scrollUp() {
        CustomerGroup customerGroup = (CustomerGroup)this.getBean();
        if (this.edit) {
            CustomerGroupDAO.getInstance().saveOrUpdate(customerGroup);
            this.edit = false;
        }
        this.dataModel.setCurrentRowIndex(this.dataModel.getPreviousRowIndex());
        this.updateData();
    }

    private void addButtonPanel() {
        JPanel paginationButtonPanel = new JPanel((LayoutManager)new MigLayout("ins 5 0 0 0,fillx", "[right,grow][]", ""));
        paginationButtonPanel.add((Component)this.lblNumberOfItem, "split 3,span");
        int iconSize = PosUIManager.getSize(16);
        this.btnPrev = new PosButton();
        this.btnPrev.setIcon(IconFontSwing.buildIcon((IconCode)GoogleMaterialDesignIcons.NAVIGATE_BEFORE, (float)iconSize));
        paginationButtonPanel.add((Component)this.btnPrev, "center");
        this.btnNext = new PosButton();
        this.btnNext.setIcon(IconFontSwing.buildIcon((IconCode)GoogleMaterialDesignIcons.NAVIGATE_NEXT, (float)iconSize));
        paginationButtonPanel.add(this.btnNext);
        this.add((Component)paginationButtonPanel, "South");
        ActionListener action = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Object source = e.getSource();
                    if (source == CustomerGroupDetailForm.this.btnPrev) {
                        CustomerGroupDetailForm.this.scrollUp();
                    } else if (source == CustomerGroupDetailForm.this.btnNext) {
                        CustomerGroupDetailForm.this.scrollDown();
                    }
                }
                catch (Exception e2) {
                    POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), e2.getMessage(), e2);
                }
            }
        };
        this.updateButton();
        this.btnPrev.addActionListener(action);
        this.btnNext.addActionListener(action);
        this.btnNext.setEnabled(false);
        this.btnPrev.setEnabled(false);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int index;
        String actionCommand = e.getActionCommand();
        if (POSConstants.DELETE.equals(actionCommand) && (index = this.customerListItemTable.getSelectedRow()) < 0) {
            BOMessageDialog.showError(POSConstants.SELECT_ITEM_TO_DELETE);
            return;
        }
    }

    @Override
    public boolean save() {
        try {
            if (!this.updateModel()) {
                return false;
            }
            CustomerGroup customerGroup = (CustomerGroup)this.getBean();
            CustomerGroupDAO.getInstance().saveOrUpdate(customerGroup);
            return true;
        }
        catch (IllegalModelStateException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    protected void updateView() {
        CustomerGroup customerGroup = (CustomerGroup)this.getBean();
        if (customerGroup.getId() == null) {
            return;
        }
        this.dataModel.setCurrentRowIndex(0);
        this.updateData();
    }

    @Override
    protected boolean updateModel() throws IllegalModelStateException {
        return true;
    }

    @Override
    public String getDisplayText() {
        return OroCustMessages.getString("CustomerGroupDetailForm.17") + ((CustomerGroup)this.getBean()).getName();
    }

    public void setEditable(boolean b) {
        boolean bl = this.viewMode = !b;
        if (this.viewMode) {
            this.customerListItemTable.setEnabled(false);
        }
    }

    private class CustomerListExplorerTableModel
    extends ListTableModel<Customer> {
        String[] columnNames = new String[]{OroCustMessages.getString("CustomerGroupDetailForm.12"), OroCustMessages.getString("CustomerGroupDetailForm.13"), OroCustMessages.getString("CustomerGroupDetailForm.14"), OroCustMessages.getString("CustomerGroupDetailForm.15")};
        List<Customer> customerList = new ArrayList<Customer>();

        public void setItems(List<Customer> customers) {
            if (customers == null) {
                return;
            }
            this.customerList.clear();
            this.customerList.addAll(customers);
            this.fireTableDataChanged();
        }

        public List<Customer> getItems() {
            return this.customerList;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        @Override
        public int getRowCount() {
            if (this.customerList == null) {
                return 0;
            }
            return this.customerList.size();
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public String getColumnName(int index) {
            return this.columnNames[index];
        }

        @Override
        public Object getValueAt(int row, int column) {
            if (this.customerList == null) {
                return "";
            }
            Customer customer = this.customerList.get(row);
            if (customer == null) {
                return "";
            }
            switch (column) {
                case 0: {
                    return customer.getId();
                }
                case 1: {
                    return customer.getName();
                }
                case 2: {
                    return customer.getMobileNo();
                }
                case 3: {
                    return customer.getEmail();
                }
            }
            return null;
        }
    }
}

