/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.orocust.ui.view;

import com.floreantpos.PosLog;
import com.floreantpos.bo.ui.modifierdesigner.CustomerSelectionDialog;
import com.floreantpos.model.Customer;
import com.floreantpos.model.CustomerGroup;
import com.floreantpos.model.dao.CustomerDAO;
import com.floreantpos.model.dao.CustomerGroupDAO;
import com.floreantpos.swing.ComboBoxModel;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.orocube.orocust.OroCustMessages;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Hibernate;
import org.hibernate.Session;

public class CustomerGroupForm
extends BeanEditor<CustomerGroup> {
    private JLabel lblCustomerGroupName;
    private FixedLengthTextField tfCustomerGroupName;
    private JLabel lblCustomerGroupCode;
    private FixedLengthTextField tfCustomerGroupCode;
    private JLabel lblCustomerGroupDescription;
    private JTextArea txtCustomerGroupDescription;
    private JList listCustomers;
    private ComboBoxModel customerListModel;

    public CustomerGroupForm(CustomerGroup customerGroup) {
        this.setLayout(new BorderLayout());
        this.createUI();
        this.setBean(customerGroup);
    }

    private void createUI() {
        this.setLayout(new BorderLayout());
        JPanel itemInfoPanel = new JPanel();
        JScrollPane scrollPane = new JScrollPane(itemInfoPanel, 20, 31);
        scrollPane.setBorder(null);
        this.add((Component)itemInfoPanel, "North");
        itemInfoPanel.setLayout((LayoutManager)new MigLayout("fill", "[][grow][]", ""));
        this.lblCustomerGroupName = new JLabel(OroCustMessages.getString("CustomerGroupForm.3"));
        itemInfoPanel.add(this.lblCustomerGroupName);
        this.tfCustomerGroupName = new FixedLengthTextField();
        itemInfoPanel.add((Component)this.tfCustomerGroupName, "growx,wrap");
        this.tfCustomerGroupName.setLength(30);
        this.lblCustomerGroupCode = new JLabel(OroCustMessages.getString("CustomerGroupForm.0"));
        itemInfoPanel.add((Component)this.lblCustomerGroupCode, "");
        this.tfCustomerGroupCode = new FixedLengthTextField();
        this.tfCustomerGroupCode.setLength(6);
        itemInfoPanel.add((Component)this.tfCustomerGroupCode, "growx,wrap");
        this.lblCustomerGroupDescription = new JLabel(OroCustMessages.getString("CustomerGroupForm.8"));
        itemInfoPanel.add(this.lblCustomerGroupDescription);
        this.txtCustomerGroupDescription = new JTextArea(4, 4);
        this.txtCustomerGroupDescription.setLineWrap(true);
        itemInfoPanel.add((Component)new JScrollPane(this.txtCustomerGroupDescription), "growx,h 90!,wrap");
        JPanel customerPanel = new JPanel((LayoutManager)new MigLayout("fill"));
        JPanel custmoneListPanel = new JPanel(new BorderLayout());
        JPanel buttonPanel = new JPanel((LayoutManager)new MigLayout(""));
        Border loweredetched = BorderFactory.createEtchedBorder(1);
        TitledBorder title = BorderFactory.createTitledBorder(loweredetched, OroCustMessages.getString("CustomerGroupForm.12"));
        title.setTitleJustification(1);
        JButton btnAddCustomer = new JButton(OroCustMessages.getString("CustomerGroupForm.13"));
        btnAddCustomer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CustomerGroupForm.this.doAddCustomer();
            }
        });
        JButton btnRemoveCustomer = new JButton(OroCustMessages.getString("CustomerGroupForm.14"));
        btnRemoveCustomer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Customer customer = (Customer)CustomerGroupForm.this.listCustomers.getSelectedValue();
                if (customer == null) {
                    return;
                }
                CustomerGroupForm.this.customerListModel.removeElement(customer);
            }
        });
        this.listCustomers = new JList();
        JScrollPane listCustomerScrollPane = new JScrollPane(this.listCustomers);
        custmoneListPanel.setBorder(title);
        custmoneListPanel.add(listCustomerScrollPane);
        buttonPanel.add(btnAddCustomer);
        buttonPanel.add(btnRemoveCustomer);
        customerPanel.add((Component)custmoneListPanel, "grow, span");
        this.add((Component)buttonPanel, "South");
        this.add((Component)customerPanel, "Center");
    }

    @Override
    public boolean save() {
        try {
            if (!this.updateModel()) {
                return false;
            }
            CustomerGroup customerGroup = (CustomerGroup)this.getBean();
            CustomerGroupDAO.getInstance().saveOrUpdate(customerGroup);
            return true;
        }
        catch (Exception e) {
            POSMessageDialog.showError(e.getMessage());
            return false;
        }
    }

    @Override
    public void updateView() {
        CustomerGroup customerGroup = (CustomerGroup)this.getBean();
        if (customerGroup.getId() != null && !Hibernate.isInitialized(customerGroup.getCustomers())) {
            CustomerDAO dao = new CustomerDAO();
            Session session = dao.getSession();
            customerGroup = (CustomerGroup)session.merge((Object)customerGroup);
            Hibernate.initialize(customerGroup.getCustomers());
            session.close();
        }
        this.customerListModel = new ComboBoxModel();
        if (customerGroup.getCustomers() != null) {
            this.customerListModel.setDataList(customerGroup.getCustomers());
        } else {
            this.customerListModel.setDataList(new ArrayList());
        }
        this.listCustomers.setModel(this.customerListModel);
        try {
            CustomerGroup customerGroup1 = (CustomerGroup)this.getBean();
            if (customerGroup1 == null) {
                return;
            }
            this.tfCustomerGroupName.setText(customerGroup1.getName());
            this.tfCustomerGroupCode.setText(customerGroup1.getCode());
            this.txtCustomerGroupDescription.setText(customerGroup1.getDescription());
        }
        catch (Exception e) {
            PosLog.error(this.getClass(), e);
        }
    }

    @Override
    public boolean updateModel() {
        CustomerGroup customerGroup = (CustomerGroup)this.getBean();
        String name = this.tfCustomerGroupName.getText();
        if (StringUtils.isEmpty((String)name)) {
            POSMessageDialog.showError(OroCustMessages.getString("CustomerGroupForm.16"));
            return false;
        }
        customerGroup.setName(name);
        customerGroup.setCode(this.tfCustomerGroupCode.getText());
        customerGroup.setDescription(this.txtCustomerGroupDescription.getText());
        List customerList = this.customerListModel.getDataList();
        for (Customer customer : customerList) {
            customer.setCustomerGroupId(customerGroup.getId());
            CustomerDAO.getInstance().update(customer);
        }
        customerGroup.setCustomers(customerList);
        return true;
    }

    @Override
    public String getDisplayText() {
        CustomerGroup customerGroup = (CustomerGroup)this.getBean();
        if (customerGroup.getId() == null) {
            return OroCustMessages.getString("CustomerGroupForm.17");
        }
        return OroCustMessages.getString("CustomerGroupForm.18");
    }

    private void doAddCustomer() {
        CustomerSelectionDialog customerSelectionDialog = new CustomerSelectionDialog(this.getEditorDialog(), this.customerListModel.getDataList());
        customerSelectionDialog.setSize(800, 600);
        customerSelectionDialog.open();
        if (customerSelectionDialog.isCanceled()) {
            return;
        }
        List<Customer> selectedCustomerList = customerSelectionDialog.getSelectedCustomerList();
        this.customerListModel.removeAllElements();
        for (Customer customerList : selectedCustomerList) {
            this.customerListModel.addElement(customerList);
        }
    }
}

