/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.orocust.ui.view;

import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.model.DeliveryCharge;
import com.floreantpos.model.dao.DeliveryChargeDAO;
import com.floreantpos.swing.DoubleTextField;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.swing.MessageDialog;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.util.POSUtil;
import com.orocube.orocust.OroCustMessages;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JLabel;
import net.miginfocom.swing.MigLayout;

public class DeliveryChargeForm
extends BeanEditor {
    private DoubleTextField tfStartRange;
    private DoubleTextField tfEndRange;
    private DoubleTextField tfChargeAmount;
    private FixedLengthTextField tfName;
    private FixedLengthTextField tfZipCode;

    public DeliveryChargeForm() {
        this(new DeliveryCharge());
    }

    public DeliveryChargeForm(DeliveryCharge deliveryCharge) {
        this.initComponents();
        this.setBean(deliveryCharge);
    }

    private void initComponents() {
        this.setLayout((LayoutManager)new MigLayout("fill"));
        JLabel lblName = new JLabel(OroCustMessages.getString("DeliveryChargeForm.1") + ":", 4);
        JLabel lblStartRange = new JLabel(OroCustMessages.getString("DeliveryChargeForm.3") + ":", 4);
        JLabel lblEndRange = new JLabel(OroCustMessages.getString("DeliveryChargeForm.5") + ":", 4);
        JLabel lblChargeAmount = new JLabel(OroCustMessages.getString("DeliveryChargeForm.7"), 4);
        JLabel lblZipCode = new JLabel(OroCustMessages.getString("DeliveryChargeForm.8"), 4);
        this.tfStartRange = new DoubleTextField();
        this.tfEndRange = new DoubleTextField();
        this.tfChargeAmount = new DoubleTextField();
        this.tfName = new FixedLengthTextField();
        this.tfName.setLength(220);
        this.tfZipCode = new FixedLengthTextField();
        this.add((Component)lblName, "grow");
        this.add((Component)this.tfName, "grow, wrap");
        this.add((Component)lblZipCode, "grow");
        this.add((Component)this.tfZipCode, "grow,wrap");
        this.add((Component)lblStartRange, "grow");
        this.add((Component)this.tfStartRange, "grow, wrap");
        this.add((Component)lblEndRange, "grow");
        this.add((Component)this.tfEndRange, "grow, wrap");
        this.add((Component)lblChargeAmount, "grow");
        this.add((Component)this.tfChargeAmount, "grow, wrap");
    }

    @Override
    public boolean save() {
        try {
            if (!this.updateModel()) {
                return false;
            }
            DeliveryCharge deliveryCharge = (DeliveryCharge)this.getBean();
            DeliveryChargeDAO dao = new DeliveryChargeDAO();
            dao.saveOrUpdate(deliveryCharge);
        }
        catch (Exception e) {
            MessageDialog.showError(e);
            return false;
        }
        return true;
    }

    @Override
    protected void updateView() {
        DeliveryCharge deliveryCharge = (DeliveryCharge)this.getBean();
        if (deliveryCharge.getId() == null) {
            this.tfName.setText("");
            return;
        }
        this.tfName.setText(deliveryCharge.getName());
        this.tfZipCode.setText(deliveryCharge.getZipCode());
        this.tfStartRange.setText(String.valueOf(deliveryCharge.getStartRange()));
        this.tfEndRange.setText(String.valueOf(deliveryCharge.getEndRange()));
        this.tfChargeAmount.setText(String.valueOf(deliveryCharge.getChargeAmount()));
    }

    @Override
    protected boolean updateModel() {
        DeliveryCharge deliveryCharge = (DeliveryCharge)this.getBean();
        String name = this.tfName.getText();
        String startRange = this.tfStartRange.getText();
        String endRange = this.tfEndRange.getText();
        String chargeAmount = this.tfChargeAmount.getText();
        if (POSUtil.isBlankOrNull(name)) {
            BOMessageDialog.showError(OroCustMessages.getString("DeliveryChargeForm.10"));
            return false;
        }
        if (POSUtil.isBlankOrNull(startRange)) {
            BOMessageDialog.showError(OroCustMessages.getString("DeliveryChargeForm.11"));
            return false;
        }
        if (POSUtil.isBlankOrNull(endRange)) {
            BOMessageDialog.showError(OroCustMessages.getString("DeliveryChargeForm.12"));
            return false;
        }
        if (POSUtil.isBlankOrNull(chargeAmount)) {
            BOMessageDialog.showError(OroCustMessages.getString("DeliveryChargeForm.13"));
            return false;
        }
        deliveryCharge.setName(this.tfName.getText());
        deliveryCharge.setZipCode(this.tfZipCode.getText());
        deliveryCharge.setStartRange(this.tfStartRange.getDouble());
        deliveryCharge.setEndRange(this.tfEndRange.getDouble());
        deliveryCharge.setChargeAmount(this.tfChargeAmount.getDouble());
        return true;
    }

    @Override
    public String getDisplayText() {
        DeliveryCharge deliveryCharge = (DeliveryCharge)this.getBean();
        if (deliveryCharge.getId() == null) {
            return OroCustMessages.getString("DeliveryChargeForm.14");
        }
        return OroCustMessages.getString("DeliveryChargeForm.15");
    }
}

