/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.orocust.ui.view;

import com.floreantpos.ITicketList;
import com.floreantpos.POSConstants;
import com.floreantpos.customer.CustomerSelectorDialog;
import com.floreantpos.customer.CustomerSelectorFactory;
import com.floreantpos.main.Application;
import com.floreantpos.model.Customer;
import com.floreantpos.model.DataUpdateInfo;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.Store;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.dao.DataUpdateInfoDAO;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.swing.POSToggleButton;
import com.floreantpos.swing.PosBlinkButton;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosScrollPane;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.DeliveryDispatchTicketFilterPanel;
import com.floreantpos.ui.TicketListUpdateListener;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.PosGuiUtil;
import com.orocube.orocust.OroCustMessages;
import com.orocube.orocust.ui.DispatchTableCellRenderer;
import com.orocube.orocust.ui.TicketListTableModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.Timer;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.ColorHighlighter;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.HighlightPredicate;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.table.ColumnControlButton;
import org.jdesktop.swingx.table.TableColumnModelExt;
import org.joda.time.DateTime;

public class DeliveryDispatchTicketListView
extends JPanel
implements ITicketList,
DeliveryDispatchTicketFilterPanel.DeliveryDispatchTicketFilterListener {
    private JXTable ticketListTable;
    private TicketListTableModel tableModel;
    private PosBlinkButton btnRefresh;
    private PosButton btnPrevious;
    private PosButton btnNext;
    private TableColumnModelExt columnModel;
    private ArrayList<TicketListUpdateListener> ticketUpdateListenerList = new ArrayList();
    private boolean isCustomerHistoryOpen;
    private List<Ticket> addedTicketList = new ArrayList<Ticket>();
    private Date lastUpdateTime;
    private Timer lastUpateCheckTimer = new Timer(15000, new TaskLastUpdateCheck());
    private DeliveryDispatchTicketFilterPanel filterPanel;
    private POSToggleButton btnOrderFilters;
    private DispatchTableCellRenderer renderer;
    private OrderType orderType;
    private Map<String, JToggleButton> seletedButtonList = new HashMap<String, JToggleButton>();
    private JToggleButton toggleButton;
    private JTextField tfCustomerName;
    private String selectedCustomerId;
    private POSToggleButton btnUnassigned;

    public DeliveryDispatchTicketListView() {
        this.setLayout(new BorderLayout());
        this.createTicketTable();
        this.updateTicketList();
        this.updateButtonStatus();
    }

    public DeliveryDispatchTicketListView(Integer customerId, boolean customerHistory) {
        this.isCustomerHistoryOpen = customerHistory;
        this.setLayout(new BorderLayout());
        this.createTicketTable();
        this.updateTicketList();
        this.updateButtonStatus();
    }

    private void createTicketTable() {
        this.ticketListTable = new JXTable();
        this.ticketListTable.setSortable(true);
        this.ticketListTable.setSelectionMode(0);
        this.ticketListTable.setColumnControlVisible(true);
        this.tableModel = new TicketListTableModel();
        this.tableModel.setPageSize(10);
        this.ticketListTable.setModel((TableModel)this.tableModel);
        this.ticketListTable.setRowHeight(PosUIManager.getSize(60));
        this.ticketListTable.setAutoResizeMode(3);
        this.renderer = new DispatchTableCellRenderer();
        this.ticketListTable.setDefaultRenderer(Object.class, (TableCellRenderer)this.renderer);
        this.ticketListTable.setAutoscrolls(true);
        this.ticketListTable.setShowGrid(true);
        this.ticketListTable.setBorder(null);
        this.ticketListTable.setFocusable(false);
        this.ticketListTable.setDefaultRenderer(Object.class, (TableCellRenderer)new DispatchTableCellRenderer());
        this.ticketListTable.setGridColor(Color.LIGHT_GRAY);
        this.ticketListTable.getTableHeader().setPreferredSize(new Dimension(100, PosUIManager.getSize(40)));
        this.ticketListTable.setHighlighters(new Highlighter[]{new ColorHighlighter((HighlightPredicate)new TicketTableColorHighlighterPredicate(), Color.white, Color.red)});
        this.columnModel = (TableColumnModelExt)this.ticketListTable.getColumnModel();
        this.columnModel.getColumn(0).setPreferredWidth(80);
        this.columnModel.getColumn(1).setPreferredWidth(20);
        this.columnModel.getColumn(2).setPreferredWidth(100);
        this.columnModel.getColumn(3).setPreferredWidth(100);
        this.columnModel.getColumn(5).setPreferredWidth(30);
        this.columnModel.getColumn(6).setPreferredWidth(50);
        this.createScrollPane();
    }

    private void createScrollPane() {
        this.btnOrderFilters = new POSToggleButton();
        this.btnOrderFilters.setText("<html>" + OroCustMessages.getString("SwitchboardView.2") + "</html>");
        this.btnRefresh = new PosBlinkButton(OroCustMessages.getString("TicketListView.3"));
        this.btnPrevious = new PosButton(OroCustMessages.getString("TicketListView.4"));
        this.btnNext = new PosButton(OroCustMessages.getString("TicketListView.5"));
        this.createActionHandlers();
        PosScrollPane scrollPane = new PosScrollPane((Component)this.ticketListTable, 20, 31);
        int height = PosUIManager.getSize(40);
        JPanel topButtonPanel = new JPanel((LayoutManager)new MigLayout("ins 0", "grow", ""));
        ColumnControlButton controlButton = new ColumnControlButton(this.ticketListTable);
        if (!this.isCustomerHistoryOpen) {
            topButtonPanel.add((Component)controlButton, "h " + height + "!, grow, wrap");
        }
        topButtonPanel.add((Component)this.btnRefresh, "h " + height + "!, grow, wrap");
        topButtonPanel.add((Component)this.btnPrevious, "h " + height + "!, grow, wrap");
        JPanel downButtonPanel = new JPanel((LayoutManager)new MigLayout("ins 0", "grow", ""));
        downButtonPanel.add((Component)this.btnNext, "h " + height + "!, grow, wrap");
        downButtonPanel.add((Component)this.btnOrderFilters, "h " + height + "!, grow, wrap");
        JPanel tableButtonPanel = new JPanel(new BorderLayout());
        tableButtonPanel.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        tableButtonPanel.setPreferredSize(new Dimension(PosUIManager.getSize(80), 0));
        tableButtonPanel.add((Component)topButtonPanel, "North");
        tableButtonPanel.add((Component)downButtonPanel, "South");
        tableButtonPanel.add(scrollPane.getVerticalScrollBar());
        ArrayList<String> filters = new ArrayList<String>();
        filters.add(POSConstants.ALL);
        filters.add(POSConstants.TODAY);
        filters.add(POSConstants.TOMORROW);
        filters.add(OroCustMessages.getString("OroCust.DDTLV.5"));
        filters.add(OroCustMessages.getString("OroCust.DDTLV.6"));
        filters.add(OroCustMessages.getString("OroCust.DDTLV.7"));
        JPanel customerFitlerPanel = new JPanel((LayoutManager)new MigLayout("fillx"));
        customerFitlerPanel.setBorder(new TitledBorder(""));
        this.filterPanel = new DeliveryDispatchTicketFilterPanel(filters);
        this.filterPanel.addFilterListener((DeliveryDispatchTicketFilterPanel.DeliveryDispatchTicketFilterListener)this);
        JLabel lblByCustomer = new JLabel(OroCustMessages.getString("OroCust.DDTLV.10"));
        this.tfCustomerName = new JTextField(15);
        this.tfCustomerName.setEditable(false);
        PosButton btnSelect = new PosButton(OroCustMessages.getString("OroCust.DDTLV.11"));
        btnSelect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CustomerSelectorDialog dialog = CustomerSelectorFactory.createCustomerSelectorDialog(DeliveryDispatchTicketListView.this.orderType);
                dialog.setLocationRelativeTo(Application.getPosWindow());
                dialog.setCreateNewTicket(false);
                dialog.setVisibleOnlySelectionButtons(true);
                dialog.openUndecoratedFullScreen();
                if (dialog.isCanceled()) {
                    return;
                }
                Customer customer = dialog.getSelectedCustomer();
                if (customer == null) {
                    return;
                }
                DeliveryDispatchTicketListView.this.tfCustomerName.setText(customer.getName());
                DeliveryDispatchTicketListView.this.selectedCustomerId = customer.getId();
                DeliveryDispatchTicketListView.this.updateTicketList();
            }
        });
        PosButton btnClear = new PosButton(OroCustMessages.getString("OroCust.DDTLV.12"));
        btnClear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DeliveryDispatchTicketListView.this.selectedCustomerId = null;
                DeliveryDispatchTicketListView.this.tfCustomerName.setText("");
                DeliveryDispatchTicketListView.this.updateTicketList();
            }
        });
        customerFitlerPanel.add((Component)lblByCustomer, "split 4");
        customerFitlerPanel.add((Component)this.tfCustomerName, "grow");
        customerFitlerPanel.add((Component)btnSelect, "w " + PosUIManager.getSize(70));
        customerFitlerPanel.add((Component)btnClear, "w " + PosUIManager.getSize(70));
        JPanel filterUnassignedPanel = new JPanel((LayoutManager)new MigLayout("fillx"));
        this.btnUnassigned = new POSToggleButton(OroCustMessages.getString("OroCust.DDTLV.19"));
        this.btnUnassigned.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DeliveryDispatchTicketListView.this.updateTicketList();
            }
        });
        filterUnassignedPanel.setBorder(BorderFactory.createTitledBorder(""));
        filterUnassignedPanel.add((Component)this.btnUnassigned, "growx,w " + PosUIManager.getSize(150));
        this.filterPanel.getContentPane().add(filterUnassignedPanel);
        this.filterPanel.getContentPane().add((Component)customerFitlerPanel, "growx,span");
        this.add((Component)this.filterPanel, "North");
        this.add(scrollPane);
        this.add((Component)tableButtonPanel, "East");
    }

    public void createActionHandlers() {
        this.btnPrevious.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DeliveryDispatchTicketListView.this.tableModel.hasPrevious()) {
                    DeliveryDispatchTicketListView.this.tableModel.setCurrentRowIndex(DeliveryDispatchTicketListView.this.tableModel.getPreviousRowIndex());
                    DeliveryDispatchTicketListView.this.doPerformFilter();
                }
                DeliveryDispatchTicketListView.this.updateButtonStatus();
            }
        });
        this.btnNext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DeliveryDispatchTicketListView.this.tableModel.hasNext()) {
                    DeliveryDispatchTicketListView.this.tableModel.setCurrentRowIndex(DeliveryDispatchTicketListView.this.tableModel.getNextRowIndex());
                    DeliveryDispatchTicketListView.this.doPerformFilter();
                }
                DeliveryDispatchTicketListView.this.updateButtonStatus();
            }
        });
        this.btnRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DeliveryDispatchTicketListView.this.getTableModel().setCurrentRowIndex(0);
                DeliveryDispatchTicketListView.this.doPerformFilter();
                DeliveryDispatchTicketListView.this.updateButtonStatus();
                DeliveryDispatchTicketListView.this.setTicketNeedSpecialAttension();
            }
        });
        this.btnOrderFilters.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DeliveryDispatchTicketListView.this.filterPanel.setCollapsed(!DeliveryDispatchTicketListView.this.filterPanel.isCollapsed());
            }
        });
    }

    public void updateButtonStatus() {
        this.btnNext.setEnabled(this.tableModel.hasNext());
        this.btnPrevious.setEnabled(this.tableModel.hasPrevious());
    }

    @Override
    public synchronized void updateTicketList() {
        this.toggleButton = this.filterPanel.getToggleButton();
        this.doPerformFilter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setTicketList() {
        try {
            Application.getPosWindow().setGlassPaneVisible(true);
            Date startDate = null;
            Date endDate = null;
            DateTime now = DateTime.now();
            DateTime todayStart = now.withTimeAtStartOfDay();
            DateTime tomorrowStart = now.plusDays(1).withTimeAtStartOfDay();
            DateTime tomorrowEnd = tomorrowStart.plusDays(1).withTimeAtStartOfDay();
            boolean isOnline = false;
            boolean isPickup = false;
            boolean isDelivery = false;
            JToggleButton todayToggleButton = this.seletedButtonList.get(POSConstants.TODAY);
            JToggleButton tomorrowToggleButton = this.seletedButtonList.get(POSConstants.TOMORROW);
            JToggleButton onlineToggleButton = this.seletedButtonList.get(OroCustMessages.getString("OroCust.DDTLV.5"));
            JToggleButton pickUpToggleButton = this.seletedButtonList.get(OroCustMessages.getString("OroCust.DDTLV.6"));
            JToggleButton deliveryToggleButton = this.seletedButtonList.get(OroCustMessages.getString("OroCust.DDTLV.7"));
            if (todayToggleButton != null && todayToggleButton.isSelected()) {
                startDate = todayStart.toDate();
                endDate = tomorrowStart.toDate();
            }
            if (tomorrowToggleButton != null && tomorrowToggleButton.isSelected()) {
                startDate = tomorrowStart.toDate();
                endDate = tomorrowEnd.toDate();
            }
            if (onlineToggleButton != null && onlineToggleButton.isSelected()) {
                isOnline = true;
            }
            if (pickUpToggleButton != null && pickUpToggleButton.isSelected()) {
                isPickup = true;
            }
            if (deliveryToggleButton != null && deliveryToggleButton.isSelected()) {
                isDelivery = true;
            }
            boolean isUnassigned = this.btnUnassigned.isSelected();
            TicketListTableModel ticketListTableModel = this.getTableModel();
            TicketDAO.getInstance().loadDeliveryTickets(ticketListTableModel, this.selectedCustomerId, startDate, endDate, isOnline, isPickup, isDelivery, isUnassigned);
            this.updateButtonStatus();
            this.btnRefresh.setBlinking(false);
            for (int i = 0; i < this.ticketUpdateListenerList.size(); ++i) {
                TicketListUpdateListener listener = this.ticketUpdateListenerList.get(i);
                listener.ticketListUpdated();
            }
        }
        catch (Exception e) {
            POSMessageDialog.showError(this, OroCustMessages.getString("SwitchboardView.19"), e);
        }
        finally {
            Application.getPosWindow().setGlassPaneVisible(false);
        }
    }

    public void addTicketListUpateListener(TicketListUpdateListener l) {
        this.ticketUpdateListenerList.add(l);
    }

    public void setTicketNeedSpecialAttension() {
        Store store = Application.getInstance().getStore();
        if (store == null) {
            return;
        }
        String strMin = store.getProperty("deliveryConfig.highlightBeforeMinute");
        if (StringUtils.isEmpty((String)strMin)) {
            return;
        }
        int minutes = Integer.valueOf(strMin);
        if (minutes < 0) {
            return;
        }
        List ticketList = this.tableModel.getRows();
        if (ticketList == null || ticketList.size() == 0) {
            return;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Ticket ticket : ticketList) {
            long deliveryTimeMillis;
            long timeDiffInMillis;
            long timeDiffInMin;
            Date deliveryDate = ticket.getDeliveryDate();
            if (deliveryDate == null || (timeDiffInMin = (timeDiffInMillis = (deliveryTimeMillis = deliveryDate.getTime()) - currentTimeMillis) / 1000L / 60L) >= (long)minutes) continue;
            ticket.setNeedSpecialAttention(true);
        }
    }

    public void setTickets(List<Ticket> tickets) {
        ArrayList<Ticket> newTicketList = new ArrayList<Ticket>();
        if (tickets != null && !tickets.isEmpty()) {
            for (Ticket ticket : tickets) {
                ticket = TicketDAO.getInstance().loadFullTicket(ticket.getId());
                boolean sentToKitchen = false;
                boolean readyToDelivery = true;
                for (TicketItem ticketItem : ticket.getTicketItems()) {
                    if (ticketItem.isPrintedToKitchen().booleanValue()) {
                        sentToKitchen = true;
                    }
                    if (ticketItem.getKitchenStatus().equals("Ready")) continue;
                    readyToDelivery = false;
                }
                if (sentToKitchen) {
                    if (readyToDelivery) {
                        ticket.setStatus("Ready");
                        ticket.setSortOrder("1");
                    } else {
                        ticket.setStatus("Waiting (Kitchen)");
                        ticket.setSortOrder("2");
                    }
                } else {
                    ticket.setStatus("Not Sent");
                    ticket.setSortOrder("3");
                }
                newTicketList.add(ticket);
            }
            Collections.sort(newTicketList, new Comparator<Ticket>(){

                @Override
                public int compare(Ticket o1, Ticket o2) {
                    return o1.getSortOrder().compareTo(o2.getSortOrder());
                }
            });
        }
        this.tableModel.setRows(newTicketList);
    }

    public List<Ticket> getTickets() {
        return this.tableModel.getRows();
    }

    public void addTicket(Ticket ticket) {
        this.tableModel.addItem(ticket);
    }

    @Override
    public Ticket getSelectedTicket() {
        int selectedRow = this.ticketListTable.getSelectedRow();
        if (selectedRow < 0) {
            return null;
        }
        return (Ticket)this.tableModel.getRowData(this.ticketListTable.convertRowIndexToModel(selectedRow));
    }

    public List<Ticket> getSelectedTickets() {
        int[] selectedRows = this.ticketListTable.getSelectedRows();
        ArrayList<Ticket> tickets = new ArrayList<Ticket>(selectedRows.length);
        for (int i = 0; i < selectedRows.length; ++i) {
            Ticket ticket = (Ticket)this.tableModel.getRowData(this.ticketListTable.convertRowIndexToModel(selectedRows[i]));
            tickets.add(ticket);
        }
        return tickets;
    }

    public List<Ticket> getAddedTickets() {
        return this.addedTicketList;
    }

    public Ticket getFirstSelectedTicket() {
        List<Ticket> selectedTickets = this.getSelectedTickets();
        if (selectedTickets.size() == 0 || selectedTickets.size() > 1) {
            POSMessageDialog.showMessage(OroCustMessages.getString("TicketListView.14"));
            return null;
        }
        Ticket ticket = selectedTickets.get(0);
        return ticket;
    }

    public String getFirstSelectedTicketId() {
        Ticket ticket = this.getFirstSelectedTicket();
        if (ticket == null) {
            return null;
        }
        return ticket.getId();
    }

    public JTable getTable() {
        return this.ticketListTable;
    }

    public TicketListTableModel getTableModel() {
        return this.tableModel;
    }

    public void setCurrentRowIndexZero() {
        this.getTableModel().setCurrentRowIndex(0);
    }

    public void setAutoUpdateCheck(boolean check) {
        if (check) {
            this.lastUpateCheckTimer.restart();
        } else {
            this.lastUpateCheckTimer.stop();
        }
    }

    private void doPerformFilter() {
        if (this.toggleButton == null) {
            return;
        }
        this.setTicketList();
    }

    public void filterSelected(JToggleButton toggleButton) {
        JToggleButton pickUpBtn;
        this.toggleButton = toggleButton;
        String actionCommand = toggleButton.getActionCommand();
        if (actionCommand.equals(OroCustMessages.getString("OroCust.DDTLV.6"))) {
            JToggleButton deliveryButton = this.seletedButtonList.get(OroCustMessages.getString("OroCust.DDTLV.7"));
            if (deliveryButton != null) {
                deliveryButton.setSelected(false);
            }
        } else if (actionCommand.equals(OroCustMessages.getString("OroCust.DDTLV.7")) && (pickUpBtn = this.seletedButtonList.get(OroCustMessages.getString("OroCust.DDTLV.6"))) != null) {
            pickUpBtn.setSelected(false);
        }
        this.seletedButtonList.put(actionCommand, toggleButton);
        this.doPerformFilter();
    }

    public void setOrderType(OrderType orderType) {
        this.orderType = orderType;
    }

    public void filterUnSelected(JToggleButton toggleButton) {
        this.seletedButtonList.put(toggleButton.getActionCommand(), null);
        this.doPerformFilter();
    }

    class TicketTableColorHighlighterPredicate
    implements HighlightPredicate {
        TicketTableColorHighlighterPredicate() {
        }

        public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
            Ticket rowData = (Ticket)DeliveryDispatchTicketListView.this.tableModel.getRowData(adapter.row);
            return rowData.isNeedSpecialAttention();
        }
    }

    private class TaskLastUpdateCheck
    implements ActionListener {
        private TaskLastUpdateCheck() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                if (PosGuiUtil.isModalDialogShowing()) {
                    return;
                }
                DeliveryDispatchTicketListView.this.lastUpateCheckTimer.stop();
                DataUpdateInfo lastUpdateInfo = DataUpdateInfoDAO.getLastUpdateInfo();
                if (lastUpdateInfo != null && lastUpdateInfo.getLastUpdateTime().after(DeliveryDispatchTicketListView.this.lastUpdateTime)) {
                    DeliveryDispatchTicketListView.this.btnRefresh.setBlinking(true);
                }
                DeliveryDispatchTicketListView.this.setTicketNeedSpecialAttension();
                DeliveryDispatchTicketListView.this.ticketListTable.repaint();
            }
            finally {
                DeliveryDispatchTicketListView.this.lastUpateCheckTimer.restart();
            }
        }
    }
}

