/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.orocust.ui.view;

import com.floreantpos.PosLog;
import com.floreantpos.model.Store;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.swing.PosButton;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.NumberUtil;
import com.orocube.orocust.OroCustMessages;
import com.orocube.orocust.ui.util.GMapUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingWorker;
import net.miginfocom.swing.MigLayout;

public class MapBrowser
extends JPanel {
    private JLabel lblDistance;
    private String source;
    private String destination;
    private static int zoom = 12;
    private double distanceValue;
    private String lengthUnit;
    private String googleMapApiKey;
    private JLabel mapView;

    public MapBrowser() {
        this.setLayout(new BorderLayout());
        JPanel headerPanel = new JPanel((LayoutManager)new MigLayout("fillx, hidemode 3"));
        this.lblDistance = new JLabel();
        PosButton btnZoomPlus = new PosButton("+");
        btnZoomPlus.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                zoom++;
                LoadMapTask map = new LoadMapTask(MapBrowser.this.source, MapBrowser.this.destination);
                map.execute();
            }
        });
        PosButton btnZoomMinus = new PosButton("-");
        btnZoomMinus.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                zoom--;
                LoadMapTask map = new LoadMapTask(MapBrowser.this.source, MapBrowser.this.destination);
                map.execute();
            }
        });
        headerPanel.add((Component)this.lblDistance, "grow");
        this.mapView = new JLabel();
        JScrollPane scrollPane = new JScrollPane(this.mapView);
        scrollPane.setBorder(null);
        headerPanel.add((Component)btnZoomPlus, "right, w 30!, h 20!,split 2");
        headerPanel.add((Component)btnZoomMinus, "w 30!, h 20!");
        this.add((Component)headerPanel, "North");
        this.add((Component)scrollPane, "Center");
        Store store = DataProvider.get().getStore();
        this.lengthUnit = store.getProperty("deliveryConfig.unitName", "KM");
        this.googleMapApiKey = store.getProperty("google.map.api.key", "AIzaSyDc-5LFTSC-bB9kQcZkM74LHUxwndRy_XM");
    }

    public void load(String source, String destination) {
        this.source = source;
        this.destination = destination;
        new LoadMapTask(source, destination).execute();
    }

    public Double getDistance() {
        return this.distanceValue;
    }

    private class LoadMapTask
    extends SwingWorker<BufferedImage, Object> {
        private String source;
        private String destination;
        private String distance;
        private String duration;
        private String direction;

        public LoadMapTask(String source, String destination) {
            if (source != null) {
                source = source.replaceAll("\\s+", "+");
            }
            if (destination != null) {
                destination = destination.replaceAll("\\s+", "+");
            }
            this.source = source;
            this.destination = destination;
            try {
                this.doInBackground();
            }
            catch (Exception e) {
                PosLog.error(MapBrowser.class, e);
            }
        }

        @Override
        protected BufferedImage doInBackground() throws Exception {
            BufferedImage mapImage = null;
            this.direction = GMapUtil.getDirection(this.source, this.destination);
            String[] output = GMapUtil.getDistanceAndDuration(this.source, this.destination);
            double distanceInMeter = Double.valueOf(output[0]);
            if ("KM".equals(MapBrowser.this.lengthUnit)) {
                MapBrowser.this.distanceValue = NumberUtil.roundToTwoDigit(distanceInMeter / 1000.0);
            } else {
                MapBrowser.this.distanceValue = NumberUtil.roundToTwoDigit(distanceInMeter * 6.21371E-4);
            }
            this.distance = String.valueOf(MapBrowser.this.distanceValue);
            this.duration = output[1];
            try {
                URL mapUrl = new URL("https://maps.googleapis.com/maps/api/staticmap?&zoom=" + zoom + "&markers=color:green%7Clabel:G%7C" + this.source + "&markers=color:red%7Clabel:C%7C" + this.destination + "&size=712x712&path=enc:" + this.direction + "&key=" + MapBrowser.this.googleMapApiKey);
                mapImage = ImageIO.read(mapUrl);
            }
            catch (Exception exp) {
                PosLog.error(MapBrowser.class, exp);
            }
            return mapImage;
        }

        @Override
        protected void done() {
            try {
                MapBrowser.this.lblDistance.setText("<html><b>" + OroCustMessages.getString("MapBrowser.17") + this.distance + " " + MapBrowser.this.lengthUnit.toLowerCase() + "," + OroCustMessages.getString("MapBrowser.20") + this.duration + "</b></html>");
                BufferedImage image = (BufferedImage)this.get();
                if (image != null) {
                    MapBrowser.this.mapView.setIcon(new ImageIcon(image.getScaledInstance(MapBrowser.this.getWidth() - 30, MapBrowser.this.getHeight() - 75, 4)));
                }
            }
            catch (Exception ex) {
                POSMessageDialog.showError(OroCustMessages.getString("MapBrowser.22") + ex.getMessage());
            }
        }
    }
}

