/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.orocust.ui.view;

import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.bo.ui.CustomCellRenderer;
import com.floreantpos.model.DeliveryCharge;
import com.floreantpos.model.Store;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.dao.DeliveryChargeDAO;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.swing.DoubleTextField;
import com.floreantpos.swing.FixedLengthDocument;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.swing.IntegerTextField;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.RefreshableView;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.ConfirmDeleteDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.POSUtil;
import com.orocube.orocust.OroCustMessages;
import com.orocube.orocust.ui.view.DeliveryChargeForm;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Font;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.URI;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableCellRenderer;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;
import org.hibernate.StaleStateException;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.table.TableColumnModelExt;

public class OrocustConfigurationView
extends JPanel
implements RefreshableView {
    private JXTable table;
    private BeanTableModel<DeliveryCharge> tableModel;
    private JComboBox cbUnits;
    private JCheckBox chkChargeByZipCode;
    private JTextArea taTerminalLocation;
    private FixedLengthTextField tfMapApiKey;
    private TableColumnModelExt columnModel;
    private JLabel lblHighlightMin;
    private IntegerTextField tfMin;
    private Store store;
    private JLabel lblDefaultOrderPrepTime;
    private IntegerTextField tfPreperationTime;
    private JCheckBox chkCallerIdEnable;
    private JComboBox cbCallerIds;
    private JLabel lblExchangeRate;
    private JLabel lblPointForPurchases;
    private JLabel lblPointForVisit;
    private JLabel lblMinRedeemable;
    private JCheckBox chkLoyaltyEnable;
    private DoubleTextField tfExchangeRate;
    private IntegerTextField tfPointForPurchases;
    private IntegerTextField tfPointForVisit;
    private IntegerTextField tfMinRedeemable;
    private JCheckBox chkDeductPoint;

    public OrocustConfigurationView() {
        this.initComponents();
        this.initializeData();
    }

    @Override
    public String getName() {
        return POSConstants.CONFIG_TAB_DELIVERY;
    }

    public void initializeData() {
        this.store = DataProvider.get().getStore();
        String strChargeByZipCode = this.store.getProperty("deliveryConfig.zipcode");
        String strHighlightBeforeMin = this.store.getProperty("deliveryConfig.highlightBeforeMinute");
        String strLengthUnitName = this.store.getProperty("deliveryConfig.unitName");
        String strPreperationTime = this.store.getProperty("deliveryConfig.preperationTime");
        if (StringUtils.isEmpty((String)strChargeByZipCode) || StringUtils.isEmpty((String)strHighlightBeforeMin) || StringUtils.isEmpty((String)strPreperationTime)) {
            strChargeByZipCode = "false";
            strHighlightBeforeMin = "0";
            strPreperationTime = "40";
            this.store.addProperty("deliveryConfig.highlightBeforeMinute", strHighlightBeforeMin);
            this.store.addProperty("deliveryConfig.zipcode", strHighlightBeforeMin);
            this.store.addProperty("deliveryConfig.preperationTime", strPreperationTime);
            StoreDAO.getInstance().saveOrUpdate(this.store);
            DataProvider.get().refreshStore();
        }
        if (StringUtils.isNotEmpty((String)strLengthUnitName)) {
            if (strLengthUnitName.equals("MILE")) {
                this.cbUnits.setSelectedItem("MILE");
            } else {
                this.cbUnits.setSelectedItem("KM");
            }
        }
        this.tfPreperationTime.setText(strPreperationTime);
        this.cbCallerIds.setSelectedItem(this.store.getProperty("callerId.device"));
        this.chkCallerIdEnable.setSelected(Boolean.valueOf(this.store.getProperty("callerId.CallerIdEnable")));
        this.setVisiblity(this.chkCallerIdEnable.isSelected());
        Terminal terminal = DataProvider.get().getCurrentTerminal();
        this.taTerminalLocation.setText(terminal.getLocation());
        Boolean loyaltyEnabled = this.store.getProperty("loyalty.enabled") == null ? false : Boolean.valueOf(this.store.getProperty("loyalty.enabled"));
        Boolean loyaltyDeductPoint = this.store.getProperty("loyalty.deductPointOnRefund") == null ? false : Boolean.valueOf(this.store.getProperty("loyalty.deductPointOnRefund"));
        this.chkLoyaltyEnable.setSelected(loyaltyEnabled);
        this.chkDeductPoint.setSelected(loyaltyDeductPoint);
        this.tfExchangeRate.setText(this.store.getProperty("loyalty.exchangeRate"));
        this.tfPointForPurchases.setText(this.store.getProperty("loyalty.pointForPuchases"));
        this.tfPointForVisit.setText(this.store.getProperty("loyalty.pointForVisit"));
        this.tfMinRedeemable.setText(this.store.getProperty("loyalty.minRedeemablePoint"));
        this.setVisibleLoyaltyProgram(loyaltyEnabled);
        boolean isChargeByZipCode = Boolean.valueOf(strChargeByZipCode);
        this.chkChargeByZipCode.setSelected(isChargeByZipCode);
        Integer highlightBeforeMinute = Integer.valueOf(strHighlightBeforeMin);
        if (highlightBeforeMinute != null) {
            this.tfMin.setText(String.valueOf(highlightBeforeMinute));
        }
        String map_api_key = this.store.getProperty("google.map.api.key", "AIzaSyDc-5LFTSC-bB9kQcZkM74LHUxwndRy_XM");
        this.tfMapApiKey.setText(map_api_key);
        this.columnModel.getColumnExt((Object)OroCustMessages.getString("OrocustConfigurationView.6")).setVisible(!this.chkChargeByZipCode.isSelected());
        this.columnModel.getColumnExt((Object)OroCustMessages.getString("OrocustConfigurationView.7")).setVisible(!this.chkChargeByZipCode.isSelected());
    }

    public boolean save() {
        try {
            String unit = this.cbUnits.getSelectedItem().toString();
            int min = this.tfMin.getInteger();
            int preperationTime = this.tfPreperationTime.getInteger();
            this.store.addProperty("deliveryConfig.unitName", unit);
            this.store.addProperty("deliveryConfig.zipcode", String.valueOf(this.chkChargeByZipCode.isSelected()));
            this.store.addProperty("deliveryConfig.highlightBeforeMinute", String.valueOf(min));
            this.store.addProperty("deliveryConfig.preperationTime", String.valueOf(preperationTime));
            this.store.addProperty("callerId.CallerIdEnable", String.valueOf(this.chkCallerIdEnable.isSelected()));
            this.store.addProperty("callerId.device", String.valueOf(this.cbCallerIds.getSelectedItem()));
            this.store.addProperty("google.map.api.key", this.tfMapApiKey.getText());
            boolean isLoyaltyEnabled = this.chkLoyaltyEnable.isSelected();
            this.store.addProperty("loyalty.enabled", String.valueOf(isLoyaltyEnabled));
            if (isLoyaltyEnabled) {
                if (this.tfPointForPurchases.getInteger() <= 0) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), OroCustMessages.getString("pointForPurchasesNotZero"));
                    return false;
                }
                if (this.tfMinRedeemable.getInteger() <= 0) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), OroCustMessages.getString("minRedeemableNotZero"));
                    return false;
                }
                this.store.addProperty("loyalty.deductPointOnRefund", String.valueOf(this.chkDeductPoint.isSelected()));
                this.store.addProperty("loyalty.exchangeRate", String.valueOf(this.tfExchangeRate.getDoubleOrZero()));
                this.store.addProperty("loyalty.pointForPuchases", String.valueOf(this.tfPointForPurchases.getInteger()));
                this.store.addProperty("loyalty.pointForVisit", String.valueOf(this.tfPointForVisit.getInteger()));
                this.store.addProperty("loyalty.minRedeemablePoint", String.valueOf(this.tfMinRedeemable.getInteger()));
            }
            Terminal terminal = DataProvider.get().getCurrentTerminal();
            terminal.setLocation(this.taTerminalLocation.getText());
            TerminalDAO.getInstance().update(terminal);
            StoreDAO.getInstance().saveOrUpdate(this.store);
            DataProvider.get().refreshStore();
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), OroCustMessages.getString("OrocustConfigurationView.10"));
            return true;
        }
        catch (StaleStateException e) {
            POSMessageDialog.showMessageDialogWithReloadButton(POSUtil.getFocusedWindow(), this);
        }
        catch (Exception e) {
            POSMessageDialog.showError(e.getMessage(), e);
        }
        return false;
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.chkCallerIdEnable = new JCheckBox(OroCustMessages.getString(OroCustMessages.getString("OrocustConfigurationView.11")));
        Vector<String> callerIds = new Vector<String>();
        callerIds.add(OroCustMessages.getString("OrocustConfigurationView.12"));
        callerIds.add(OroCustMessages.getString("OrocustConfigurationView.13"));
        callerIds.add(OroCustMessages.getString("OrocustConfigurationView.14"));
        this.cbCallerIds = new JComboBox(callerIds);
        JPanel topConfigPanel = new JPanel((LayoutManager)new MigLayout("", "[][][]", ""));
        this.lblHighlightMin = new JLabel(OroCustMessages.getString("OrocustConfigurationView.18"));
        this.tfMin = new IntegerTextField(5);
        this.lblDefaultOrderPrepTime = new JLabel(OroCustMessages.getString("OrocustConfigurationView.19"));
        this.tfPreperationTime = new IntegerTextField(5);
        this.chkCallerIdEnable.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                JCheckBox chkbox = (JCheckBox)e.getSource();
                OrocustConfigurationView.this.setVisiblity(chkbox.isSelected());
            }
        });
        topConfigPanel.add((Component)this.chkCallerIdEnable, "skip 1,wrap");
        topConfigPanel.add((Component)new JLabel(OroCustMessages.getString("OrocustConfigurationView.20")), "right");
        topConfigPanel.add((Component)this.cbCallerIds, "wrap,grow");
        topConfigPanel.add((Component)this.lblDefaultOrderPrepTime, "right");
        topConfigPanel.add((Component)this.tfPreperationTime, "growx");
        topConfigPanel.add((Component)new JLabel(OroCustMessages.getString("OrocustConfigurationView.2")), "wrap");
        topConfigPanel.add((Component)this.lblHighlightMin, "");
        topConfigPanel.add((Component)this.tfMin, "growx");
        topConfigPanel.add(new JLabel("Min"));
        JPanel contentPanel = new JPanel();
        contentPanel.setLayout((LayoutManager)new MigLayout("fill", "", ""));
        contentPanel.setBorder(new TitledBorder(OroCustMessages.getString("OrocustConfigurationView.8")));
        JButton addButton = new JButton(POSConstants.ADD);
        addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OrocustConfigurationView.this.doAdd();
            }
        });
        JButton editButton = new JButton(POSConstants.EDIT);
        editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OrocustConfigurationView.this.doEdit();
            }
        });
        JButton deleteButton = new JButton(POSConstants.DELETE);
        deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OrocustConfigurationView.this.doDelete();
            }
        });
        this.tableModel = new BeanTableModel(DeliveryCharge.class);
        this.tableModel.addColumn(POSConstants.NAME.toUpperCase(), "name");
        this.tableModel.addColumn(OroCustMessages.getString("OrocustConfigurationView.27"), "zipCode");
        this.tableModel.addColumn(OroCustMessages.getString("OrocustConfigurationView.28"), "startRange");
        this.tableModel.addColumn(OroCustMessages.getString("OrocustConfigurationView.29"), "endRange");
        this.tableModel.addColumn(OroCustMessages.getString("OrocustConfigurationView.30"), "chargeAmount");
        this.tableModel.addRows(DeliveryChargeDAO.getInstance().findAll());
        this.table = new JXTable(this.tableModel);
        this.table.setDefaultRenderer(Object.class, (TableCellRenderer)new CustomCellRenderer());
        this.columnModel = (TableColumnModelExt)this.table.getColumnModel();
        JPanel deliveryChargePanel = new JPanel((LayoutManager)new MigLayout("fill"));
        deliveryChargePanel.setBorder(new TitledBorder(OroCustMessages.getString("OrocustConfigurationView.32")));
        TransparentPanel panel = new TransparentPanel();
        panel.add(addButton);
        panel.add(editButton);
        panel.add(deleteButton);
        deliveryChargePanel.add((Component)new JScrollPane((Component)this.table), "grow,wrap");
        deliveryChargePanel.add((Component)panel, "grow,center");
        JLabel lblLengthUnit = new JLabel("Length unit: ");
        Vector<String> units = new Vector<String>();
        units.add("KM");
        units.add("MILE");
        this.cbUnits = new JComboBox(units);
        this.taTerminalLocation = new JTextArea(new FixedLengthDocument(320));
        this.chkChargeByZipCode = new JCheckBox(OroCustMessages.getString("OrocustConfigurationView.34"));
        this.chkChargeByZipCode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OrocustConfigurationView.this.columnModel.getColumnExt((Object)OroCustMessages.getString("OrocustConfigurationView.35")).setVisible(!OrocustConfigurationView.this.chkChargeByZipCode.isSelected());
                OrocustConfigurationView.this.columnModel.getColumnExt((Object)OroCustMessages.getString("OrocustConfigurationView.36")).setVisible(!OrocustConfigurationView.this.chkChargeByZipCode.isSelected());
            }
        });
        this.tfMapApiKey = new FixedLengthTextField();
        this.tfMapApiKey.setLength(220);
        JButton btnGetMapKey = new JButton("Get Map Key");
        btnGetMapKey.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String link = "https://console.developers.google.com/flows/enableapi?apiid=places_backend&keyType=SERVER_SIDE";
                try {
                    OrocustConfigurationView.this.openBrowser(link);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        btnGetMapKey.setFont(new Font(this.getFont().getName(), 1, 11));
        JPanel centerConfigPanel = new JPanel((LayoutManager)new MigLayout("left", "[][]", ""));
        centerConfigPanel.add((Component)lblLengthUnit, "right");
        centerConfigPanel.add((Component)this.cbUnits, "w 150!,wrap");
        centerConfigPanel.add((Component)new JLabel(OroCustMessages.getString("OrocustConfigurationView.41")), "right");
        centerConfigPanel.add((Component)this.tfMapApiKey, "split 2");
        centerConfigPanel.add((Component)btnGetMapKey, "wrap");
        JLabel lblLocation = new JLabel(OroCustMessages.getString("OrocustConfigurationView.1"));
        centerConfigPanel.add((Component)lblLocation, "right");
        centerConfigPanel.add((Component)new JScrollPane(this.taTerminalLocation), "w 500!, h 100!,wrap");
        centerConfigPanel.add((Component)this.chkChargeByZipCode, "skip 1");
        contentPanel.add((Component)centerConfigPanel, "grow, wrap");
        contentPanel.add((Component)deliveryChargePanel, "h 250!,grow");
        JPanel saveBtnPanel = new JPanel((LayoutManager)new MigLayout("center"));
        JButton btnSave = new JButton(POSConstants.SAVE);
        saveBtnPanel.add((Component)btnSave, "center");
        btnSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OrocustConfigurationView.this.save();
            }
        });
        JPanel centerPanel = new JPanel(new BorderLayout());
        centerPanel.add((Component)this.addLoyaltyPanel(), "North");
        centerPanel.add((Component)contentPanel, "Center");
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.add((Component)topConfigPanel, "North");
        mainPanel.add((Component)centerPanel, "Center");
        mainPanel.add((Component)saveBtnPanel, "South");
        this.add((Component)new JScrollPane(mainPanel), "Center");
    }

    private JPanel addLoyaltyPanel() {
        JPanel loyaltyPanel = new JPanel((LayoutManager)new MigLayout("left,hidemode 3", "[][]", ""));
        loyaltyPanel.setBorder(new TitledBorder(OroCustMessages.getString("LoyaltyConfig")));
        String currencySymbol = CurrencyUtil.getCurrencySymbol();
        this.chkLoyaltyEnable = new JCheckBox(OroCustMessages.getString("enableLoyaltyProgram"));
        this.chkLoyaltyEnable.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                JCheckBox chkbox = (JCheckBox)e.getSource();
                OrocustConfigurationView.this.setVisibleLoyaltyProgram(chkbox.isSelected());
            }
        });
        this.lblExchangeRate = new JLabel(OroCustMessages.getString("exchangeRate") + currencySymbol);
        this.tfExchangeRate = new DoubleTextField(0, 8, 4);
        this.lblPointForPurchases = new JLabel(OroCustMessages.getString("pointForPurchases") + currencySymbol);
        this.tfPointForPurchases = new IntegerTextField();
        this.lblPointForVisit = new JLabel(OroCustMessages.getString("pointForVisit"));
        this.tfPointForVisit = new IntegerTextField();
        this.lblMinRedeemable = new JLabel(OroCustMessages.getString("minRedeemable"));
        this.tfMinRedeemable = new IntegerTextField();
        this.chkDeductPoint = new JCheckBox(OroCustMessages.getString("deductPoint"));
        loyaltyPanel.add((Component)this.chkLoyaltyEnable, "wrap,skip 1");
        loyaltyPanel.add((Component)this.lblExchangeRate, "right");
        loyaltyPanel.add((Component)this.tfExchangeRate, "w 150!,wrap");
        loyaltyPanel.add((Component)this.lblPointForPurchases, "right");
        loyaltyPanel.add((Component)this.tfPointForPurchases, "w 150!,wrap");
        loyaltyPanel.add((Component)this.lblPointForVisit, "right");
        loyaltyPanel.add((Component)this.tfPointForVisit, "w 150!,wrap");
        loyaltyPanel.add((Component)this.lblMinRedeemable, "right");
        loyaltyPanel.add((Component)this.tfMinRedeemable, "w 150!,wrap");
        loyaltyPanel.add((Component)this.chkDeductPoint, "skip 1,wrap");
        return loyaltyPanel;
    }

    private void openBrowser(String link) throws Exception {
        URI uri = new URI(link);
        if (Desktop.isDesktopSupported()) {
            Desktop.getDesktop().browse(uri);
        }
    }

    private void doAdd() {
        try {
            DeliveryChargeForm editor = new DeliveryChargeForm();
            BeanEditorDialog dialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)editor);
            dialog.open();
            if (dialog.isCanceled()) {
                return;
            }
            DeliveryCharge deliveryCharge = (DeliveryCharge)editor.getBean();
            this.tableModel.addRow(deliveryCharge);
        }
        catch (Exception x) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
        }
    }

    private void doEdit() {
        try {
            int index = this.table.getSelectedRow();
            if (index < 0) {
                return;
            }
            index = this.table.convertRowIndexToModel(index);
            DeliveryCharge deliveryCharge = this.tableModel.getRow(index);
            DeliveryChargeForm deliveryChargeForm = new DeliveryChargeForm(deliveryCharge);
            BeanEditorDialog dialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)deliveryChargeForm);
            dialog.open();
            if (dialog.isCanceled()) {
                return;
            }
            this.table.repaint();
        }
        catch (Throwable x) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
        }
    }

    private void doDelete() {
        try {
            int index = this.table.getSelectedRow();
            if (index < 0) {
                return;
            }
            index = this.table.convertRowIndexToModel(index);
            DeliveryCharge deliveryCharge = this.tableModel.getRow(index);
            if (ConfirmDeleteDialog.showMessage(POSUtil.getBackOfficeWindow(), POSConstants.CONFIRM_DELETE, POSConstants.DELETE) == 0) {
                DeliveryChargeDAO.getInstance().delete(deliveryCharge);
                this.tableModel.removeRow(index);
            }
        }
        catch (Exception x) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
        }
    }

    private void setVisiblity(boolean isVisible) {
        this.cbCallerIds.setEnabled(isVisible);
        this.tfMin.setEnabled(isVisible);
        this.tfPreperationTime.setEnabled(isVisible);
    }

    private void setVisibleLoyaltyProgram(boolean isEnabledLoyaltyProgram) {
        this.chkDeductPoint.setVisible(isEnabledLoyaltyProgram);
        this.tfExchangeRate.setVisible(isEnabledLoyaltyProgram);
        this.lblExchangeRate.setVisible(isEnabledLoyaltyProgram);
        this.tfPointForPurchases.setVisible(isEnabledLoyaltyProgram);
        this.lblPointForPurchases.setVisible(isEnabledLoyaltyProgram);
        this.tfPointForVisit.setVisible(isEnabledLoyaltyProgram);
        this.lblPointForVisit.setVisible(isEnabledLoyaltyProgram);
        this.tfMinRedeemable.setVisible(isEnabledLoyaltyProgram);
        this.lblMinRedeemable.setVisible(isEnabledLoyaltyProgram);
    }

    @Override
    public void refresh() {
        this.initializeData();
    }
}

