/*
 * Decompiled with CFR 0.152.
 */
package com.orostock.inventory.dao;

import com.floreantpos.model.InventoryVendor;
import com.floreantpos.model.InventoryVendorItems;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.dao.GenericDAO;
import com.floreantpos.swing.PaginationSupport;
import java.util.List;
import net.authorize.util.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

public class InventoryDAO
extends GenericDAO {
    public static InventoryDAO instance;

    public static InventoryDAO getInstance() {
        if (null == instance) {
            instance = new InventoryDAO();
        }
        return instance;
    }

    public void loadInventoryItems(PaginationSupport model, MenuGroup menuGroup, String itemName, List<InventoryVendor> vendors) {
        this.loadInventoryItems(model, menuGroup, itemName, vendors, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MenuItem> loadInventoryItems(PaginationSupport model, MenuGroup menuGroup, String itemName, List<InventoryVendor> vendors, Boolean activeStatus) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            if (vendors != null && !vendors.isEmpty()) {
                criteria = this.findItemsByVendor(model, menuGroup, itemName, vendors, activeStatus, session);
            } else {
                criteria = this.createCommonCriteriaForMenuItem(menuGroup, itemName, activeStatus, session);
                model.setNumRows(this.rowCount(criteria));
                int currentRowIndex = model.getCurrentRowIndex();
                if (model.getNumRows() < model.getCurrentRowIndex()) {
                    criteria.setFirstResult(0);
                    model.setCurrentRowIndex(0);
                } else {
                    criteria.setFirstResult(currentRowIndex);
                }
                criteria.setMaxResults(model.getPageSize());
                criteria.addOrder(Order.asc((String)MenuItem.PROP_ID));
            }
            criteria.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
            List result = criteria.list();
            this.loadVendors(session, result);
            model.setRows(result);
            List list = result;
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    private Criteria createCommonCriteriaForMenuItem(MenuGroup menuGroup, String itemName, Boolean activeStatus, Session session) {
        Criteria criteria = session.createCriteria(MenuItem.class);
        criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_VARIANT, (Object)Boolean.FALSE));
        criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)MenuItem.PROP_INVENTORY_ITEM), (Criterion)Restrictions.eq((String)MenuItem.PROP_INVENTORY_ITEM, (Object)Boolean.TRUE)));
        this.addDeletedFilter(criteria);
        itemName = itemName.trim();
        if (StringUtils.isNotEmpty((String)itemName)) {
            criteria.add((Criterion)Restrictions.or((Criterion[])new Criterion[]{Restrictions.ilike((String)MenuItem.PROP_NAME, (String)itemName, (MatchMode)MatchMode.ANYWHERE), Restrictions.ilike((String)MenuItem.PROP_SKU, (String)itemName, (MatchMode)MatchMode.START), Restrictions.ilike((String)MenuItem.PROP_BARCODE, (String)itemName, (MatchMode)MatchMode.START)}));
        }
        if (menuGroup != null) {
            criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_MENU_GROUP_ID, (Object)menuGroup.getId()));
        }
        if (activeStatus != null) {
            criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_VISIBLE, (Object)activeStatus));
        }
        return criteria;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int rowCount(MenuGroup menuGroup, String itemName, List<InventoryVendor> vendors, Boolean activeStatus) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = vendors != null && !vendors.isEmpty() ? this.createCommonCriteriaForVendor(menuGroup, itemName, vendors, activeStatus, session) : this.createCommonCriteriaForMenuItem(menuGroup, itemName, activeStatus, session);
            int n = 0;
            return n;
        }
        finally {
            this.closeSession(session);
        }
    }

    private void loadVendors(Session session, List<MenuItem> result) {
        if (!result.isEmpty()) {
            Criteria criteria = session.createCriteria(InventoryVendorItems.class);
            criteria.add(Restrictions.in((String)InventoryVendorItems.PROP_ITEM, result));
            List list = criteria.list();
            for (MenuItem item : result) {
                for (InventoryVendorItems inventoryVendorItems : list) {
                    String name;
                    if (inventoryVendorItems.getItem() == null || inventoryVendorItems.getItem().getId() == null || !item.getId().equals(inventoryVendorItems.getItem().getId())) continue;
                    String string = name = StringUtils.isNotEmpty((String)item.getVendorNames()) ? item.getVendorNames() + ", " : "";
                    if (inventoryVendorItems.getVendor() == null) continue;
                    item.setVendorNames(name + inventoryVendorItems.getVendor().getName());
                }
            }
        }
    }

    private Criteria findItemsByVendor(PaginationSupport model, MenuGroup menuGroup, String itemName, List<InventoryVendor> vendors, Boolean activeStatus, Session session) {
        Criteria criteria = this.createCommonCriteriaForVendor(menuGroup, itemName, vendors, activeStatus, session);
        model.setNumRows(this.rowCount(criteria));
        int currentRowIndex = model.getCurrentRowIndex();
        if (model.getNumRows() < model.getCurrentRowIndex()) {
            criteria.setFirstResult(0);
            model.setCurrentRowIndex(0);
        } else {
            criteria.setFirstResult(currentRowIndex);
        }
        criteria.setProjection((Projection)Projections.property((String)InventoryVendorItems.PROP_ITEM));
        criteria.addOrder(Order.asc((String)InventoryVendorItems.PROP_VENDOR));
        criteria.setFirstResult(model.getCurrentRowIndex());
        criteria.setMaxResults(model.getPageSize());
        return criteria;
    }

    private Criteria createCommonCriteriaForVendor(MenuGroup menuGroup, String itemName, List<InventoryVendor> vendors, Boolean activeStatus, Session session) {
        Criteria criteria = session.createCriteria(InventoryVendorItems.class);
        criteria.add(Restrictions.in((String)InventoryVendorItems.PROP_VENDOR, vendors));
        criteria.createAlias(InventoryVendorItems.PROP_ITEM, "menuItem");
        criteria.add((Criterion)Restrictions.eq((String)("menuItem." + MenuItem.PROP_INVENTORY_ITEM), (Object)true));
        criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)("menuItem." + MenuItem.PROP_DELETED)), (Criterion)Restrictions.eq((String)("menuItem." + MenuItem.PROP_DELETED), (Object)Boolean.FALSE)));
        itemName = itemName.trim();
        if (StringUtils.isNotEmpty((String)itemName)) {
            criteria.add((Criterion)Restrictions.or((Criterion[])new Criterion[]{Restrictions.ilike((String)("menuItem." + MenuItem.PROP_NAME), (String)itemName, (MatchMode)MatchMode.ANYWHERE), Restrictions.ilike((String)("menuItem." + MenuItem.PROP_SKU), (String)itemName, (MatchMode)MatchMode.START), Restrictions.ilike((String)("menuItem." + MenuItem.PROP_BARCODE), (String)itemName, (MatchMode)MatchMode.START)}));
        }
        if (menuGroup != null) {
            criteria.add((Criterion)Restrictions.eq((String)("menuItem." + MenuItem.PROP_MENU_GROUP_ID), (Object)menuGroup.getId()));
        }
        if (activeStatus != null) {
            criteria.add((Criterion)Restrictions.eq((String)("menuItem." + MenuItem.PROP_VISIBLE), (Object)activeStatus));
        }
        return criteria;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadVendors(PaginationSupport tableModel, String txName) {
        Criteria criteria = null;
        try (Session session = null;){
            session = this.createNewSession();
            criteria = session.createCriteria(InventoryVendor.class);
            if (txName != null && StringUtils.isNotEmpty((String)txName)) {
                criteria.add(Restrictions.ilike((String)InventoryVendor.PROP_NAME, (String)txName, (MatchMode)MatchMode.ANYWHERE));
            }
            criteria.setProjection(Projections.rowCount());
            Number rowCount = (Number)criteria.uniqueResult();
            tableModel.setNumRows(rowCount.intValue());
            criteria.setProjection(null);
            criteria.setFirstResult(tableModel.getCurrentRowIndex());
            criteria.setMaxResults(tableModel.getPageSize());
            tableModel.setRows(criteria.list());
        }
    }
}

