/*
 * Decompiled with CFR 0.152.
 */
package com.orostock.inventory.report;

import com.floreantpos.POSConstants;
import com.floreantpos.main.Application;
import com.floreantpos.model.InventoryTransaction;
import com.floreantpos.model.InventoryTransactionType;
import com.floreantpos.model.MenuCategory;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.Store;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.dao.InventoryTransactionDAO;
import com.floreantpos.model.dao.MenuCategoryDAO;
import com.floreantpos.model.dao.MenuGroupDAO;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.model.ext.PaperSize;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.report.ReportUtil;
import com.floreantpos.swing.MultiSelectComboBox;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.util.UiUtil;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.POSUtil;
import com.orostock.inventory.InvMessages;
import com.orostock.inventory.report.InventoryTransactionReportModel;
import com.orostock.inventory.report.ReportParser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRTableModelDataSource;
import net.sf.jasperreports.view.JRViewer;
import org.jdesktop.swingx.JXDatePicker;

public class InventoryTransactionReportView
extends TransparentPanel {
    private JButton btnGo;
    private JXDatePicker fromDatePicker;
    private JXDatePicker toDatePicker;
    private JPanel reportPanel;
    private JPanel contentPane;
    private JComboBox cbGroup;
    private JComboBox cbCategory;
    private List<MenuGroup> groups;
    private JTextField tfNameSku;
    private JCheckBox chkShowInGroups;
    private MultiSelectComboBox<InventoryTransactionType> mscTtype;

    public InventoryTransactionReportView() {
        this.$$$setupUI$$$();
        TerminalDAO terminalDAO = new TerminalDAO();
        List<Terminal> terminals = terminalDAO.findAll();
        terminals.add(0, (Terminal)((Object)POSConstants.ALL));
        this.setLayout(new BorderLayout());
        this.add(this.contentPane);
        this.btnGo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InventoryTransactionReportView.this.viewReport();
            }
        });
    }

    private void viewReport() {
        Date fromDate = this.fromDatePicker.getDate();
        Date toDate = this.toDatePicker.getDate();
        String strTransactionType = "All";
        if (fromDate.after(toDate)) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.FROM_DATE_CANNOT_BE_GREATER_THAN_TO_DATE_);
            return;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime(fromDate);
        calendar.set(1, calendar2.get(1));
        calendar.set(2, calendar2.get(2));
        calendar.set(5, calendar2.get(5));
        calendar.set(10, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        fromDate = calendar.getTime();
        calendar.clear();
        calendar2.setTime(toDate);
        calendar.set(1, calendar2.get(1));
        calendar.set(2, calendar2.get(2));
        calendar.set(5, calendar2.get(5));
        calendar.set(10, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        toDate = calendar.getTime();
        InventoryTransactionDAO dao = new InventoryTransactionDAO();
        List<InventoryTransactionType> transactionTypes = this.mscTtype.getSelectedItems();
        ArrayList<Integer> types = new ArrayList<Integer>();
        if (transactionTypes != null) {
            strTransactionType = "";
            Iterator<InventoryTransactionType> iterator = transactionTypes.iterator();
            while (iterator.hasNext()) {
                InventoryTransactionType inventoryTransactionType = iterator.next();
                types.add(inventoryTransactionType.getType());
                strTransactionType = strTransactionType + inventoryTransactionType.name();
                if (!iterator.hasNext()) continue;
                strTransactionType = strTransactionType + ", ";
            }
        }
        Object selectedCategory = this.cbCategory.getSelectedItem();
        MenuCategory category = null;
        if (selectedCategory instanceof MenuCategory) {
            category = (MenuCategory)selectedCategory;
        }
        Object selectedGroup = this.cbGroup.getSelectedItem();
        MenuGroup group = null;
        if (selectedGroup instanceof MenuGroup) {
            group = (MenuGroup)selectedGroup;
        }
        String nameOrSku = this.tfNameSku.getText();
        List<InventoryTransaction> transactions = dao.findTransactionsByType(nameOrSku, types, group, category, fromDate, toDate);
        String strCategory = "All";
        String strGroup = "All";
        if (category != null) {
            strCategory = category.getName();
        }
        if (group != null) {
            strGroup = group.getName();
        }
        String searchKey = "Transaction type: " + strTransactionType + "; Category: " + strCategory + "; Group: " + strGroup + ";";
        try {
            String reportName = "inventoryTransactionReport";
            JasperReport report = ReportParser.getReport("/reports/" + PaperSize.getReportNameAccording2Size(reportName) + ".jasper");
            HashMap<String, Object> properties = new HashMap<String, Object>();
            ReportUtil.populateRestaurantProperties(properties);
            String dateRange = InvMessages.getString("IVTRV.11") + DateUtil.getOnlyFormattedDate(fromDate) + InvMessages.getString("IVTRV.12") + DateUtil.getOnlyFormattedDate(toDate);
            properties.put("DateRange", dateRange);
            properties.put("group", searchKey);
            Store store = Application.getInstance().getStore();
            properties.put("companyName", store.getName());
            properties.put("address", store.getAddressLine1());
            properties.put("city", store.getAddressLine2());
            properties.put("address3", store.getAddressLine3());
            properties.put("phone", store.getTelephone());
            properties.put("currencySymbol", CurrencyUtil.getCurrencySymbolWithBracket());
            properties.put("isGroup", this.chkShowInGroups.isSelected());
            InventoryTransactionReportModel reportModel = new InventoryTransactionReportModel();
            if (transactions == null || transactions.size() <= 0) {
                this.reportPanel.removeAll();
                POSMessageDialog.showMessage(POSUtil.getBackOfficeWindow(), InvMessages.getString("IVCRV.13"));
                return;
            }
            reportModel.setRows(transactions);
            properties.put("totalExpenses", String.valueOf(reportModel.getTotalAmount()));
            properties.put("totalQty", reportModel.getTotalQuantity());
            JasperPrint print = JasperFillManager.fillReport((JasperReport)report, properties, (JRDataSource)new JRTableModelDataSource((TableModel)reportModel));
            JRViewer viewer = ReportUtil.getCustomJRViewer(print);
            this.reportPanel.removeAll();
            this.reportPanel.add((Component)viewer);
            this.reportPanel.revalidate();
        }
        catch (JRException e) {
            e.printStackTrace();
        }
    }

    private void $$$setupUI$$$() {
        this.contentPane = new JPanel();
        this.contentPane.setLayout((LayoutManager)new MigLayout("fillx,hidemode 3", "", "[][][][grow]"));
        JLabel lblTransactionType = new JLabel(InvMessages.getString("IVTRV.25"));
        this.mscTtype = new MultiSelectComboBox();
        InventoryTransactionType[] itt = InventoryTransactionType.values();
        ArrayList<InventoryTransactionType> transactionTypes = new ArrayList<InventoryTransactionType>();
        for (int i = 0; i < itt.length; ++i) {
            transactionTypes.add(itt[i]);
        }
        this.mscTtype.setItems(transactionTypes);
        JLabel lblFrom = new JLabel(POSConstants.FROM + ":");
        JLabel lblToDate = new JLabel(POSConstants.TO + ":");
        this.fromDatePicker = UiUtil.getCurrentMonthStart();
        this.toDatePicker = UiUtil.getCurrentMonthEnd();
        this.btnGo = new JButton();
        this.btnGo.setPreferredSize(PosUIManager.getSize(100, 0));
        this.btnGo.setText(POSConstants.GO);
        JLabel lblCategory = new JLabel(InvMessages.getString("IVCRV.20"));
        this.cbCategory = new JComboBox();
        this.cbCategory.addItem(InvMessages.getString("IVCRV.21"));
        List<MenuCategory> categories = MenuCategoryDAO.getInstance().findAllForReport(false);
        for (MenuCategory menuCategory : categories) {
            this.cbCategory.addItem(menuCategory);
        }
        this.cbCategory.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Object selectedItem = InventoryTransactionReportView.this.cbCategory.getSelectedItem();
                if (selectedItem instanceof MenuCategory) {
                    List<MenuGroup> groupList = MenuGroupDAO.getInstance().findByParent((MenuCategory)selectedItem);
                    InventoryTransactionReportView.this.cbGroup.removeAllItems();
                    InventoryTransactionReportView.this.cbGroup.addItem(InvMessages.getString("IVCRV.21"));
                    for (MenuGroup group : groupList) {
                        InventoryTransactionReportView.this.cbGroup.addItem(group);
                    }
                } else {
                    InventoryTransactionReportView.this.cbGroup.removeAllItems();
                    InventoryTransactionReportView.this.cbGroup.addItem(InvMessages.getString("IVCRV.21"));
                    for (MenuGroup group : InventoryTransactionReportView.this.groups) {
                        InventoryTransactionReportView.this.cbGroup.addItem(group);
                    }
                }
            }
        });
        JLabel lblGroup = new JLabel(InvMessages.getString("IVCRV.23"));
        this.cbGroup = new JComboBox();
        this.cbGroup.addItem(InvMessages.getString("IVCRV.21"));
        this.groups = MenuGroupDAO.getInstance().findAllForReport(false);
        for (MenuGroup group : this.groups) {
            this.cbGroup.addItem(group);
        }
        JLabel jLabel = new JLabel(InvMessages.getString("IVTRV.34"));
        this.tfNameSku = new JTextField();
        this.tfNameSku.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InventoryTransactionReportView.this.viewReport();
            }
        });
        this.chkShowInGroups = new JCheckBox(InvMessages.getString("IVTRV.35"));
        JSeparator separator1 = new JSeparator();
        this.reportPanel = new JPanel();
        this.reportPanel.setLayout(new BorderLayout(0, 0));
        this.contentPane.add((Component)jLabel, "split 12");
        this.contentPane.add((Component)this.tfNameSku, "growx, w 200!");
        this.contentPane.add((Component)lblTransactionType, "");
        this.contentPane.add(this.mscTtype);
        this.contentPane.add(lblCategory);
        this.contentPane.add(this.cbCategory);
        this.contentPane.add(lblGroup);
        this.contentPane.add(this.cbGroup);
        this.contentPane.add(lblFrom);
        this.contentPane.add((Component)this.fromDatePicker);
        this.contentPane.add(lblToDate);
        this.contentPane.add((Component)this.toDatePicker, "wrap");
        this.contentPane.add((Component)this.chkShowInGroups, "split 2");
        this.contentPane.add(this.btnGo);
        this.contentPane.add((Component)separator1, "newline,growx,span");
        this.contentPane.add((Component)this.reportPanel, "newline,grow,span");
    }

    public JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }
}

