/*
 * Decompiled with CFR 0.152.
 */
package com.orostock.inventory.ui;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.bo.ui.explorer.ExplorerButtonPanel;
import com.floreantpos.model.InventoryTransaction;
import com.floreantpos.model.InventoryTransactionType;
import com.floreantpos.model.InventoryUnit;
import com.floreantpos.model.InventoryVendor;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.dao.InventoryVendorDAO;
import com.floreantpos.model.dao.MenuGroupDAO;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.model.dao.MenuItemInventoryStatusDAO;
import com.floreantpos.swing.MultiSelectComboBox;
import com.floreantpos.swing.OverflowCombobox;
import com.floreantpos.swing.PaginationSupport;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.PosTableRenderer;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.inv.InventoryStockInForm;
import com.floreantpos.ui.inv.InventoryTransactionEntryForm;
import com.floreantpos.ui.model.MenuItemForm;
import com.floreantpos.util.POSUtil;
import com.orostock.inventory.InvMessages;
import com.orostock.inventory.dao.InventoryDAO;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.TreePath;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;
import org.jdesktop.swingx.JXTreeTable;
import org.jdesktop.swingx.treetable.DefaultMutableTreeTableNode;
import org.jdesktop.swingx.treetable.DefaultTreeTableModel;
import org.jdesktop.swingx.treetable.MutableTreeTableNode;
import org.jdesktop.swingx.treetable.TreeTableModel;
import org.jdesktop.swingx.treetable.TreeTableNode;

public class InventoryItemExplorer
extends TransparentPanel {
    private JXTreeTable treeTable;
    private InventoryTreeTableModel treeTableModel;
    private JComboBox<MenuGroup> cbGroups;
    private MultiSelectComboBox<InventoryVendor> cbVendors;
    private JTextField tfName;
    private JButton btnBack;
    private JButton btnForward;
    private JLabel lblNumberOfItem;
    private JComboBox<String> cbStatus;
    private JButton btnUpdateStockAmount;
    private JButton btnInventoryIn;
    private JButton btnInventoryOut;
    private JButton btnInventoryTransfer;

    public InventoryItemExplorer() {
        this.init();
        this.buildInventoryTree(0);
        this.treeTable.expandAll();
        this.treeTable.collapseAll();
    }

    private void buildInventoryTree(int rowIndex) {
        int totalNumber;
        MenuItem dummy = new MenuItem();
        dummy.setId("0");
        dummy.setName("Root");
        DefaultMutableTreeTableNode root = new DefaultMutableTreeTableNode((Object)dummy);
        root.setUserObject((Object)dummy);
        if (this.treeTableModel == null) {
            this.treeTableModel = new InventoryTreeTableModel(root);
            this.treeTable.setTreeTableModel((TreeTableModel)this.treeTableModel);
        } else {
            this.treeTableModel.setRoot((TreeTableNode)root);
        }
        Object selectedType = this.cbGroups.getSelectedItem();
        Object selectedStatus = this.cbStatus.getSelectedItem();
        List<InventoryVendor> vendors = this.cbVendors.getSelectedItems();
        String txName = this.tfName.getText();
        Boolean status = null;
        MenuGroup menuGroup = null;
        if (selectedType instanceof MenuGroup) {
            menuGroup = (MenuGroup)selectedType;
        }
        if (selectedStatus.equals("Active")) {
            status = true;
        }
        if (selectedStatus.equals("Inactive")) {
            status = false;
        }
        List<MenuItem> loadInventoryItems = InventoryDAO.getInstance().loadInventoryItems(this.treeTableModel, menuGroup, txName, vendors, status);
        for (MenuItem menuItem : loadInventoryItems) {
            DefaultMutableTreeTableNode inventoryNode = new DefaultMutableTreeTableNode((Object)menuItem);
            MenuItemDAO.getInstance().initialize(menuItem);
            List<MenuItem> linkedInventoryList = menuItem.getVariants();
            for (MenuItem linkedInventory : linkedInventoryList) {
                DefaultMutableTreeTableNode node = new DefaultMutableTreeTableNode((Object)linkedInventory);
                inventoryNode.add((MutableTreeTableNode)node);
            }
            root.add((MutableTreeTableNode)inventoryNode);
        }
        int startNumber = this.treeTableModel.getCurrentRowIndex() + 1;
        int endNumber = this.treeTableModel.getNextRowIndex();
        if (endNumber > (totalNumber = this.treeTableModel.getNumRows())) {
            endNumber = totalNumber;
        }
        this.lblNumberOfItem.setText(String.format(Messages.getString("UserExplorer.17"), startNumber, endNumber, totalNumber));
        this.btnBack.setEnabled(this.treeTableModel.hasPrevious());
        this.btnForward.setEnabled(this.treeTableModel.hasNext());
    }

    private void showInventoryItems(int rowIndex) {
        this.treeTableModel.setCurrentRowIndex(rowIndex);
        this.buildInventoryTree(rowIndex);
        this.treeTable.expandAll();
        this.treeTable.collapseAll();
    }

    private void init() {
        this.treeTable = new JXTreeTable();
        this.treeTable.setRootVisible(false);
        this.treeTable.setShowGrid(true, true);
        this.treeTable.setRowHeight(PosUIManager.getSize(30));
        this.treeTable.setLeafIcon(null);
        this.treeTable.setOpenIcon(null);
        this.treeTable.setClosedIcon(null);
        this.treeTable.setSelectionMode(0);
        this.treeTable.setDefaultRenderer(Object.class, (TableCellRenderer)new PosTableRenderer());
        this.btnBack = new JButton(InvMessages.getString("IVIE.30"));
        this.btnForward = new JButton(InvMessages.getString("IVIE.31"));
        this.lblNumberOfItem = new JLabel();
        this.btnBack.addActionListener(e -> this.showInventoryItems(this.treeTableModel.getPreviousRowIndex()));
        this.btnForward.addActionListener(e -> this.showInventoryItems(this.treeTableModel.getNextRowIndex()));
        this.setLayout(new BorderLayout(5, 5));
        this.add(new JScrollPane((Component)this.treeTable));
        this.add((Component)this.createButtonPanel(), "South");
        this.add((Component)this.buildSearchForm(), "North");
        this.treeTable.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent arg0) {
                int index = InventoryItemExplorer.this.treeTable.getSelectedRow();
                if (index < 0) {
                    return;
                }
                TreePath treePath = InventoryItemExplorer.this.treeTable.getPathForRow(index);
                DefaultMutableTreeTableNode lastPathComponent = (DefaultMutableTreeTableNode)treePath.getLastPathComponent();
                MenuItem menuItem = (MenuItem)lastPathComponent.getUserObject();
                InventoryItemExplorer.this.btnInventoryIn.setEnabled(menuItem.isHasVariant() == false);
                InventoryItemExplorer.this.btnInventoryOut.setEnabled(menuItem.isHasVariant() == false);
                InventoryItemExplorer.this.btnInventoryTransfer.setEnabled(menuItem.isHasVariant() == false);
            }
        });
        this.treeTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                int col = InventoryItemExplorer.this.treeTable.columnAtPoint(me.getPoint());
                if (me.getClickCount() == 2 && col == 0) {
                    InventoryItemExplorer.this.treeTable.expandPath(InventoryItemExplorer.this.treeTable.getPathForRow(InventoryItemExplorer.this.treeTable.getSelectedRow()));
                } else if (me.getClickCount() == 2 && col != 0) {
                    InventoryItemExplorer.this.editSelectedRow();
                }
            }
        });
    }

    private JPanel buildSearchForm() {
        JPanel panel = new JPanel();
        panel.setLayout((LayoutManager)new MigLayout("", "[][]15[][]15[][]15[]", "[]5[]"));
        try {
            JLabel lblGroup = new JLabel(InvMessages.getString("IVIE.32"));
            this.cbGroups = new OverflowCombobox();
            this.cbGroups.addItem(null);
            this.cbGroups.addItemListener(e -> this.showInventoryItems());
            List<MenuGroup> menuGroups = MenuGroupDAO.getInstance().findAll();
            for (MenuGroup menuGroup : menuGroups) {
                this.cbGroups.addItem(menuGroup);
            }
            this.cbVendors = new MultiSelectComboBox();
            this.cbVendors.addItemListener(e -> this.showInventoryItems());
            List<InventoryVendor> inventoryVendors = InventoryVendorDAO.getInstance().findAll();
            this.cbVendors.setItems(inventoryVendors);
            final String[] status = new String[]{"All", "Active", "Inactive"};
            JLabel lblStatus = new JLabel(InvMessages.getString("IVIE.33"));
            this.cbStatus = new JComboBox<String>(status);
            this.cbStatus.addItemListener(event -> this.showInventoryItems());
            JLabel lblName = new JLabel(InvMessages.getString("IVIE.0"));
            this.tfName = new JTextField(15);
            JButton searchBttn = new JButton(InvMessages.getString("IVIS.22"));
            JButton btnClear = new JButton(InvMessages.getString("IVIE.34"));
            btnClear.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    InventoryItemExplorer.this.tfName.setText("");
                    InventoryItemExplorer.this.cbGroups.setSelectedItem(null);
                    InventoryItemExplorer.this.cbVendors.setSelectedItem(null);
                    InventoryItemExplorer.this.cbVendors.unselectAllItems();
                    InventoryItemExplorer.this.cbStatus.setSelectedItem(status[0]);
                    InventoryItemExplorer.this.showInventoryItems();
                }
            });
            panel.add((Component)lblName, "align label");
            panel.add(this.tfName);
            panel.add(lblGroup);
            panel.add(this.cbGroups, "width 200!");
            panel.add(new JLabel(InvMessages.getString("Inventory.IE.10")));
            panel.add(this.cbVendors, "width 150!");
            panel.add((Component)lblStatus, "split 2");
            panel.add(this.cbStatus);
            panel.add(searchBttn);
            panel.add(btnClear);
            Border loweredetched = BorderFactory.createEtchedBorder(1);
            TitledBorder title = BorderFactory.createTitledBorder(loweredetched, InvMessages.getString("IVIS.22"));
            title.setTitleJustification(1);
            panel.setBorder(title);
            searchBttn.addActionListener(e -> this.showInventoryItems());
            this.tfName.addActionListener(e -> this.showInventoryItems());
            this.tfName.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    String searchItem = InventoryItemExplorer.this.tfName.getText();
                    if (StringUtils.isNotEmpty((String)searchItem) && searchItem.length() > 2) {
                        InventoryItemExplorer.this.showInventoryItems();
                    }
                }
            });
        }
        catch (Throwable x) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
        }
        return panel;
    }

    private void showInventoryItems() {
        this.showInventoryItems(0);
    }

    private JPanel createButtonPanel() {
        ExplorerButtonPanel explorerButton = new ExplorerButtonPanel();
        JButton editButton = explorerButton.getEditButton();
        JButton addButton = explorerButton.getAddButton();
        JButton deleteButton = explorerButton.getDeleteButton();
        addButton.setText(InvMessages.getString("IVIE.17"));
        editButton.setText(InvMessages.getString("IVIE.18"));
        deleteButton.setText(InvMessages.getString("IVIE.19"));
        this.btnUpdateStockAmount = new JButton(InvMessages.getString("IVIE.20"));
        this.btnUpdateStockAmount.addActionListener(e -> this.doUpdateStockAmount());
        editButton.addActionListener(e -> this.editSelectedRow());
        deleteButton.addActionListener(e -> this.doDeleteMenuItem());
        JPanel bottomPanel = new JPanel((LayoutManager)new MigLayout("fillx", "[][fill]"));
        TransparentPanel actionButtonPanel = new TransparentPanel();
        if (POSUtil.isAllowLocalItem()) {
            actionButtonPanel.add(addButton);
        }
        actionButtonPanel.add(editButton);
        actionButtonPanel.add(deleteButton);
        this.addInventoryButtonActions(actionButtonPanel);
        actionButtonPanel.add(this.btnUpdateStockAmount);
        bottomPanel.add((Component)actionButtonPanel, "");
        JPanel navigationPanel = new JPanel(new FlowLayout(4));
        navigationPanel.add(this.lblNumberOfItem);
        navigationPanel.add(this.btnBack);
        navigationPanel.add(this.btnForward);
        bottomPanel.add((Component)navigationPanel, "grow");
        return bottomPanel;
    }

    private void addInventoryButtonActions(JPanel panel) {
        this.btnInventoryIn = new JButton(InvMessages.getString("IVIE.35"));
        this.btnInventoryOut = new JButton(InvMessages.getString("IVIE.36"));
        this.btnInventoryTransfer = new JButton(InvMessages.getString("IVIE.37"));
        this.btnInventoryIn.addActionListener(e -> this.doShowStockInDialog(InventoryTransactionType.IN));
        this.btnInventoryOut.addActionListener(e -> this.doAdjustStock(InventoryTransactionType.OUT, false));
        this.btnInventoryTransfer.addActionListener(e -> this.doAdjustStock(InventoryTransactionType.UNCHANGED, true));
        panel.add(this.btnInventoryIn);
        panel.add(this.btnInventoryOut);
        panel.add(this.btnInventoryTransfer);
    }

    private boolean doAdjustStock(InventoryTransactionType type, boolean transfer) {
        if (this.treeTable.getRowCount() == 0) {
            String message = InvMessages.getString("InventoryItemExplorer.0");
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), message);
            return false;
        }
        int index = this.treeTable.getSelectedRow();
        if (index < 0) {
            String message = InvMessages.getString("InventoryItemExplorer.1");
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), message);
            return false;
        }
        TreePath treePath = this.treeTable.getPathForRow(index = this.treeTable.convertRowIndexToModel(index));
        DefaultMutableTreeTableNode lastPathComponent = (DefaultMutableTreeTableNode)treePath.getLastPathComponent();
        MenuItem menuItem = (MenuItem)lastPathComponent.getUserObject();
        if (menuItem == null) {
            return false;
        }
        if (menuItem.getUnit() == null) {
            POSMessageDialog.showError(this, InvMessages.getString("InventoryItemExplorer.2"));
            return false;
        }
        MenuItemDAO.getInstance().initialize(menuItem);
        InventoryTransaction inventoryTransaction = new InventoryTransaction();
        inventoryTransaction.setTransactionType(type);
        if (transfer) {
            inventoryTransaction.setReason("TRANSFER");
        }
        inventoryTransaction.setMenuItem(menuItem);
        InventoryTransactionEntryForm inventoryTransactionEntryForm = new InventoryTransactionEntryForm(inventoryTransaction);
        BeanEditorDialog dialog = new BeanEditorDialog(inventoryTransactionEntryForm);
        dialog.setPreferredSize(PosUIManager.getSize(500, 500));
        dialog.open();
        if (dialog.isCanceled()) {
            return false;
        }
        this.showInventoryItems();
        return true;
    }

    private boolean doShowStockInDialog(InventoryTransactionType type) {
        int index = this.treeTable.getSelectedRow();
        MenuItem menuItem = null;
        if (index >= 0) {
            index = this.treeTable.convertRowIndexToModel(index);
            TreePath treePath = this.treeTable.getPathForRow(index);
            DefaultMutableTreeTableNode lastPathComponent = (DefaultMutableTreeTableNode)treePath.getLastPathComponent();
            menuItem = (MenuItem)lastPathComponent.getUserObject();
            MenuItemDAO.getInstance().initialize(menuItem);
        }
        InventoryTransaction inventoryTransaction = new InventoryTransaction();
        inventoryTransaction.setTransactionType(type);
        InventoryStockInForm editor = null;
        if (menuItem == null) {
            editor = new InventoryStockInForm(inventoryTransaction);
        } else {
            inventoryTransaction.setMenuItem(menuItem);
            InventoryUnit unit = menuItem.getUnit();
            if (unit == null) {
                POSMessageDialog.showError(this, InvMessages.getString("IVIE.38"));
                return false;
            }
            inventoryTransaction.setUnit(unit.getUniqueCode());
            Double replenishLevel = menuItem.getReplenishLevel();
            inventoryTransaction.setQuantity(replenishLevel);
            Double cost = menuItem.getCost();
            inventoryTransaction.setUnitCost(cost);
            inventoryTransaction.setTotal(replenishLevel * cost);
            editor = new InventoryStockInForm(inventoryTransaction);
        }
        BeanEditorDialog dialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)editor);
        dialog.openWithScale(830, 630);
        if (dialog.isCanceled()) {
            return false;
        }
        this.showInventoryItems();
        return true;
    }

    public void resizeColumnWidth(JTable table) {
        TableColumnModel columnModel = table.getColumnModel();
        for (int column = 0; column < table.getColumnCount(); ++column) {
            columnModel.getColumn(column).setPreferredWidth((Integer)this.getColumnWidth().get(column));
        }
    }

    private List getColumnWidth() {
        ArrayList<Integer> columnWidth = new ArrayList<Integer>();
        columnWidth.add(100);
        columnWidth.add(250);
        columnWidth.add(60);
        columnWidth.add(70);
        columnWidth.add(70);
        columnWidth.add(80);
        columnWidth.add(80);
        columnWidth.add(50);
        columnWidth.add(140);
        columnWidth.add(70);
        columnWidth.add(70);
        columnWidth.add(100);
        columnWidth.add(100);
        columnWidth.add(200);
        return columnWidth;
    }

    private void editSelectedRow() {
        try {
            int index = this.treeTable.getSelectedRow();
            if (index < 0) {
                POSMessageDialog.showError(this, Messages.getString("SelectToEdit"));
                return;
            }
            TreePath treePath = this.treeTable.getPathForRow(index);
            DefaultMutableTreeTableNode lastPathComponent = (DefaultMutableTreeTableNode)treePath.getLastPathComponent();
            MenuItem menuItem = (MenuItem)lastPathComponent.getUserObject();
            menuItem = MenuItemDAO.getInstance().getInitialized(menuItem.getId());
            MenuItemForm editor = new MenuItemForm(menuItem);
            BeanEditorDialog dialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)editor, true);
            dialog.openFullScreen();
            if (dialog.isCanceled()) {
                return;
            }
            this.treeTableModel.valueForPathChanged(treePath, menuItem);
        }
        catch (Throwable x) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
        }
    }

    private void doUpdateStockAmount() {
        try {
            if (this.treeTable.getRowCount() == 0) {
                String message = InvMessages.getString("InventoryItemExplorer.5");
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), message);
                return;
            }
            int index = this.treeTable.getSelectedRow();
            if (index < 0) {
                String message = InvMessages.getString("InventoryItemExplorer.1");
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), message);
                return;
            }
            TreePath treePath = this.treeTable.getPathForRow(index);
            DefaultMutableTreeTableNode lastPathComponent = (DefaultMutableTreeTableNode)treePath.getLastPathComponent();
            MenuItem menuItem = (MenuItem)lastPathComponent.getUserObject();
            String amountString = JOptionPane.showInputDialog(POSUtil.getBackOfficeWindow(), InvMessages.getString("IVIE.8"), menuItem.getAvailableUnit());
            if (amountString == null || amountString.equals("")) {
                return;
            }
            double stockAmount = Double.parseDouble(amountString);
            if (stockAmount < 0.0) {
                POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), InvMessages.getString("IVIE.10"));
                return;
            }
            menuItem.setAvailableUnit(stockAmount);
            MenuItemInventoryStatusDAO.getInstance().saveOrUpdate(menuItem.getStockStatus());
            this.treeTable.repaint();
            this.showInventoryItems();
        }
        catch (NumberFormatException e1) {
            POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), InvMessages.getString("IVIE.11"));
            return;
        }
        catch (Exception e2) {
            BOMessageDialog.showError(POSUtil.getBackOfficeWindow(), POSConstants.ERROR_MESSAGE, e2);
            return;
        }
    }

    private void doDeleteMenuItem() {
        try {
            if (this.treeTable.getRowCount() == 0) {
                String message = InvMessages.getString("InventoryItemExplorer.7");
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), message);
                return;
            }
            int index = this.treeTable.getSelectedRow();
            if (index < 0) {
                String message = InvMessages.getString("InventoryItemExplorer.1");
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), message);
                return;
            }
            index = this.treeTable.convertRowIndexToModel(index);
            if (POSMessageDialog.showYesNoQuestionDialog(POSUtil.getBackOfficeWindow(), POSConstants.CONFIRM_DELETE, POSConstants.DELETE) != 0) {
                return;
            }
            TreePath treePath = this.treeTable.getPathForRow(index);
            DefaultMutableTreeTableNode lastPathComponent = (DefaultMutableTreeTableNode)treePath.getLastPathComponent();
            MenuItem item = (MenuItem)lastPathComponent.getUserObject();
            MenuItemDAO foodItemDAO = new MenuItemDAO();
            foodItemDAO.initialize(item);
            if (item.getDiscounts().size() > 0) {
                foodItemDAO.releaseParentAndDelete(item);
            } else {
                foodItemDAO.delete(item);
            }
            this.showInventoryItems();
        }
        catch (Throwable x) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
        }
    }

    class InventoryTreeTableModel
    extends DefaultTreeTableModel
    implements PaginationSupport {
        private final String[] COLUMN_NAMES;
        private int numRows;
        private int currentRowIndex;
        private int pageSize;
        private List rows;

        public Object getValueAt(Object node, int column) {
            if (node instanceof DefaultMutableTreeTableNode) {
                MenuItem menuItem = (MenuItem)((DefaultMutableTreeTableNode)node).getUserObject();
                if (menuItem == null) {
                    return "";
                }
                boolean variant = menuItem.isVariant();
                switch (column) {
                    case 0: {
                        return menuItem.getSku();
                    }
                    case 1: {
                        return menuItem.getName();
                    }
                    case 2: {
                        return menuItem.getCost();
                    }
                    case 3: {
                        return menuItem.getAvailableUnit();
                    }
                    case 4: {
                        return menuItem.getUnitOnHand();
                    }
                    case 5: {
                        return menuItem.getUnit();
                    }
                    case 6: {
                        return menuItem.getVendorNames();
                    }
                }
            }
            return null;
        }

        public InventoryTreeTableModel(DefaultMutableTreeTableNode rootLocation) {
            super((TreeTableNode)rootLocation);
            this.COLUMN_NAMES = new String[]{POSConstants.SKU.toUpperCase(), POSConstants.NAME.toUpperCase(), POSConstants.COST.toUpperCase(), InvMessages.getString("Inventory.IE.0"), InvMessages.getString("Inventory.IE.1"), InvMessages.getString("Inventory.IE.2"), InvMessages.getString("Inventory.IE.4"), "vendorNames"};
            this.pageSize = 50;
        }

        public void setRoot(TreeTableNode root) {
            super.setRoot(root);
        }

        public int getColumnCount() {
            return this.COLUMN_NAMES.length;
        }

        public String getColumnName(int column) {
            return this.COLUMN_NAMES[column];
        }

        public boolean isCellEditable(Object node, int column) {
            return false;
        }

        @Override
        public int getNumRows() {
            return this.numRows;
        }

        @Override
        public void setNumRows(int numRows) {
            this.numRows = numRows;
        }

        @Override
        public int getCurrentRowIndex() {
            return this.currentRowIndex;
        }

        @Override
        public void setCurrentRowIndex(int currentRowIndex) {
            this.currentRowIndex = currentRowIndex;
        }

        @Override
        public int getPageSize() {
            return this.pageSize;
        }

        @Override
        public void setPageSize(int pageSize) {
            this.pageSize = pageSize;
        }

        @Override
        public boolean hasNext() {
            return this.currentRowIndex + this.pageSize < this.numRows;
        }

        @Override
        public boolean hasPrevious() {
            return this.currentRowIndex > 0;
        }

        @Override
        public int getNextRowIndex() {
            if (this.numRows == 0) {
                return 0;
            }
            return this.getCurrentRowIndex() + this.getPageSize();
        }

        @Override
        public int getPreviousRowIndex() {
            int i = this.getCurrentRowIndex() - this.getPageSize();
            if (i < 0) {
                i = 0;
            }
            return i;
        }

        @Override
        public void setRows(List rows) {
            this.rows = rows;
        }

        public List getRows() {
            return this.rows;
        }
    }
}

