/*
 * Decompiled with CFR 0.152.
 */
package com.orostock.inventory.ui;

import com.floreantpos.PosException;
import com.floreantpos.model.InventoryLocation;
import com.floreantpos.model.dao.GenericDAO;
import com.floreantpos.model.dao.InventoryLocationDAO;
import com.floreantpos.swing.IntegerTextField;
import com.floreantpos.swing.POSTextField;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.dialog.TreeDisplayDialog;
import com.floreantpos.util.POSUtil;
import com.orostock.inventory.InvMessages;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import net.miginfocom.swing.MigLayout;

public class InventoryLocationEntryForm
extends BeanEditor<InventoryLocation> {
    private POSTextField tfName;
    private JLabel lblSortOrder;
    private IntegerTextField tfSortOrder;
    InventoryLocation inventoryLocation;
    private JLabel lblTranslatedName;
    private POSTextField tfTranslatedName;
    private JButton btnParentLoc;
    private POSTextField tfParentLocation;
    private JLabel lblParentLoc;
    private POSTextField tfAddress;
    private JLabel lblAddress;
    private JCheckBox cbDefaultInLocation;
    private JCheckBox cbDefaultOutLocation;
    private InventoryLocation parentLocation;
    private JLabel lblCode;
    private POSTextField tfCode;
    private JLabel lblDescription;
    private JTextArea taDescription;

    public InventoryLocationEntryForm(InventoryLocation inventoryLocation) {
        this.inventoryLocation = inventoryLocation;
        this.setLayout(new BorderLayout());
        this.createUI();
        this.setBean(inventoryLocation);
        this.updateView();
        this.btnParentLoc.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List<InventoryLocation> rootLocations = InventoryLocationDAO.getInstance().getRootLocations();
                DefaultMutableTreeNode root = new DefaultMutableTreeNode();
                for (InventoryLocation inventoryLocation : rootLocations) {
                    DefaultMutableTreeNode node = new DefaultMutableTreeNode(inventoryLocation);
                    root.add(node);
                    InventoryLocationEntryForm.this.buildTree(node);
                }
                JTree tree = new JTree(root);
                for (int i = 1; i < tree.getRowCount() * 2; ++i) {
                    tree.expandRow(i);
                }
                tree.setRootVisible(false);
                TreeDisplayDialog treeDisplayDialog = new TreeDisplayDialog(tree);
                treeDisplayDialog.setPreferredSize(PosUIManager.getSize(500, 600));
                treeDisplayDialog.open();
                if (treeDisplayDialog.isCanceled()) {
                    return;
                }
                DefaultMutableTreeNode path = treeDisplayDialog.getPath();
                InventoryLocationEntryForm.this.parentLocation = (InventoryLocation)path.getUserObject();
                InventoryLocationEntryForm.this.tfParentLocation.setText(String.valueOf(InventoryLocationEntryForm.this.parentLocation));
                InventoryLocationEntryForm.this.tfParentLocation.setEditable(false);
            }
        });
    }

    public InventoryLocationEntryForm() {
        this.setLayout(new BorderLayout());
        this.createUI();
    }

    private void createUI() {
        JPanel panel = new JPanel();
        this.add((Component)panel, "Center");
        panel.setLayout((LayoutManager)new MigLayout("", "[][grow][]", ""));
        JLabel lblName = new JLabel(InvMessages.getString("IVIS.2"));
        panel.add((Component)lblName, "cell 0 0,alignx trailing");
        this.tfName = new POSTextField();
        panel.add((Component)this.tfName, "cell 1 0,growx");
        this.lblTranslatedName = new JLabel(InvMessages.getString("IVLEF.6"));
        panel.add((Component)this.lblTranslatedName, "cell 0 1,alignx trailing ");
        this.tfTranslatedName = new POSTextField();
        panel.add((Component)this.tfTranslatedName, "cell 1 1,growx");
        this.lblAddress = new JLabel(InvMessages.getString("IVLEF.9"));
        panel.add((Component)this.lblAddress, "cell 0 2, alignx trailing");
        this.tfAddress = new POSTextField();
        panel.add((Component)this.tfAddress, "cell 1 2, growx");
        this.lblCode = new JLabel(InvMessages.getString("IVLEF.12"));
        panel.add((Component)this.lblCode, "cell 0 3, alignx trailing");
        this.tfCode = new POSTextField();
        panel.add((Component)this.tfCode, "cell 1 3, growx");
        this.lblDescription = new JLabel(InvMessages.getString("IVLEF.15"));
        panel.add((Component)this.lblDescription, "cell 0 4, alignx trailing");
        this.taDescription = new JTextArea();
        this.taDescription.setLineWrap(true);
        JScrollPane scrlDescription = new JScrollPane(this.taDescription, 20, 30);
        scrlDescription.setPreferredSize(PosUIManager.getSize(0, 100));
        panel.add((Component)scrlDescription, "cell 1 4, growx");
        this.lblParentLoc = new JLabel(InvMessages.getString("IVLEF.18"));
        panel.add((Component)this.lblParentLoc, "cell 0 5, alignx trailing");
        this.tfParentLocation = new POSTextField();
        this.tfParentLocation.setEditable(false);
        panel.add((Component)this.tfParentLocation, "cell 1 5,split 3, growx");
        this.btnParentLoc = new JButton(InvMessages.getString("IVLEF.21"));
        panel.add(this.btnParentLoc);
        JButton btnClear = new JButton(InvMessages.getString("IVLEF.22"));
        panel.add(btnClear);
        btnClear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InventoryLocationEntryForm.this.parentLocation = null;
                InventoryLocationEntryForm.this.tfParentLocation.setText("");
                ((InventoryLocation)InventoryLocationEntryForm.this.getBean()).setParentLocation(null);
            }
        });
        this.lblSortOrder = new JLabel(InvMessages.getString("IVLEF.24"));
        panel.add((Component)this.lblSortOrder, "cell 0 6,alignx trailing");
        this.tfSortOrder = new IntegerTextField();
        panel.add((Component)this.tfSortOrder, "cell 1 6,growx");
        this.cbDefaultInLocation = new JCheckBox(InvMessages.getString("IVLEF.27"), false);
        panel.add((Component)this.cbDefaultInLocation, "cell 1 7");
        this.cbDefaultOutLocation = new JCheckBox(InvMessages.getString("IVLEF.29"), false);
        panel.add((Component)this.cbDefaultOutLocation, "cell 1 8");
    }

    private void buildTree(DefaultMutableTreeNode node) {
        InventoryLocation location = (InventoryLocation)node.getUserObject();
        if (location == null) {
            return;
        }
        List<InventoryLocation> children = location.getChildren();
        if (children == null) {
            return;
        }
        for (InventoryLocation inventoryLocation : children) {
            DefaultMutableTreeNode newChild = new DefaultMutableTreeNode(inventoryLocation);
            node.add(newChild);
            this.buildTree(newChild);
        }
    }

    @Override
    public boolean save() {
        try {
            if (!this.updateModel()) {
                return false;
            }
            InventoryLocation model = (InventoryLocation)this.getBean();
            InventoryLocationDAO.getInstance().saveOrUpdate(model);
            return true;
        }
        catch (PosException e) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e.getMessage());
        }
        catch (Exception e) {
            POSMessageDialog.showError(e.getMessage());
        }
        return false;
    }

    @Override
    public void updateView() {
        InventoryLocation model = (InventoryLocation)this.getBean();
        if (model == null) {
            return;
        }
        this.tfName.setText(model.getName());
        this.tfTranslatedName.setText(model.getTranslatedName());
        this.tfAddress.setText(model.getAddress());
        if (model.getParentLocation() != null) {
            this.tfParentLocation.setText(model.getParentLocation().getName());
        }
        this.tfSortOrder.setText(String.valueOf(model.getSortOrder()));
        this.cbDefaultInLocation.setSelected(model.isDefaultInLocation());
        this.cbDefaultOutLocation.setSelected(model.isDefaultOutLocation());
        this.tfCode.setText(model.getCode());
        this.taDescription.setText(model.getDescription());
    }

    @Override
    public boolean updateModel() {
        InventoryLocation model = (InventoryLocation)this.getBean();
        if (model == null) {
            return false;
        }
        String nameString = this.tfName.getText();
        String translatedName = this.tfTranslatedName.getText();
        String address = this.tfAddress.getText();
        if (this.parentLocation != null) {
            model.setParentLocation(this.parentLocation);
        }
        GenericDAO.getInstance().checkIdOrNameExists(model.getId(), nameString, InventoryLocation.class);
        model.setName(nameString);
        model.setTranslatedName(translatedName);
        model.setAddress(address);
        model.setSortOrder(this.tfSortOrder.getInteger());
        if (model.getParentLocation() == null) {
            model.setRoot(true);
        } else {
            model.setRoot(false);
        }
        List<InventoryLocation> inventoryLocationList = InventoryLocationDAO.getInstance().findAll();
        if (this.cbDefaultInLocation.isSelected()) {
            for (InventoryLocation inventoryLocation : inventoryLocationList) {
                if (!inventoryLocation.isDefaultInLocation().booleanValue() || inventoryLocation.equals(model)) continue;
                inventoryLocation.setDefaultInLocation(false);
                InventoryLocationDAO.getInstance().saveOrUpdate(inventoryLocation);
            }
        }
        model.setDefaultInLocation(this.cbDefaultInLocation.isSelected());
        if (this.cbDefaultOutLocation.isSelected()) {
            for (InventoryLocation inventoryLocation : inventoryLocationList) {
                if (!inventoryLocation.isDefaultOutLocation().booleanValue() || inventoryLocation.equals(model)) continue;
                inventoryLocation.setDefaultOutLocation(false);
                InventoryLocationDAO.getInstance().saveOrUpdate(inventoryLocation);
            }
        }
        model.setDefaultOutLocation(this.cbDefaultOutLocation.isSelected());
        model.setCode(this.tfCode.getText());
        model.setDescription(this.taDescription.getText());
        return true;
    }

    @Override
    public String getDisplayText() {
        return InvMessages.getString("IVLEF.32");
    }
}

