/*
 * Decompiled with CFR 0.152.
 */
package com.orostock.inventory.ui;

import com.floreantpos.model.InventoryMetaCode;
import com.floreantpos.model.dao.InventoryMetaCodeDAO;
import com.floreantpos.swing.IntegerTextField;
import com.floreantpos.swing.POSTextField;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.dialog.POSBackofficeDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.orostock.inventory.InvMessages;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;

public class InventoryMetacodeEntryDialog
extends POSBackofficeDialog {
    private InventoryMetaCode model;
    private TitlePanel titlePanel;
    private JPanel panel_1;
    private JButton psbtnOk;
    private JButton psbtnCancel;
    private JLabel lblType;
    private JLabel lblName;
    private JLabel lblNo;
    private JLabel lblDescription;
    private POSTextField tfType;
    private POSTextField tfName;
    private IntegerTextField tfNo;
    private POSTextField tfDescription;

    public InventoryMetacodeEntryDialog(InventoryMetaCode ig) {
        this.model = ig;
        this.createUI();
        this.setDefaultCloseOperation(2);
        this.updateView();
    }

    private void createUI() {
        this.titlePanel = new TitlePanel();
        this.getContentPane().add((Component)this.titlePanel, "North");
        JPanel panel = new JPanel();
        this.getContentPane().add((Component)panel, "Center");
        panel.setLayout((LayoutManager)new MigLayout("", "[][grow]", "[][][][]"));
        this.lblType = new JLabel(InvMessages.getString("IVMCED.3"));
        panel.add((Component)this.lblType, "cell 0 0,alignx trailing");
        this.tfType = new POSTextField();
        panel.add((Component)this.tfType, "cell 1 0,growx");
        this.lblName = new JLabel(InvMessages.getString("IVIS.2"));
        panel.add((Component)this.lblName, "cell 0 1,alignx trailing");
        this.tfName = new POSTextField();
        panel.add((Component)this.tfName, "cell 1 1,growx");
        this.lblNo = new JLabel(InvMessages.getString("IVMCED.9"));
        panel.add((Component)this.lblNo, "cell 0 2,alignx trailing");
        this.tfNo = new IntegerTextField();
        panel.add((Component)this.tfNo, "cell 1 2,growx");
        this.lblDescription = new JLabel(InvMessages.getString("IVMCED.12"));
        panel.add((Component)this.lblDescription, "cell 0 3,alignx trailing");
        this.tfDescription = new POSTextField();
        panel.add((Component)this.tfDescription, "cell 1 3,growx");
        this.panel_1 = new JPanel();
        this.getContentPane().add((Component)this.panel_1, "South");
        this.psbtnOk = new JButton();
        this.psbtnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InventoryMetacodeEntryDialog.this.saveAndDispose();
            }
        });
        this.psbtnOk.setText(InvMessages.getString("IVMCED.15"));
        this.panel_1.add(this.psbtnOk);
        this.psbtnCancel = new JButton();
        this.psbtnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InventoryMetacodeEntryDialog.this.setCanceled(true);
                InventoryMetacodeEntryDialog.this.dispose();
            }
        });
        this.psbtnCancel.setText(InvMessages.getString("IVMCED.16"));
        this.panel_1.add(this.psbtnCancel);
    }

    protected void saveAndDispose() {
        try {
            this.updateModel();
            InventoryMetaCodeDAO.getInstance().saveOrUpdate(this.model);
            this.setCanceled(false);
            this.dispose();
        }
        catch (Exception e) {
            POSMessageDialog.showError(e.getMessage());
        }
    }

    private void updateView() {
        if (this.model == null) {
            return;
        }
        this.tfType.setText(this.model.getType());
        this.tfName.setText(this.model.getCodeText());
        this.tfNo.setText("" + this.model.getCodeNo());
        this.tfDescription.setText(this.model.getDescription());
    }

    private boolean updateModel() {
        if (this.model == null) {
            this.model = new InventoryMetaCode();
        }
        this.model.setType(this.tfType.getText());
        this.model.setCodeText(this.tfName.getText());
        this.model.setCodeNo(this.tfNo.getInteger());
        this.model.setDescription(this.tfDescription.getText());
        return true;
    }

    @Override
    public void setTitle(String title) {
        this.titlePanel.setTitle(title);
    }

    public InventoryMetaCode getModel() {
        return this.model;
    }
}

