/*
 * Decompiled with CFR 0.152.
 */
package com.orostock.inventory.ui;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.model.InventoryLocation;
import com.floreantpos.model.InventoryStock;
import com.floreantpos.model.InventoryTransaction;
import com.floreantpos.model.InventoryTransactionType;
import com.floreantpos.model.InventoryUnit;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.dao.InventoryLocationDAO;
import com.floreantpos.model.dao.InventoryStockDAO;
import com.floreantpos.model.dao.InventoryTransactionDAO;
import com.floreantpos.model.dao.InventoryUnitDAO;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.swing.PosTable;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.dialog.WeightSelectionDialog;
import com.floreantpos.ui.inv.InventoryTransactionEntryForm;
import com.floreantpos.util.POSUtil;
import com.orostock.inventory.InvMessages;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import net.miginfocom.swing.MigLayout;
import org.hibernate.Session;
import org.jdesktop.swingx.JXTable;

public class InventoryStockBrowser
extends TransparentPanel {
    private static final long serialVersionUID = 1L;
    private JXTable table;
    private BeanTableModel<InventoryStock> tableModel = new BeanTableModel(InventoryStock.class);
    private JTextField tfName;
    private JComboBox<Object> cbLocation;

    public InventoryStockBrowser() {
        this.tableModel.addColumn(POSConstants.SKU.toUpperCase(), InventoryStock.PROP_SKU);
        this.tableModel.addColumn(POSConstants.ITEM.toUpperCase(), InventoryStock.PROP_ITEM_NAME);
        this.tableModel.addColumn(InvMessages.getString("InventoryStockBrowser.0"), "inventoryLocation");
        this.tableModel.addColumn(InvMessages.getString("InventoryStockBrowser.1"), "quantityInHand", 11, BeanTableModel.DataType.NUMBER);
        this.tableModel.addColumn(InvMessages.getString("InventoryStockBrowser.2"), "unitName");
        this.table = new PosTable(this.tableModel);
        this.setLayout(new BorderLayout(5, 5));
        this.add(new JScrollPane((Component)this.table));
        this.add(this.createButtonPanel(), "South");
        this.add((Component)this.buildSearchForm(), "North");
        this.searchItem();
    }

    private Component createButtonPanel() {
        JPanel panel = new JPanel();
        this.addInventoryButtonActions(panel);
        return panel;
    }

    private void addInventoryButtonActions(JPanel panel) {
        JButton inTransactionButton = new JButton(InvMessages.getString("IVISB.12"));
        JButton outTransactionButton = new JButton(InvMessages.getString("IVISB.11"));
        JButton transferTransactionButton = new JButton(InvMessages.getString("IVISB.10"));
        JButton btnConvert = new JButton(InvMessages.getString("IVISB.9"));
        btnConvert.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    InventoryStockBrowser.this.doConvertion();
                }
                catch (Exception x) {
                    POSMessageDialog.showError(InventoryStockBrowser.this, x.getMessage(), x);
                }
            }
        });
        inTransactionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int index = InventoryStockBrowser.this.table.getSelectedRow();
                if (index < 0) {
                    return;
                }
                InventoryStock stock = (InventoryStock)InventoryStockBrowser.this.tableModel.getRow(index);
                MenuItem menuItem = MenuItemDAO.getInstance().loadInitialized(stock.getMenuItemId());
                InventoryTransaction inventoryTransaction = new InventoryTransaction();
                inventoryTransaction.setType(InventoryTransactionType.IN.getType());
                inventoryTransaction.setMenuItem(menuItem);
                inventoryTransaction.setToInventoryLocation(stock.getInventoryLocation());
                InventoryTransactionEntryForm inventoryTransactionEntryForm = new InventoryTransactionEntryForm(inventoryTransaction);
                BeanEditorDialog dialog = new BeanEditorDialog(inventoryTransactionEntryForm);
                dialog.setPreferredSize(PosUIManager.getSize(500, 500));
                dialog.open();
                if (dialog.isCanceled()) {
                    return;
                }
            }
        });
        outTransactionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int index = InventoryStockBrowser.this.table.getSelectedRow();
                if (index < 0) {
                    return;
                }
                InventoryStock stock = (InventoryStock)InventoryStockBrowser.this.tableModel.getRow(index);
                MenuItem menuItem = MenuItemDAO.getInstance().loadInitialized(stock.getMenuItemId());
                InventoryTransaction inventoryTransaction = new InventoryTransaction();
                inventoryTransaction.setType(InventoryTransactionType.OUT.getType());
                inventoryTransaction.setMenuItem(menuItem);
                inventoryTransaction.setFromInventoryLocation(stock.getInventoryLocation());
                InventoryTransactionEntryForm inventoryTransactionEntryForm = new InventoryTransactionEntryForm(inventoryTransaction);
                BeanEditorDialog dialog = new BeanEditorDialog(inventoryTransactionEntryForm);
                dialog.setPreferredSize(PosUIManager.getSize(500, 500));
                dialog.open();
                if (dialog.isCanceled()) {
                    return;
                }
            }
        });
        transferTransactionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int index = InventoryStockBrowser.this.table.getSelectedRow();
                if (index < 0) {
                    return;
                }
                InventoryStock stock = (InventoryStock)InventoryStockBrowser.this.tableModel.getRow(index);
                MenuItem menuItem = MenuItemDAO.getInstance().loadInitialized(stock.getMenuItemId());
                InventoryTransaction inventoryTransaction = new InventoryTransaction();
                inventoryTransaction.setReason("TRANSFER");
                inventoryTransaction.setMenuItem(menuItem);
                InventoryTransactionEntryForm transferForm = new InventoryTransactionEntryForm(inventoryTransaction);
                BeanEditorDialog dialog = new BeanEditorDialog(transferForm);
                dialog.setPreferredSize(PosUIManager.getSize(500, 500));
                dialog.open();
                if (dialog.isCanceled()) {
                    return;
                }
            }
        });
        panel.add(btnConvert);
    }

    private Double getConvertQuantity(InventoryStock stock, InventoryUnit inventoryUnit, MenuItem menuItem) {
        WeightSelectionDialog dialog = new WeightSelectionDialog(inventoryUnit, stock.getUnit(), menuItem);
        dialog.setTitle(InvMessages.getString("IVISB.8"));
        dialog.setFloatingPoint(true);
        dialog.setValue(stock.getQuantityInHand());
        dialog.pack();
        dialog.open();
        if (dialog.isCanceled()) {
            return null;
        }
        Double inputQuantity = dialog.getValue();
        if (inputQuantity > stock.getQuantityInHand()) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), InvMessages.getString("IVISB.7"));
            return this.getConvertQuantity(stock, inventoryUnit, menuItem);
        }
        if (inputQuantity == 0.0) {
            POSMessageDialog.showError(InvMessages.getString("IVISB.6"));
            return this.getConvertQuantity(stock, inventoryUnit, menuItem);
        }
        return inputQuantity;
    }

    private Double getConvertQuantity(InventoryStock stock) {
        WeightSelectionDialog dialog = new WeightSelectionDialog(POSUtil.getBackOfficeWindow());
        dialog.setTitle(InvMessages.getString("IVISB.8"));
        dialog.setFloatingPoint(true);
        dialog.setValue(stock.getQuantityInHand());
        dialog.pack();
        dialog.open();
        if (dialog.isCanceled()) {
            return null;
        }
        Double inputQuantity = dialog.getValue();
        if (inputQuantity > stock.getQuantityInHand()) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), InvMessages.getString("IVISB.7"));
            this.getConvertQuantity(stock);
        }
        if (inputQuantity == 0.0) {
            POSMessageDialog.showError(InvMessages.getString("IVISB.6"));
            this.getConvertQuantity(stock);
        }
        return inputQuantity;
    }

    private JPanel buildSearchForm() {
        JPanel panel = new JPanel();
        panel.setLayout((LayoutManager)new MigLayout("", "[][]15[][]15[][]15[]", "[]5[]"));
        JLabel lblName = new JLabel(InvMessages.getString("IVISB.0"));
        JLabel lblGroup = new JLabel(InvMessages.getString("IVISB.5"));
        this.tfName = new JTextField(15);
        try {
            this.cbLocation = new JComboBox();
            List<InventoryLocation> inventoryLocationList = InventoryLocationDAO.getInstance().findAll();
            this.cbLocation.addItem(InvMessages.getString("IVCRV.21"));
            for (InventoryLocation s : inventoryLocationList) {
                this.cbLocation.addItem(s);
            }
            JButton searchBttn = new JButton(InvMessages.getString("IVIS.22"));
            panel.add((Component)lblName, "align label");
            panel.add(this.tfName);
            panel.add(lblGroup);
            panel.add(this.cbLocation);
            panel.add(searchBttn);
            Border loweredetched = BorderFactory.createEtchedBorder(1);
            TitledBorder title = BorderFactory.createTitledBorder(loweredetched, InvMessages.getString("IVIS.22"));
            title.setTitleJustification(1);
            panel.setBorder(title);
            searchBttn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    InventoryStockBrowser.this.searchItem();
                }
            });
            this.tfName.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    InventoryStockBrowser.this.searchItem();
                }
            });
        }
        catch (Throwable x) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
        }
        return panel;
    }

    private void searchItem() {
        String txName = this.tfName.getText();
        Object selectedGroup = this.cbLocation.getSelectedItem();
        List<InventoryStock> similarItem = InventoryStockDAO.getInstance().getInventoryStock(txName, selectedGroup);
        this.tableModel.removeAll();
        this.tableModel.addRows(similarItem);
    }

    private void editSelectedRow() {
        try {
            int index = this.table.getSelectedRow();
            if (index < 0) {
                return;
            }
            index = this.table.convertRowIndexToModel(index);
            InventoryStock inventoryStock = this.tableModel.getRow(index);
            inventoryStock = InventoryStockDAO.getInstance().initialize(inventoryStock);
            this.tableModel.setRow(index, inventoryStock);
            this.table.repaint();
        }
        catch (Throwable x) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
        }
    }

    private void refresh() {
        this.searchItem();
    }

    private void doConvertion() {
        int index = this.table.getSelectedRow();
        if (index < 0) {
            return;
        }
        InventoryStock stock = this.tableModel.getRow(index = this.table.convertRowIndexToModel(index));
        if (stock.getQuantityInHand() == 0.0) {
            POSMessageDialog.showError(this, Messages.getString("InventoryStockBrowser.4"));
            return;
        }
        MenuItem menuItem = MenuItemDAO.getInstance().loadInitialized(stock.getMenuItemId());
        if (menuItem == null) {
            return;
        }
        if (menuItem.getUnit() == null) {
            POSMessageDialog.showError(this, InvMessages.getString("HasNoUnit"));
            return;
        }
        InventoryUnit sourceInventoryUnit = (InventoryUnit)InventoryUnitDAO.getInstance().findByCode(stock.getUnit());
        InventoryUnit destinationInventoryUnit = new InventoryUnit();
        Double convertValue = this.getConvertQuantity(stock, destinationInventoryUnit, menuItem);
        if (convertValue == null) {
            return;
        }
        double convertedQuantity = menuItem.getUnitQuantity(sourceInventoryUnit, destinationInventoryUnit) * convertValue;
        try (Session session = InventoryTransactionDAO.getInstance().createNewSession();){
            Boolean isConverted = InventoryTransactionDAO.getInstance().convertInventoryUnit(session, menuItem, stock, sourceInventoryUnit, destinationInventoryUnit, convertValue);
            if (!isConverted.booleanValue()) {
                return;
            }
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), InvMessages.getString("InventoryStockBrowser.3") + convertValue + " " + sourceInventoryUnit.getName() + InvMessages.getString("InventoryStockBrowser.5") + convertedQuantity + " " + destinationInventoryUnit.getName());
            this.refresh();
        }
    }
}

