/*
 * Decompiled with CFR 0.152.
 */
package com.orostock.inventory.ui;

import com.floreantpos.PosException;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.model.IUnit;
import com.floreantpos.model.InventoryUnit;
import com.floreantpos.model.InventoryUnitGroup;
import com.floreantpos.model.base.BaseInventoryUnit;
import com.floreantpos.model.dao.GenericDAO;
import com.floreantpos.model.dao.InventoryUnitDAO;
import com.floreantpos.model.dao.InventoryUnitGroupDAO;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.model.util.IllegalModelStateException;
import com.floreantpos.model.util.InventoryUnitConversionRule;
import com.floreantpos.swing.ComboBoxModel;
import com.floreantpos.swing.DoubleTextField;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import com.orostock.inventory.InvMessages;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public class InventoryUnitFormTree
extends BeanEditor<InventoryUnit> {
    private static final String EMPTY_SPACE = " ";
    private FixedLengthTextField tfName = new FixedLengthTextField(30);
    private FixedLengthTextField tfCode = new FixedLengthTextField(10);
    private DoubleTextField tfFactor = new DoubleTextField(10);
    private JComboBox<InventoryUnitConversionRule> cbConversionRule = new JComboBox();
    private JComboBox<InventoryUnitGroup> cbUnitGroups = new JComboBox();
    private List<InventoryUnitGroup> groups;
    private JButton btnAddNew;
    private JCheckBox chkBaseUnit;
    private JLabel lblConversionStatus;

    public InventoryUnitFormTree() {
        this(new InventoryUnit());
    }

    public InventoryUnitFormTree(InventoryUnit unit) {
        this.createUI();
        this.groups = InventoryUnitGroupDAO.getInstance().findAll();
        if (this.groups != null) {
            this.cbUnitGroups.setModel(new ComboBoxModel(this.groups));
        }
        this.setBean(unit);
        if (unit.getId() != null) {
            this.tfCode.setEnabled(false);
        }
        String conversionRule = unit.getProperty("conversion.rule", InventoryUnitConversionRule.DIVISION.getName());
        this.cbConversionRule.setModel(new ComboBoxModel(Arrays.asList(InventoryUnitConversionRule.values())));
        InventoryUnitConversionRule selectedRule = InventoryUnitConversionRule.fromName(conversionRule);
        this.cbConversionRule.setSelectedItem((Object)selectedRule);
        if (selectedRule == InventoryUnitConversionRule.DIVISION) {
            this.tfFactor.setText(String.valueOf(unit.getConversionRate()));
        } else if (selectedRule == InventoryUnitConversionRule.MULTIPLICATION) {
            this.tfFactor.setText(String.valueOf(1.0 / unit.getConversionRate()));
        }
        if (unit.getId() != null) {
            this.processConversionStatusMessage();
        }
    }

    private void createUI() {
        this.setLayout((LayoutManager)new MigLayout("fillx"));
        this.add(new JLabel(InvMessages.getString("IVUFT.1")));
        this.add((Component)this.tfCode, "grow, wrap");
        this.add(new JLabel(InvMessages.getString("IVUFT.3")));
        this.add((Component)this.tfName, "grow, wrap");
        this.add(new JLabel(InvMessages.getString("IVUFT.5")));
        this.add((Component)this.tfFactor, "split 2");
        this.add((Component)new JLabel(InvMessages.getString("InventoryUnitFormTree.0")), "newline");
        this.add(this.cbConversionRule, "gapright 20, split 2");
        this.lblConversionStatus = new JLabel();
        this.add((Component)this.lblConversionStatus, "wrap");
        this.add(new JLabel(InvMessages.getString("IVUFT.7")));
        this.add(this.cbUnitGroups, "split 2");
        this.btnAddNew = new JButton(InvMessages.getString("IVUFT.9"));
        this.add((Component)this.btnAddNew, "wrap");
        this.chkBaseUnit = new JCheckBox(InvMessages.getString("IVUFT.16"));
        this.add((Component)this.chkBaseUnit, "skip 1,wrap");
        this.btnAddNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    String groupName = JOptionPane.showInputDialog(POSUtil.getFocusedWindow(), (Object)InvMessages.getString("IVUFT.10"));
                    if (groupName == null) {
                        return;
                    }
                    if (groupName.length() > 30) {
                        BOMessageDialog.showError(POSUtil.getFocusedWindow(), InvMessages.getString("IVUFT.13"));
                        return;
                    }
                    InventoryUnitGroup group = new InventoryUnitGroup();
                    GenericDAO.getInstance().checkIdOrNameExists(group.getId(), groupName, InventoryUnitGroup.class);
                    group.setName(groupName);
                    InventoryUnitGroupDAO.getInstance().saveOrUpdate(group);
                    InventoryUnitFormTree.this.groups.add(group);
                    InventoryUnitFormTree.this.cbUnitGroups.setModel(new ComboBoxModel(InventoryUnitFormTree.this.groups));
                    InventoryUnitFormTree.this.cbUnitGroups.setSelectedItem(group);
                }
                catch (PosException exception) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage());
                }
            }
        });
        this.tfFactor.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                InventoryUnitFormTree.this.processConversionStatusMessage();
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }
        });
        this.cbUnitGroups.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                InventoryUnitFormTree.this.processConversionStatusMessage();
            }
        });
        this.cbConversionRule.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                InventoryUnitFormTree.this.processConversionStatusMessage();
            }
        });
    }

    private void processConversionStatusMessage() {
        if (StringUtils.isEmpty((String)this.tfName.getText())) {
            POSMessageDialog.showError(InvMessages.getString("InventoryUnitFormTree.1"));
            this.tfFactor.setText(null);
            return;
        }
        String conversionRateText = this.tfFactor.getText();
        if (StringUtils.isEmpty((String)conversionRateText)) {
            this.lblConversionStatus.setText(null);
            return;
        }
        Double conversionRate = Double.parseDouble(conversionRateText);
        if (conversionRate == 0.0) {
            this.lblConversionStatus.setText(null);
            return;
        }
        InventoryUnitGroup group = (InventoryUnitGroup)this.cbUnitGroups.getSelectedItem();
        InventoryUnitConversionRule rule = (InventoryUnitConversionRule)((Object)this.cbConversionRule.getSelectedItem());
        BaseInventoryUnit baseUnit = null;
        List<InventoryUnit> units = group.getUnits();
        if (units != null) {
            for (InventoryUnit unit : units) {
                if (!unit.isBaseUnit().booleanValue()) continue;
                baseUnit = unit;
                break;
            }
        }
        if (baseUnit == null) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("(");
            stringBuilder.append(InvMessages.getString("InventoryUnitFormTree.2"));
            stringBuilder.append(EMPTY_SPACE);
            stringBuilder.append(group.getName());
            stringBuilder.append(".");
            stringBuilder.append(")");
            this.lblConversionStatus.setText(stringBuilder.toString());
            return;
        }
        if (baseUnit.getCode().equals(this.tfCode.getText())) {
            this.lblConversionStatus.setText(null);
            return;
        }
        Double ratio = 0.0;
        if (rule == InventoryUnitConversionRule.DIVISION) {
            ratio = baseUnit.getConversionRate() / conversionRate;
        } else if (rule == InventoryUnitConversionRule.MULTIPLICATION) {
            ratio = baseUnit.getConversionRate() * conversionRate;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(");
        stringBuilder.append("1 ");
        stringBuilder.append(this.tfName.getText());
        stringBuilder.append(" = ");
        stringBuilder.append(NumberUtil.round(ratio, 8));
        stringBuilder.append(EMPTY_SPACE);
        stringBuilder.append(baseUnit.getName());
        stringBuilder.append(")");
        this.lblConversionStatus.setText(stringBuilder.toString());
    }

    @Override
    public boolean save() {
        try {
            if (!this.updateModel()) {
                return false;
            }
            InventoryUnit selectedUnit = (InventoryUnit)this.getBean();
            if (StringUtils.isEmpty((String)selectedUnit.getId())) {
                IUnit findByCode = null;
                try {
                    findByCode = InventoryUnitDAO.getInstance().findByCode(selectedUnit.getCode());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (findByCode != null) {
                    String message = InvMessages.getString("InventoryUnitFormTree.6") + selectedUnit.getCode() + InvMessages.getString("InventoryUnitFormTree.7") + EMPTY_SPACE + findByCode.getName() + EMPTY_SPACE + InvMessages.getString("InventoryUnitFormTree.8");
                    POSMessageDialog.showError(message);
                    return false;
                }
            }
            boolean baseUnit = selectedUnit.isBaseUnit();
            InventoryUnitGroup unitGroup = InventoryUnitGroupDAO.getInstance().get(selectedUnit.getUnitGroupId());
            if (baseUnit) {
                if (unitGroup.getUnits() != null) {
                    for (InventoryUnit unit : unitGroup.getUnits()) {
                        unit.setBaseUnit(false);
                    }
                }
                selectedUnit.setBaseUnit(true);
            }
            InventoryUnitConversionRule selectedRule = (InventoryUnitConversionRule)((Object)this.cbConversionRule.getSelectedItem());
            selectedUnit.addProperty("conversion.rule", selectedRule.getName());
            if (selectedRule == InventoryUnitConversionRule.MULTIPLICATION) {
                selectedUnit.setConversionRate(1.0 / selectedUnit.getConversionRate());
            } else {
                selectedUnit.setConversionRate(selectedUnit.getConversionRate());
            }
            ArrayList<InventoryUnit> newUnits = new ArrayList<InventoryUnit>();
            List<InventoryUnit> units = unitGroup.getUnits();
            if (units != null) {
                if (units.contains(selectedUnit)) {
                    for (InventoryUnit inventoryUnit : units) {
                        if (inventoryUnit.getId().equals(selectedUnit.getId())) {
                            inventoryUnit = selectedUnit;
                        }
                        newUnits.add(inventoryUnit);
                    }
                    unitGroup.setUnits(newUnits);
                } else {
                    unitGroup.addTounits(selectedUnit);
                }
            } else {
                unitGroup.addTounits(selectedUnit);
            }
            TerminalDAO.getInstance().performBatchSave(unitGroup.getUnits().toArray());
            return true;
        }
        catch (PosException exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage());
        }
        catch (IllegalModelStateException e) {
            POSMessageDialog.showError(this, e.getMessage());
        }
        return false;
    }

    @Override
    public void createNew() {
        this.setBean(new InventoryUnit());
        this.clearFields();
    }

    @Override
    public void setFieldsEnable(boolean enable) {
        this.tfName.setEnabled(enable);
        this.tfFactor.setEnabled(enable);
        this.cbUnitGroups.setEnabled(enable);
        this.btnAddNew.setEnabled(enable);
        this.chkBaseUnit.setEnabled(enable);
    }

    @Override
    public void clearFields() {
        this.tfName.setText("");
        this.tfCode.setText("");
        this.tfFactor.setText("");
    }

    @Override
    protected void updateView() {
        ComboBoxModel model;
        InventoryUnit inventoryUnit = (InventoryUnit)this.getBean();
        if (inventoryUnit == null) {
            return;
        }
        this.tfName.setText(inventoryUnit.getName());
        this.tfCode.setText(inventoryUnit.getCode());
        this.tfFactor.setText(inventoryUnit.getConversionRate() + "");
        String groupId = inventoryUnit.getUnitGroupId();
        if (StringUtils.isNotEmpty((String)groupId) && (model = (ComboBoxModel)this.cbUnitGroups.getModel()).getSize() > 0) {
            for (InventoryUnitGroup group : model.getDataList()) {
                if (!group.getId().equals(groupId)) continue;
                this.cbUnitGroups.setSelectedItem(group);
            }
        }
        this.chkBaseUnit.setSelected(inventoryUnit.isBaseUnit());
    }

    @Override
    protected boolean updateModel() throws IllegalModelStateException {
        InventoryUnit inventoryUnit = (InventoryUnit)this.getBean();
        String code = this.tfCode.getText();
        String name = this.tfName.getText();
        double conversionRate = this.tfFactor.getDouble();
        InventoryUnitGroup group = (InventoryUnitGroup)this.cbUnitGroups.getSelectedItem();
        if (StringUtils.isEmpty((String)code)) {
            POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), InvMessages.getString("IVUFT.23"));
            return false;
        }
        inventoryUnit.setCode(code);
        if (Double.isNaN(conversionRate) || conversionRate <= 0.0) {
            POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), InvMessages.getString("IVUFT.25"));
            return false;
        }
        if (group == null) {
            POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), InvMessages.getString("IVUFT.26"));
            return false;
        }
        inventoryUnit.setName(name);
        if (StringUtils.isEmpty((String)inventoryUnit.getCode())) {
            inventoryUnit.setCode(code.replaceAll("[^\\p{Alnum}]", "_"));
        }
        GenericDAO.getInstance().checkIdOrNameExists(inventoryUnit.getId(), name, InventoryUnit.class);
        inventoryUnit.setConversionRate(conversionRate);
        inventoryUnit.setUnitGroupId(group.getId());
        inventoryUnit.setBaseUnit(this.chkBaseUnit.isSelected());
        return true;
    }

    @Override
    public boolean delete() {
        try {
            InventoryUnit inventoryUnit = (InventoryUnit)this.getBean();
            if (inventoryUnit == null) {
                return false;
            }
            int option = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getBackOfficeWindow(), InvMessages.getString("IVUFT.29"), InvMessages.getString("IVUFT.30"));
            if (option != 0) {
                return false;
            }
            InventoryUnitDAO.getInstance().delete(inventoryUnit);
            this.clearFields();
            return true;
        }
        catch (Exception e) {
            POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), e.getMessage(), e);
            return false;
        }
    }

    @Override
    public String getDisplayText() {
        return InvMessages.getString("IVUFT.31");
    }
}

