/*
 * Decompiled with CFR 0.152.
 */
package com.orostock.inventory.ui;

import com.floreantpos.PosException;
import com.floreantpos.model.InventoryUnitGroup;
import com.floreantpos.model.dao.GenericDAO;
import com.floreantpos.model.dao.InventoryUnitGroupDAO;
import com.floreantpos.swing.POSTextField;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import com.orostock.inventory.InvMessages;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;

public class InventoryUnitGroupEntryForm
extends BeanEditor<InventoryUnitGroup> {
    private JCheckBox chkVisible;
    private POSTextField tfName;

    public InventoryUnitGroupEntryForm(InventoryUnitGroup inventoryGroup) {
        this.createUI();
        this.setBean(inventoryGroup);
    }

    private void createUI() {
        this.setLayout(new BorderLayout(0, 0));
        JPanel panel = new JPanel();
        this.add(panel);
        panel.setLayout((LayoutManager)new MigLayout("", "[][grow]", "[][]"));
        JLabel lblName = new JLabel(InvMessages.getString("IVUGEF.3"));
        panel.add((Component)lblName, "cell 0 0,alignx trailing");
        this.tfName = new POSTextField();
        panel.add((Component)this.tfName, "cell 1 0,growx");
        this.chkVisible = new JCheckBox(InvMessages.getString("IVUGEF.6"), true);
        panel.add((Component)this.chkVisible, "cell 1 1");
    }

    @Override
    public void createNew() {
        this.setBean(new InventoryUnitGroup());
        this.clearFields();
    }

    @Override
    public void clearFields() {
        this.tfName.setText("");
        this.chkVisible.setSelected(false);
    }

    @Override
    public void setFieldsEnable(boolean enable) {
        this.tfName.setEnabled(enable);
        this.chkVisible.setEnabled(enable);
    }

    @Override
    public void updateView() {
        InventoryUnitGroup inventoryGroup = (InventoryUnitGroup)this.getBean();
        if (inventoryGroup == null) {
            this.clearFields();
            return;
        }
        this.tfName.setText(inventoryGroup.getName());
    }

    @Override
    public boolean updateModel() {
        InventoryUnitGroup inventoryUnitGroup = (InventoryUnitGroup)this.getBean();
        if (inventoryUnitGroup == null) {
            inventoryUnitGroup = new InventoryUnitGroup();
        }
        String nameString = this.tfName.getText();
        GenericDAO.getInstance().checkIdOrNameExists(inventoryUnitGroup.getId(), nameString, InventoryUnitGroup.class);
        inventoryUnitGroup.setName(nameString);
        return true;
    }

    @Override
    public String getDisplayText() {
        return InvMessages.getString("IVUGEF.10");
    }

    @Override
    public boolean save() {
        try {
            if (!this.updateModel()) {
                return false;
            }
            InventoryUnitGroup model = (InventoryUnitGroup)this.getBean();
            InventoryUnitGroupDAO.getInstance().saveOrUpdate(model);
            return true;
        }
        catch (PosException e) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e.getMessage());
        }
        catch (Exception e) {
            POSMessageDialog.showError(e.getMessage());
        }
        return false;
    }

    @Override
    public boolean delete() {
        try {
            InventoryUnitGroup inventoryGroup = (InventoryUnitGroup)this.getBean();
            if (inventoryGroup == null) {
                return false;
            }
            int option = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getBackOfficeWindow(), InvMessages.getString("IVUGEF.11"), InvMessages.getString("IVUGEF.12"));
            if (option != 0) {
                return false;
            }
            InventoryUnitGroupDAO.getInstance().delete(inventoryGroup);
            this.clearFields();
            return true;
        }
        catch (Exception e) {
            POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), e.getMessage(), e);
            return false;
        }
    }
}

