/*
 * Decompiled with CFR 0.152.
 */
package com.orostock.inventory.ui;

import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.bo.ui.explorer.ExplorerButtonPanel;
import com.floreantpos.model.InventoryUnit;
import com.floreantpos.model.InventoryUnitGroup;
import com.floreantpos.model.dao.InventoryUnitDAO;
import com.floreantpos.model.dao.InventoryUnitGroupDAO;
import com.floreantpos.model.util.InventoryUnitConversionRule;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import com.orostock.inventory.InvMessages;
import com.orostock.inventory.ui.InventoryUnitFormTree;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.DecimalFormat;
import java.util.Enumeration;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.tree.TreePath;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.swingx.JXTreeTable;
import org.jdesktop.swingx.treetable.DefaultMutableTreeTableNode;
import org.jdesktop.swingx.treetable.DefaultTreeTableModel;
import org.jdesktop.swingx.treetable.MutableTreeTableNode;
import org.jdesktop.swingx.treetable.TreeTableModel;
import org.jdesktop.swingx.treetable.TreeTableNode;

public class InventoryUnitsExplorer
extends TransparentPanel
implements ActionListener,
ListSelectionListener {
    private static final long serialVersionUID = 1L;
    private JXTreeTable treeTable;
    private InvUnitGroupTreeTableModel noRootTreeTableModel;
    private List<InventoryUnitGroup> rootUnitGroupList;
    private final DecimalFormat decimalFormat = new DecimalFormat("#.########");

    public InventoryUnitsExplorer() {
        this.setLayout(new BorderLayout(5, 5));
        this.treeTable = new JXTreeTable();
        this.treeTable.setRowHeight(PosUIManager.getSize(30));
        this.treeTable.setRootVisible(false);
        this.loadData();
        this.treeTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                int col = InventoryUnitsExplorer.this.treeTable.columnAtPoint(me.getPoint());
                if (me.getClickCount() == 2 && col == 0) {
                    InventoryUnitsExplorer.this.treeTable.expandPath(InventoryUnitsExplorer.this.treeTable.getPathForRow(InventoryUnitsExplorer.this.treeTable.getSelectedRow()));
                } else if (me.getClickCount() == 2 && col != 0) {
                    InventoryUnitsExplorer.this.editSelectedRow();
                }
            }
        });
        this.add((Component)new JScrollPane((Component)this.treeTable), "Center");
        this.treeTable.getColumnModel().getColumn(3).setCellRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component tableCellRendererComponent = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                this.setHorizontalAlignment(4);
                return tableCellRendererComponent;
            }
        });
        this.createButtonPanel();
        JPanel topPanel = new JPanel((LayoutManager)new MigLayout());
        JButton btnRefresh = new JButton(InvMessages.getString("IVUE.0"));
        btnRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InventoryUnitsExplorer.this.loadData();
            }
        });
        topPanel.add(btnRefresh);
        this.add((Component)topPanel, "North");
    }

    private void loadData() {
        this.rootUnitGroupList = InventoryUnitGroupDAO.getInstance().findAll();
        this.createTree();
        this.treeTable.expandAll();
    }

    private void createTree() {
        if (this.rootUnitGroupList != null) {
            InventoryUnitGroup demo = new InventoryUnitGroup();
            demo.setId("0");
            demo.setName(InvMessages.getString("IVUE.2"));
            DefaultMutableTreeTableNode rootNode = new DefaultMutableTreeTableNode((Object)demo);
            rootNode.setUserObject((Object)demo);
            for (InventoryUnitGroup inventoryUnitGroup : this.rootUnitGroupList) {
                DefaultMutableTreeTableNode node = new DefaultMutableTreeTableNode((Object)inventoryUnitGroup);
                rootNode.add((MutableTreeTableNode)node);
                this.buildLocationTree(node);
            }
            List<InventoryUnit> unGrouped = InventoryUnitDAO.getInstance().findUnGrouped();
            for (InventoryUnit inventoryUnit : unGrouped) {
                DefaultMutableTreeTableNode node = new DefaultMutableTreeTableNode((Object)inventoryUnit);
                rootNode.add((MutableTreeTableNode)node);
            }
            this.noRootTreeTableModel = new InvUnitGroupTreeTableModel(rootNode);
            this.treeTable.setTreeTableModel((TreeTableModel)this.noRootTreeTableModel);
        }
    }

    private void buildLocationTree(DefaultMutableTreeTableNode defaultMutableTreeTableNode) {
        InventoryUnitGroup unitGroup = (InventoryUnitGroup)defaultMutableTreeTableNode.getUserObject();
        if (unitGroup == null) {
            return;
        }
        defaultMutableTreeTableNode.setAllowsChildren(true);
        List<InventoryUnit> unitList = unitGroup.getUnits();
        for (InventoryUnit inventoryUnit : unitList) {
            DefaultMutableTreeTableNode node = new DefaultMutableTreeTableNode((Object)inventoryUnit);
            defaultMutableTreeTableNode.add((MutableTreeTableNode)node);
        }
    }

    private void createButtonPanel() {
        ExplorerButtonPanel explorerButton = new ExplorerButtonPanel();
        JButton btn_newGroup = new JButton(InvMessages.getString("IVUE.10"));
        JButton btn_newUnit = new JButton(InvMessages.getString("IVUE.11"));
        JButton editButton = explorerButton.getEditButton();
        JButton deleteButton = explorerButton.getDeleteButton();
        btn_newGroup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    String groupName = JOptionPane.showInputDialog(POSUtil.getFocusedWindow(), (Object)InvMessages.getString("IVUE.12"));
                    if (groupName == null) {
                        return;
                    }
                    if (groupName.equals("")) {
                        POSMessageDialog.showError(POSUtil.getFocusedWindow(), InvMessages.getString("IVUE.14"));
                        return;
                    }
                    if (groupName.length() > 30) {
                        BOMessageDialog.showError(POSUtil.getFocusedWindow(), InvMessages.getString("IVUE.15"));
                        return;
                    }
                    InventoryUnitGroup inventoryUnitGroup = new InventoryUnitGroup();
                    inventoryUnitGroup.setName(groupName);
                    InventoryUnitGroupDAO inventoryUnitGroupDAO = new InventoryUnitGroupDAO();
                    inventoryUnitGroupDAO.saveOrUpdate(inventoryUnitGroup);
                    if (inventoryUnitGroup != null) {
                        MutableTreeTableNode root = (MutableTreeTableNode)InventoryUnitsExplorer.this.noRootTreeTableModel.getRoot();
                        InventoryUnitsExplorer.this.noRootTreeTableModel.insertNodeInto((MutableTreeTableNode)new DefaultMutableTreeTableNode((Object)inventoryUnitGroup), root, root.getChildCount());
                    }
                    InventoryUnitsExplorer.this.treeTable.expandAll();
                }
                catch (Exception e2) {
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, e2);
                }
            }
        });
        btn_newUnit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InventoryUnitFormTree inventoryUnitFormTree = new InventoryUnitFormTree(new InventoryUnit());
                BeanEditorDialog dialog = new BeanEditorDialog(inventoryUnitFormTree);
                dialog.setPreferredSize(PosUIManager.getSize(500, 600));
                dialog.open();
                if (dialog.isCanceled()) {
                    return;
                }
                InventoryUnit unit = (InventoryUnit)inventoryUnitFormTree.getBean();
                InventoryUnitGroup parentOfNewLoc = unit.getUnitGroup();
                if (unit != null) {
                    MutableTreeTableNode root = (MutableTreeTableNode)InventoryUnitsExplorer.this.noRootTreeTableModel.getRoot();
                    if (parentOfNewLoc != null) {
                        MutableTreeTableNode parentNode = InventoryUnitsExplorer.this.findTreeNodeForLocation(root, parentOfNewLoc.getId());
                        if (parentNode != null) {
                            InventoryUnitsExplorer.this.noRootTreeTableModel.insertNodeInto((MutableTreeTableNode)new DefaultMutableTreeTableNode((Object)unit), parentNode, parentNode.getChildCount());
                        }
                    } else {
                        MutableTreeTableNode parentNode = InventoryUnitsExplorer.this.findTreeNodeForLocation(root, "0");
                        if (parentNode != null) {
                            InventoryUnitsExplorer.this.noRootTreeTableModel.insertNodeInto((MutableTreeTableNode)new DefaultMutableTreeTableNode((Object)unit), parentNode, parentNode.getChildCount());
                        }
                    }
                }
                InventoryUnitsExplorer.this.treeTable.expandAll();
            }
        });
        editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InventoryUnitsExplorer.this.editSelectedRow();
            }
        });
        deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                this.deleteInventoryUnit();
            }

            private void deleteInventoryUnit() {
                try {
                    int index = InventoryUnitsExplorer.this.treeTable.getSelectedRow();
                    if (index < 0) {
                        POSMessageDialog.showError(POSUtil.getFocusedWindow(), InvMessages.getString("IVUE.17"));
                        return;
                    }
                    TreePath treePath = InventoryUnitsExplorer.this.treeTable.getPathForRow(index);
                    DefaultMutableTreeTableNode lastPathComponent = (DefaultMutableTreeTableNode)treePath.getLastPathComponent();
                    if (lastPathComponent.getUserObject() instanceof InventoryUnitGroup) {
                        InventoryUnitGroup unitGroup = (InventoryUnitGroup)lastPathComponent.getUserObject();
                        if (unitGroup != null) {
                            throw new PosException(InvMessages.getString("InventoryUnitsExplorer.5"));
                        }
                        MutableTreeTableNode tableNode = InventoryUnitsExplorer.this.findTreeNodeForLocation((MutableTreeTableNode)InventoryUnitsExplorer.this.noRootTreeTableModel.getRoot(), unitGroup.getId());
                        if (tableNode.getParent() != null) {
                            InventoryUnitsExplorer.this.noRootTreeTableModel.removeNodeFromParent(tableNode);
                        }
                    } else if (lastPathComponent.getUserObject() instanceof InventoryUnit) {
                        if (POSMessageDialog.showYesNoQuestionDialog(InventoryUnitsExplorer.this.getRootPane(), POSConstants.CONFIRM_DELETE, POSConstants.DELETE) != 0) {
                            return;
                        }
                        InventoryUnit unit = (InventoryUnit)lastPathComponent.getUserObject();
                        InventoryUnitDAO.getInstance().delete(unit);
                        MutableTreeTableNode tableNode = InventoryUnitsExplorer.this.findTreeNodeForLocation((MutableTreeTableNode)InventoryUnitsExplorer.this.noRootTreeTableModel.getRoot(), unit.getId());
                        if (tableNode.getParent() != null) {
                            InventoryUnitsExplorer.this.noRootTreeTableModel.removeNodeFromParent(tableNode);
                        }
                    }
                    InventoryUnitsExplorer.this.treeTable.repaint();
                    InventoryUnitsExplorer.this.treeTable.revalidate();
                }
                catch (PosException e) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), e.getMessage());
                }
                catch (Throwable x) {
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
                }
            }
        });
        TransparentPanel panel = new TransparentPanel();
        panel.add(btn_newGroup);
        panel.add(btn_newUnit);
        panel.add(editButton);
        panel.add(deleteButton);
        this.add((Component)panel, "South");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
    }

    private void editSelectedRow() {
        try {
            int index = this.treeTable.getSelectedRow();
            if (index < 0) {
                POSMessageDialog.showError(this, InvMessages.getString("IVUE.18"));
                return;
            }
            TreePath treePath = this.treeTable.getPathForRow(index);
            DefaultMutableTreeTableNode lastPathComponent = (DefaultMutableTreeTableNode)treePath.getLastPathComponent();
            if (lastPathComponent.getUserObject() instanceof InventoryUnitGroup) {
                InventoryUnitGroup unitGroup = (InventoryUnitGroup)lastPathComponent.getUserObject();
                this.editInventoryGroup(unitGroup);
            } else if (lastPathComponent.getUserObject() instanceof InventoryUnit) {
                InventoryUnit unit = (InventoryUnit)lastPathComponent.getUserObject();
                this.editInventoryItem(unit);
            }
            this.loadData();
        }
        catch (Throwable x) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
        }
    }

    public void editInventoryItem(InventoryUnit unit) {
        InventoryUnitFormTree inventoryUnitFormTree = new InventoryUnitFormTree(unit);
        BeanEditorDialog dialog = new BeanEditorDialog(inventoryUnitFormTree);
        dialog.setPreferredSize(PosUIManager.getSize(500, 600));
        dialog.open();
    }

    public void editInventoryGroup(InventoryUnitGroup unitGroup) {
        String groupName = JOptionPane.showInputDialog(POSUtil.getFocusedWindow(), InvMessages.getString("IVUE.19"), unitGroup.getName());
        if (groupName == null) {
            return;
        }
        if (groupName.isEmpty()) {
            POSMessageDialog.showError(this, InvMessages.getString("IVUE.20"));
            return;
        }
        if (groupName.length() > 30) {
            BOMessageDialog.showError(POSUtil.getFocusedWindow(), InvMessages.getString("IVUE.21"));
            return;
        }
        unitGroup.setName(groupName);
        InventoryUnitGroupDAO inventoryUnitGroupDAO = new InventoryUnitGroupDAO();
        inventoryUnitGroupDAO.saveOrUpdate(unitGroup);
    }

    public MutableTreeTableNode findTreeNodeForLocation(MutableTreeTableNode locationNode, String locationId) {
        block5: {
            block4: {
                if (!(((DefaultMutableTreeTableNode)locationNode).getUserObject() instanceof InventoryUnitGroup)) break block4;
                InventoryUnitGroup groupLocation = (InventoryUnitGroup)locationNode.getUserObject();
                if (locationId.equals(groupLocation.getId())) {
                    return locationNode;
                }
                Enumeration children = locationNode.children();
                while (children.hasMoreElements()) {
                    MutableTreeTableNode treeTableNode = (MutableTreeTableNode)children.nextElement();
                    MutableTreeTableNode findLocById = this.findTreeNodeForLocation(treeTableNode, locationId);
                    if (findLocById == null) continue;
                    return findLocById;
                }
                break block5;
            }
            if (!(((DefaultMutableTreeTableNode)locationNode).getUserObject() instanceof InventoryUnit)) break block5;
            InventoryUnit unitLocation = (InventoryUnit)locationNode.getUserObject();
            if (locationId.equals(unitLocation.getId())) {
                return locationNode;
            }
            Enumeration children = locationNode.children();
            while (children.hasMoreElements()) {
                MutableTreeTableNode treeTableNode = (MutableTreeTableNode)children.nextElement();
                MutableTreeTableNode findLocById = this.findTreeNodeForLocation(treeTableNode, locationId);
                if (findLocById == null) continue;
                return findLocById;
            }
        }
        return null;
    }

    class InvUnitGroupTreeTableModel
    extends DefaultTreeTableModel {
        private final String[] COLUMN_NAMES;

        public InvUnitGroupTreeTableModel(DefaultMutableTreeTableNode rootLocation) {
            super((TreeTableNode)rootLocation);
            this.COLUMN_NAMES = new String[]{InvMessages.getString("InventoryUnitsExplorer.0"), InvMessages.getString("InventoryUnitsExplorer.1"), InvMessages.getString("InventoryUnitsExplorer.2"), InvMessages.getString("InventoryUnitsExplorer.3"), InvMessages.getString("InventoryUnitsExplorer.6"), InvMessages.getString("InventoryUnitsExplorer.4")};
        }

        public void setRoot(TreeTableNode root) {
            super.setRoot(root);
        }

        public int getColumnCount() {
            return this.COLUMN_NAMES.length;
        }

        public String getColumnName(int column) {
            return this.COLUMN_NAMES[column];
        }

        public boolean isCellEditable(Object node, int column) {
            return false;
        }

        public Object getValueAt(Object node, int column) {
            if (node instanceof DefaultMutableTreeTableNode) {
                if (((DefaultMutableTreeTableNode)node).getUserObject() instanceof InventoryUnitGroup) {
                    InventoryUnitGroup inventoryLocation = (InventoryUnitGroup)((DefaultMutableTreeTableNode)node).getUserObject();
                    if (inventoryLocation == null) {
                        return "";
                    }
                    switch (column) {
                        case 0: {
                            return inventoryLocation.getName();
                        }
                    }
                } else if (((DefaultMutableTreeTableNode)node).getUserObject() instanceof InventoryUnit) {
                    InventoryUnit inventoryUnit = (InventoryUnit)((DefaultMutableTreeTableNode)node).getUserObject();
                    if (inventoryUnit == null) {
                        return "";
                    }
                    switch (column) {
                        case 1: {
                            return inventoryUnit.getCode();
                        }
                        case 2: {
                            return inventoryUnit.getName();
                        }
                        case 3: {
                            String inventoryUnitConversionRuleName = inventoryUnit.getProperty("conversion.rule", InventoryUnitConversionRule.DIVISION.getName());
                            InventoryUnitConversionRule inventoryUnitConversionRule = InventoryUnitConversionRule.fromName(inventoryUnitConversionRuleName);
                            Double conversionRate = 0.0;
                            if (inventoryUnitConversionRule == InventoryUnitConversionRule.MULTIPLICATION) {
                                conversionRate = 1.0 / inventoryUnit.getConversionRate();
                            } else if (inventoryUnitConversionRule == InventoryUnitConversionRule.DIVISION) {
                                conversionRate = inventoryUnit.getConversionRate();
                            }
                            return InventoryUnitsExplorer.this.decimalFormat.format(conversionRate);
                        }
                        case 4: {
                            return inventoryUnit.getProperty("conversion.rule", InventoryUnitConversionRule.DIVISION.getName());
                        }
                        case 5: {
                            return inventoryUnit.isBaseUnit();
                        }
                    }
                }
            }
            return null;
        }
    }
}

