/*
 * Decompiled with CFR 0.152.
 */
package com.orostock.inventory.ui;

import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.model.InventoryStockUnit;
import com.floreantpos.model.InventoryUnit;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.PackagingUnit;
import com.floreantpos.model.dao.InventoryStockUnitDAO;
import com.floreantpos.model.dao.PackagingUnitDAO;
import com.floreantpos.model.util.IllegalModelStateException;
import com.floreantpos.swing.ComboBoxModel;
import com.floreantpos.swing.DoubleTextField;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import com.orostock.inventory.InvMessages;
import com.orostock.inventory.ui.InventoryUnitForm;
import com.orostock.inventory.ui.PackagingUnitForm;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import net.miginfocom.swing.MigLayout;

public class MenuItemPackagingUnitForm
extends BeanEditor<InventoryStockUnit> {
    private DoubleTextField tfFactor = new DoubleTextField(10);
    private JComboBox cbPackagingUnit = new JComboBox();
    private JButton btnAddNew;
    private MenuItem menuItem;
    private JLabel lblBaseUnit;
    private JComboBox cbItemUnits = new JComboBox();
    private boolean recipeUnit;

    public MenuItemPackagingUnitForm() {
        this(new InventoryStockUnit(), null);
    }

    public MenuItemPackagingUnitForm(InventoryStockUnit unit, MenuItem menuItem) {
        this(unit, menuItem, false);
    }

    public MenuItemPackagingUnitForm(InventoryStockUnit unit, MenuItem menuItem, boolean recipeUnit) {
        this.recipeUnit = recipeUnit;
        this.createUI();
        this.menuItem = menuItem;
        if (menuItem != null) {
            if (unit.getId() == null) {
                InventoryUnit invUnit = menuItem.getUnit();
                if (invUnit != null) {
                    this.lblBaseUnit.setText(invUnit.getCode());
                }
            } else {
                this.lblBaseUnit.setText(unit.getUnit().getName());
            }
            List<PackagingUnit> stockUnits = PackagingUnitDAO.getInstance().findAll(recipeUnit);
            this.cbPackagingUnit.setModel(new ComboBoxModel(stockUnits));
            this.cbPackagingUnit.setSelectedItem(unit.getPackagingUnit());
            this.cbItemUnits.setModel(new ComboBoxModel(menuItem.getUnit().getUnitGroup().getUnits()));
            this.cbItemUnits.setSelectedItem(menuItem.getUnit());
        }
        this.setBean(unit);
    }

    private void createUI() {
        this.setLayout((LayoutManager)new MigLayout("fillx"));
        this.add(new JLabel(this.recipeUnit ? InvMessages.getString("IVMIPUF.1") : InvMessages.getString("IVMIPUF.2")));
        this.add((Component)this.cbPackagingUnit, "split 2,grow");
        this.btnAddNew = new JButton(InvMessages.getString("IVMIPUF.0"));
        this.btnAddNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuItemPackagingUnitForm.this.doAddPackagingUnit();
            }
        });
        this.add((Component)this.btnAddNew, "wrap");
        this.add((Component)new JLabel("="), "right");
        this.add((Component)this.tfFactor, "split 3,grow");
        this.lblBaseUnit = new JLabel();
        this.add((Component)this.cbItemUnits, "grow");
        JButton btnAddInventoryUnit = new JButton(InvMessages.getString("IVMIPUF.0"));
        btnAddInventoryUnit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuItemPackagingUnitForm.this.doAddInventoryUnit();
            }
        });
        this.add(btnAddInventoryUnit);
    }

    private void doAddPackagingUnit() {
        try {
            PackagingUnitForm editor = new PackagingUnitForm(this.recipeUnit);
            BeanEditorDialog dialog = new BeanEditorDialog(editor);
            dialog.open();
            if (dialog.isCanceled()) {
                return;
            }
            PackagingUnit packagingUnit = (PackagingUnit)editor.getBean();
            ComboBoxModel model = (ComboBoxModel)this.cbPackagingUnit.getModel();
            model.addElement(packagingUnit);
            this.cbPackagingUnit.setSelectedItem(packagingUnit);
        }
        catch (Exception x) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
        }
    }

    private void doAddInventoryUnit() {
        try {
            InventoryUnitForm editor = new InventoryUnitForm();
            BeanEditorDialog dialog = new BeanEditorDialog(editor);
            dialog.open();
            if (dialog.isCanceled()) {
                return;
            }
            InventoryUnit inventoryUnit = (InventoryUnit)editor.getBean();
            ComboBoxModel model = (ComboBoxModel)this.cbItemUnits.getModel();
            model.addElement(inventoryUnit);
            this.cbItemUnits.setSelectedItem(inventoryUnit);
        }
        catch (Exception x) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
        }
    }

    @Override
    public boolean save() {
        try {
            return this.updateModel();
        }
        catch (IllegalModelStateException e) {
            POSMessageDialog.showError(this, e.getMessage());
            return false;
        }
    }

    @Override
    public void createNew() {
        this.setBean(new InventoryStockUnit());
        this.clearFields();
    }

    @Override
    public void setFieldsEnable(boolean enable) {
        this.tfFactor.setEnabled(enable);
        this.btnAddNew.setEnabled(enable);
    }

    @Override
    public void clearFields() {
        this.tfFactor.setText("");
    }

    @Override
    protected void updateView() {
        InventoryStockUnit inventoryUnit = (InventoryStockUnit)this.getBean();
        if (inventoryUnit == null) {
            return;
        }
        this.cbPackagingUnit.setSelectedItem(inventoryUnit.getPackagingUnit());
        this.tfFactor.setText(inventoryUnit.getConversionValue() + "");
        InventoryUnit unit = inventoryUnit.getUnit();
        if (unit != null) {
            this.lblBaseUnit.setText(unit.getName());
            this.cbItemUnits.setSelectedItem(unit);
        }
    }

    @Override
    protected boolean updateModel() throws IllegalModelStateException {
        InventoryStockUnit stockUnit = (InventoryStockUnit)this.getBean();
        double conversionRate = this.tfFactor.getDouble();
        stockUnit.setPackagingUnit((PackagingUnit)this.cbPackagingUnit.getSelectedItem());
        stockUnit.setConversionValue(conversionRate);
        if (this.menuItem.getUnit() == null) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), InvMessages.getString("IVMIPUF.13"));
            return false;
        }
        stockUnit.setUnit(this.menuItem.getUnit());
        stockUnit.setMenuItemId(this.menuItem.getId());
        stockUnit.setUnit((InventoryUnit)this.cbItemUnits.getSelectedItem());
        stockUnit.calculateBaseUnitValue();
        return true;
    }

    @Override
    public boolean delete() {
        try {
            InventoryStockUnit inventoryUnit = (InventoryStockUnit)this.getBean();
            if (inventoryUnit == null) {
                return false;
            }
            int option = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getBackOfficeWindow(), InvMessages.getString("IVMIPUF.14"), InvMessages.getString("IVMIPUF.15"));
            if (option != 0) {
                return false;
            }
            InventoryStockUnitDAO.getInstance().delete(inventoryUnit);
            this.clearFields();
            return true;
        }
        catch (Exception e) {
            POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), e.getMessage(), e);
            return false;
        }
    }

    @Override
    public String getDisplayText() {
        if (this.recipeUnit) {
            return InvMessages.getString("IVMIPUF.16");
        }
        return InvMessages.getString("IVMIPUF.17");
    }
}

