/*
 * Decompiled with CFR 0.152.
 */
package com.orostock.inventory.ui;

import com.floreantpos.PosLog;
import com.floreantpos.main.Application;
import com.floreantpos.model.Customer;
import com.floreantpos.model.InventoryLocation;
import com.floreantpos.model.InventoryVendor;
import com.floreantpos.model.PurchaseOrder;
import com.floreantpos.model.PurchaseOrderItem;
import com.floreantpos.model.Store;
import com.floreantpos.model.dao.InventoryLocationDAO;
import com.floreantpos.model.dao.InventoryVendorDAO;
import com.floreantpos.model.dao.InventoryVendorItemsDAO;
import com.floreantpos.model.dao.PurchaseOrderDAO;
import com.floreantpos.model.dao.PurchaseOrderItemDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.swing.ComboBoxModel;
import com.floreantpos.swing.DoubleTextField;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.swing.ListTableModel;
import com.floreantpos.swing.POSTextField;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.NumberSelectionDialog2;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.inv.InventoryLocationSelector;
import com.floreantpos.ui.util.UiUtil;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import com.orostock.inventory.InvMessages;
import com.orostock.inventory.ui.PurchaseOrderItemEntryDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.swingx.JXDatePicker;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.table.TableColumnModelExt;

public class PurchaseOrderForm
extends BeanEditor<PurchaseOrder> {
    private static final long serialVersionUID = 1L;
    private JButton btnParentLoc;
    private POSTextField tfLocation;
    private JLabel lblLoc;
    private JLabel lblVendor;
    private PurchaseOrder purchaseOrder;
    private JComboBox<InventoryVendor> cbVendor;
    private FixedLengthTextField tfOrderId;
    private JLabel lblOrderId;
    private InventoryLocation location;
    private TitledBorder titleBorder;
    private JXDatePicker dpPurchaseOrderDate;
    private JXDatePicker dpReceivedDate;
    private JXTable table;
    private PurchaseItemTableModel tableModel;
    private DoubleTextField tfSubTotalAmount;
    private List<PurchaseOrderItem> items = new ArrayList<PurchaseOrderItem>();
    private boolean receive;
    private JButton btnAddItem;
    private JButton btnDeleteItem;
    private boolean updateAvailableUnit;
    private POSTextField tfInvoiceNumber;
    private JXDatePicker dpShipDate;

    public PurchaseOrderForm() {
        this(new PurchaseOrder());
    }

    public PurchaseOrderForm(PurchaseOrder purchaseOrder) {
        this(purchaseOrder, false);
    }

    public PurchaseOrderForm(PurchaseOrder purchaseOrder, boolean receive) {
        this.purchaseOrder = purchaseOrder;
        this.receive = receive;
        this.updateAvailableUnit = Application.getInstance().getStore().isUpdateOnHandBlncForPORec();
        if (purchaseOrder.getOrderItems() != null) {
            this.items.addAll(purchaseOrder.getOrderItems());
        }
        if (receive) {
            for (PurchaseOrderItem item : purchaseOrder.getOrderItems()) {
                item.setQuantityToReceive(item.getItemQuantity() - item.getQuantityReceived());
            }
        }
        this.initComponents();
        InventoryVendorDAO inventoryVendorDao = new InventoryVendorDAO();
        List<InventoryVendor> inventoryVendors = inventoryVendorDao.findAll();
        this.cbVendor.setModel(new ComboBoxModel(inventoryVendors));
        this.setBean(purchaseOrder);
        this.tfLocation.setEditable(false);
        this.btnParentLoc.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InventoryLocation selectedLocation = InventoryLocationSelector.openLocationSelector();
                if (selectedLocation == null) {
                    return;
                }
                PurchaseOrderForm.this.location = selectedLocation;
                PurchaseOrderForm.this.tfLocation.setText(PurchaseOrderForm.this.location.getName());
            }
        });
        this.updatePrice();
    }

    public void setReceive(boolean receive, boolean updateAvailableUnit) {
        this.receive = receive;
        this.updateAvailableUnit = updateAvailableUnit;
    }

    private void updatePrice() {
        double subtotalAmount = 0.0;
        if (this.items == null) {
            return;
        }
        for (PurchaseOrderItem item : this.items) {
            item.calculatePrice();
            subtotalAmount += item.getSubtotalAmount().doubleValue();
        }
        this.tfSubTotalAmount.setText(NumberUtil.formatNumber(subtotalAmount));
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        JPanel itemInfoPanel = new JPanel((LayoutManager)new MigLayout("hidemode 3", "[][grow][]", ""));
        this.titleBorder = new TitledBorder("");
        itemInfoPanel.setBorder(this.titleBorder);
        this.add((Component)itemInfoPanel, "North");
        this.lblOrderId = new JLabel(InvMessages.getString("IVPOF.4"));
        itemInfoPanel.add((Component)this.lblOrderId, "alignx trailing");
        this.tfOrderId = new FixedLengthTextField();
        itemInfoPanel.add((Component)this.tfOrderId, "growx, wrap");
        this.lblVendor = new JLabel(InvMessages.getString("IVPOF.7"));
        itemInfoPanel.add((Component)this.lblVendor, "alignx trailing");
        this.cbVendor = new JComboBox();
        this.cbVendor.setMinimumSize(PosUIManager.getSize(90, 0));
        itemInfoPanel.add(this.cbVendor, "wrap");
        this.cbVendor.setEnabled(!this.receive);
        this.lblLoc = new JLabel(InvMessages.getString("IVPOF.10"));
        itemInfoPanel.add((Component)this.lblLoc, "alignx trailing");
        this.tfLocation = new POSTextField();
        itemInfoPanel.add((Component)this.tfLocation, "split 2,growx");
        this.tfLocation.setEditable(false);
        this.btnParentLoc = new JButton(InvMessages.getString("IVPOF.13"));
        itemInfoPanel.add((Component)this.btnParentLoc, "wrap");
        this.dpPurchaseOrderDate = UiUtil.getDeafultDate();
        if (!this.receive) {
            this.dpPurchaseOrderDate.setDate(new Date());
            itemInfoPanel.add((Component)new JLabel(InvMessages.getString("IVPOF.15")), "alignx trailing");
            itemInfoPanel.add((Component)this.dpPurchaseOrderDate, "split 5");
        }
        this.dpReceivedDate = UiUtil.getDeafultDate();
        if (this.receive) {
            this.dpReceivedDate.setDate(new Date());
            itemInfoPanel.add((Component)new JLabel(InvMessages.getString("IVPOF.18")), "alignx trailing");
            itemInfoPanel.add((Component)this.dpReceivedDate, "split 5");
        }
        this.dpShipDate = UiUtil.getDeafultDate();
        this.dpShipDate.setDate(new Date());
        itemInfoPanel.add((Component)new JLabel(InvMessages.getString("IVPOF.21")), "gapleft 20, alignx trailing");
        itemInfoPanel.add((Component)this.dpShipDate);
        this.tfInvoiceNumber = new POSTextField(20);
        itemInfoPanel.add((Component)new JLabel(InvMessages.getString("IVPOF.23")), "gapleft 20, alignx trailing");
        itemInfoPanel.add(this.tfInvoiceNumber);
        String[] columnNamesWithMember = new String[]{InvMessages.getString("PurchaseOrderForm.0"), InvMessages.getString("PurchaseOrderForm.1"), InvMessages.getString("PurchaseOrderForm.2"), InvMessages.getString("PurchaseOrderForm.3"), InvMessages.getString("PurchaseOrderForm.4"), InvMessages.getString("PurchaseOrderForm.5") + " (" + CurrencyUtil.getCurrencySymbol() + ")", InvMessages.getString("PurchaseOrderForm.8"), InvMessages.getString("PurchaseOrderForm.9") + " (" + CurrencyUtil.getCurrencySymbol() + ")", InvMessages.getString("PurchaseOrderForm.12")};
        String[] columnNamesWithoutMember = new String[]{InvMessages.getString("PurchaseOrderForm.13"), InvMessages.getString("PurchaseOrderForm.14"), InvMessages.getString("PurchaseOrderForm.15"), InvMessages.getString("PurchaseOrderForm.16"), InvMessages.getString("PurchaseOrderForm.17"), InvMessages.getString("PurchaseOrderForm.18") + " (" + CurrencyUtil.getCurrencySymbol() + ")", InvMessages.getString("PurchaseOrderForm.21"), InvMessages.getString("PurchaseOrderForm.22") + " (" + CurrencyUtil.getCurrencySymbol() + ")"};
        Store store = Application.getInstance().getStore();
        this.tableModel = new PurchaseItemTableModel(store.isAllwMemberbasedPOI() ? columnNamesWithMember : columnNamesWithoutMember);
        this.table = new JXTable(this.tableModel){

            public void changeSelection(int row, int column, boolean toggle, boolean extend) {
                super.changeSelection(row, column, toggle, extend);
                PurchaseOrderForm.this.table.editCellAt(row, column);
                DefaultCellEditor editor = (DefaultCellEditor)PurchaseOrderForm.this.table.getCellEditor(row, column);
                DoubleTextField textField = (DoubleTextField)editor.getComponent();
                textField.requestFocus();
                textField.selectAll();
            }

            public void setValueAt(Object value, int rowIndex, int columnIndex) {
                PurchaseOrderItem purchaseOrderItem = PurchaseOrderForm.this.tableModel.getRowData(rowIndex);
                String receiveStr = (String)value;
                if (receiveStr.isEmpty()) {
                    return;
                }
                double quantity = Double.parseDouble(receiveStr);
                if (columnIndex == 4) {
                    if (PurchaseOrderForm.this.receive) {
                        purchaseOrderItem.setQuantityToReceive(quantity);
                        List<PurchaseOrderItem> orderItems = PurchaseOrderForm.this.purchaseOrder.getOrderItems();
                        for (PurchaseOrderItem orderItem : orderItems) {
                            if (!orderItem.equals(purchaseOrderItem)) continue;
                            orderItem.setQuantityToReceive(purchaseOrderItem.getQuantityToReceive());
                        }
                    } else {
                        purchaseOrderItem.setUnitPrice(quantity);
                        purchaseOrderItem.calculatePrice();
                    }
                }
                if (columnIndex == 5 && PurchaseOrderForm.this.receive) {
                    purchaseOrderItem.setUnitPrice(quantity);
                }
                if (columnIndex == 3 && !PurchaseOrderForm.this.receive) {
                    purchaseOrderItem.setItemQuantity(quantity);
                }
                PurchaseOrderForm.this.updatePrice();
                PurchaseOrderForm.this.table.repaint();
            }
        };
        this.table.setDefaultRenderer(Object.class, (TableCellRenderer)new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                if (column <= 2) {
                    this.setHorizontalAlignment(2);
                } else {
                    this.setHorizontalAlignment(4);
                }
                if (column == 3) {
                    value = value + " " + ((PurchaseOrderItem)PurchaseOrderForm.this.items.get(row)).getItemUnitName();
                }
                return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            }
        });
        this.table.setSelectionMode(0);
        this.table.getInputMap().put(KeyStroke.getKeyStroke(32, 0), "startEditing");
        DoubleTextField tfEditField = new DoubleTextField();
        tfEditField.setHorizontalAlignment(2);
        DefaultCellEditor editor = new DefaultCellEditor(tfEditField);
        editor.setClickCountToStart(1);
        if (!this.receive) {
            this.table.setDefaultEditor(this.table.getColumnClass(3), (TableCellEditor)editor);
        }
        this.table.setDefaultEditor(this.table.getColumnClass(4), (TableCellEditor)editor);
        this.table.setDefaultEditor(this.table.getColumnClass(5), (TableCellEditor)editor);
        this.table.setRowHeight(PosUIManager.getSize(30));
        this.add(new JScrollPane((Component)this.table));
        TableColumnModelExt columnModel = (TableColumnModelExt)this.table.getColumnModel();
        columnModel.getColumnExt(4).setVisible(this.receive);
        columnModel.getColumnExt(5).setVisible(this.receive);
        JPanel southActionPanel = new JPanel((LayoutManager)new MigLayout("fillx,hidemode 3"));
        this.btnAddItem = new JButton(InvMessages.getString("IVPOF.53"));
        JButton btnEditItem = new JButton(InvMessages.getString("IVPOF.54"));
        this.btnDeleteItem = new JButton(InvMessages.getString("IVPOF.55"));
        this.btnAddItem.setVisible(!this.receive);
        this.btnDeleteItem.setVisible(!this.receive);
        this.btnAddItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PurchaseOrderForm.this.doAddItem();
            }
        });
        btnEditItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PurchaseOrderForm.this.doEditItem();
            }
        });
        this.btnDeleteItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PurchaseOrderForm.this.doDeleteItem();
            }
        });
        southActionPanel.add((Component)this.btnAddItem, "split 3,left");
        southActionPanel.add(btnEditItem);
        southActionPanel.add(this.btnDeleteItem);
        this.tfSubTotalAmount = new DoubleTextField(10);
        this.tfSubTotalAmount.setHorizontalAlignment(4);
        this.tfSubTotalAmount.setEditable(false);
        southActionPanel.add((Component)new JLabel(InvMessages.getString("PurchaseOrderForm.25") + " (" + CurrencyUtil.getCurrencySymbol() + ")"), "split 2,right");
        southActionPanel.add((Component)this.tfSubTotalAmount, "");
        this.add((Component)southActionPanel, "South");
        this.resizeTableColumns();
    }

    private void resizeTableColumns() {
        this.table.setAutoResizeMode(4);
        if (!this.receive) {
            this.setColumnWidth(0, PosUIManager.getSize(100));
            this.setColumnWidth(2, PosUIManager.getSize(150));
            this.setColumnWidth(3, PosUIManager.getSize(100));
            this.setColumnWidth(4, PosUIManager.getSize(80));
            this.setColumnWidth(5, PosUIManager.getSize(120));
        } else {
            this.setColumnWidth(0, PosUIManager.getSize(100));
            this.setColumnWidth(2, PosUIManager.getSize(150));
        }
    }

    private void setColumnWidth(int columnNumber, int width) {
        TableColumn column = this.table.getColumnModel().getColumn(columnNumber);
        column.setPreferredWidth(width);
        column.setMaxWidth(width);
        column.setMinWidth(width);
    }

    @Override
    public boolean save() {
        try {
            if (!this.updateModel()) {
                return false;
            }
            PurchaseOrder purchaseOrder = (PurchaseOrder)this.getBean();
            Store store = DataProvider.get().getStore();
            if (this.receive) {
                InventoryVendorItemsDAO.getInstance().saveItems(purchaseOrder);
                PurchaseOrderDAO.getInstance().saveOrUpdate(purchaseOrder, true, this.updateAvailableUnit);
            } else if (store.isUpdateAvlBlncForPOCreated()) {
                PurchaseOrderDAO.getInstance().saveOrUpdateWithItemAvailBalance(purchaseOrder);
            } else {
                PurchaseOrderDAO.getInstance().saveOrUpdate(purchaseOrder);
            }
            return true;
        }
        catch (Exception e) {
            PosLog.error(this.getClass(), e);
            POSMessageDialog.showError(e.getMessage());
            return false;
        }
    }

    @Override
    public void updateView() {
        PurchaseOrder purchaseOrder = (PurchaseOrder)this.getBean();
        if (purchaseOrder.getInventoryLocation() == null) {
            this.location = InventoryLocationDAO.getInstance().getDefaultInInventoryLocation();
            if (this.location != null) {
                this.tfLocation.setText(this.location.getName());
            }
        } else {
            this.tfLocation.setText(purchaseOrder.getInventoryLocation().getName());
            this.location = purchaseOrder.getInventoryLocation();
        }
        if (purchaseOrder.getId() == null) {
            this.tfOrderId.setText(String.valueOf(PurchaseOrderDAO.getInstance().getNextOrderSequenceNumber()));
            return;
        }
        this.dpPurchaseOrderDate.setDate(purchaseOrder.getCreatedDate());
        this.dpShipDate.setDate(purchaseOrder.getShipDate());
        this.cbVendor.setSelectedItem(purchaseOrder.getVendor());
        this.tfOrderId.setText(purchaseOrder.getOrderId());
        this.tfInvoiceNumber.setText(purchaseOrder.getInvoiceNumber());
        this.updatePrice();
    }

    @Override
    public boolean updateModel() {
        PurchaseOrder purchaseOrder = (PurchaseOrder)this.getBean();
        if (this.location == null) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), InvMessages.getString("IVPOF.62"));
            return false;
        }
        purchaseOrder.setInventoryLocation(this.location);
        String orderId = this.tfOrderId.getText();
        if (StringUtils.isEmpty((CharSequence)orderId)) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), InvMessages.getString("IVPOF.63"));
            return false;
        }
        purchaseOrder.setOrderId(orderId);
        purchaseOrder.setCreatedDate(this.dpPurchaseOrderDate.getDate());
        purchaseOrder.setVendor((InventoryVendor)this.cbVendor.getSelectedItem());
        purchaseOrder.setInventoryLocation(this.location);
        purchaseOrder.setType(PurchaseOrder.DEBIT);
        purchaseOrder.setShipDate(this.dpShipDate.getDate());
        if (this.receive && this.dpReceivedDate.getDate() != null) {
            purchaseOrder.setReceivingDate(this.dpReceivedDate.getDate());
        }
        if (this.items == null || this.items.isEmpty()) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), InvMessages.getString("IVPOF.64"));
            return false;
        }
        String invoiceNumber = this.tfInvoiceNumber.getText();
        purchaseOrder.setInvoiceNumber(invoiceNumber);
        if (purchaseOrder.getOrderItems() != null) {
            purchaseOrder.getOrderItems().clear();
        }
        for (PurchaseOrderItem item : this.items) {
            item.setPurchaseOrder(purchaseOrder);
            purchaseOrder.addToorderItems(item);
        }
        purchaseOrder.calculatePrice();
        return true;
    }

    @Override
    public String getDisplayText() {
        return InvMessages.getString("IVPOF.68");
    }

    public List<PurchaseOrderItem> getItems() {
        return this.items;
    }

    private void doAddItem() {
        try {
            PurchaseOrderItem orderItem = new PurchaseOrderItem();
            PurchaseOrderItemEntryDialog dialog = new PurchaseOrderItemEntryDialog(orderItem);
            dialog.setSize(700, 650);
            dialog.open();
            if (dialog.isCanceled()) {
                return;
            }
            this.tableModel.addPurchaseOrderItem(orderItem);
            this.updatePrice();
        }
        catch (Exception ex) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), ex.getMessage(), ex);
        }
    }

    private void doEditItem() {
        try {
            int row = this.table.getSelectedRow();
            if (row == -1) {
                return;
            }
            int index = this.table.convertRowIndexToModel(row);
            PurchaseOrderItem item = this.items.get(index);
            if (item == null) {
                return;
            }
            if (this.receive) {
                double pendingReceivedQty = item.getItemQuantity() - item.getQuantityReceived();
                double quantity = NumberSelectionDialog2.takeDoubleInput(InvMessages.getString("IVPOF.69"), pendingReceivedQty);
                if (quantity > pendingReceivedQty || quantity < 0.0) {
                    POSMessageDialog.showMessage(POSUtil.getBackOfficeWindow(), InvMessages.getString("IVPOF.70"));
                    return;
                }
                item.setQuantityToReceive(quantity);
            } else {
                PurchaseOrderItemEntryDialog dialog = new PurchaseOrderItemEntryDialog(item);
                dialog.setSize(700, 650);
                dialog.open();
                if (dialog.isCanceled()) {
                    return;
                }
            }
            this.table.repaint();
            this.updatePrice();
        }
        catch (Exception ex) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), ex.getMessage(), ex);
        }
    }

    private void doDeleteItem() {
        try {
            int row = this.table.getSelectedRow();
            if (row == -1) {
                return;
            }
            int index = this.table.convertRowIndexToModel(row);
            PurchaseOrderItem item = this.tableModel.getRowData(index);
            if (item == null) {
                return;
            }
            this.tableModel.deletePurchaseOrder(item, index);
        }
        catch (Exception ex) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), ex.getMessage(), ex);
        }
    }

    class PurchaseItemTableModel
    extends ListTableModel<PurchaseOrderItem> {
        private static final long serialVersionUID = 1L;
        private String[] columnNames;

        public PurchaseItemTableModel(String[] columnNames) {
            this.columnNames = columnNames;
        }

        @Override
        public int getRowCount() {
            if (PurchaseOrderForm.this.items == null) {
                return 0;
            }
            return PurchaseOrderForm.this.items.size();
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public String getColumnName(int column) {
            return this.columnNames[column];
        }

        @Override
        public PurchaseOrderItem getRowData(int row) {
            return (PurchaseOrderItem)PurchaseOrderForm.this.items.get(row);
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            if (columnIndex == 3 && !PurchaseOrderForm.this.receive) {
                return true;
            }
            return columnIndex == 4 || columnIndex == 5;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (PurchaseOrderForm.this.items == null) {
                return "";
            }
            PurchaseOrderItem item = (PurchaseOrderItem)PurchaseOrderForm.this.items.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return item.getSku();
                }
                case 1: {
                    return item.getName();
                }
                case 2: {
                    return item.getNote();
                }
                case 3: {
                    return item.getItemQuantity();
                }
                case 4: {
                    return item.getQuantityToReceive();
                }
                case 5: {
                    return item.getUnitPrice();
                }
                case 6: {
                    return item.getItemUnitName();
                }
                case 7: {
                    return NumberUtil.formatNumber(item.getTotalAmount());
                }
                case 8: {
                    return this.buildCustomerName(item);
                }
            }
            return null;
        }

        private String buildCustomerName(PurchaseOrderItem item) {
            PurchaseOrderItemDAO.getInstance().loadCustomers(item);
            Set<Customer> customers = item.getCustomers();
            String customerName = "";
            if (customers == null) {
                return "";
            }
            Iterator<Customer> iterator = customers.iterator();
            while (iterator.hasNext()) {
                Customer customer = iterator.next();
                String name = customer.getName();
                customerName = name != null ? customerName + name : customerName + customer.getEmail();
                if (!iterator.hasNext()) continue;
                customerName = customerName + ", ";
            }
            return customerName;
        }

        public void addPurchaseOrderItem(PurchaseOrderItem item) {
            int size = PurchaseOrderForm.this.items.size();
            PurchaseOrderForm.this.items.add(item);
            this.fireTableRowsInserted(size, size);
        }

        public void deletePurchaseOrder(PurchaseOrderItem item, int index) {
            PurchaseOrderForm.this.items.remove(item);
            this.fireTableRowsDeleted(index, index);
        }
    }
}

