/*
 * Decompiled with CFR 0.152.
 */
package com.orostock.inventory.ui.recepie;

import com.floreantpos.bo.ui.CustomCellRenderer;
import com.floreantpos.model.IUnit;
import com.floreantpos.model.InventoryStockUnit;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.RecepieItem;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.swing.ComboBoxModel;
import com.floreantpos.swing.ListTableModel;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.util.NumberUtil;
import com.orostock.inventory.InvMessages;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractCellEditor;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ChangeListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.text.JTextComponent;

public class RecipeItemTable
extends JTable {
    private RecepieTableModel model;
    private JComboBox cbUnits;
    private ChangeListener listener;
    private int currentRowIndex;
    private int currentColumnIndex;

    public RecipeItemTable(List<RecepieItem> recipeItems) {
        this.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.model = new RecepieTableModel();
        this.model.setRows(recipeItems);
        this.setModel(this.model);
        this.getTableHeader().setPreferredSize(new Dimension(0, 25));
        this.setDefaultRenderer(Object.class, new CustomCellRenderer());
        this.setRowHeight(PosUIManager.getSize(25));
        DefaultTableCellRenderer cellRenderer = new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                this.setHorizontalAlignment(4);
                return c;
            }
        };
        this.getColumnModel().getColumn(3).setCellRenderer(cellRenderer);
        this.getColumnModel().getColumn(1).setCellRenderer(cellRenderer);
        this.cbUnits = new JComboBox();
        this.cbUnits.setModel(new ComboBoxModel(new ArrayList()));
        this.cbUnits.setSelectedItem("");
        JTextComponent editor = (JTextComponent)this.cbUnits.getEditor().getEditorComponent();
        editor.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyChar() == '\n') {
                    JComponent ja = (JComponent)e.getSource();
                    JComboBox jcbloc = (JComboBox)ja.getParent();
                    JTable jtb = (JTable)jcbloc.getParent();
                    jtb.changeSelection(0, 1, false, false);
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }
        });
        editor.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                JComponent ja = (JComponent)e.getSource();
                JComponent jcbloc = (JComponent)ja.getParent();
                JComboBox jcb = (JComboBox)jcbloc;
                jcb.setPopupVisible(true);
                JTextComponent editor = (JTextComponent)jcb.getEditor().getEditorComponent();
                editor.setSelectionStart(0);
                editor.setSelectionEnd(editor.getText().length());
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
        TableColumn colCombo = this.getColumnModel().getColumn(2);
        this.cbUnits.setEditable(true);
        ComboBoxEditor cbe = new ComboBoxEditor(this.cbUnits);
        colCombo.setCellEditor(cbe);
        TableColumn colQuantity = this.getColumnModel().getColumn(1);
        TextCellEditor quantityEditor = new TextCellEditor(new JTextField());
        colQuantity.setCellEditor(quantityEditor);
        this.resizeTableColumns();
    }

    private void resizeTableColumns() {
        this.setAutoResizeMode(4);
        this.setColumnWidth(1, PosUIManager.getSize(90));
        this.setColumnWidth(2, PosUIManager.getSize(90));
        this.setColumnWidth(3, PosUIManager.getSize(90));
    }

    private void setColumnWidth(int columnNumber, int width) {
        TableColumn column = this.getColumnModel().getColumn(columnNumber);
        column.setPreferredWidth(width);
        column.setMaxWidth(width);
        column.setMinWidth(width);
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        if (column == 1 || column == 2) {
            return true;
        }
        return super.isCellEditable(row, column);
    }

    @Override
    public void changeSelection(int rowIndex, int columnIndex, boolean toggle, boolean extend) {
        super.changeSelection(rowIndex, columnIndex, toggle, extend);
        if (columnIndex > -1 && this.editCellAt(rowIndex, columnIndex)) {
            Component editor = this.getEditorComponent();
            editor.requestFocusInWindow();
            if (editor instanceof JTextField) {
                JTextField jf = (JTextField)editor;
                jf.select(0, jf.toString().length());
            }
            if (editor instanceof JComboBox) {
                JComboBox jcb = (JComboBox)editor;
                String selectedUnit = (String)jcb.getSelectedItem();
                RecepieItem item = (RecepieItem)this.model.getRows().get(rowIndex);
                ArrayList<String> units = new ArrayList<String>();
                List<IUnit> stockUnits = item.getInventoryItem().getUnits();
                for (IUnit inventoryStockUnit : stockUnits) {
                    units.add(inventoryStockUnit.getUniqueCode());
                }
                this.currentRowIndex = rowIndex;
                this.currentColumnIndex = columnIndex;
                if (stockUnits != null) {
                    ComboBoxModel comboBoxModel = (ComboBoxModel)jcb.getModel();
                    comboBoxModel.removeAllElements();
                    comboBoxModel.setDataList(units);
                    jcb.setSelectedItem(selectedUnit);
                }
                jcb.setPopupVisible(true);
                JTextComponent editorCombo = (JTextComponent)jcb.getEditor().getEditorComponent();
                editorCombo.setSelectionStart(0);
                editorCombo.setSelectionEnd(editorCombo.getText().length());
            }
        }
    }

    public void setItems(List<RecepieItem> recepieItems) {
        if (recepieItems != null) {
            for (RecepieItem recepieItem : recepieItems) {
                MenuItemDAO.getInstance().initialize(recepieItem.getInventoryItem());
                recepieItem.calculatePercentage();
            }
        }
        this.model.setRows(recepieItems);
    }

    public void removeItem(int selectedRow) {
        this.model.deleteItem(selectedRow);
    }

    public RecepieItem getRow(int index) {
        return (RecepieItem)this.model.getRowData(index);
    }

    public void addRow(RecepieItem item) {
        this.model.addItem(item);
    }

    public Collection<? extends RecepieItem> getRows() {
        return this.model.getRows();
    }

    public void setParentMenuItem(MenuItem e) {
        List<InventoryStockUnit> stockUnits = e.getStockUnits();
        this.cbUnits.setModel(new ComboBoxModel(stockUnits));
    }

    public void setValueChangeListener(ChangeListener listener) {
        this.listener = listener;
    }

    public class TextCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        JTextField jtextfield;

        public TextCellEditor(JTextField jtf) {
            this.jtextfield = jtf;
        }

        @Override
        public Object getCellEditorValue() {
            return this.jtextfield.getText();
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (isSelected) {
                // empty if block
            }
            if (value == null) {
                value = "";
            }
            if ((value = value.toString()) instanceof Integer) {
                value = value.toString();
            }
            this.jtextfield.setText((String)value);
            return this.jtextfield;
        }

        @Override
        public boolean stopCellEditing() {
            this.fireEditingStopped();
            return true;
        }
    }

    public class ComboBoxEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        JComboBox comboBox;

        public ComboBoxEditor(JComboBox jcb) {
            this.comboBox = jcb;
        }

        @Override
        public Object getCellEditorValue() {
            return this.comboBox.getSelectedItem();
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.comboBox.setSelectedItem(value);
            return this.comboBox;
        }

        @Override
        public boolean stopCellEditing() {
            this.fireEditingStopped();
            return true;
        }
    }

    private class RecepieTableModel
    extends ListTableModel<RecepieItem> {
        public RecepieTableModel() {
            super(new String[]{InvMessages.getString("RecipeItemTable.2"), InvMessages.getString("RecipeItemTable.3"), InvMessages.getString("RecipeItemTable.4"), InvMessages.getString("RecipeItemTable.5")});
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            RecepieItem item = (RecepieItem)this.rows.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return item.getInventoryItem();
                }
                case 1: {
                    Double quantity = item.getQuantity() == 0.0 ? 1.0 : item.getQuantity();
                    return NumberUtil.format6DigitNumber(quantity);
                }
                case 2: {
                    IUnit unit = item.getUnit();
                    if (unit == null) {
                        return "";
                    }
                    return unit.getUniqueCode();
                }
                case 3: {
                    return NumberUtil.formatNumber(item.getCost());
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            RecepieItem item = (RecepieItem)this.rows.get(rowIndex);
            switch (columnIndex) {
                case 1: {
                    double quantity = 1.0;
                    try {
                        quantity = Double.valueOf(String.valueOf(aValue));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (item.getQuantity() == quantity) {
                        this.fireTableRowsUpdated(rowIndex, rowIndex);
                        return;
                    }
                    item.setQuantity(quantity);
                    item.calculatePercentage();
                    this.fireTableRowsUpdated(rowIndex, rowIndex);
                    if (RecipeItemTable.this.listener == null) break;
                    RecipeItemTable.this.listener.stateChanged(null);
                    break;
                }
                case 2: {
                    String unit = (String)aValue;
                    if (unit.equals(item.getUnitCode())) {
                        this.fireTableRowsUpdated(rowIndex, rowIndex);
                        return;
                    }
                    item.setUnitCode(unit);
                    item.calculatePercentage();
                    this.fireTableRowsUpdated(rowIndex, rowIndex);
                    if (RecipeItemTable.this.listener == null) break;
                    RecipeItemTable.this.listener.stateChanged(null);
                    break;
                }
                default: {
                    super.setValueAt(aValue, rowIndex, columnIndex);
                }
            }
        }
    }
}

