/*
 * Decompiled with CFR 0.152.
 */
package com.orostock.inventory.ui.recepie;

import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.Recepie;
import com.floreantpos.model.RecepieItem;
import com.floreantpos.model.RecipeTable;
import com.floreantpos.model.dao.RecipeTableDAO;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.swing.DoubleTextField;
import com.floreantpos.swing.IUpdatebleView;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import com.jidesoft.swing.TitledSeparator;
import com.orostock.inventory.InvMessages;
import com.orostock.inventory.ui.recepie.RecipeEntryForm;
import com.orostock.inventory.ui.recepie.RecipeItemTable;
import com.orostock.inventory.ui.recepie.RecipeSelectionDialog;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;

public class RecipeView
extends JPanel
implements IUpdatebleView<MenuItem> {
    private RecipeItemTable table;
    private DoubleTextField tfTotalCost = new DoubleTextField(8);
    private JButton btnChangeRecipe = new JButton(InvMessages.getString("IVRV.0"));
    boolean inited = false;
    protected Recepie recipe;
    private JTextField tfRecipeName;
    private RecipeTable recipeTable;
    private DoubleTextField tfPortion = new DoubleTextField(8);
    private JLabel lblPortionUnit;

    public RecipeView() {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.table = new RecipeItemTable(new ArrayList<RecepieItem>());
        this.table.setEnabled(false);
        JLabel lblRecipeItems = new JLabel(InvMessages.getString("IVRV.1"));
        Color fg = new Color(49, 106, 196);
        lblRecipeItems.setForeground(fg);
        JLabel lblSubRecipe = new JLabel(InvMessages.getString("IVRV.2"));
        lblSubRecipe.setForeground(fg);
        TitledSeparator sep1 = new TitledSeparator((JComponent)lblRecipeItems, 0);
        this.tfPortion.setHorizontalAlignment(4);
        JPanel tablePanel = new JPanel((LayoutManager)new MigLayout("fill,wrap 1"));
        tablePanel.add((Component)sep1, "span,grow");
        tablePanel.add((Component)new JLabel(InvMessages.getString("IVRV.5")), "split 3,span,right");
        tablePanel.add(this.tfPortion);
        this.lblPortionUnit = new JLabel("");
        tablePanel.add(this.lblPortionUnit);
        tablePanel.add((Component)new JScrollPane(this.table), "span,grow");
        tablePanel.add((Component)new JLabel(InvMessages.getString("IVRV.9")), "right,split 2");
        tablePanel.add(this.tfTotalCost);
        this.tfTotalCost.setEditable(false);
        this.tfTotalCost.setHorizontalAlignment(4);
        this.add(tablePanel);
        this.btnChangeRecipe.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ArrayList<Recepie> recipes = new ArrayList<Recepie>();
                if (RecipeView.this.recipe != null) {
                    recipes.add(RecipeView.this.recipe);
                }
                RecipeSelectionDialog dialog = new RecipeSelectionDialog(recipes, false);
                dialog.setSelectionMode(0);
                dialog.setSize(PosUIManager.getSize(600, 515));
                dialog.open();
                if (dialog.isCanceled()) {
                    return;
                }
                RecipeView.this.recipe = dialog.getSelectedRowData();
                RecipeView.this.updateView();
            }
        });
        JPanel buttonPanel = new JPanel((LayoutManager)new MigLayout("center"));
        JButton btnAddRecipe = new JButton(InvMessages.getString("IVRV.12"));
        btnAddRecipe.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    RecipeEntryForm editor = new RecipeEntryForm(new Recepie());
                    BeanEditorDialog dialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)editor);
                    dialog.openWithScale(700, 650);
                    if (dialog.isCanceled()) {
                        return;
                    }
                    RecipeView.this.recipe = (Recepie)editor.getBean();
                    RecipeView.this.updateView();
                }
                catch (Exception x) {
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
                }
            }
        });
        JButton btnRemove = new JButton(InvMessages.getString("IVRV.13"));
        btnRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    RecipeView.this.recipe = null;
                    RecipeView.this.updateView();
                }
                catch (Exception x) {
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
                }
            }
        });
        JLabel lblRecipeName = new JLabel(InvMessages.getString("IVRV.14"));
        this.tfRecipeName = new JTextField(30);
        this.tfRecipeName.setEditable(false);
        buttonPanel.add(lblRecipeName);
        buttonPanel.add((Component)this.tfRecipeName, "growx");
        buttonPanel.add(this.btnChangeRecipe);
        buttonPanel.add(btnAddRecipe);
        buttonPanel.add(btnRemove);
        this.add((Component)buttonPanel, "North");
    }

    @Override
    public boolean updateModel(MenuItem e) {
        if (this.recipe == null && this.recipeTable != null) {
            RecipeTableDAO.getInstance().delete(this.recipeTable);
            return true;
        }
        if (this.recipeTable == null) {
            this.recipeTable = new RecipeTable();
        }
        if (this.recipe != null && (double)this.recipeTable.getPortion().intValue() != this.tfPortion.getDoubleOrZero()) {
            double portion = this.tfPortion.getDoubleOrZero();
            this.recipeTable.setPortion(portion <= 0.0 ? 1.0 : portion);
            this.recipeTable.setMenuItem(e);
            if (e.getId() == null) {
                TerminalDAO.getInstance().performBatchSave(e, this.recipeTable);
            } else {
                RecipeTableDAO.getInstance().saveOrUpdate(this.recipeTable);
            }
        }
        return true;
    }

    @Override
    public void initView(MenuItem e) {
        if (this.inited) {
            return;
        }
        this.recipeTable = RecipeTableDAO.getInstance().findBy(e.getId());
        this.updateView();
        this.inited = true;
    }

    private void updateView() {
        if (this.recipe != null) {
            this.table.setItems(this.recipe.getRecepieItems());
            this.tfRecipeName.setText(this.recipe.getName());
            if (this.recipeTable == null) {
                this.tfPortion.setText("1");
            } else {
                this.tfPortion.setText(String.valueOf(this.recipeTable.getPortion() == 0.0 ? 1.0 : this.recipeTable.getPortion()));
            }
            this.lblPortionUnit.setText(this.recipe.getPortionUnit());
        } else {
            this.table.getRows().clear();
            this.tfRecipeName.setText("");
            this.table.revalidate();
            this.table.repaint();
            this.tfPortion.setText("");
            this.lblPortionUnit.setText("");
        }
        this.tfPortion.setEditable(this.recipe != null);
        this.updateTotalCost();
    }

    private void updateTotalCost() {
        double totalRecipeItemCost = 0.0;
        Collection<? extends RecepieItem> rows = this.table.getRows();
        if (rows != null) {
            for (RecepieItem recepieItem : rows) {
                recepieItem.calculatePercentage();
                totalRecipeItemCost += recepieItem.getCost();
            }
        }
        this.tfTotalCost.setText(NumberUtil.formatNumber(totalRecipeItemCost));
    }
}

