/*
 * Decompiled with CFR 0.152.
 */
package com.orostock.inventory.ui.recepie;

import com.floreantpos.bo.ui.CustomCellRenderer;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.RecepieItem;
import com.floreantpos.model.SubRecipe;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.swing.ListTableModel;
import com.floreantpos.swing.PosUIManager;
import com.orostock.inventory.InvMessages;
import java.awt.Component;
import java.awt.Dimension;
import java.util.List;
import javax.swing.AbstractCellEditor;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ChangeListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;

public class SubRecipeItemTable
extends JTable {
    private SubRecipeTableModel model;
    private ChangeListener listener;

    public SubRecipeItemTable(List<SubRecipe> recipeItems) {
        this.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.model = new SubRecipeTableModel();
        this.setItems(recipeItems);
        this.setModel(this.model);
        this.getTableHeader().setPreferredSize(new Dimension(0, 25));
        this.setDefaultRenderer(Object.class, new CustomCellRenderer());
        this.setRowHeight(PosUIManager.getSize(25));
        TableColumn colQuantity = this.getColumnModel().getColumn(1);
        TextCellEditor quantityEditor = new TextCellEditor(new JTextField());
        colQuantity.setCellEditor(quantityEditor);
        this.resizeTableColumns();
    }

    private void resizeTableColumns() {
        this.setAutoResizeMode(4);
        this.setColumnWidth(1, PosUIManager.getSize(90));
        this.setColumnWidth(2, PosUIManager.getSize(90));
        this.setColumnWidth(3, PosUIManager.getSize(90));
    }

    private void setColumnWidth(int columnNumber, int width) {
        TableColumn column = this.getColumnModel().getColumn(columnNumber);
        column.setPreferredWidth(width);
        column.setMaxWidth(width);
        column.setMinWidth(width);
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        if (column == 1) {
            return true;
        }
        return super.isCellEditable(row, column);
    }

    @Override
    public void changeSelection(int rowIndex, int columnIndex, boolean toggle, boolean extend) {
        super.changeSelection(rowIndex, columnIndex, toggle, extend);
        if (columnIndex > -1 && this.editCellAt(rowIndex, columnIndex)) {
            Component editor = this.getEditorComponent();
            editor.requestFocusInWindow();
            if (editor instanceof JTextField) {
                JTextField jf = (JTextField)editor;
                jf.select(0, jf.toString().length());
            }
        }
    }

    public void setItems(List<SubRecipe> recepieItems) {
        if (recepieItems != null) {
            for (SubRecipe subRecipe : recepieItems) {
                List<RecepieItem> items = subRecipe.getRecipe().getRecepieItems();
                if (items == null) continue;
                for (RecepieItem recepieItem : items) {
                    MenuItemDAO.getInstance().initialize(recepieItem.getInventoryItem());
                }
            }
        }
        this.model.setRows(recepieItems);
    }

    public void removeItem(int selectedRow) {
        this.model.deleteItem(selectedRow);
    }

    public SubRecipe getRow(int index) {
        return (SubRecipe)this.model.getRowData(index);
    }

    public void addRow(SubRecipe item) {
        this.model.addItem(item);
    }

    public List<SubRecipe> getRows() {
        return this.model.getRows();
    }

    public void setParentMenuItem(MenuItem e) {
    }

    public void setValueChangeListener(ChangeListener listener) {
        this.listener = listener;
    }

    public class TextCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        JTextField jtextfield;

        public TextCellEditor(JTextField jtf) {
            this.jtextfield = jtf;
        }

        @Override
        public Object getCellEditorValue() {
            return this.jtextfield.getText();
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (isSelected) {
                // empty if block
            }
            if (value == null) {
                value = "";
            }
            if ((value = value.toString()) instanceof Integer) {
                value = value.toString();
            }
            this.jtextfield.setText((String)value);
            return this.jtextfield;
        }

        @Override
        public boolean stopCellEditing() {
            this.fireEditingStopped();
            return true;
        }
    }

    private class SubRecipeTableModel
    extends ListTableModel<SubRecipe> {
        public SubRecipeTableModel() {
            super(new String[]{InvMessages.getString("SubRecipeItemTable.0"), InvMessages.getString("SubRecipeItemTable.1"), InvMessages.getString("SubRecipeItemTable.2"), InvMessages.getString("SubRecipeItemTable.3")});
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            SubRecipe item = (SubRecipe)this.rows.get(rowIndex);
            if (item == null) {
                return "";
            }
            switch (columnIndex) {
                case 0: {
                    return item.getName();
                }
                case 1: {
                    return item.getPortion();
                }
                case 2: {
                    return item.getYield();
                }
                case 3: {
                    return item.getCost();
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            SubRecipe item = (SubRecipe)this.rows.get(rowIndex);
            switch (columnIndex) {
                case 1: {
                    double portion = 1.0;
                    try {
                        portion = Double.valueOf(String.valueOf(aValue));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    item.setPortion(portion);
                    if (SubRecipeItemTable.this.listener == null) break;
                    SubRecipeItemTable.this.listener.stateChanged(null);
                    break;
                }
                default: {
                    super.setValueAt(aValue, rowIndex, columnIndex);
                }
            }
        }
    }
}

