/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.actions;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.actions.ForHereToGoAction;
import com.floreantpos.actions.PosAction;
import com.floreantpos.main.Application;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.SubOrderType;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.User;
import com.floreantpos.model.UserPermission;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.dialog.RefundDialog;
import com.floreantpos.ui.views.IView;
import com.floreantpos.ui.views.order.OrderView;
import com.floreantpos.ui.views.order.RootView;
import com.floreantpos.ui.views.order.actions.DataChangeListener;
import com.floreantpos.ui.views.payment.SettleTicketDialog;
import com.floreantpos.ui.views.payment.SettleTicketProcessor;
import com.floreantpos.util.POSUtil;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashSet;

public class SettleTicketAction
extends PosAction {
    private Ticket ticket;
    private User currentUser;

    public SettleTicketAction(Ticket ticket) {
        this.ticket = ticket;
        this.setRequiredPermission(UserPermission.SETTLE_TICKET);
    }

    public SettleTicketAction(Ticket ticket, User user) {
        this.ticket = ticket;
        this.currentUser = user;
        this.setRequiredPermission(UserPermission.SETTLE_TICKET);
    }

    public SettleTicketAction(DataChangeListener listener) {
        super(POSConstants.SETTLE_TICKET_BUTTON_TEXT, listener);
        this.setRequiredPermission(UserPermission.SETTLE_TICKET);
    }

    @Override
    public void execute() {
        try {
            if (this.listener != null) {
                Object selectedObject = this.getSelectedObject();
                if (selectedObject == null) {
                    return;
                }
                if (selectedObject instanceof Ticket) {
                    this.ticket = (Ticket)selectedObject;
                }
            }
            if (!this.hasPermissionToAccessTicket(this.ticket)) {
                return;
            }
            this.performSettle();
        }
        catch (PosException e) {
            POSMessageDialog.showError(Application.getPosWindow(), e.getMessage());
        }
        catch (Exception e) {
            PosLog.error(this.getClass(), e);
            POSMessageDialog.showError(Application.getPosWindow(), POSConstants.ERROR_MESSAGE, e);
        }
    }

    public boolean performSettle() {
        SubOrderType subOrderType;
        OrderType orderType;
        User user = this.currentUser;
        if (user == null) {
            user = Application.getCurrentUser();
        }
        if ((orderType = this.ticket.getOrderType()) == null) {
            throw new PosException(Messages.getString("OrderTypeDAO.0"));
        }
        if (this.ticket.isVoided().booleanValue()) {
            POSMessageDialog.showMessage(Application.getPosWindow(), POSConstants.TICKET_IS_VOIDED);
            return false;
        }
        if (!POSUtil.checkDrawerAssignment(Application.getInstance().getTerminal(), user)) {
            return false;
        }
        TicketDAO.getInstance().loadFullTicket(this.ticket);
        if (!OrderView.getInstance().isReturnMode() && this.ticket.isAnyItemCloudSynced()) {
            POSMessageDialog.showError(Application.getPosWindow(), Messages.getString("SettleTicketAction.1"));
            return false;
        }
        if (this.ticket.isClosed().booleanValue()) {
            this.ticket.setClosed(false);
            this.ticket.setReOpened(true);
        }
        if (this.ticket.getDueAmount() < 0.0) {
            this.setMandatoryPermission(true);
            if (!this.hasPermission(user, UserPermission.PERFORM_MANAGER_TASK)) {
                return false;
            }
            SettleTicketDialog posDialog = new SettleTicketDialog(this.ticket, user);
            posDialog.setSize(Application.getPosWindow().getSize());
            posDialog.setDefaultCloseOperation(2);
            if (orderType.isBarTab().booleanValue()) {
                this.addBartabHandler(posDialog);
            }
            this.addReturnHandler(posDialog);
            posDialog.openFullScreen();
            return true;
        }
        if (orderType.getHasForHereAndToGo().booleanValue() && (subOrderType = this.ticket.getSubOrderType()) == null) {
            ForHereToGoAction forHereToGoAction = new ForHereToGoAction(this.ticket);
            forHereToGoAction.execute();
            if (!forHereToGoAction.isPerformed()) {
                return false;
            }
        }
        SettleTicketDialog posDialog = new SettleTicketDialog(this.ticket, user);
        posDialog.setSize(Application.getPosWindow().getSize());
        posDialog.setDefaultCloseOperation(2);
        if (orderType.isBarTab().booleanValue()) {
            this.addBartabHandler(posDialog);
        }
        posDialog.openUndecoratedFullScreen();
        IView currentView = RootView.getInstance().getCurrentView();
        if (currentView != null) {
            currentView.refresh();
        }
        if (posDialog.isCanceled()) {
            return false;
        }
        if (this.listener != null) {
            this.listener.dataChanged(this.ticket);
        } else {
            this.fireTicketEditingFinish(this.ticket);
        }
        return true;
    }

    private void fireTicketEditingFinish(Ticket ticket) {
        try {
            OrderView.getInstance().getOrderController().fireTicketEditingFinish(ticket);
        }
        catch (Exception e) {
            PosLog.error(this.getClass(), e);
        }
    }

    private void addBartabHandler(final SettleTicketDialog posDialog) {
        PosTransaction bartabTransaction = this.ticket.getBartabTransaction();
        if (bartabTransaction != null && !bartabTransaction.isCaptured().booleanValue() && !bartabTransaction.isVoided().booleanValue()) {
            posDialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowOpened(WindowEvent e) {
                    try {
                        posDialog.settleBartab();
                    }
                    catch (Exception e2) {
                        POSMessageDialog.showError(POSUtil.getFocusedWindow(), e2.getMessage(), e2);
                        posDialog.setCanceled(true);
                        posDialog.dispose();
                    }
                }
            });
        }
    }

    private void addReturnHandler(final SettleTicketDialog posDialog) {
        posDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                try {
                    double refundedAmount;
                    if (SettleTicketAction.this.ticket.getTransactions() == null) {
                        SettleTicketAction.this.ticket.setTransactions(new HashSet<PosTransaction>());
                    }
                    if ((refundedAmount = SettleTicketAction.this.ticket.getDueAmount().doubleValue()) >= 0.0) {
                        POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("SettleTicketProcessor.8"));
                        return;
                    }
                    RefundDialog dialog = new RefundDialog((Window)posDialog, SettleTicketAction.this.ticket, new SettleTicketProcessor(SettleTicketAction.this.getCurrentUser(), null));
                    dialog.setSize(810, 600);
                    dialog.open();
                    if (dialog.isCanceled()) {
                        return;
                    }
                    posDialog.dispose();
                }
                catch (Exception e2) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), e2.getMessage(), e2);
                    posDialog.setCanceled(true);
                    posDialog.dispose();
                }
            }
        });
    }

    @Override
    protected User getCurrentUser() {
        if (this.currentUser == null) {
            return Application.getCurrentUser();
        }
        return this.currentUser;
    }

    public static class RefundAction
    extends PosAction {
        private Ticket ticket;

        public RefundAction(Ticket ticket) {
            this.ticket = ticket;
            this.setRequiredPermission(UserPermission.PERFORM_MANAGER_TASK);
            this.setMandatoryPermission(true);
        }

        public RefundAction(Ticket ticket, UserPermission userPermission) {
            this.ticket = ticket;
            this.setRequiredPermission(userPermission);
        }

        @Override
        public void execute() {
            try {
                double refundedAmount;
                if (this.ticket.getTransactions() == null) {
                    this.ticket.setTransactions(new HashSet<PosTransaction>());
                }
                if ((refundedAmount = this.ticket.getDueAmount().doubleValue()) >= 0.0) {
                    POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("SettleTicketProcessor.8"));
                    return;
                }
                RefundDialog dialog = new RefundDialog(POSUtil.getFocusedWindow(), this.ticket, new SettleTicketProcessor(this.getCurrentUser(), null));
                dialog.setSize(810, 600);
                dialog.open();
            }
            catch (PosException e) {
                POSMessageDialog.showError(Application.getPosWindow(), e.getMessage());
            }
            catch (Exception e) {
                POSMessageDialog.showError(Application.getPosWindow(), e.getMessage(), e);
            }
        }
    }
}

