/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.actions;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.actions.PosAction;
import com.floreantpos.main.Application;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.UserPermission;
import com.floreantpos.model.dao.ActionHistoryDAO;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.services.TicketService;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.order.OrderController;
import com.floreantpos.ui.views.order.TicketSelectionDialog;
import com.floreantpos.ui.views.order.actions.DataChangeListener;
import com.floreantpos.util.POSUtil;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.JOptionPane;

public class TicketCloseAction
extends PosAction {
    private Object selectedObject;

    public TicketCloseAction() {
        super(POSConstants.CLOSE_ORDER_BUTTON_TEXT);
        this.setRequiredPermission(UserPermission.PERFORM_MANAGER_TASK);
        this.setMandatoryPermission(true);
    }

    public TicketCloseAction(DataChangeListener listener) {
        super(POSConstants.CLOSE_ORDER_BUTTON_TEXT, listener);
        this.setRequiredPermission(UserPermission.PERFORM_MANAGER_TASK);
        this.setMandatoryPermission(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            this.selectedObject = this.getSelectedObject();
            if (this.selectedObject instanceof Ticket) {
                Ticket ticket = (Ticket)this.selectedObject;
                if (ticket.getDueAmount() != 0.0) {
                    super.actionPerformed(e);
                } else {
                    this.execute();
                }
            }
        }
        catch (PosException exception) {
            POSMessageDialog.showError(Application.getPosWindow(), exception.getMessage());
        }
    }

    @Override
    public void execute() {
        this.closeTicket();
    }

    private void closeTicket() {
        try {
            if (this.selectedObject != null) {
                this.closeSingleTicket(this.selectedObject);
            } else {
                this.closeMultipleTickets();
            }
        }
        catch (PosException e) {
            POSMessageDialog.showError(Application.getPosWindow(), e.getMessage());
        }
        catch (Exception e) {
            POSMessageDialog.showError(Application.getPosWindow(), e.getMessage(), e);
        }
    }

    private void closeMultipleTickets() {
        List<Ticket> tickets = TicketDAO.getInstance().getTicketsWithSpecificFields(Ticket.PROP_ID, Ticket.PROP_DUE_AMOUNT, Ticket.PROP_TOKEN_NO, Ticket.PROP_TICKET_TABLE_NUMBERS);
        TicketSelectionDialog ticketSelectionDialog = new TicketSelectionDialog(tickets);
        ticketSelectionDialog.setCaption(Messages.getString("TicketCloseAction.0"));
        ticketSelectionDialog.openFullScreen();
        if (ticketSelectionDialog.isCanceled()) {
            return;
        }
        List<Ticket> selectedTickets = ticketSelectionDialog.getSelectedTickets();
        if (selectedTickets == null) {
            return;
        }
        int option = POSMessageDialog.showYesNoQuestionDialog(Application.getPosWindow(), Messages.getString("TicketCloseAction.1"), Messages.getString("TicketCloseAction.2"));
        if (option == 0) {
            TicketDAO.closeOrders(selectedTickets.toArray(new Ticket[selectedTickets.size()]));
        }
    }

    private void closeSingleTicket(Object selectedObject) {
        Ticket ticket = null;
        ticket = selectedObject instanceof Ticket ? (Ticket)selectedObject : TicketService.getTicket((String)selectedObject);
        if (ticket == null) {
            return;
        }
        if (ticket.isVoided().booleanValue()) {
            POSMessageDialog.showMessage(Application.getPosWindow(), POSConstants.TICKET_IS_VOIDED);
            return;
        }
        ticket = TicketDAO.getInstance().loadFullTicket(ticket.getId());
        int due = (int)POSUtil.getDouble(ticket.getDueAmount());
        if (due != 0) {
            POSMessageDialog.showError(Messages.getString("TicketCloseAction.5"));
            return;
        }
        int option = JOptionPane.showOptionDialog(Application.getPosWindow(), Messages.getString("SwitchboardView.6") + ticket.getId() + Messages.getString("SwitchboardView.7"), POSConstants.CONFIRM, 2, 1, null, null, null);
        if (option != 0) {
            return;
        }
        OrderController.closeOrder(ticket);
        ActionHistoryDAO.saveHistory(this.getCurrentUser(), ticket, "Close ticket", String.format("Server: %s, total: %s", ticket.getOwner().getFirstName(), ticket.getTotalAmount()));
        if (this.listener != null) {
            this.listener.dataChanged(ticket);
        }
    }
}

