/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.actions;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.actions.PosAction;
import com.floreantpos.main.Application;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.MenuModifier;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.SalesArea;
import com.floreantpos.model.ShopTable;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemModifier;
import com.floreantpos.model.TicketItemTax;
import com.floreantpos.model.UserPermission;
import com.floreantpos.model.dao.MenuModifierDAO;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.model.ext.ReorderType;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.tableselection.TableSelectionView;
import com.floreantpos.ui.tableselection.TableSelectorDialog;
import com.floreantpos.ui.tableselection.TableSelectorFactory;
import com.floreantpos.ui.views.order.OrderTypeSelectionDialog;
import com.floreantpos.ui.views.order.OrderView;
import com.floreantpos.ui.views.order.RootView;
import com.floreantpos.ui.views.order.actions.DataChangeListener;
import com.floreantpos.util.POSUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class TicketReorderAction
extends PosAction {
    private Ticket ticket;
    private boolean isReorder;

    public TicketReorderAction() {
        super(POSConstants.REORDER_TICKET_BUTTON_TEXT);
        this.setRequiredPermission(UserPermission.CREATE_TICKET);
    }

    public TicketReorderAction(Ticket ticket, UserPermission requiredPermission) {
        super(POSConstants.REORDER_TICKET_BUTTON_TEXT, requiredPermission);
        this.ticket = ticket;
    }

    public TicketReorderAction(DataChangeListener listener) {
        super(POSConstants.REORDER_TICKET_BUTTON_TEXT, listener);
        this.setRequiredPermission(UserPermission.CREATE_TICKET);
    }

    public void setTicket(Ticket ticket) {
        this.ticket = ticket;
    }

    public Ticket getTicket() {
        return this.ticket;
    }

    @Override
    public void execute() {
        try {
            if (!this.getCurrentUser().hasPermission(this.requiredPermission)) {
                POSMessageDialog.showError(Messages.getString("OrderTypeButton.1"));
                return;
            }
            if (this.listener != null) {
                Object selectedObject = this.getSelectedObject();
                if (selectedObject == null) {
                    return;
                }
                if (selectedObject instanceof Ticket) {
                    this.ticket = (Ticket)selectedObject;
                }
            }
            if (this.ticket == null) {
                return;
            }
            int option = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), Messages.getString("TicketReorderAction.0"), Messages.getString("TicketReorderAction.1"));
            if (option != 0) {
                return;
            }
            Ticket currentTicket = DataProvider.get().getTicketToBeCreated();
            if (currentTicket != null) {
                currentTicket.setCustomer(this.ticket.getCustomer());
                this.createReOrder(this.ticket, currentTicket.getOrderType(), currentTicket);
            } else {
                OrderTypeSelectionDialog dialog = new OrderTypeSelectionDialog();
                dialog.open();
                if (dialog.isCanceled()) {
                    return;
                }
                OrderType orderType = dialog.getSelectedOrderType();
                this.ticket = TicketDAO.getInstance().loadFullTicket(this.ticket.getId());
                this.createReOrder(this.ticket, orderType, null);
            }
            this.isReorder = true;
        }
        catch (PosException e) {
            POSMessageDialog.showError(Application.getPosWindow(), e.getMessage());
        }
        catch (Exception e) {
            POSMessageDialog.showError(Application.getPosWindow(), POSConstants.ERROR_MESSAGE, e);
        }
    }

    private void createReOrder(Ticket oldticket, OrderType orderType, Ticket newTicket) {
        if (oldticket == null) {
            throw new PosException(Messages.getString("TicketReorderAction.2"));
        }
        Ticket ticket = newTicket;
        if (newTicket == null) {
            ticket = new Ticket(true);
            ticket.setOrderType(orderType);
        }
        if (newTicket == null && orderType.isShowTableSelection().booleanValue()) {
            TableSelectorDialog dialog = TableSelectorFactory.createTableSelectorDialog(orderType);
            TableSelectionView tableSelector = dialog.getTableSelector();
            tableSelector.setHomeViewMode(Boolean.FALSE);
            tableSelector.setShouldReorder(Boolean.TRUE);
            tableSelector.setReorderType(ReorderType.TICKET_REORDER);
            dialog.setCreateNewTicket(false);
            dialog.updateView(true);
            dialog.openUndecoratedFullScreen();
            tableSelector.setReorderType(null);
            tableSelector.setShouldReorder(Boolean.FALSE);
            if (dialog.isCanceled()) {
                return;
            }
            List<ShopTable> tables = dialog.getSelectedTables();
            ArrayList<Integer> tableNumbers = new ArrayList<Integer>();
            for (ShopTable shopTable : tables) {
                SalesArea salesArea = shopTable.getSalesArea();
                if (salesArea != null) {
                    ticket.setSalesArea(salesArea);
                    ticket.setSalesAreaId(salesArea.getId());
                }
                tableNumbers.add(shopTable.getId());
            }
            ticket.setTableNumbers(tableNumbers);
        }
        ArrayList<TicketItem> newTicketItems = new ArrayList<TicketItem>();
        for (TicketItem oldTicketItem : oldticket.getTicketItems()) {
            List<TicketItemModifier> ticketItemModifiers;
            if (oldTicketItem.isVoided().booleanValue() || oldTicketItem.isTreatAsSeat().booleanValue()) continue;
            TicketItem newTicketItem = oldTicketItem.cloneAsNew();
            newTicketItem.setTicket(ticket);
            newTicketItems.add(newTicketItem);
            MenuItem menuItem = newTicketItem.getMenuItem();
            if (menuItem != null) {
                if (!menuItem.isEditablePrice().booleanValue()) {
                    newTicketItem.setUnitPrice(menuItem.getPrice());
                }
                MenuItem.setItemTaxes(newTicketItem, menuItem.getTaxGroup(ticket.getCustomer()), ticket.getOrderType());
            }
            if ((ticketItemModifiers = newTicketItem.getTicketItemModifiers()) == null) continue;
            ticketItemModifiers.forEach(ticketItemModifier -> {
                MenuModifier menuModifier;
                String modifierId = ticketItemModifier.getItemId();
                MenuModifier menuModifier2 = menuModifier = StringUtils.isBlank((String)modifierId) ? null : MenuModifierDAO.getInstance().get(modifierId);
                if (menuModifier != null) {
                    ticketItemModifier.setUnitPrice(menuModifier.getPrice());
                    if (menuModifier.isTaxable().booleanValue()) {
                        ticketItemModifier.setTaxable(true);
                        ticketItemModifier.setTaxSameAsItem(menuModifier.isTaxSameAsItem());
                        List<TicketItemTax> taxes = menuModifier.getTaxByOrderType(orderType, newTicketItem);
                        if (taxes != null) {
                            ticketItemModifier.getTaxes().clear();
                            ticketItemModifier.getTaxes().addAll(taxes);
                        }
                    } else {
                        ticketItemModifier.setTaxable(false);
                        ticketItemModifier.setTaxSameAsItem(false);
                        ticketItemModifier.setTaxes(null);
                    }
                }
            });
        }
        ticket.getTicketItems().addAll(newTicketItems);
        if (ticket.getCustomer() == null) {
            ticket.setCustomer(oldticket.getCustomer());
        }
        OrderView.getInstance().setCurrentTicket(ticket);
        RootView.getInstance().showView("ORDER_VIEW");
    }

    public boolean isReorder() {
        return this.isReorder;
    }
}

