/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.actions;

import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.actions.PosAction;
import com.floreantpos.main.Application;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.order.OrderView;
import com.floreantpos.ui.views.order.RootView;
import com.floreantpos.ui.views.order.actions.DataChangeListener;
import com.floreantpos.util.POSUtil;

public class TicketReturnAction
extends PosAction {
    private Ticket ticket;

    public TicketReturnAction() {
        super(POSConstants.REORDER_TICKET_BUTTON_TEXT);
    }

    public TicketReturnAction(Ticket ticket) {
        super(POSConstants.REORDER_TICKET_BUTTON_TEXT);
        this.ticket = ticket;
    }

    public TicketReturnAction(DataChangeListener listener) {
        super(POSConstants.REORDER_TICKET_BUTTON_TEXT, listener);
    }

    public void setTicket(Ticket ticket) {
        this.ticket = ticket;
    }

    public Ticket getTicket() {
        return this.ticket;
    }

    @Override
    public void execute() {
        try {
            if (this.listener != null) {
                Object selectedObject = this.getSelectedObject();
                if (selectedObject == null) {
                    return;
                }
                if (selectedObject instanceof Ticket) {
                    this.ticket = (Ticket)selectedObject;
                }
            }
            if (this.ticket == null) {
                return;
            }
            int option = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), "Are you sure to return this ticket?", "Return");
            if (option != 0) {
                return;
            }
            this.ticket = TicketDAO.getInstance().loadFullTicket(this.ticket.getId());
            OrderView.getInstance().setCurrentTicket(this.ticket);
            RootView rootView = RootView.getInstance();
            rootView.showView("ORDER_VIEW");
            rootView.getHeaderPanel().setReturnMode(true);
        }
        catch (PosException e) {
            POSMessageDialog.showError(Application.getPosWindow(), e.getMessage());
        }
        catch (Exception e) {
            POSMessageDialog.showError(Application.getPosWindow(), POSConstants.ERROR_MESSAGE, e);
        }
    }
}

